/*
 * Decompiled with CFR 0.152.
 */
package JSSHTerminal;

import JSSHTerminal.GraphicTerminal;
import JSSHTerminal.SSHSession;
import JSSHTerminal.TerminalEvent;
import JSSHTerminal.TextTerminal;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;

public class MainPanel
extends JFrame
implements AdjustmentListener,
MouseWheelListener {
    public static final String DEFAULT_VERSION = "-.-";
    public static final String VERSION = MainPanel.getVersion();
    static final boolean isWindows;
    private TerminalEvent textArea;
    private JScrollBar scrollBar;
    private SSHSession session;
    private String _host;
    private String _user;
    private String _password;
    private boolean exitOnClose = false;
    private boolean scrollUpdate;
    private String command = null;

    public MainPanel(String host, String user, String password, int width, int height, int scrollSize, boolean center) {
        this._host = host;
        this._user = user;
        this._password = password;
        this.textArea = !isWindows ? new TextTerminal(this, width, height) : new GraphicTerminal(this, width, height);
        this.session = new SSHSession(this, width, height, scrollSize);
        this.textArea.setSession(this.session);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.textArea, "Center");
        this.getContentPane().setBackground(Color.BLACK);
        this.scrollBar = new JScrollBar();
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum(height);
        this.scrollBar.setValue(0);
        this.scrollBar.setVisibleAmount(height);
        this.scrollBar.addAdjustmentListener(this);
        this.scrollUpdate = false;
        this.getContentPane().add((Component)this.scrollBar, "East");
        this.setTitle("JSSHTerminal " + VERSION + " " + user + "@" + host);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                try {
                    MainPanel.this.session.connect(MainPanel.this._host, MainPanel.this._user, MainPanel.this._password);
                    if (MainPanel.this.command != null) {
                        MainPanel.this.session.execCommand(MainPanel.this.command);
                    }
                    MainPanel.this.textArea.notifySizeChange();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Cannot connect :" + ex.getMessage(), "Error", 0);
                    MainPanel.this.setVisible(false);
                    MainPanel.this.exitFrame();
                }
                super.windowOpened(e);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                MainPanel.this.exitFrame();
            }
        });
        this.addMouseWheelListener(this);
        this.pack();
        if (center) {
            this.setLocationRelativeTo(null);
        }
        this.setDefaultCloseOperation(1);
    }

    public MainPanel(String host, String user, String password, int width, int height, int scrollSize) {
        this(host, user, password, width, height, scrollSize, true);
    }

    public void setExitOnClose(boolean exitOnClose) {
        this.exitOnClose = exitOnClose;
    }

    public void setCommand(String cmd) {
        this.command = cmd;
    }

    public void setSSHPort(int port) {
        this.session.setSshPort(port);
    }

    public void setAnswerYes(boolean enable) {
        this.session.setAnswerYes(enable);
    }

    public void setX11Forwarding(boolean enable) {
        this.session.setX11Forwarding(enable);
    }

    public void write(String s) {
        this.session.getTerminal().write(s.toCharArray(), s.length());
    }

    void setExtraTilte(String tilte) {
        this.setTitle("JSSHTerminal " + VERSION + " " + tilte);
    }

    void exitFrame() {
        if (this.session != null) {
            this.session.close();
        }
        this.textArea.dispose();
        if (this.exitOnClose) {
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.scrollUpdate) {
            int sbValue = e.getValue();
            this.textArea.setScrollPos(sbValue);
        }
    }

    void updateScrollBar() {
        this.scrollUpdate = true;
        int scrollPos = this.textArea.scrollPos;
        int scrollSize = this.textArea.terminal.getScrollSize();
        int height = this.textArea.termHeight;
        this.scrollBar.setValues(scrollSize - scrollPos - height, height, 0, scrollSize);
        this.scrollUpdate = false;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.textArea.moveScroll(-3 * e.getWheelRotation());
        this.updateScrollBar();
        e.consume();
    }

    private static String getVersion() {
        Package p = MainPanel.class.getPackage();
        if (p.getImplementationVersion() != null) {
            return p.getImplementationVersion();
        }
        return DEFAULT_VERSION;
    }

    static void dumpCharSet(String set) {
        int j;
        int i;
        System.out.print("\u001b[m");
        System.out.print("\u001b[0m");
        System.out.println("---------- Set ------- " + set);
        System.out.print("\u001b" + set);
        char c = ' ';
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 16; ++j) {
                if (c < '\u007f') {
                    System.out.print(c);
                }
                c = (char)(c + '\u0001');
            }
            System.out.println();
        }
        System.out.print("\u001b[1m");
        c = ' ';
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 16; ++j) {
                if (c < '\u007f') {
                    System.out.print(c);
                }
                c = (char)(c + '\u0001');
            }
            System.out.println();
        }
        System.out.print("\u001b(A");
    }

    static void dumpCharSets() {
        MainPanel.dumpCharSet("(A");
        MainPanel.dumpCharSet(")A");
        MainPanel.dumpCharSet("(B");
        MainPanel.dumpCharSet(")B");
        MainPanel.dumpCharSet("(0");
        MainPanel.dumpCharSet(")0");
        MainPanel.dumpCharSet("(1");
        MainPanel.dumpCharSet(")1");
        MainPanel.dumpCharSet("(2");
        MainPanel.dumpCharSet(")2");
    }

    public static void printUsage() {
        System.out.println("Usage: jterminal username@host [-p password] [-P port] [-y] [-s WxHxS] [-X] [-c command]");
        System.out.println("       username@host username used to login on host");
        System.out.println("       -p password password used to login");
        System.out.println("       -P SSH port number (default is 22)");
        System.out.println("       -y Answer yes to question");
        System.out.println("       -s WxHxS terminal size WidthxHeightxScrollbar");
        System.out.println("       -X Enable X11 forwarding");
        System.out.println("       -c command Execute command after connection");
        System.exit(0);
    }

    public static void main(String[] args) {
        String[] uh;
        int W = 80;
        int H = 24;
        int S = 500;
        int P = 22;
        String password = null;
        boolean yes = false;
        boolean X11 = false;
        String command = null;
        if (args.length == 0) {
            MainPanel.printUsage();
        }
        if ((uh = args[0].split("@")).length != 2) {
            MainPanel.printUsage();
        }
        int argc = 1;
        while (argc < args.length) {
            if (args[argc].equals("-y")) {
                yes = true;
                ++argc;
                continue;
            }
            if (args[argc].equals("-X")) {
                X11 = true;
                ++argc;
                continue;
            }
            if (args[argc].equals("-p")) {
                if (argc + 1 < args.length) {
                    password = args[argc + 1];
                } else {
                    MainPanel.printUsage();
                }
                argc += 2;
                continue;
            }
            if (args[argc].equals("-c")) {
                if (argc + 1 < args.length) {
                    command = args[argc + 1];
                } else {
                    MainPanel.printUsage();
                }
                argc += 2;
                continue;
            }
            if (args[argc].equals("-P")) {
                if (argc + 1 < args.length) {
                    P = Integer.parseInt(args[argc + 1]);
                } else {
                    MainPanel.printUsage();
                }
                argc += 2;
                continue;
            }
            if (args[argc].equals("-s")) {
                if (argc + 1 < args.length) {
                    String[] sz = args[argc + 1].split("x");
                    if (sz.length == 3) {
                        W = Integer.parseInt(sz[0]);
                        H = Integer.parseInt(sz[1]);
                        S = Integer.parseInt(sz[2]);
                    } else {
                        MainPanel.printUsage();
                    }
                } else {
                    MainPanel.printUsage();
                }
                argc += 2;
                continue;
            }
            System.out.println("Invalid option " + args[argc]);
            MainPanel.printUsage();
        }
        MainPanel f = new MainPanel(uh[1], uh[0], password, W, H, S);
        f.setExitOnClose(true);
        f.setSSHPort(P);
        f.setAnswerYes(yes);
        f.setX11Forwarding(X11);
        f.setCommand(command);
        f.setVisible(true);
    }

    static {
        String OS_NAME = System.getProperty("os.name");
        String _OS_NAME = OS_NAME.toLowerCase();
        isWindows = _OS_NAME.startsWith("windows");
    }
}

