/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.EventsTable;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.CommunicationFailed;
import fr.esrf.TangoApi.ConnectionFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.EventSystemFailed;
import fr.esrf.TangoApi.NonDbDevice;
import fr.esrf.TangoApi.NonSupportedFeature;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoApi.WrongNameSyntax;
import fr.esrf.TangoApi.events.ITangoArchiveListener;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.ITangoPeriodicListener;
import fr.esrf.TangoApi.events.TangoArchiveEvent;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

public class SubscribedSignal
implements TangoConst {
    static final String defVal = "-----";
    Exception except = null;
    boolean subscribed = false;
    String name;
    String value = "-----";
    String time = "-----";
    String d_time = "-----";
    String d_value = "-----";
    List<EventHistory> histo = new ArrayList<EventHistory>();
    String deviceName;
    String attributeName;
    int mode;
    int cnt = 0;
    int data_type;
    private double dt_min = Double.MAX_VALUE;
    private double dt_max = 0.0;
    private double dt_average = 0.0;
    private double[] values = null;
    private double[] prev_val = null;
    private long t0;
    private TangoEventsAdapter adapter;
    private ArchiveEventListener arch_listener = null;
    private ChangeEventListener change_listener = null;
    private PeriodicEventListener periodic_listener = null;
    private EventsTable parent;
    private AttributeInfoEx attributeInfo;

    public SubscribedSignal(String name, int mode) {
        this.name = name;
        int pos = name.lastIndexOf("/");
        this.deviceName = name.substring(0, pos);
        this.attributeName = name.substring(pos + 1);
        this.mode = mode;
        try {
            this.attributeInfo = new AttributeProxy(name).get_info_ex();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    void subscribe(EventsTable parent) {
        this.parent = parent;
        new SubscribeThread(this).start();
    }

    String except_str() {
        StringBuilder sb = new StringBuilder();
        if (this.except instanceof ConnectionFailed) {
            sb.append(((ConnectionFailed)this.except).getStack());
        } else if (this.except instanceof CommunicationFailed) {
            sb.append(((CommunicationFailed)this.except).getStack());
        } else if (this.except instanceof WrongNameSyntax) {
            sb.append(((WrongNameSyntax)this.except).getStack());
        } else if (this.except instanceof WrongData) {
            sb.append(((WrongData)this.except).getStack());
        } else if (this.except instanceof NonDbDevice) {
            sb.append(((NonDbDevice)this.except).getStack());
        } else if (this.except instanceof NonSupportedFeature) {
            sb.append(((NonSupportedFeature)this.except).getStack());
        } else if (this.except instanceof EventSystemFailed) {
            sb.append(((EventSystemFailed)this.except).getStack());
        } else if (this.except instanceof AsynReplyNotArrived) {
            sb.append(((AsynReplyNotArrived)this.except).getStack());
        } else if (this.except instanceof DevFailed) {
            DevFailed df = (DevFailed)((Object)this.except);
            for (int i = 0; i < df.errors.length; ++i) {
                sb.append(df.toString()).append(":\n");
                sb.append("Tango exception\n");
                sb.append("Severity -> ");
                switch (df.errors[i].severity.value()) {
                    case 0: {
                        sb.append("WARNING \n");
                        break;
                    }
                    case 1: {
                        sb.append("ERROR \n");
                        break;
                    }
                    case 2: {
                        sb.append("PANIC \n");
                        break;
                    }
                    default: {
                        sb.append("Unknown severity code");
                    }
                }
                sb.append("Desc -> ").append(df.errors[i].desc).append("\n");
                sb.append("Reason -> ").append(df.errors[i].reason).append("\n");
                sb.append("Origin -> ").append(df.errors[i].origin).append("\n");
                if (i >= df.errors.length - 1) continue;
                sb.append("-------------------------------------------------------------\n");
            }
        } else {
            sb = new StringBuilder(this.except.toString());
        }
        return sb.toString();
    }

    void setData(Exception e) {
        this.value = defVal;
        this.d_time = defVal;
        this.d_value = defVal;
        this.except = e;
    }

    void setData(DeviceAttribute attr) throws DevFailed {
        long t1 = System.currentTimeMillis();
        double dt = (double)(t1 - this.t0) / 1000.0;
        String date = SubscribedSignal.getStrDate(attr.getTimeValMillisSec());
        ++this.cnt;
        this.time = "" + date;
        this.setValue(attr);
        if (this.cnt > 1) {
            this.d_time = "" + dt + " sec.";
            this.setDeltaValue();
        }
        if (this.cnt > 2) {
            if (dt > this.dt_max) {
                this.dt_max = dt;
            }
            if (dt < this.dt_min) {
                this.dt_min = dt;
            }
            this.dt_average = (this.dt_average * (double)(this.cnt - 3) + dt) / (double)(this.cnt - 2);
        }
        this.t0 = t1;
        if (this.values != null) {
            this.histo.add(new EventHistory(attr.getTimeValMillisSec(), this.values, this.d_value, this.d_time));
            this.prev_val = this.values;
        }
        this.except = null;
    }

    private void setDeltaValue() {
        double dv_max = 0.0;
        double relative = 0.0;
        if (this.values != null && this.prev_val != null) {
            for (int i = 0; i < this.values.length && i < this.prev_val.length; ++i) {
                double dv = Math.abs(this.values[i] - this.prev_val[i]);
                if (!(dv > dv_max)) continue;
                dv_max = dv;
                if (this.prev_val[i] == 0.0) continue;
                relative = dv / this.prev_val[i];
            }
            this.d_value = SubscribedSignal.formatValue(dv_max);
            relative = (double)((int)(10000.0 * relative)) / 100.0;
            this.d_value = this.d_value + "  (" + relative + " %)";
        }
    }

    static String formatValue(double val) {
        String str;
        if (val >= 20.0) {
            str = "" + (int)val;
        } else {
            str = "" + val;
            int idx = str.indexOf(".");
            if (val >= 1.0 && idx > 0) {
                str = str.substring(0, idx + 2);
            } else if (val >= 0.1 && idx > 0) {
                str = str.substring(0, idx + 3);
            } else if (val >= 0.01 && idx > 0) {
                str = str.substring(0, idx + 4);
            } else if (val >= 0.001 && idx > 0) {
                str = str.substring(0, idx + 5);
            } else if (val >= 1.0E-4 && idx > 0) {
                str = str.substring(0, idx + 6);
            }
        }
        return str;
    }

    void unsubscribe() {
        if (this.subscribed && this.adapter != null) {
            try {
                if (this.arch_listener != null) {
                    this.adapter.removeTangoArchiveListener((ITangoArchiveListener)this.arch_listener, this.attributeName);
                }
                if (this.change_listener != null) {
                    this.adapter.removeTangoChangeListener((ITangoChangeListener)this.change_listener, this.attributeName);
                }
                if (this.periodic_listener != null) {
                    this.adapter.removeTangoPeriodicListener((ITangoPeriodicListener)this.periodic_listener, this.attributeName);
                }
                System.out.println("unsubscribe event for " + this.name);
            }
            catch (DevFailed e) {
                System.out.println("Failed to unsubscribe event for " + this.name);
                Except.print_exception((Exception)((Object)e));
            }
        }
    }

    public String toString() {
        return this.name + "  [" + EventsTable.strMode[this.mode] + "]";
    }

    public String getTimes() {
        if (this.cnt <= 2) {
            return null;
        }
        int tmp = (int)(1000.0 * this.dt_average);
        return "dt minimum = " + this.dt_min + " sec.\ndt average   = " + (double)tmp / 1000.0 + " sec.\ndt maximum = " + this.dt_max + " sec.";
    }

    public String status() {
        String status = this.name + ":\n" + Tango_CmdArgTypeName[this.data_type] + "\n\n";
        if (this.subscribed) {
            status = status + "Is  Subscribed On " + EventsTable.strMode[this.mode] + " mode\n";
            status = status + "Value:\n" + this.value + "\n\n";
            status = status + "Receive  " + this.cnt + " event";
            if (this.cnt > 1) {
                status = status + "s";
            }
            status = status + "  at " + SubscribedSignal.getStrDate();
            if (this.cnt > 2) {
                status = status + "\n" + this.getTimes();
            }
        } else if (this.except != null) {
            if (this.except instanceof DevFailed) {
                DevFailed df = (DevFailed)((Object)this.except);
                status = status + df.errors[0].desc;
            } else {
                status = status + this.except.toString();
            }
        } else {
            status = status + "? ? ?";
        }
        return status;
    }

    static String getStrDate(long ms) {
        StringTokenizer st = new StringTokenizer(new Date(ms).toString());
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        return (String)tokens.get(3) + "  " + (String)tokens.get(2) + " " + (String)tokens.get(1);
    }

    static String getStrDate() {
        return SubscribedSignal.getStrDate(System.currentTimeMillis());
    }

    private void setValue(DeviceAttribute attr) throws DevFailed {
        StringBuilder sb = new StringBuilder();
        String format = null;
        if (this.attributeInfo != null && !this.attributeInfo.format.equals("Not specified")) {
            format = this.attributeInfo.format;
        }
        this.data_type = attr.getType();
        switch (this.data_type) {
            case 1: {
                boolean[] tmp = attr.extractBooleanArray();
                if (tmp.length == 1) {
                    sb = new StringBuilder("" + tmp[0]);
                    break;
                }
                for (int i = 0; i < tmp.length; ++i) {
                    sb.append(tmp[i] ? "1" : "0");
                    if ((i + 1) % 4 != 0) continue;
                    sb.append(" ");
                }
                break;
            }
            case 22: {
                short[] tmp = attr.extractUCharArray();
                for (int i = 0; i < tmp.length; ++i) {
                    sb.append(tmp[i]);
                    if (i >= tmp.length - 1) continue;
                    sb.append("\n");
                }
                break;
            }
            case 2: {
                short[] tmp = attr.extractShortArray();
                this.values = new double[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    if (format == null) {
                        sb.append(tmp[i]);
                    } else {
                        sb.append(String.format(format, tmp[i]));
                    }
                    if (i < tmp.length - 1) {
                        sb.append("\n");
                    }
                    this.values[i] = tmp[i];
                }
                break;
            }
            case 6: {
                int[] tmp = attr.extractUShortArray();
                this.values = new double[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    if (format == null) {
                        sb.append(tmp[i]);
                    } else {
                        sb.append(String.format(format, tmp[i]));
                    }
                    if (i < tmp.length - 1) {
                        sb.append("\n");
                    }
                    this.values[i] = tmp[i];
                }
                break;
            }
            case 3: {
                int[] tmp = attr.extractLongArray();
                this.values = new double[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    if (format == null) {
                        sb.append(tmp[i]);
                    } else {
                        sb.append(String.format(format, tmp[i]));
                    }
                    if (i < tmp.length - 1) {
                        sb.append("\n");
                    }
                    this.values[i] = tmp[i];
                }
                break;
            }
            case 23: {
                long[] tmp = attr.extractLong64Array();
                this.values = new double[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    if (format == null) {
                        sb.append(tmp[i]);
                    } else {
                        sb.append(String.format(format, tmp[i]));
                    }
                    if (i < tmp.length - 1) {
                        sb.append("\n");
                    }
                    this.values[i] = tmp[i];
                }
                break;
            }
            case 7: {
                long[] tmp = attr.extractULongArray();
                this.values = new double[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    if (format == null) {
                        sb.append(tmp[i]);
                    } else {
                        sb.append(String.format(format, tmp[i]));
                    }
                    if (i < tmp.length - 1) {
                        sb.append("\n");
                    }
                    this.values[i] = tmp[i];
                }
                break;
            }
            case 4: {
                float[] tmp = attr.extractFloatArray();
                this.values = new double[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    if (format == null) {
                        sb.append(tmp[i]);
                    } else {
                        sb.append(String.format(format, Float.valueOf(tmp[i])));
                    }
                    if (i < tmp.length - 1) {
                        sb.append("\n");
                    }
                    this.values[i] = tmp[i];
                }
                break;
            }
            case 5: {
                double[] tmp = attr.extractDoubleArray();
                this.values = new double[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    if (format == null) {
                        sb.append(tmp[i]);
                    } else {
                        sb.append(String.format(format, tmp[i]));
                    }
                    if (i < tmp.length - 1) {
                        sb.append("\n");
                    }
                    this.values[i] = tmp[i];
                }
                break;
            }
            case 8: {
                String[] tmp = attr.extractStringArray();
                for (int i = 0; i < tmp.length; ++i) {
                    sb.append(tmp[i]);
                    if (i >= tmp.length - 1) continue;
                    sb.append("\n");
                }
                break;
            }
            case 19: {
                DevState state = attr.extractState();
                sb = new StringBuilder(ApiUtil.stateName((DevState)state));
                break;
            }
            default: {
                sb = new StringBuilder("" + this.data_type + " ?  - Unsupported Type");
            }
        }
        this.value = sb.toString();
    }

    class PeriodicEventListener
    implements ITangoPeriodicListener {
        SubscribedSignal signal;

        PeriodicEventListener(SubscribedSignal signal) {
            this.signal = signal;
        }

        public void periodic(TangoPeriodicEvent event) {
            try {
                DeviceAttribute attr = event.getValue();
                this.signal.setData(attr);
            }
            catch (DevFailed e) {
                this.signal.setData((Exception)((Object)e));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.signal.setData(e);
            }
            SubscribedSignal.this.parent.updateTable();
        }
    }

    class ArchiveEventListener
    implements ITangoArchiveListener {
        SubscribedSignal signal;

        ArchiveEventListener(SubscribedSignal signal) {
            this.signal = signal;
        }

        public void archive(TangoArchiveEvent event) {
            try {
                DeviceAttribute attr = event.getValue();
                this.signal.setData(attr);
            }
            catch (DevFailed e) {
                this.signal.setData((Exception)((Object)e));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.signal.setData(e);
            }
            SubscribedSignal.this.parent.updateTable();
        }
    }

    class ChangeEventListener
    implements ITangoChangeListener {
        SubscribedSignal signal;

        ChangeEventListener(SubscribedSignal signal) {
            this.signal = signal;
        }

        public void change(TangoChangeEvent event) {
            try {
                DeviceAttribute attr = event.getValue();
                this.signal.setData(attr);
            }
            catch (DevFailed e) {
                this.signal.setData((Exception)((Object)e));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.signal.setData(e);
            }
            SubscribedSignal.this.parent.updateTable();
        }
    }

    class SubscribeThread
    extends Thread {
        SubscribedSignal signal;

        SubscribeThread(SubscribedSignal signal) {
            this.signal = signal;
        }

        @Override
        public void run() {
            while (!this.signal.subscribed) {
                System.out.println("Trying to subscribe on " + SubscribedSignal.this.name);
                try {
                    this.signal.adapter = new TangoEventsAdapter(SubscribedSignal.this.deviceName);
                    if (SubscribedSignal.this.mode == 2) {
                        SubscribedSignal.this.arch_listener = new ArchiveEventListener(this.signal);
                        SubscribedSignal.this.adapter.addTangoArchiveListener((ITangoArchiveListener)SubscribedSignal.this.arch_listener, SubscribedSignal.this.attributeName, new String[0]);
                    } else if (SubscribedSignal.this.mode == 0) {
                        SubscribedSignal.this.change_listener = new ChangeEventListener(this.signal);
                        SubscribedSignal.this.adapter.addTangoChangeListener((ITangoChangeListener)SubscribedSignal.this.change_listener, SubscribedSignal.this.attributeName, new String[0]);
                    } else if (SubscribedSignal.this.mode == 1) {
                        SubscribedSignal.this.periodic_listener = new PeriodicEventListener(this.signal);
                        SubscribedSignal.this.adapter.addTangoPeriodicListener((ITangoPeriodicListener)SubscribedSignal.this.periodic_listener, SubscribedSignal.this.attributeName, new String[0]);
                    } else {
                        Except.throw_exception((String)"", (String)("Unknown event subscription mode (" + SubscribedSignal.this.mode + ")"), (String)"SubscribedSignal.SubscribeThread.run()");
                    }
                    SubscribedSignal.this.subscribed = true;
                    System.out.println("subscribeEvent() done for " + SubscribedSignal.this.name);
                    SubscribedSignal.this.except = null;
                }
                catch (DevFailed e) {
                    SubscribedSignal.this.except = e;
                    Except.print_exception((Exception)((Object)e));
                }
                catch (Exception e) {
                    SubscribedSignal.this.except = e;
                    e.printStackTrace();
                }
                try {
                    SubscribeThread.sleep(2000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    static class EventHistory {
        long time;
        double[] values;
        String d_value;
        String d_time;
        Exception except;

        EventHistory(long time, double[] values, String d_value, String d_time) {
            this.time = time;
            this.values = values;
            this.d_value = d_value;
            this.d_time = d_time;
            this.except = null;
        }
    }
}

