/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import admin.astor.tools.ListDialog;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ServerUsageDialog
extends JDialog {
    private JFrame parent;
    private List<TangoClass> tangoClasses = new ArrayList<TangoClass>();
    private List<Domain> domains = new ArrayList<Domain>();
    private int nbServers;
    private String wildcard;
    private String urlFile;
    private int serversCounter = 0;
    private static final String header = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<Title> title </Title>\n</HEAD>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#7F00FF\" ALINK=\"#FF0000\">\n<P><!-------TITLE------></P>\n";
    private static final String footer = "</Body>\n</Html>\n";
    private JTabbedPane tabbedPane;
    private JLabel titleLabel;

    public ServerUsageDialog(JFrame parent) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.initComponents(null);
    }

    public ServerUsageDialog(JFrame parent, String server) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.initComponents(server);
    }

    private void initComponents(String server) throws DevFailed {
        this.initComponents();
        this.displayServerUsage(server);
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void displayServerUsage(String inputServer) throws DevFailed {
        Object servers;
        List<Object> serverList;
        if (inputServer != null) {
            serverList = new ArrayList<String>();
            serverList.add(inputServer);
        } else {
            servers = ApiUtil.get_db_obj().get_server_name_list();
            ListDialog dialog = new ListDialog(this.parent, "Servers in " + ApiUtil.getTangoHost(), (String[])servers);
            serverList = dialog.showDialog();
            if (serverList == null || serverList.isEmpty()) {
                this.doClose();
                return;
            }
        }
        try {
            AstorUtil.startSplash((String)serverList.get(0));
            servers = serverList.iterator();
            while (servers.hasNext()) {
                String server;
                this.wildcard = server = (String)servers.next();
                this.wildcard = this.wildcard + "/*";
                this.titleLabel.setText(this.wildcard);
                this.tangoClasses.clear();
                this.domains.clear();
                String[] serverNames = ApiUtil.get_db_obj().get_server_list(this.wildcard);
                this.nbServers = serverNames.length;
                for (String serverName : serverNames) {
                    AstorUtil.increaseSplashProgress(1, serverName);
                    this.fillTangoClasses(serverName);
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                URL url = new URL(this.buildTmpFile(this.toHtml()));
                JEditorPane editorPane = new JEditorPane();
                editorPane.setEditable(false);
                editorPane.setPage(url);
                JScrollPane scrollPane = new JScrollPane(editorPane);
                scrollPane.setPreferredSize(new Dimension(480, 440));
                this.tabbedPane.add(scrollPane);
                this.tabbedPane.setTitleAt(this.serversCounter++, server);
                this.tabbedPane.setSelectedComponent(scrollPane);
            }
            AstorUtil.stopSplash();
        }
        catch (IOException e) {
            Except.throw_exception((String)"URL failed", (String)e.getMessage());
        }
    }

    private String buildTmpFile(String code) {
        String urlStr = null;
        try {
            int random_value = new Random().nextInt(30000);
            String tmpDir = System.getProperty("java.io.tmpdir");
            this.urlFile = tmpDir + "/html." + random_value;
            FileOutputStream outputStream = new FileOutputStream(this.urlFile);
            outputStream.write((header + code + footer).getBytes());
            outputStream.close();
            urlStr = "file:" + this.urlFile;
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (Exception)e);
            e.printStackTrace();
        }
        return urlStr;
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton anotherBtn = new JButton();
        JLabel jLabel1 = new JLabel();
        JButton cancelBtn = new JButton();
        this.tabbedPane = new JTabbedPane();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ServerUsageDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        anotherBtn.setText("Another Server");
        anotherBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerUsageDialog.this.anotherBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(anotherBtn);
        jLabel1.setText("                              ");
        bottomPanel.add(jLabel1);
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerUsageDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void anotherBtnActionPerformed(ActionEvent evt) {
        try {
            this.displayServerUsage(null);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
        }
    }

    private void doClose() {
        try {
            if (this.urlFile != null && !new File(this.urlFile).delete()) {
                System.err.println("Cannot delete " + this.urlFile);
            }
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (Exception)e);
        }
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void fillTangoClasses(String serverName) throws DevFailed {
        DbServer server = new DbServer(serverName);
        String[] class_dev = server.get_device_class_list();
        boolean doneForServer = false;
        for (int i = 0; i < class_dev.length; i += 2) {
            String deviceName = class_dev[i];
            String className = class_dev[i + 1];
            if (className.equals("DServer")) continue;
            ArrayList _class = null;
            for (TangoClass tangoClass : this.tangoClasses) {
                if (!tangoClass.name.toLowerCase().equals(className.toLowerCase())) continue;
                _class = tangoClass;
            }
            if (_class == null) {
                _class = new TangoClass(className);
                this.tangoClasses.add((TangoClass)_class);
            }
            _class.add(deviceName);
            Domain domain = this.getDomain(deviceName);
            domain.add(deviceName);
            if (doneForServer) continue;
            domain.addServer();
            doneForServer = true;
        }
    }

    private Domain getDomain(String deviceName) throws DevFailed {
        Domain domain = null;
        String domainName = deviceName.substring(0, deviceName.indexOf("/")).toLowerCase();
        for (Domain d : this.domains) {
            if (!d.name.equalsIgnoreCase(domainName)) continue;
            domain = d;
        }
        if (domain == null) {
            domain = new Domain(domainName);
            this.domains.add(domain);
        }
        return domain;
    }

    private String toHtml() {
        int nbDevices = 0;
        for (TangoClass tangoClass : this.tangoClasses) {
            nbDevices += tangoClass.size();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<font size+=1><b>").append(nbDevices).append(" devices for ").append(this.nbServers).append(" server instances </u></b></font>\n");
        sb.append("<br><br>\n");
        sb.append("<table border=0> <td>\n");
        sb.append("<font size+=1><b><u>By Domain:</u></b></font>\n");
        sb.append("<table border=1 cellSpacing=0>\n");
        sb.append("<td><b>Domain</b></td> <td><b>Instances</b></td> <td><b>Devices</b></td>\n");
        for (Domain domain : this.domains) {
            sb.append("<tr> <td> ").append(domain.name).append(" </td> <td>").append(domain.nbServers).append(" </td> <td>").append(domain.size()).append(" </td> </tr>\n");
        }
        sb.append("</table>\n");
        sb.append("</td> <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td> <td>\n");
        sb.append("<font size+=1><b><u>Devices by Class:</u></b></font>\n");
        sb.append("<table border=1 cellSpacing=0>\n");
        sb.append("<td><b>Class name</b></td> <td><b>Devices</b></td>\n");
        for (TangoClass tangoClass : this.tangoClasses) {
            sb.append("<tr> <td> ").append(tangoClass.name).append(" </td> <td>").append(tangoClass.size()).append(" </td> </tr>\n");
        }
        sb.append("</table>\n");
        sb.append("</td></table>\n");
        return sb.toString();
    }

    @Override
    public String toString() {
        int nbDevices = 0;
        StringBuilder sb = new StringBuilder();
        sb.append(this.wildcard).append("\n");
        sb.append("\n=====================================\n");
        for (TangoClass tangoClass : this.tangoClasses) {
            sb.append(tangoClass);
            nbDevices += tangoClass.size();
        }
        sb.append("\n=====================================\n");
        for (Domain domain : this.domains) {
            sb.append("Domain ").append(domain.name).append(":\t");
            sb.append(domain.size()).append(" devices\t");
            sb.append(domain.nbServers).append(" servers\n");
        }
        sb.append("\n=====================================\n");
        sb.append(this.nbServers).append("\tservers\n");
        sb.append(nbDevices).append("\tdevices\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            new ServerUsageDialog(null, null).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
        }
    }

    private class TangoClass
    extends ArrayList<String> {
        private String name;

        private TangoClass(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            return "Class " + this.name + ":\t" + this.size() + " devices\n";
        }
    }

    private class Domain
    extends ArrayList<String> {
        private String name;
        private int nbServers = 0;

        private Domain(String name) {
            this.name = name;
        }

        private void addServer() {
            ++this.nbServers;
        }

        @Override
        public String toString() {
            return "Domain " + this.name + ":\t" + this.size() + " devices\n";
        }
    }
}

