/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class PopupTable
extends JDialog {
    private DataTableModel model;
    private static String[] col_names;
    private String[][] data;
    private JLabel titleLabel;
    private Window parent;
    private boolean fromApplication = true;
    private boolean sortAvailable = true;
    private JTable my_table;
    private JScrollPane scrollPane;

    public PopupTable(JFrame parent, String filename) throws SecurityException, IOException, DevFailed {
        this(parent, filename, (Dimension)null);
    }

    public PopupTable(JFrame parent, String filename, Dimension dim) throws SecurityException, IOException, DevFailed {
        super((Frame)parent, false);
        this.parent = parent;
        this.readDataFile(filename);
        this.buildObject(filename, col_names, this.data, dim);
        if (parent.getWidth() == 0) {
            this.fromApplication = false;
        }
    }

    public PopupTable(JFrame parent, String title, String filename) throws SecurityException, IOException, DevFailed {
        this(parent, title, filename, null);
    }

    public PopupTable(JFrame parent, String title, String filename, Dimension dim) throws SecurityException, IOException, DevFailed {
        super((Frame)parent, false);
        this.parent = parent;
        this.readDataFile(filename);
        this.buildObject(title, col_names, this.data, dim);
        if (parent.getWidth() == 0) {
            this.fromApplication = false;
        }
    }

    public PopupTable(JFrame parent, String title, String[] col, List<String[]> list) throws DevFailed {
        this(parent, title, col, list, null);
    }

    public PopupTable(JDialog parent, String title, String[] col, List<String[]> list) throws DevFailed {
        this(parent, title, col, list, null);
    }

    public PopupTable(JDialog parent, String title, String[] col, String[][] array) throws DevFailed {
        this(parent, title, col, array, null);
    }

    public PopupTable(JDialog parent, String title, String[] col, List<String[]> list, Dimension dim) throws DevFailed {
        super((Dialog)parent, false);
        this.parent = parent;
        this.buildObject(title, col, (String[][])list.toArray((T[])new String[list.size()][]), dim);
    }

    public PopupTable(JDialog parent, String title, String[] col, String[][] array, Dimension dim) throws DevFailed {
        super((Dialog)parent, false);
        this.parent = parent;
        this.buildObject(title, col, array, dim);
    }

    public PopupTable(JFrame parent, String title, String[] col, String[][] array) throws DevFailed {
        this(parent, title, col, array, null);
    }

    public PopupTable(JFrame parent, String title, String[] col, List<String[]> list, Dimension dim) throws DevFailed {
        super((Frame)parent, false);
        this.parent = parent;
        this.buildObject(title, col, (String[][])list.toArray((T[])new String[list.size()][]), dim);
    }

    public PopupTable(JFrame parent, String title, String[] col, String[][] array, Dimension dim) throws DevFailed {
        super((Frame)parent, false);
        this.parent = parent;
        this.buildObject(title, col, array, dim);
        if (parent.getWidth() == 0) {
            this.fromApplication = false;
        }
    }

    private void readDataFile(String filename) throws SecurityException, IOException {
        FileInputStream fid = new FileInputStream(filename);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        int nb1 = fid.read(inStr);
        if (nb1 == 0) {
            return;
        }
        String str = new String(inStr);
        fid.close();
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(str, "\n");
        while (stk.hasMoreTokens()) {
            tokens.add(stk.nextToken());
        }
        System.out.println(tokens.size() + " lines");
        this.data = new String[tokens.size() - 1][];
        for (int i = 0; i < tokens.size(); ++i) {
            int j;
            String line = (String)tokens.get(i);
            stk = new StringTokenizer(line, "\t");
            if (i == 0) {
                col_names = new String[stk.countTokens()];
                j = 0;
                while (stk.hasMoreTokens()) {
                    PopupTable.col_names[j] = stk.nextToken();
                    ++j;
                }
                continue;
            }
            this.data[i - 1] = new String[stk.countTokens()];
            j = 0;
            while (stk.hasMoreTokens()) {
                this.data[i - 1][j] = stk.nextToken();
                ++j;
            }
        }
    }

    private void buildObject(String title, String[] col, String[][] array, Dimension dim) throws DevFailed {
        col_names = col;
        this.initComponents();
        this.data = array;
        this.initMyComponents(dim);
        this.titleLabel.setText(title);
        if (this.parent.getWidth() > 0) {
            Point p = this.parent.getLocationOnScreen();
            p.x += 10;
            p.y += 10;
            this.setLocation(p);
        }
        this.pack();
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JButton cancelBtn = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PopupTable.this.closeDialog();
            }
        });
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(evt -> this.cancelBtnActionPerformed());
        jPanel1.add(cancelBtn);
        this.getContentPane().add((Component)jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        this.pack();
    }

    private void initMyComponents(Dimension dim) throws DevFailed {
        try {
            this.model = new DataTableModel();
            JTable table = new JTable(this.model);
            table.setRowSelectionAllowed(true);
            table.setColumnSelectionAllowed(true);
            table.setDragEnabled(true);
            table.setSelectionMode(0);
            table.getTableHeader().setFont(new Font("Dialog", 1, 14));
            table.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    PopupTable.this.tableActionPerformed(evt);
                }
            });
            this.scrollPane = new JScrollPane(table);
            if (dim == null) {
                int heith = 18 + 18 * this.data.length;
                if (heith > 400) {
                    heith = 400;
                }
                this.scrollPane.setPreferredSize(new Dimension(650, heith));
            } else {
                this.scrollPane.setPreferredSize(dim);
            }
            this.getContentPane().add((Component)this.scrollPane, "Center");
            this.my_table = table;
        }
        catch (Exception e) {
            e.printStackTrace();
            Except.throw_exception((String)"INIT_ERROR", (String)e.toString(), (String)"PopupTable.initMyComponents()");
        }
        this.model.fireTableDataChanged();
    }

    public void setSortAvailable(boolean b) {
        this.sortAvailable = b;
    }

    private void tableActionPerformed(MouseEvent evt) {
        int column = this.my_table.getTableHeader().columnAtPoint(new Point(evt.getX(), evt.getY()));
        if (this.sortAvailable) {
            new UsedData().sort(column);
        }
        this.model.fireTableDataChanged();
    }

    public void setColumnWidth(int[] width) {
        Enumeration<TableColumn> cenum = this.my_table.getColumnModel().getColumns();
        int sp_width = 0;
        int i = 0;
        while (cenum.hasMoreElements()) {
            TableColumn tc = cenum.nextElement();
            tc.setPreferredWidth(width[i]);
            sp_width += width[i];
            ++i;
        }
        this.scrollPane.setPreferredSize(new Dimension(sp_width, 450));
        this.pack();
    }

    private void cancelBtnActionPerformed() {
        this.doClose();
    }

    private void closeDialog() {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (!this.fromApplication) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("File's name to find data ?");
            System.exit(0);
        }
        try {
            new PopupTable(new JFrame(), args[0]).setVisible(true);
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (Exception)e);
            e.printStackTrace();
            System.exit(0);
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return PopupTable.this.data[0].length;
        }

        @Override
        public int getRowCount() {
            return PopupTable.this.data.length;
        }

        @Override
        public String getColumnName(int aCol) {
            if (aCol >= this.getColumnCount()) {
                return col_names[this.getColumnCount() - 1];
            }
            return col_names[aCol];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return PopupTable.this.data[row][col];
        }
    }

    class UsedData
    extends ArrayList<String[]> {
        private int column;

        UsedData() {
            this.addAll(Arrays.asList(PopupTable.this.data));
        }

        void sort(int column) {
            this.column = column;
            this.sort(new StringArrayComparator());
            for (int i = 0; i < this.size(); ++i) {
                ((PopupTable)PopupTable.this).data[i] = (String[])this.get(i);
            }
        }

        class StringArrayComparator
        implements Comparator<String[]> {
            StringArrayComparator() {
            }

            @Override
            public int compare(String[] a1, String[] a2) {
                String s1 = a1[UsedData.this.column];
                String s2 = a2[UsedData.this.column];
                try {
                    double d1 = Double.parseDouble(s1);
                    double d2 = Double.parseDouble(s2);
                    if (d1 == d2) {
                        return 0;
                    }
                    return d1 > d2 ? 1 : -1;
                }
                catch (NumberFormatException numberFormatException) {
                    return s1.compareToIgnoreCase(s2);
                }
            }
        }
    }
}

