/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class PingHosts {
    private List<String> aliveList = new ArrayList<String>();
    private List<String> stoppedList = new ArrayList<String>();
    private static final String PingCommand = AstorUtil.osIsUnix() ? "ping  -c 1 -W 1 " : "ping  -n 1 -w 1 ";
    private static final String AliveResponse = AstorUtil.osIsUnix() ? "1 received" : "Received = 1";

    public PingHosts(String host) {
        this(new String[]{host});
    }

    PingHosts(String[] hosts) {
        ArrayList<PingThread> threads = new ArrayList<PingThread>();
        for (String host : hosts) {
            PingThread thread = new PingThread(host);
            thread.start();
            threads.add(thread);
        }
        for (PingThread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (thread.hostAlive()) {
                this.aliveList.add(thread.hostName);
            } else {
                this.stoppedList.add(thread.hostName);
            }
            thread.interrupt();
        }
    }

    public boolean noStopped() {
        return this.stoppedList.isEmpty();
    }

    public List<String> getAliveList() {
        return this.aliveList;
    }

    List<String> getStoppedList() {
        return this.stoppedList;
    }

    private class PingThread
    extends Thread {
        private String hostName;
        private boolean alive = false;

        private PingThread(String hostName) {
            this.hostName = hostName;
        }

        private boolean hostAlive() {
            return this.alive;
        }

        @Override
        public void run() {
            try {
                String str = this.executeShellCmdOneLine(PingCommand + this.hostName);
                this.alive = str.contains(AliveResponse);
                if (!this.alive) {
                    System.out.println(str);
                }
            }
            catch (DevFailed e) {
                Except.print_exception((Exception)((Object)e));
            }
        }

        String executeShellCmdOneLine(String cmd) throws DevFailed {
            StringBuilder sb = new StringBuilder();
            try {
                String str;
                Process process = Runtime.getRuntime().exec(cmd);
                InputStream inputStream = process.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                while ((str = br.readLine()) != null) {
                    sb.append(str).append("\n");
                }
            }
            catch (Exception e) {
                Except.throw_exception((String)e.toString(), (String)("The shell command\n" + cmd + "\nHas failed"));
            }
            return sb.toString();
        }
    }
}

