/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.events.DbEventImportInfo;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFrame;

public class MySqlUtil {
    private static MySqlUtil instance = new MySqlUtil();

    public static MySqlUtil getInstance() {
        return instance;
    }

    public MySqlData executeMySqlSelect(String command) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(command);
        DeviceData argout = ApiUtil.get_db_obj().command_inout("DbMySqlSelect", argIn);
        return new MySqlData(argout.extractLongStringArray());
    }

    public String[] getHostControlledList() throws DevFailed {
        ArrayList deviceList = new ArrayList();
        String command = "SELECT name FROM device WHERE class=\"Starter\" ORDER BY name";
        MySqlData result = this.executeMySqlSelect(command);
        for (MySqlRow row : result) {
            if (!row.hasNoNull()) continue;
            deviceList.add(row.get(0));
        }
        ArrayList<String> hostList = new ArrayList<String>();
        for (String deviceName : deviceList) {
            StringTokenizer stk = new StringTokenizer(deviceName, "/");
            if (stk.countTokens() != 3) continue;
            stk.nextToken();
            stk.nextToken();
            String host = stk.nextToken();
            int idx = host.indexOf(46);
            if (idx > 0) {
                host = host.substring(0, idx);
            }
            if (hostList.contains(host)) {
                System.err.println("WARNING: " + host + " found several times as Starter");
                continue;
            }
            hostList.add(host);
        }
        return hostList.toArray(new String[0]);
    }

    public DbEventImportInfo[] getMultipleEventImportInfo(String deviceName) throws DevFailed {
        String table = "event";
        String[] fields = new String[]{"name", "host", "exported", "ior"};
        StringBuilder cmd = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            cmd.append(fields[i]);
            if (i >= fields.length - 1) continue;
            cmd.append(",");
        }
        cmd.append(" FROM ").append(table);
        cmd.append(" WHERE name LIKE \"").append(deviceName).append("\"");
        MySqlData result = this.executeMySqlSelect(cmd.toString());
        DbEventImportInfo[] info = new DbEventImportInfo[result.size()];
        int idx = 0;
        for (MySqlRow row : result) {
            if (!row.hasNoNull()) continue;
            info[idx++] = new DbEventImportInfo(((String)row.get(0)).toLowerCase(), (String)row.get(1), ((String)row.get(2)).equals("1"), (String)row.get(3));
        }
        return info;
    }

    public DbDevImportInfo[] getHostDevImportInfo(String deviceName) throws DevFailed {
        String table = "device";
        String[] fields = new String[]{"name", "exported", "version", "ior", "server", "host", "class"};
        StringBuilder cmd = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            cmd.append(fields[i]);
            if (i >= fields.length - 1) continue;
            cmd.append(",");
        }
        cmd.append(" FROM ").append(table);
        cmd.append(" WHERE name LIKE \"").append(deviceName).append("\" ORDER BY name");
        MySqlData result = this.executeMySqlSelect(cmd.toString());
        DbDevImportInfo[] info = new DbDevImportInfo[result.size()];
        int idx = 0;
        for (MySqlRow row : result) {
            if (!row.hasNoNull()) continue;
            info[idx++] = new DbDevImportInfo(((String)row.get(0)).toLowerCase(), ((String)row.get(1)).equals("1"), (String)row.get(2), (String)row.get(3), (String)row.get(4), (String)row.get(5), (String)row.get(6));
        }
        return info;
    }

    public List<String[]> getHostProperty(String deviceName, String propertyName) throws DevFailed {
        String table = "property_device";
        String[] fields = new String[]{"device", "value"};
        StringBuilder cmd = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            cmd.append(fields[i]);
            if (i >= fields.length - 1) continue;
            cmd.append(",");
        }
        cmd.append(" FROM ").append(table);
        cmd.append(" WHERE device LIKE \"").append(deviceName).append("\"");
        cmd.append(" And name = \"").append(propertyName).append("\"");
        MySqlData result = this.executeMySqlSelect(cmd.toString());
        ArrayList<String[]> lines = new ArrayList<String[]>();
        for (MySqlRow row : result) {
            if (!row.hasNoNull()) continue;
            lines.add(new String[]{(String)row.get(0), (String)row.get(1)});
        }
        return lines;
    }

    public void manageTangoHostProperties(List<TangoHost> hosts) {
        try {
            String starters = AstorUtil.getStarterDeviceHeader() + "%";
            MySqlUtil mysql = MySqlUtil.getInstance();
            List<String[]> collections = mysql.getHostProperty(starters, "HostCollection");
            List<String[]> host_usage = mysql.getHostProperty(starters, "HostUsage");
            for (TangoHost host : hosts) {
                if (host != null) {
                    String deviceName = host.get_name();
                    for (String[] collection : collections) {
                        if (!deviceName.equals(collection[0])) continue;
                        host.collection = collection[1];
                    }
                    for (String[] usage : host_usage) {
                        if (!deviceName.equals(usage[0])) continue;
                        host.usage = usage[1];
                    }
                    continue;
                }
                System.err.println("Host is null");
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
        }
    }

    private static class MySqlData
    extends ArrayList<MySqlRow> {
        private MySqlData(DevVarLongStringArray lsa) {
            int nbRows = lsa.lvalue[lsa.lvalue.length - 2];
            int nbFields = lsa.lvalue[lsa.lvalue.length - 1];
            int idx = 0;
            for (int i = 0; i < nbRows; ++i) {
                ArrayList<String> row = new ArrayList<String>();
                int j = 0;
                while (j < nbFields) {
                    if (lsa.lvalue[idx] != 0) {
                        row.add(lsa.svalue[idx]);
                    } else {
                        row.add(null);
                    }
                    ++j;
                    ++idx;
                }
                this.add(new MySqlRow(row));
            }
        }
    }

    private static class MySqlRow
    extends ArrayList<String> {
        private MySqlRow(List<String> vs) {
            this.addAll(vs);
        }

        private boolean hasNoNull() {
            for (String s : this) {
                if (s != null) continue;
                return false;
            }
            return true;
        }
    }
}

