/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DeviceSelection
extends JDialog {
    private Component parent;
    private ServerTree serverTree;
    private String selectedDevice = null;
    private String serverName;
    private boolean withDServer;
    private ImageIcon serverIcon;
    private ImageIcon classIcon;
    private ImageIcon deviceIcon;
    private JPanel centerPanel;
    private JLabel titleLabel;

    public DeviceSelection(JFrame parent, String serverName, String[] classDeviceNames, boolean withDServer) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.serverName = serverName;
        this.withDServer = withDServer;
        this.buildTheForm(classDeviceNames);
    }

    public DeviceSelection(JDialog parent, String serverName, String[] classDeviceNames, boolean withDServer) throws DevFailed {
        super((Dialog)parent, true);
        this.parent = parent;
        this.serverName = serverName;
        this.withDServer = withDServer;
        this.buildTheForm(classDeviceNames);
    }

    private void buildTheForm(String[] classDeviceNames) throws DevFailed {
        this.initComponents();
        this.serverIcon = Utils.getInstance().getIcon("server.gif");
        this.classIcon = Utils.getInstance().getIcon("class.gif");
        this.deviceIcon = Utils.getInstance().getIcon("device.gif");
        if (classDeviceNames == null) {
            classDeviceNames = DeviceSelection.getClassDevices(this.serverName);
        }
        this.getContentPane().remove(this.centerPanel);
        this.serverTree = new ServerTree(this.serverName, classDeviceNames);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.serverTree);
        scrollPane.setPreferredSize(new Dimension(350, 400));
        this.getContentPane().add((Component)scrollPane, "Center");
        this.titleLabel.setText("Device Selection by class");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    public static String[] getClassDevices(String serverName) throws DevFailed {
        StringTokenizer stk = new StringTokenizer(serverName, "/");
        String deviceName = null;
        switch (stk.countTokens()) {
            case 2: {
                deviceName = "dserver/" + serverName;
                break;
            }
            case 3: {
                deviceName = serverName;
                break;
            }
            default: {
                Except.throw_exception((String)"BadParam", (String)(serverName + " not a server name"));
            }
        }
        DeviceData argOut = new DeviceProxy(deviceName).command_inout("QueryDevice");
        return argOut.extractStringArray();
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.centerPanel = new JPanel();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DeviceSelection.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        this.centerPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.centerPanel, "Center");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeviceSelection.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeviceSelection.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.selectedDevice = this.serverTree.getSelectedDevice();
        if (this.selectedDevice == null) {
            JOptionPane.showMessageDialog(this, "No device selected !");
        } else {
            this.doClose();
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.selectedDevice = null;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.selectedDevice = null;
        this.doClose();
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public String showDialog() {
        this.setVisible(true);
        return this.selectedDevice;
    }

    public static void main(String[] args) {
        try {
            String serverName = "VacGaugeServer/sr_c01-pen";
            String[] classDeviceNames = DeviceSelection.getClassDevices(serverName);
            if (classDeviceNames.length > 1) {
                String deviceName = new DeviceSelection((JDialog)null, serverName, classDeviceNames, true).showDialog();
                if (deviceName != null) {
                    System.out.println(deviceName);
                }
                System.exit(0);
            } else {
                String deviceName = classDeviceNames[0];
                int idx = deviceName.indexOf("::");
                if (idx > 0) {
                    deviceName = deviceName.substring(idx + 2);
                }
                System.out.println(deviceName);
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)e);
            System.exit(0);
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private final Font rootFont = new Font("Dialog", 1, 14);
        private final Font collectionFont = new Font("Dialog", 1, 12);
        private final Font leafFont = new Font("Dialog", 0, 12);

        private TangoRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(Color.white);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (row == 0) {
                this.setFont(this.rootFont);
                this.setIcon(DeviceSelection.this.serverIcon);
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                if (node.getUserObject() instanceof ClassObject) {
                    this.setFont(this.collectionFont);
                    this.setIcon(DeviceSelection.this.classIcon);
                } else {
                    this.setFont(this.leafFont);
                    this.setIcon(DeviceSelection.this.deviceIcon);
                }
            }
            return this;
        }
    }

    private class ServerTree
    extends JTree
    implements TangoConst {
        private DefaultMutableTreeNode rootNode;

        private ServerTree(String serverName, String[] classDeviceNames) {
            this.rootNode = new DefaultMutableTreeNode(serverName);
            this.createNodes(classDeviceNames);
            this.getSelectionModel().setSelectionMode(1);
            DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
            this.setModel(treeModel);
            ToolTipManager.sharedInstance().registerComponent(this);
            TangoRenderer renderer = new TangoRenderer();
            this.setCellRenderer(renderer);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    ServerTree.this.treeMouseClicked(evt);
                }
            });
            this.setSelectionPath(null);
        }

        private void treeMouseClicked(MouseEvent evt) {
            TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
            Object userObject = node.getUserObject();
            if (evt.getClickCount() == 2 && evt.getButton() == 1 && userObject instanceof DeviceObject) {
                DeviceSelection.this.okBtnActionPerformed(null);
            }
        }

        private void createNodes(String[] classDeviceNames) {
            ClassObject _class = null;
            DefaultMutableTreeNode classNode = null;
            for (String str : classDeviceNames) {
                StringTokenizer stk = new StringTokenizer(str, "::");
                if (stk.countTokens() != 2) continue;
                String className = stk.nextToken();
                String deviceName = stk.nextToken();
                if (_class == null || !className.equals(_class.name)) {
                    _class = new ClassObject(className);
                    classNode = new DefaultMutableTreeNode(_class);
                    this.rootNode.add(classNode);
                }
                classNode.add(new DefaultMutableTreeNode(new DeviceObject(deviceName)));
            }
            if (DeviceSelection.this.withDServer) {
                classNode = new DefaultMutableTreeNode(new ClassObject("DServer"));
                this.rootNode.add(classNode);
                classNode.add(new DefaultMutableTreeNode(new DeviceObject("dserver/" + DeviceSelection.this.serverName.toLowerCase())));
            }
        }

        private String getSelectedDevice() {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            if (node == null) {
                return null;
            }
            return node.getUserObject().toString();
        }
    }

    private class ClassObject {
        String name;

        private ClassObject(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class DeviceObject {
        String name;

        private DeviceObject(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

