/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.RemoteLoginThread;
import admin.astor.TangoServer;
import admin.astor.tools.DeviceHierarchyDialog;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DeviceHierarchy
extends JTree
implements AstorDefs {
    private static ImageIcon root_icon;
    private Astor astor = null;
    private boolean running = true;
    private Device root = null;
    private String rootname = null;
    private DeviceHierarchyPopupMenu menu;
    private DeviceHierarchyDialog parent;
    private String[] deviceNames = new String[0];
    private static final Color BACKGROUND;
    private static final String SUB_DEV_PROP_NAME = "__SubDevices";
    private static final int UPDATE = 0;
    private static final int TEST_DEVICE = 1;
    private static final int HOST_PANEL = 2;
    private static final int REM_LOGIN = 3;
    private static final int OFFSET = 2;
    private static String[] menuLabels;

    public DeviceHierarchy(DeviceHierarchyDialog parent, Astor astor, String name) throws DevFailed {
        this.parent = parent;
        this.astor = astor;
        this.setBackground(BACKGROUND);
        this.initNames(name);
        this.buildTree();
        this.menu = new DeviceHierarchyPopupMenu(this);
        this.expandRow(0);
        for (int i = 0; i < this.getRowCount(); ++i) {
            TreePath tp = this.getPathForRow(i);
            Device d = (Device)tp.getLastPathComponent();
            if (!d.isDeviceFromServer) continue;
            this.expandPath(tp);
        }
    }

    private void initNames(String name) throws DevFailed {
        String[] nameSplied = name.split("/");
        switch (nameSplied.length) {
            case 2: {
                this.rootname = nameSplied[0] + "/" + nameSplied[1];
                String admin = "dserver/" + this.rootname;
                String[] tmp = new TangoServer(admin).queryDeviceFromDb();
                this.deviceNames = new String[tmp.length + 1];
                System.arraycopy(tmp, 0, this.deviceNames, 0, tmp.length);
                this.deviceNames[tmp.length] = admin;
                break;
            }
            case 3: {
                this.rootname = "Device";
                this.deviceNames = new String[1];
                this.deviceNames[0] = nameSplied[0] + "/" + nameSplied[1] + "/" + nameSplied[2];
                break;
            }
            default: {
                Except.throw_exception((String)"BAD_PARAMETER", (String)"Bad device or server name", (String)"DeviceHierarchy.initNames()");
            }
        }
        this.root = new Device(this.rootname, true);
        this.root.isParent = true;
        Device[] devices = new Device[this.deviceNames.length];
        ArrayList<String> listOfChildren = new ArrayList<String>();
        for (int i = 0; i < this.deviceNames.length; ++i) {
            String deviceName = this.deviceNames[i];
            devices[i] = new Device(deviceName, true);
            this.addChildrenIfIsNotAlready(listOfChildren, devices[i]);
        }
        for (Device dev : devices) {
            if (listOfChildren.contains(dev.name)) continue;
            dev.isRootDevice = true;
            this.root.add(dev);
        }
    }

    private void buildTree() {
        this.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
        this.setModel(treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        TangoRenderer renderer = new TangoRenderer();
        this.setCellRenderer(renderer);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DeviceHierarchy.this.treeMouseClicked(evt);
            }
        });
    }

    private void treeMouseClicked(MouseEvent evt) {
        DefaultMutableTreeNode node;
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        DefaultMutableTreeNode o = node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        int mask = evt.getModifiers();
        if (evt.getClickCount() != 2 || (mask & 0x10) == 0) {
            if ((mask & 0x10) != 0) {
                this.deviceInfo((Device)node);
            } else if ((mask & 4) != 0) {
                if (node == this.root) {
                    this.menu.showMenu(evt, (String)((Object)o));
                } else if (o instanceof Device) {
                    this.menu.showMenu(evt, (Device)o);
                }
            }
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node;
    }

    private void testDevice(Device dev) {
        AstorUtil.testDevice(this.parent, dev.name);
    }

    private void deviceInfo(Device dev) {
        try {
            String info = dev.getInfo();
            this.parent.setText(info);
        }
        catch (DevFailed e) {
            this.parent.setText(Except.str_exception((Exception)((Object)e)));
        }
    }

    private void remoteShell(Device dev) {
        try {
            String hostname = dev.getHost();
            new RemoteLoginThread(hostname).start();
        }
        catch (DevFailed e) {
            this.parent.setText(Except.str_exception((Exception)((Object)e)));
        }
    }

    private void hostPanel(Device dev) {
        try {
            this.astor.tree.displayHostInfoDialog(dev.getHost());
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
        }
    }

    void stopThread() {
        this.running = false;
    }

    @Override
    public String toString() {
        String str = "";
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            Device dev = this.root.getDevice(i);
            str = str + dev.toFullString();
            for (int j = 0; j < dev.getChildCount(); ++j) {
                str = str + dev.getDevice(j).toFullString();
            }
        }
        return str;
    }

    private void addChildrenIfIsNotAlready(ArrayList<String> listOfChildren, Device dev) {
        for (String child : dev.childrenStr) {
            if (listOfChildren.contains(child) || dev.name.equals(child)) continue;
            listOfChildren.add(child);
        }
    }

    static {
        BACKGROUND = new Color(240, 240, 240);
        menuLabels = new String[]{"Update Dependencies", "Test Device", "Host Panel", "Remote Login"};
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private final int TITLE = 0;
        private final int COLLEC = 1;
        private final int LEAF = 2;
        private boolean firstPass = true;

        public TangoRenderer() {
            Utils utils = Utils.getInstance();
            root_icon = utils.getIcon("TangoClass.png", 0.33);
            this.fonts = new Font[3];
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 12);
            this.fonts[2] = new Font("Dialog", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(BACKGROUND);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (row == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(root_icon);
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                if (node instanceof Device) {
                    this.setFont(this.fonts[1]);
                    Device device = (Device)node;
                    this.setIcon(AstorUtil.state_icons[device.state]);
                    if (device.too_old) {
                        this.setBackgroundNonSelectionColor(Color.yellow);
                    }
                }
            }
            return this;
        }
    }

    private class Device
    extends DefaultMutableTreeNode {
        DeviceProxy proxy;
        DevFailed failed;
        String name;
        boolean too_old;
        boolean isParent;
        boolean isPopulated;
        boolean isRootDevice;
        boolean isDeviceFromServer;
        short state;
        String[] childrenStr;

        private Device(String name, boolean isDeviceFromServer) {
            super(name);
            this.failed = null;
            this.too_old = false;
            this.isParent = false;
            this.isPopulated = false;
            this.isRootDevice = false;
            this.isDeviceFromServer = false;
            this.state = (short)6;
            AstorUtil.increaseSplashProgress(1, "checking for " + name);
            this.isDeviceFromServer = isDeviceFromServer;
            try {
                this.name = name;
                this.proxy = new DeviceProxy(name);
                new StateManager().start();
                DbDatum datum = this.proxy.get_property(DeviceHierarchy.SUB_DEV_PROP_NAME);
                this.childrenStr = datum.extractStringArray();
                if (this.childrenStr.length == 1 && this.childrenStr[0] == "") {
                    this.childrenStr = new String[0];
                } else {
                    this.isParent = true;
                }
            }
            catch (DevFailed e) {
                System.err.println(e.errors[0].desc);
                this.failed = e;
            }
        }

        @Override
        public boolean isLeaf() {
            return !this.isParent;
        }

        private Device getDevice(int i) {
            return (Device)this.getChildAt(i);
        }

        private String toFullString() {
            String toReturn = (String)this.userObject;
            toReturn = toReturn + '\n';
            for (int i = 0; i < this.getChildCount(); ++i) {
                Device d = this.getDevice(i);
                toReturn = toReturn + '\t' + (String)d.userObject + '\n';
            }
            toReturn = toReturn + "------------------------------------------------";
            return toReturn;
        }

        @Override
        public int getChildCount() {
            if (this.isParent && this.childrenStr != null && !this.isPopulated) {
                this.isPopulated = true;
                for (String child : this.childrenStr) {
                    boolean isDeviceFromServer = this.isDeviceFromServer(child);
                    Device dev = new Device(child, isDeviceFromServer);
                    this.add(dev);
                }
            }
            return super.getChildCount();
        }

        private boolean isDeviceFromServer(String child) {
            if (child.equals(this.name)) {
                return false;
            }
            for (String dev : DeviceHierarchy.this.deviceNames) {
                if (!dev.equals(child)) continue;
                return true;
            }
            return false;
        }

        private String getHost() throws DevFailed {
            DeviceInfo info = this.proxy.get_info();
            return info.hostname;
        }

        private String getInfo() throws DevFailed {
            if (this.failed != null) {
                return Except.str_exception((Exception)((Object)this.failed));
            }
            StringBuilder sb = new StringBuilder();
            if (this.too_old) {
                sb.append("   WARNING:  Too Old TANGO Release \n").append("             To get dependencies !!!\n").append("\n========================================================\n");
            }
            sb.append(this.proxy.get_info().toString());
            sb.append("\n========================================================\n");
            try {
                String s = this.proxy.status();
                sb.append(s);
            }
            catch (DevFailed e) {
                sb.append(Except.str_exception((Exception)((Object)e)));
            }
            return sb.toString();
        }

        @Override
        public String toString() {
            return (String)this.userObject;
        }

        private class StateManager
        extends Thread {
            private StateManager() {
            }

            @Override
            public void run() {
                while (DeviceHierarchy.this.running) {
                    try {
                        Device.this.proxy.ping();
                        Device.this.state = 0;
                    }
                    catch (DevFailed e) {
                        Device.this.state = (short)5;
                    }
                    DeviceHierarchy.this.repaint();
                    try {
                        StateManager.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private class DeviceHierarchyPopupMenu
    extends JPopupMenu {
        private JTree tree;
        private JLabel title;

        private DeviceHierarchyPopupMenu(JTree tree) {
            this.tree = tree;
            this.buildBtnPopupMenu();
        }

        private void buildBtnPopupMenu() {
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : menuLabels) {
                if (menuLabel == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        DeviceHierarchyPopupMenu.this.deviceActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        public void showMenu(MouseEvent evt, String name) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.title.setText(name);
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(2).setVisible(true);
            this.show(this.tree, evt.getX(), evt.getY());
        }

        public void showMenu(MouseEvent evt, Device dev) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            DeviceHierarchy.this.deviceInfo(dev);
            if (dev.failed == null) {
                this.title.setText(dev.toString());
                this.getComponent(2).setVisible(false);
                for (int i = 3; i < menuLabels.length; ++i) {
                    this.getComponent(2 + i).setEnabled(false);
                }
                this.getComponent(5).setEnabled(AstorUtil.osIsUnix());
                this.getComponent(4).setEnabled(DeviceHierarchy.this.astor != null);
                this.getComponent(3).setEnabled(dev.state == 0);
                if (Astor.rwMode == 2) {
                    this.getComponent(3).setVisible(false);
                }
                this.show(this.tree, evt.getX(), evt.getY());
            }
        }

        private void deviceActionPerformed(ActionEvent evt) {
            Device dev = (Device)DeviceHierarchy.this.getSelectedNode();
            Object obj = evt.getSource();
            int cmdidx = 0;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != obj) continue;
                cmdidx = i;
            }
            switch (cmdidx) {
                case 0: {
                    DeviceHierarchy.this.parent.update();
                    break;
                }
                case 3: {
                    DeviceHierarchy.this.remoteShell(dev);
                    break;
                }
                case 2: {
                    DeviceHierarchy.this.hostPanel(dev);
                    break;
                }
                case 1: {
                    DeviceHierarchy.this.testDevice(dev);
                }
            }
        }
    }
}

