/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.PolledElement;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.util.ArrayList;

public class DevPollStatus
extends ArrayList<PolledElement> {
    private DeviceProxy deviceProxy;
    private boolean pollSeveralAttributes = false;
    private static final boolean FULL_NAME = true;
    private static final boolean ATTR_NAME = false;

    public DevPollStatus(String deviceName) throws DevFailed {
        this.deviceProxy = new DeviceProxy(deviceName).get_adm_dev();
        this.readData(deviceName, false);
    }

    public DevPollStatus(String[] deviceNames) throws DevFailed {
        boolean full_name = true;
        if (deviceNames.length < 2) {
            full_name = false;
        }
        for (String deviceName : deviceNames) {
            this.deviceProxy = new DeviceProxy(deviceName).get_adm_dev();
            this.readData(this.removeTangoHostIfAny(deviceName), full_name);
        }
    }

    public boolean isPollingSeveralAttributes() {
        return this.pollSeveralAttributes;
    }

    private String removeTangoHostIfAny(String deviceName) {
        String tangoHeader = "tango://";
        if (deviceName.startsWith(tangoHeader)) {
            deviceName = deviceName.substring(tangoHeader.length());
            deviceName = deviceName.substring(deviceName.indexOf(47) + 1);
        }
        return deviceName;
    }

    private void readData(String deviceName, boolean full_name) throws DevFailed {
        String[] lines;
        DeviceData argin = new DeviceData();
        argin.insert(deviceName);
        DeviceData argOut = this.deviceProxy.command_inout("DevPollStatus", argin);
        for (String line : lines = argOut.extractStringArray()) {
            if (line.contains("Time needed for the last attribute") && line.contains("Time needed for the last attributes")) {
                this.pollSeveralAttributes = true;
            }
            PolledElement polledElement = new PolledElement(deviceName, line);
            boolean found = false;
            for (int j = 0; !found && j < this.size(); ++j) {
                found = full_name ? ((PolledElement)this.get((int)j)).name.toLowerCase().equals(deviceName + "/" + polledElement.name.toLowerCase()) : ((PolledElement)this.get((int)j)).name.toLowerCase().equals(polledElement.name.toLowerCase());
            }
            if (found) continue;
            if (full_name) {
                polledElement.name = deviceName + "/" + polledElement.name;
            }
            this.add(polledElement);
        }
    }

    public int polledCount() {
        int cnt = 0;
        for (PolledElement polledElement : this) {
            if (!polledElement.polled) continue;
            ++cnt;
        }
        return cnt;
    }

    public int triggeredCount() {
        int cnt = 0;
        for (PolledElement polledElement : this) {
            if (polledElement.polled) continue;
            ++cnt;
        }
        return cnt;
    }

    static void displaySyntax() {
        System.out.println("device name ?");
        System.exit(1);
    }

    public static void main(String[] args) {
        String deviceName = null;
        if (args.length > 0) {
            deviceName = args[0];
        } else {
            DevPollStatus.displaySyntax();
        }
        try {
            DevPollStatus clients = new DevPollStatus(deviceName);
            for (PolledElement client : clients) {
                String[] infoArray;
                for (String info : infoArray = client.getInfo()) {
                    System.out.println(info);
                }
                System.out.println();
            }
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
            System.exit(1);
        }
        System.exit(0);
    }
}

