/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.Astor;
import admin.astor.AstorUtil;
import admin.astor.HostInfoDialog;
import admin.astor.RemoteLoginThread;
import admin.astor.tools.TopDialog;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.DeviceProxyFactory;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class BlackBoxTable
extends JDialog {
    private String deviceName;
    private Component parent;
    private DataTableModel model;
    private BlackBox blackbox = null;
    private UpdateThread thread;
    private JDialog table_dialog;
    private FilterDialog filter_dlg = null;
    private TopDialog top_dialog = null;
    private boolean auto_update = false;
    private boolean clearBlackBox = false;
    private int upd_period = 1000;
    private TablePopupMenu menu;
    private final Column[] columns = new Column[]{new Column("Date", 170), new Column("Operation", 150), new Column("Name", 130), new Column("Source", 100), new Column("Host", 130), new Column("Process", 220)};
    static final int DATES = 0;
    static final int OPERATION = 1;
    static final int HOST = 4;
    static final int PROCESS = 5;
    private static final int height = 400;
    private JRadioButton autoUpdateBtn;
    private JLabel filterLabel;
    private JLabel titleLabel;
    private JTextField updPeriodTxt;
    private JLabel warningLbl;

    public BlackBoxTable(JFrame parent, String deviceName) throws DevFailed {
        super((Frame)parent, false);
        this.parent = parent;
        this.initDialog(deviceName);
    }

    public BlackBoxTable(JDialog parent, String deviceName) throws DevFailed {
        super((Dialog)parent, false);
        this.parent = parent;
        this.initDialog(deviceName);
    }

    private void initDialog(String devname) throws DevFailed {
        this.deviceName = devname;
        this.table_dialog = this;
        this.blackbox = new BlackBox();
        this.initComponents();
        int width = 0;
        for (Column col : this.columns) {
            width += col.width;
        }
        try {
            this.model = new DataTableModel();
            JTable table = new JTable(this.model){

                @Override
                public String getToolTipText(MouseEvent e) {
                    String tip = null;
                    if (this.isVisible()) {
                        Point p = e.getPoint();
                        int row = this.rowAtPoint(p);
                        if (BlackBoxTable.this.blackbox != null) {
                            tip = BlackBoxTable.this.blackbox.getCodeLine(row);
                        }
                    }
                    return tip;
                }
            };
            table.setRowSelectionAllowed(true);
            table.setColumnSelectionAllowed(true);
            table.setDragEnabled(false);
            table.setSelectionMode(0);
            table.getTableHeader().setFont(new Font("Dialog", 1, 14));
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    BlackBoxTable.this.tableActionPerformed(evt);
                }
            });
            this.menu = new TablePopupMenu(table);
            JScrollPane scrollPane = new JScrollPane(table);
            scrollPane.setPreferredSize(new Dimension(width, 400));
            this.setColumnWidth(table);
            this.getContentPane().add((Component)scrollPane, "Center");
        }
        catch (Exception e) {
            e.printStackTrace();
            Except.throw_exception((String)"INIT_ERROR", (String)e.toString(), (String)"PopupTable.initMyComponents()");
        }
        this.thread = new UpdateThread();
        this.thread.start();
        this.titleLabel.setText("Black box on  " + devname);
        this.updPeriodTxt.setText(Integer.toString(this.upd_period));
        this.warningLbl.setVisible(false);
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void tableActionPerformed(MouseEvent evt) {
        JTable table = (JTable)evt.getSource();
        int column = table.columnAtPoint(new Point(evt.getX(), evt.getY()));
        int row = table.rowAtPoint(new Point(evt.getX(), evt.getY()));
        if (column != 4) {
            return;
        }
        String hostname = this.blackbox.toString(row, column);
        if (!hostname.equals("polling")) {
            this.menu.showMenu(evt, hostname);
        }
    }

    private void setColumnWidth(JTable table) {
        Enumeration<TableColumn> cenum = table.getColumnModel().getColumns();
        for (int i = 0; i < this.columns.length && cenum.hasMoreElements(); ++i) {
            TableColumn tc = cenum.nextElement();
            tc.setPreferredWidth(this.columns[i].width);
        }
    }

    private void initComponents() {
        JPanel bottomPanel = new JPanel();
        JButton cancelBtn = new JButton();
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel westPanel = new JPanel();
        this.autoUpdateBtn = new JRadioButton();
        JLabel jLabel1 = new JLabel();
        this.updPeriodTxt = new JTextField();
        JButton filterBtn = new JButton();
        JSeparator separator = new JSeparator();
        this.filterLabel = new JLabel();
        JButton topBtn = new JButton();
        JButton clearBtn = new JButton();
        this.warningLbl = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                BlackBoxTable.this.closeDialog(evt);
            }
        });
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlackBoxTable.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        westPanel.setLayout(new GridBagLayout());
        this.autoUpdateBtn.setText("Update");
        this.autoUpdateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlackBoxTable.this.autoUpdateBtnActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        westPanel.add((Component)this.autoUpdateBtn, gridBagConstraints);
        jLabel1.setText("Period (milli sec):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        westPanel.add((Component)jLabel1, gridBagConstraints);
        this.updPeriodTxt.setColumns(8);
        this.updPeriodTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlackBoxTable.this.updPeriodTxtActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        westPanel.add((Component)this.updPeriodTxt, gridBagConstraints);
        filterBtn.setText("Filter");
        filterBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlackBoxTable.this.filterBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        westPanel.add((Component)filterBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        westPanel.add((Component)separator, gridBagConstraints);
        this.filterLabel.setText("none");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        westPanel.add((Component)this.filterLabel, gridBagConstraints);
        topBtn.setText("Top");
        topBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlackBoxTable.this.topBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 0, 10, 0);
        westPanel.add((Component)topBtn, gridBagConstraints);
        clearBtn.setText("Clear");
        clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlackBoxTable.this.clearBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        westPanel.add((Component)clearBtn, gridBagConstraints);
        this.warningLbl.setForeground(new Color(255, 51, 0));
        this.warningLbl.setText("!!!  Warning  !!!");
        this.warningLbl.setToolTipText("Lines could have been lost !!!  Check update period.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        westPanel.add((Component)this.warningLbl, gridBagConstraints);
        this.getContentPane().add((Component)westPanel, "West");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void autoUpdateBtnActionPerformed(ActionEvent evt) {
        boolean bl = this.auto_update = this.autoUpdateBtn.getSelectedObjects() != null;
        if (this.auto_update) {
            this.checkUpdatePeriode();
        }
    }

    private void manageWarningButton(boolean recover) {
        if (this.blackbox.size() > 0) {
            this.warningLbl.setVisible(!recover);
        } else {
            this.warningLbl.setVisible(false);
        }
    }

    private void checkUpdatePeriode() {
        String strval = this.updPeriodTxt.getText().trim();
        try {
            int tmp = Integer.parseInt(strval);
            if (tmp < 100) {
                tmp = 100;
            }
            this.updPeriodTxt.setText(Integer.toString(tmp));
            if (tmp != this.upd_period) {
                this.upd_period = tmp;
                this.thread.wakeUp();
            }
        }
        catch (NumberFormatException e) {
            ErrorPane.showErrorMessage((Component)this, null, (Exception)e);
        }
    }

    private void updPeriodTxtActionPerformed(ActionEvent evt) {
        this.checkUpdatePeriode();
    }

    private void filterBtnActionPerformed(ActionEvent evt) {
        if (this.filter_dlg == null) {
            this.filter_dlg = new FilterDialog(this);
        }
        if (this.filter_dlg.showDialog() == 0) {
            Filter filter = this.filter_dlg.getFilter();
            this.blackbox.setFilter(filter);
            if (filter != null) {
                this.filterLabel.setText(filter.toString());
            } else {
                this.filterLabel.setText("none");
            }
            if (this.top_dialog != null && this.top_dialog.isVisible()) {
                this.top_dialog.displayTop();
            }
        }
    }

    private void topBtnActionPerformed(ActionEvent evt) {
        if (this.top_dialog == null) {
            this.top_dialog = new TopDialog(this, this.deviceName, this.blackbox);
        }
        this.top_dialog.showDialog();
    }

    private void clearBtnActionPerformed(ActionEvent evt) {
        this.clearBlackBox = true;
        this.thread.wakeUp();
    }

    private void doClose() {
        this.thread.stopThread();
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.auto_update = false;
            this.autoUpdateBtn.setSelected(false);
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] args) {
        String deviceName = "srdiag/beam-current/total";
        if (args.length > 0) {
            deviceName = args[0];
        }
        try {
            new BlackBoxTable((JFrame)null, deviceName).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new Frame(), (String)"", (DevFailed)e);
        }
    }

    public class FilterDialog
    extends JDialog {
        private List<JRadioButton> buttons;
        private JPanel txtPanel;
        private JTextField strFilterTxt;
        private JLabel titleLabel;
        private int retVal;

        public FilterDialog(JDialog parent) {
            GridBagConstraints gbc;
            super((Dialog)parent, true);
            this.buttons = new ArrayList<JRadioButton>();
            this.retVal = 0;
            this.initComponents();
            JPanel centerPanel = new JPanel();
            centerPanel.setLayout(new GridBagLayout());
            this.getContentPane().add((Component)centerPanel, "Center");
            int line = 0;
            for (int i = 1; i < BlackBoxTable.this.columns.length; ++i) {
                JRadioButton btn = new JRadioButton(((BlackBoxTable)BlackBoxTable.this).columns[i].name);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = line++;
                gbc.gridwidth = 2;
                gbc.fill = 2;
                centerPanel.add((Component)btn, gbc);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        FilterDialog.this.btnActionPerformed(evt);
                    }
                });
                this.buttons.add(btn);
            }
            this.txtPanel = new JPanel();
            this.txtPanel.add(new JLabel("Filter: "));
            this.strFilterTxt = new JTextField();
            this.strFilterTxt.setColumns(15);
            this.txtPanel.add(this.strFilterTxt);
            this.strFilterTxt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FilterDialog.this.strFilterTxtActionPerformed(evt);
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = line;
            gbc.fill = 2;
            centerPanel.add((Component)this.txtPanel, gbc);
            this.txtPanel.setVisible(false);
            this.titleLabel.setText("Filtering  Black  Box Content ");
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
        }

        private void initComponents() {
            JPanel jPanel1 = new JPanel();
            JButton cancelBtn = new JButton();
            JButton okBtn = new JButton();
            JPanel jPanel2 = new JPanel();
            this.titleLabel = new JLabel();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    FilterDialog.this.closeDialog(evt);
                }
            });
            okBtn.setText("OK");
            okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FilterDialog.this.okBtnActionPerformed(evt);
                }
            });
            jPanel1.add(okBtn);
            cancelBtn.setText("Dismiss");
            cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FilterDialog.this.cancelBtnActionPerformed(evt);
                }
            });
            jPanel1.add(cancelBtn);
            this.getContentPane().add((Component)jPanel1, "South");
            this.titleLabel.setFont(new Font("Dialog", 1, 18));
            this.titleLabel.setText("Dialog Title");
            jPanel2.add(this.titleLabel);
            this.getContentPane().add((Component)jPanel2, "North");
        }

        private void strFilterTxtActionPerformed(ActionEvent evt) {
            this.okBtnActionPerformed(evt);
        }

        Filter getFilter() {
            int idx = -1;
            for (int i = 0; i < this.buttons.size(); ++i) {
                if (this.buttons.get(i).getSelectedObjects() == null) continue;
                idx = i;
            }
            if (idx == -1) {
                return null;
            }
            String str = this.strFilterTxt.getText().trim();
            if (str.length() > 0) {
                return new Filter(idx + 1, str);
            }
            return null;
        }

        private void btnActionPerformed(ActionEvent evt) {
            boolean isSet;
            JRadioButton btn = (JRadioButton)evt.getSource();
            boolean bl = isSet = btn.getSelectedObjects() != null;
            if (isSet) {
                for (JRadioButton b : this.buttons) {
                    if (b == btn) continue;
                    b.setSelected(false);
                }
            }
            isSet = false;
            for (JRadioButton b : this.buttons) {
                if (b.getSelectedObjects() == null) continue;
                isSet = true;
            }
            this.txtPanel.setVisible(isSet);
            if (isSet) {
                this.strFilterTxt.requestFocus();
                this.strFilterTxt.selectAll();
            }
            this.pack();
        }

        private void okBtnActionPerformed(ActionEvent evt) {
            this.retVal = 0;
            this.doClose();
        }

        private void cancelBtnActionPerformed(ActionEvent evt) {
            this.retVal = 2;
            this.doClose();
        }

        private void closeDialog(WindowEvent evt) {
            this.retVal = 2;
            this.doClose();
        }

        private void doClose() {
            this.setVisible(false);
            this.dispose();
        }

        public int showDialog() {
            this.strFilterTxt.requestFocus();
            this.strFilterTxt.selectAll();
            this.setVisible(true);
            return this.retVal;
        }
    }

    class TablePopupMenu
    extends JPopupMenu {
        private JTable table;
        private String hostname = null;
        private final String[] menuLabels = new String[]{"Host Panel", "Remote Login"};
        private final int OFFSET = 2;
        private final int HOST_PANEL = 0;
        private final int REMOTE_LOG = 1;

        private TablePopupMenu(JTable table) {
            this.table = table;
            JLabel title = new JLabel("Datbase Server :");
            title.setFont(new Font("Dialog", 1, 16));
            this.add(title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : this.menuLabels) {
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        TablePopupMenu.this.popupActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
            this.getComponent(3).setEnabled(AstorUtil.osIsUnix());
        }

        public void showMenu(MouseEvent evt, String hostname) {
            this.hostname = hostname;
            JLabel lbl = (JLabel)this.getComponent(0);
            lbl.setText(hostname + "  :");
            this.show(this.table, evt.getX(), evt.getY());
        }

        private void popupActionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            int commandIndex = 0;
            for (int i = 0; i < this.menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != src) continue;
                commandIndex = i;
            }
            switch (commandIndex) {
                case 0: {
                    if (BlackBoxTable.this.parent instanceof Astor) {
                        ((Astor)((BlackBoxTable)BlackBoxTable.this).parent).tree.displayHostInfoDialog(this.hostname);
                        break;
                    }
                    if (!(BlackBoxTable.this.parent instanceof HostInfoDialog)) break;
                    ((HostInfoDialog)BlackBoxTable.this.parent).displayHostInfoDialog(this.hostname);
                    break;
                }
                case 1: {
                    try {
                        new RemoteLoginThread(this.hostname).start();
                        break;
                    }
                    catch (DevFailed e) {
                        ErrorPane.showErrorMessage((Component)BlackBoxTable.this.parent, null, (DevFailed)e);
                    }
                }
            }
        }
    }

    private class UpdateThread
    extends Thread {
        private boolean stop = false;

        private UpdateThread() {
        }

        private void stopThread() {
            this.stop = true;
            this.wakeUp();
        }

        private synchronized void wakeUp() {
            this.notify();
        }

        private synchronized void waitNextLoop(long millis) {
            try {
                this.wait(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            DeviceProxy dev = null;
            boolean first = true;
            while (!this.stop) {
                block5: {
                    if (first || BlackBoxTable.this.auto_update) {
                        first = false;
                        try {
                            if (dev == null) {
                                dev = DeviceProxyFactory.get((String)BlackBoxTable.this.deviceName);
                            }
                            String[] array = dev.black_box(100);
                            BlackBoxTable.this.blackbox.update(array);
                            BlackBoxTable.this.model.fireTableDataChanged();
                            BlackBoxTable.this.titleLabel.setText(BlackBoxTable.this.deviceName + " - " + BlackBoxTable.this.blackbox.getDeltaTimeStr());
                        }
                        catch (DevFailed e) {
                            if (e.errors[0].reason.equals("API_BlackBoxEmpty")) break block5;
                            ErrorPane.showErrorMessage((Component)BlackBoxTable.this.table_dialog, (String)"", (DevFailed)e);
                        }
                    }
                }
                this.waitNextLoop(BlackBoxTable.this.upd_period);
                if (!BlackBoxTable.this.isVisible() || !BlackBoxTable.this.clearBlackBox) continue;
                BlackBoxTable.this.blackbox.clear();
                BlackBoxTable.this.clearBlackBox = false;
                BlackBoxTable.this.blackbox.update(new String[0]);
                BlackBoxTable.this.model.fireTableDataChanged();
                BlackBoxTable.this.titleLabel.setText("Black box on  " + BlackBoxTable.this.deviceName);
            }
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return BlackBoxTable.this.columns.length;
        }

        @Override
        public String getColumnName(int colnum) {
            if (colnum >= this.getColumnCount()) {
                return ((BlackBoxTable)BlackBoxTable.this).columns[this.getColumnCount() - 1].name;
            }
            return ((BlackBoxTable)BlackBoxTable.this).columns[colnum].name;
        }

        @Override
        public int getRowCount() {
            if (BlackBoxTable.this.blackbox == null) {
                return 0;
            }
            return BlackBoxTable.this.blackbox.nbRecords();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return BlackBoxTable.this.blackbox.toString(row, col);
        }
    }

    private class Filter {
        private int col_idx;
        private String str;

        private Filter(int idx, String str) {
            this.col_idx = idx;
            this.str = str;
        }

        public String toString() {
            return ((BlackBoxTable)BlackBoxTable.this).columns[this.col_idx].name + ":  " + this.str;
        }
    }

    class BlackBox
    extends ArrayList<ArrayList<String>> {
        private List<ArrayList<String>> filtered;
        private Filter filter = null;
        private List<String> code = new ArrayList<String>();
        private List<String> filtered_code;
        private double delta_time = 0.0;

        private BlackBox() {
            this.filtered = new ArrayList<ArrayList<String>>();
            this.filtered_code = new ArrayList<String>();
        }

        private void setFilter(Filter filter) {
            this.filter = filter;
            if (filter != null) {
                this.filterContent();
            }
            BlackBoxTable.this.model.fireTableDataChanged();
        }

        private void filterContent() {
            this.filtered.clear();
            this.filtered_code.clear();
            for (int i = 0; i < this.size(); ++i) {
                ArrayList line = (ArrayList)this.get(i);
                String topic = (String)line.get(this.filter.col_idx);
                if (!topic.contains(this.filter.str)) continue;
                this.filtered.add(line);
                this.filtered_code.add(this.code.get(i));
            }
        }

        ArrayList<String> getLine(int idx) {
            if (this.filter == null) {
                return (ArrayList)this.get(idx);
            }
            return this.filtered.get(idx);
        }

        int nbRecords() {
            if (this.filter == null) {
                return this.size();
            }
            return this.filtered.size();
        }

        String getDeltaTimeStr() {
            int dt = (int)this.delta_time;
            StringBuilder sb = new StringBuilder("");
            int h = 0;
            int mn = 0;
            int millis = (int)(1000.0 * (this.delta_time - (double)dt));
            if (dt > 3600) {
                h = dt / 3600;
                if (h < 10) {
                    sb.append("0");
                }
                sb.append(Integer.toString(h)).append(":");
                dt -= 3600 * h;
            }
            if (dt >= 60) {
                mn = dt / 60;
                if (mn < 10) {
                    sb.append("0");
                }
                sb.append(Integer.toString(mn)).append(":");
                dt -= 60 * mn;
            } else if (h > 0) {
                sb.append("00:");
            }
            if (dt > 0) {
                int sec = dt;
                if (sec < 10) {
                    sb.append("0");
                }
                sb.append(Integer.toString(sec)).append(".");
            } else {
                sb.append("00.");
            }
            sb.append(Integer.toString(millis));
            if (h == 0 && mn == 0) {
                sb.append(" sec.");
            }
            return sb.toString();
        }

        double getDeltaTime() {
            double stop;
            String[] dates = this.getDates();
            double start = this.parseTime(dates[0]);
            for (stop = this.parseTime(dates[1]); stop < start; stop += 86400.0) {
            }
            return stop - start;
        }

        private double parseTime(String str) {
            if (str.length() == 0) {
                return 0.0;
            }
            ArrayList<String> tokens = new ArrayList<String>();
            StringTokenizer stk = new StringTokenizer(str, ":");
            while (stk.hasMoreTokens()) {
                tokens.add(stk.nextToken());
            }
            if (tokens.size() < 4) {
                return 0.0;
            }
            double t = 0.0;
            try {
                t = 3600.0 * (double)Integer.parseInt((String)tokens.get(0));
                t += 60.0 * (double)Integer.parseInt((String)tokens.get(1));
                t += 1.0 * (double)Integer.parseInt((String)tokens.get(2));
                t += 1.0 * (double)Integer.parseInt((String)tokens.get(3)) / 100.0;
            }
            catch (NumberFormatException e) {
                System.out.println(e.toString());
            }
            return t;
        }

        String[] getDates() {
            if (this.size() == 0) {
                return new String[]{"", ""};
            }
            String start = (String)((ArrayList)this.get(this.size() - 1)).get(0);
            String stop = (String)((ArrayList)this.get(0)).get(0);
            int pos = start.indexOf(32);
            if (pos > 0) {
                start = start.substring(pos).trim();
            }
            if ((pos = stop.indexOf(32)) > 0) {
                stop = stop.substring(pos).trim();
            }
            return new String[]{start, stop};
        }

        private void update(String[] array) {
            ArrayList<ArrayList<String>> tmp = this.parseContent(array);
            boolean found = false;
            if (this.size() > 0) {
                ArrayList last_line = (ArrayList)this.get(0);
                for (int i = tmp.size() - 1; i >= 0; --i) {
                    ArrayList new_line = (ArrayList)tmp.get(i);
                    if (found) {
                        this.add(0, new_line);
                        this.code.add(0, array[i]);
                        continue;
                    }
                    boolean diff = false;
                    for (int j = 0; !diff && j < new_line.size() && j < last_line.size(); ++j) {
                        diff = !((String)new_line.get(j)).equals(last_line.get(j));
                    }
                    found = !diff;
                }
            } else {
                found = true;
            }
            if (!found || this.size() == 0) {
                this.addRecords(tmp, array);
            }
            BlackBoxTable.this.manageWarningButton(found);
            if (this.filter != null) {
                this.filterContent();
            }
            if (BlackBoxTable.this.top_dialog != null && BlackBoxTable.this.top_dialog.isVisible()) {
                BlackBoxTable.this.top_dialog.displayTop();
            }
            this.delta_time = this.getDeltaTime();
        }

        private void addRecords(List<ArrayList<String>> tmp, String[] array) {
            int idx = array.length - 1;
            if (tmp.size() > 0) {
                for (int i = tmp.size() - 1; i >= 0; --i) {
                    this.add(0, tmp.get(i));
                    while (idx >= 0 && array[idx].indexOf("Operation blackbox") > 0) {
                        --idx;
                    }
                    this.code.add(0, array[idx--]);
                }
            }
        }

        private ArrayList<ArrayList<String>> parseContent(String[] array) {
            ArrayList<ArrayList<String>> info = new ArrayList<ArrayList<String>>();
            for (String line : array) {
                String operation;
                ArrayList<String> vs = new ArrayList<String>(BlackBoxTable.this.columns.length);
                String date = this.getDate(line);
                int offset = date.length() + 3;
                String op_type = this.getNextWord(line, offset);
                offset += op_type.length() + 1;
                if (op_type.equals("Attribute")) {
                    op_type = "CORBA " + op_type;
                }
                if (op_type.equals("Operation")) {
                    operation = this.getNextWord(line, offset);
                    offset += operation.length() + 1;
                } else {
                    operation = op_type;
                }
                String op_param = "";
                if (!(operation.startsWith("command_list_query") || operation.startsWith("get_attribute_config") || operation.startsWith("ping") || operation.startsWith("adm_name"))) {
                    String tmp;
                    do {
                        tmp = this.getNextWord(line, offset);
                        offset += tmp.length() + 1;
                        op_param = op_param + " " + tmp;
                    } while (tmp.endsWith(","));
                    if ((op_param = op_param.trim()).equals("cmd")) {
                        for (int i = 0; i < 2; ++i) {
                            op_param = this.getNextWord(line, offset);
                            offset += op_param.length() + 1;
                        }
                    }
                }
                String source = "device";
                if (line.indexOf("from cache_device") > 0) {
                    source = "cache_device";
                } else if (line.indexOf("from cache") > 0) {
                    source = "cache ";
                }
                String host = "";
                offset = line.indexOf("requested from ");
                if (offset > 0) {
                    if (line.indexOf("requested form polling") > 0) {
                        host = "polling";
                    } else {
                        host = this.getNextWord(line, offset + "requested from ".length());
                        int pos = host.indexOf(46);
                        if (pos > 0) {
                            host = host.substring(0, pos);
                        }
                    }
                }
                String process = this.getProcess(line);
                if (operation.equals("blackbox")) continue;
                vs.add(date);
                vs.add(operation);
                vs.add(op_param);
                vs.add(source);
                vs.add(host);
                vs.add(process);
                info.add(vs);
            }
            return info;
        }

        private String getProcess(String line) {
            String process = "";
            String javaClient = "java client with main class";
            String cppClient = "cpp/python client with pid";
            int offset = line.toLowerCase().indexOf(javaClient);
            if (offset > 0) {
                process = line.substring(offset + javaClient.length());
                if ((offset = process.indexOf(41)) > 0) {
                    process = process.substring(0, offset);
                }
            } else {
                offset = line.toLowerCase().indexOf(cppClient);
                if (offset > 0) {
                    process = "PID=" + this.getNextWord(line, offset + cppClient.length());
                }
            }
            return process.trim();
        }

        private String getNextWord(String line, int offset) {
            StringTokenizer stk = new StringTokenizer(line = line.substring(offset));
            if (stk.hasMoreTokens()) {
                int i;
                String word = stk.nextToken();
                if (word.startsWith("(")) {
                    word = word.substring(1);
                }
                if ((i = word.indexOf(41)) > 0) {
                    word = word.substring(0, i);
                }
                return word;
            }
            return "";
        }

        private String getDate(String line) {
            int pos = 0;
            for (int i = 0; pos >= 0 && i < 4; ++i) {
                pos = line.indexOf(58, pos + 1);
            }
            if (pos < 0) {
                return "";
            }
            return line.substring(0, pos).trim();
        }

        private String getCodeLine(int rownum) {
            if (this.filter == null) {
                return this.code.get(rownum);
            }
            if (rownum < 0 || rownum > this.filtered_code.size() - 1) {
                return "row = " + rownum + "???";
            }
            return this.filtered_code.get(rownum);
        }

        public String toString(int rownum, int wordnum) {
            if (rownum < 0 || wordnum < 0) {
                return "";
            }
            if (this.filter == null) {
                return (String)((ArrayList)this.get(rownum)).get(wordnum);
            }
            return this.filtered.get(rownum).get(wordnum);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (ArrayList line : this) {
                for (String word : line) {
                    sb.append(word).append('\t');
                }
                sb.append('\n');
            }
            return sb.toString();
        }
    }

    private class Column {
        String name;
        int width;

        Column(String n, int w) {
            this.name = n;
            this.width = w;
        }
    }
}

