/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tango_release;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class JTangoVersion {
    private List<ManifestModule> modules = new ArrayList<ManifestModule>();
    private static String jarFileName;
    private static int jarFileType;
    private static final String nameHeader = "artifactId=";
    private static final String versionHeader = "version=";
    private static final String packageHeader = "/META-INF/maven/";
    private static final String manifestName = "pom.properties";
    private static final String[] packages;
    public static final int ERR = 0;
    public static final int JTANGO = 0;
    public static final int TANGORB = 1;
    public static final String[] JarUsed;
    private static JTangoVersion instance;

    private JTangoVersion() {
        jarFileType = this.getTangoJarUsed();
        if (jarFileName != null) {
            jarFileName = this.getRealFileName(jarFileName);
            if (jarFileType == 0) {
                for (String pack : packages) {
                    String packageName = packageHeader + pack + "/" + manifestName;
                    ManifestModule module = this.getManifestModule(packageName);
                    if (module == null) continue;
                    this.modules.add(module);
                }
            }
        }
    }

    public static JTangoVersion getInstance() {
        if (instance == null) {
            instance = new JTangoVersion();
        }
        return instance;
    }

    public String getJarFileName() {
        return jarFileName;
    }

    public int getJarFileType() {
        return jarFileType;
    }

    private String getRealFileName(String jarName) {
        try {
            return new File(jarName).getCanonicalPath();
        }
        catch (IOException e) {
            return jarName;
        }
    }

    private ManifestModule getManifestModule(String packageName) {
        ManifestModule manifestModule = null;
        try {
            char[] buff;
            InputStreamReader reader;
            int nb;
            InputStream inputStream = this.getClass().getResourceAsStream(packageName);
            if (inputStream != null && (nb = (reader = new InputStreamReader(inputStream)).read(buff = new char[256])) > 0) {
                String code = new String(buff);
                StringTokenizer stk = new StringTokenizer(code, "\n");
                String version = null;
                String name = null;
                String date = null;
                while (stk.hasMoreTokens()) {
                    String line = stk.nextToken().trim();
                    if (line.startsWith(nameHeader)) {
                        name = line.substring(nameHeader.length());
                        continue;
                    }
                    if (line.startsWith(versionHeader)) {
                        version = line.substring(versionHeader.length());
                        continue;
                    }
                    if (!line.startsWith("#") || line.startsWith("#Gen")) continue;
                    date = line.substring(1);
                }
                if (name != null && version != null) {
                    manifestModule = new ManifestModule(name, version, date);
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return manifestModule;
    }

    private int getTangoJarUsed() {
        String classpath = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        ArrayList<String> paths = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(classpath, separator);
        while (stk.hasMoreTokens()) {
            paths.add(stk.nextToken());
        }
        if (JTangoVersion.isJarUsed(paths, JarUsed[0])) {
            return 0;
        }
        if (JTangoVersion.isJarUsed(paths, JarUsed[1])) {
            return 1;
        }
        return 0;
    }

    private static boolean isJarUsed(List<String> paths, String jarName) {
        for (String path : paths) {
            if (path.contains(jarName + ".jar")) {
                jarFileName = path;
                return true;
            }
            if (!path.contains(jarName + "-")) continue;
            jarFileName = path;
            return true;
        }
        return false;
    }

    private String addTabulation(String str, int start, int maxLen) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < maxLen + 2; ++i) {
            sb.append(" ");
        }
        sb.append(str);
        return sb.toString();
    }

    public String toString() {
        if (jarFileType == 1) {
            return this.getJarFileName();
        }
        StringBuilder sb = new StringBuilder(this.getJarFileName() + "\n\n");
        int maxNameLen = 0;
        int maxVersionLen = 0;
        for (ManifestModule module : this.modules) {
            if (module.name.length() > maxNameLen) {
                maxNameLen = module.name.length();
            }
            if (module.version.length() <= maxVersionLen) continue;
            maxVersionLen = module.version.length();
        }
        for (ManifestModule module : this.modules) {
            sb.append(module.name).append(":").append(this.addTabulation(module.version, module.name.length(), maxNameLen)).append(this.addTabulation(module.date, module.version.length(), maxVersionLen)).append('\n');
        }
        return sb.toString().trim();
    }

    public static void main(String[] args) {
        JTangoVersion tangoVersion = new JTangoVersion();
        System.out.println(tangoVersion);
    }

    static {
        packages = new String[]{"org.tango/JavaTangoIDL", "org.tango/TangORB", "org.tango/JTangoServer", "org.zeromq/jeromq", "org.slf4j/slf4j-api"};
        JarUsed = new String[]{"JTango", "TangORB"};
        instance = null;
    }

    private class ManifestModule {
        String name;
        String version;
        String date = "";

        private ManifestModule(String name, String version, String date) {
            this.name = name;
            this.version = version;
            if (date != null) {
                this.date = this.splitDate(date);
            }
        }

        private String splitDate(String date) {
            StringTokenizer stk = new StringTokenizer(date);
            ArrayList<String> tokens = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                tokens.add(stk.nextToken());
            }
            return (String)tokens.get(2) + " " + (String)tokens.get(1) + " " + (String)tokens.get(5);
        }

        public String toString() {
            return this.name + ":  " + this.version;
        }
    }
}

