/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.AstorUtil;
import admin.astor.statistics.GlobalStatistics;
import admin.astor.statistics.GlobalStatisticsTable;
import admin.astor.statistics.ResetStatistics;
import admin.astor.statistics.ServerStat;
import admin.astor.statistics.StarterStat;
import admin.astor.statistics.StatisticsFileFilter;
import admin.astor.statistics.Utils;
import admin.astor.tools.PopupTable;
import admin.astor.tools.PopupText;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class StatisticsPanel
extends JFrame {
    private static JFileChooser chooser = null;
    private static final StatisticsFileFilter fileFilter = new StatisticsFileFilter("xml", "Statistics Files");
    private JFrame parent = null;
    private GlobalStatistics globalStatistics;
    private JScrollPane tableScrollPane = null;
    private GlobalStatisticsTable statisticsTable;
    private JPanel bottomPanel;
    private JTextField filterText;
    private JTextArea globalStatTextArea;
    private JMenuItem resetItem;
    private JPanel runningTwicePanel;
    private JTextArea runningTwiceTextArea;
    private JLabel titleLabel;
    private String filter = "";

    public StatisticsPanel(JFrame parent, String fileName) throws DevFailed {
        this.parent = parent;
        this.initComponents();
        this.customComponents();
        this.globalStatistics = new GlobalStatistics(fileName);
        this.displayGlobalStatistics();
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
    }

    public StatisticsPanel() {
        this((JFrame)null);
    }

    public StatisticsPanel(JFrame parent) {
        this.parent = parent;
        AstorUtil.startSplash("Statistics ");
        AstorUtil.increaseSplashProgress(5, "Initializing....");
        this.initComponents();
        this.customComponents();
        this.titleLabel.setText("No Statistics Read");
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
        AstorUtil.stopSplash();
    }

    private void customComponents() {
        this.runningTwicePanel.setVisible(false);
        this.bottomPanel.setVisible(false);
        this.resetItem.setVisible(System.getenv("SUPER_TANGO") != null && System.getenv("SUPER_TANGO").equals("true"));
    }

    public void readAndDisplayStatistics(ArrayList<String> hostList) {
        this.titleLabel.setText("Reading and Computing Statistics");
        new ReadThread(hostList).start();
    }

    private void displayGlobalStatistics() {
        List<ServerStat> failedServers = this.getServerFailedList(this.globalStatistics.getStarterStatistics());
        this.statisticsTable = new GlobalStatisticsTable(this);
        this.statisticsTable.setStatistics(failedServers);
        this.globalStatTextArea.setText(this.globalStatistics.toString());
        if (this.tableScrollPane != null) {
            this.getContentPane().remove(this.tableScrollPane);
        }
        this.tableScrollPane = new JScrollPane();
        this.tableScrollPane.setPreferredSize(new Dimension(this.statisticsTable.getDefaultWidth(), this.statisticsTable.getDefaultHeight()));
        this.tableScrollPane.setViewportView(this.statisticsTable);
        this.getContentPane().add((Component)this.tableScrollPane, "Center");
        String title = "During  " + Utils.formatDuration(this.globalStatistics.getDuration()) + "      " + failedServers.size();
        title = failedServers.size() <= 1 ? title + "  server has failed" : title + "  servers have failed";
        this.titleLabel.setText(title);
        String runningTwice = this.globalStatistics.getServersRunningTwice();
        if (runningTwice.length() > 0) {
            this.runningTwiceTextArea.setText(runningTwice);
            this.runningTwicePanel.setVisible(true);
        }
        this.pack();
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JScrollPane globalStatScrollPane = new JScrollPane();
        this.globalStatTextArea = new JTextArea();
        this.bottomPanel = new JPanel();
        JLabel filterLabel = new JLabel();
        this.filterText = new JTextField();
        this.runningTwicePanel = new JPanel();
        JScrollPane runningTwiceScrollPane = new JScrollPane();
        this.runningTwiceTextArea = new JTextArea();
        JLabel jLabel1 = new JLabel();
        JMenuBar jMenuBar1 = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem readItem = new JMenuItem();
        JMenuItem openItem = new JMenuItem();
        JMenuItem saveItem = new JMenuItem();
        this.resetItem = new JMenuItem();
        JMenuItem exitItem = new JMenuItem();
        JMenu editMenu = new JMenu();
        JMenuItem filterItem = new JMenuItem();
        JMenu showMenu = new JMenu();
        JMenuItem datesItem = new JMenuItem();
        JMenuItem errorItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                StatisticsPanel.this.exitForm(evt);
            }
        });
        topPanel.setLayout(new BorderLayout());
        this.titleLabel.setFont(new Font("Times New Roman", 1, 14));
        this.titleLabel.setText("Title");
        topPanel.add((Component)this.titleLabel, "Last");
        globalStatScrollPane.setPreferredSize(new Dimension(250, 110));
        this.globalStatTextArea.setColumns(20);
        this.globalStatTextArea.setEditable(false);
        this.globalStatTextArea.setFont(new Font("Monospaced", 1, 12));
        this.globalStatTextArea.setRows(5);
        globalStatScrollPane.setViewportView(this.globalStatTextArea);
        topPanel.add((Component)globalStatScrollPane, "Center");
        this.getContentPane().add((Component)topPanel, "North");
        filterLabel.setText("Filter :  ");
        this.bottomPanel.add(filterLabel);
        this.filterText.setColumns(20);
        this.filterText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                StatisticsPanel.this.filterTextKeyPressed(evt);
            }
        });
        this.bottomPanel.add(this.filterText);
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.runningTwicePanel.setLayout(new BorderLayout());
        this.runningTwiceTextArea.setColumns(20);
        this.runningTwiceTextArea.setRows(5);
        runningTwiceScrollPane.setViewportView(this.runningTwiceTextArea);
        this.runningTwicePanel.add((Component)runningTwiceScrollPane, "Center");
        jLabel1.setText("Server(s) running twice");
        this.runningTwicePanel.add((Component)jLabel1, "North");
        this.getContentPane().add((Component)this.runningTwicePanel, "East");
        fileMenu.setMnemonic('F');
        fileMenu.setText("File");
        readItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        readItem.setMnemonic('R');
        readItem.setText("Read Whole Statistics");
        readItem.setActionCommand("read");
        readItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsPanel.this.readItemActionPerformed(evt);
            }
        });
        fileMenu.add(readItem);
        openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        openItem.setMnemonic('O');
        openItem.setText("Open");
        openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsPanel.this.openItemActionPerformed(evt);
            }
        });
        fileMenu.add(openItem);
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        saveItem.setMnemonic('S');
        saveItem.setText("Save");
        saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsPanel.this.saveItemActionPerformed(evt);
            }
        });
        fileMenu.add(saveItem);
        this.resetItem.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        this.resetItem.setText("Reset Statistics");
        this.resetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsPanel.this.resetItemActionPerformed(evt);
            }
        });
        fileMenu.add(this.resetItem);
        exitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        exitItem.setMnemonic('x');
        exitItem.setText("Exit");
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsPanel.this.exitItemActionPerformed(evt);
            }
        });
        fileMenu.add(exitItem);
        jMenuBar1.add(fileMenu);
        editMenu.setMnemonic('E');
        editMenu.setText("Edit");
        filterItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        filterItem.setText("Find Server");
        filterItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsPanel.this.filterItemActionPerformed(evt);
            }
        });
        editMenu.add(filterItem);
        jMenuBar1.add(editMenu);
        showMenu.setMnemonic('S');
        showMenu.setText("Show");
        datesItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        datesItem.setText("Show Reset Dates");
        datesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsPanel.this.datesItemActionPerformed(evt);
            }
        });
        showMenu.add(datesItem);
        errorItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        errorItem.setText("Show Errors");
        errorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsPanel.this.errorItemActionPerformed(evt);
            }
        });
        showMenu.add(errorItem);
        jMenuBar1.add(showMenu);
        this.setJMenuBar(jMenuBar1);
        this.pack();
    }

    private void openItemActionPerformed(ActionEvent evt) {
        File file;
        this.initChooser("Open");
        int retval = chooser.showOpenDialog(this);
        if (retval == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory()) {
            try {
                String filename = file.getAbsolutePath();
                this.globalStatistics = new GlobalStatistics(filename);
                this.displayGlobalStatistics();
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
    }

    private void initChooser(String str) {
        if (chooser == null) {
            String path = System.getProperty("FILES");
            if (path == null) {
                path = "";
            }
            chooser = new JFileChooser(new File(path).getAbsolutePath());
            chooser.setFileFilter(fileFilter);
        }
        chooser.setApproveButtonText(str);
    }

    private void saveItemActionPerformed(ActionEvent evt) {
        File file;
        if (this.globalStatistics == null) {
            return;
        }
        this.initChooser("Save");
        int retval = chooser.showOpenDialog(this);
        if (retval == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory()) {
            String fileName = file.getAbsolutePath();
            if (!fileName.endsWith(".xml")) {
                fileName = fileName + ".xml";
            }
            if (new File(fileName).exists() && JOptionPane.showConfirmDialog(this, fileName + "   File already exists\n\n     Overwrite it ?", "Confirm Dialog", 0) != 0) {
                return;
            }
            try {
                this.globalStatistics.saveStatistics(fileName);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
    }

    private void exitItemActionPerformed(ActionEvent evt) {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    private void exitForm(WindowEvent evt) {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    private void readItemActionPerformed(ActionEvent evt) {
        this.readAndDisplayStatistics(null);
    }

    private void errorItemActionPerformed(ActionEvent evt) {
        StringBuilder sb = new StringBuilder();
        if (this.globalStatistics != null) {
            for (StarterStat starterStat : this.globalStatistics.getStarterStatistics()) {
                if (starterStat.readOK) continue;
                sb.append(starterStat.name).append(":\t").append(starterStat.error).append("\n");
            }
        }
        if (sb.length() == 0) {
            sb.append("No Error.");
        }
        new PopupText(this, true).show(sb.toString());
    }

    private void filterTextKeyPressed(KeyEvent evt) {
        if (evt.getKeyChar() == '\u001b') {
            this.resetFilter();
        } else {
            new DelayedDisplay(evt).start();
        }
    }

    private void filterItemActionPerformed(ActionEvent evt) {
        if (this.statisticsTable != null) {
            this.bottomPanel.setVisible(true);
            this.pack();
            new DelayedDisplay().start();
        }
    }

    private void resetItemActionPerformed(ActionEvent evt) {
        new ResetStatistics(this);
    }

    private void datesItemActionPerformed(ActionEvent evt) {
        if (this.globalStatistics != null) {
            try {
                new PopupTable((JFrame)this, null, new String[]{"Host", "Statistics starting Date"}, this.globalStatistics.getStarterResetDates()).setVisible(true);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
    }

    private void resetFilter() {
        if (this.statisticsTable != null) {
            this.statisticsTable.resetFilter();
            this.filterText.setText("");
            this.bottomPanel.setVisible(false);
            this.pack();
        }
    }

    private List<ServerStat> getServerFailedList(List<StarterStat> starterStats) {
        ArrayList<ServerStat> serverStats = new ArrayList<ServerStat>();
        for (StarterStat starterStat : starterStats) {
            for (ServerStat server : starterStat) {
                if (server.nbFailures <= 0) continue;
                serverStats.add(server);
            }
        }
        return serverStats;
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                new StatisticsPanel(null, args[0]).setVisible(true);
            } else {
                new StatisticsPanel().setVisible(true);
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
        }
    }

    private class DelayedDisplay
    extends Thread {
        private KeyEvent evt = null;

        private DelayedDisplay() {
        }

        private DelayedDisplay(KeyEvent evt) {
            this.evt = evt;
        }

        @Override
        public void run() {
            try {
                DelayedDisplay.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.evt == null) {
                StatisticsPanel.this.filterText.requestFocus();
            } else {
                char c = this.evt.getKeyChar();
                if ((c & 0x8000) == 0) {
                    String s = StatisticsPanel.this.filterText.getText();
                    if (!StatisticsPanel.this.filter.equals(s)) {
                        if (s.length() > 0) {
                            StatisticsPanel.this.statisticsTable.setFilter(s);
                        } else {
                            StatisticsPanel.this.statisticsTable.resetFilter();
                        }
                    }
                    StatisticsPanel.this.filter = s;
                }
            }
        }
    }

    class CompareStarterResetTime
    implements Comparator<StarterStat> {
        CompareStarterResetTime() {
        }

        @Override
        public int compare(StarterStat stat1, StarterStat stat2) {
            if (stat1.resetTime == stat2.resetTime) {
                return 0;
            }
            return stat1.resetTime > stat2.resetTime ? 1 : -1;
        }
    }

    private class ReadThread
    extends Thread {
        private ArrayList<String> hostList;

        private ReadThread(ArrayList<String> hostList) {
            this.hostList = hostList;
        }

        @Override
        public void run() {
            AstorUtil.startSplash("Statistics ");
            AstorUtil.increaseSplashProgress(5, "Reading....");
            StatisticsPanel.this.setCursor(new Cursor(3));
            List<StarterStat> starterStatistics = Utils.readHostStatistics(this.hostList);
            Collections.sort(starterStatistics, new CompareStarterResetTime());
            StatisticsPanel.this.globalStatistics = new GlobalStatistics(starterStatistics);
            StatisticsPanel.this.displayGlobalStatistics();
            StatisticsPanel.this.setCursor(new Cursor(0));
            AstorUtil.stopSplash();
        }
    }
}

