/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevFailed;
import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;

public class StatisticsFileFilter
extends FileFilter {
    private ArrayList<String> filters = new ArrayList();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public StatisticsFileFilter() {
    }

    public StatisticsFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public StatisticsFileFilter(String[] filters, String description) {
        this();
        for (String filter : filters) {
            this.addExtension(filter);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = StatisticsFileFilter.getExtension(f);
            if (extension != null) {
                for (String filter : this.filters) {
                    if (!filter.equals(extension)) continue;
                    return this.isStatisticsGeneratedFile(f.toString());
                }
            }
        }
        return false;
    }

    public static String getExtension(File f) {
        if (f != null) {
            String filename = f.getName();
            return StatisticsFileFilter.getExtension(filename);
        }
        return null;
    }

    public static String getExtension(String filename) {
        int i;
        if (filename != null && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        this.filters.add(extension.toLowerCase());
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "" : this.description + "  (";
                for (int i = 0; i < this.filters.size(); ++i) {
                    this.fullDescription = this.fullDescription + "*." + this.filters.get(i);
                    if (i >= this.filters.size() - 1) continue;
                    this.fullDescription = this.fullDescription + ", ";
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    private boolean isStatisticsGeneratedFile(String fileName) {
        String code;
        try {
            code = Utils.readFile(fileName);
        }
        catch (DevFailed e) {
            return false;
        }
        return code.contains("<?xml version=\"1.0\" encoding=\"ASCII\"?>\n<ctrlStatDsl:CtrlStatSystem xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ctrlStatDsl=\"http://www.esrf.fr/tango/starter/CtrlStatDslDsl\">");
    }
}

