/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.ServerStat;
import admin.astor.statistics.ServerStatisticsPanel;
import admin.astor.statistics.StarterStat;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class StarterStatTable
extends JDialog {
    private DataTableModel model;
    private JTable jtable;
    private String[][] data;
    private JFrame parent;
    private JLabel titleLabel;
    private StarterStat starterStat;

    public StarterStatTable(JFrame parent, String title, StarterStat starterStat) {
        super((Frame)parent, false);
        this.parent = parent;
        this.starterStat = starterStat;
        this.data = starterStat.toTable();
        this.initComponents();
        this.initMyComponents(title);
    }

    public StarterStatTable(JFrame parent, String hostname) throws DevFailed {
        super((Frame)parent, false);
        this.parent = parent;
        this.starterStat = new StarterStat(hostname);
        this.data = this.starterStat.toTable();
        this.initComponents();
        this.initMyComponents(hostname);
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JButton cancelBtn = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                StarterStatTable.this.closeDialog(evt);
            }
        });
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StarterStatTable.this.cancelBtnActionPerformed(evt);
            }
        });
        jPanel1.add(cancelBtn);
        this.getContentPane().add((Component)jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        this.pack();
    }

    private void initMyComponents(String title) {
        this.model = new DataTableModel();
        this.jtable = new JTable(this.model);
        this.jtable.setRowSelectionAllowed(true);
        this.jtable.setColumnSelectionAllowed(true);
        this.jtable.setDragEnabled(true);
        this.jtable.setSelectionMode(0);
        this.jtable.getTableHeader().setFont(new Font("Dialog", 1, 14));
        this.jtable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StarterStatTable.this.headerTableActionPerformed(evt);
            }
        });
        this.jtable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StarterStatTable.this.tableActionPerformed(evt);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.jtable);
        int height = 18 + 18 * this.data.length;
        if (height > 400) {
            height = 400;
        }
        int[] width = new int[]{180, 180, 70, 130};
        Enumeration<TableColumn> enumeration = this.jtable.getColumnModel().getColumns();
        int sp_width = 0;
        int i = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tc = enumeration.nextElement();
            tc.setPreferredWidth(width[i]);
            sp_width += width[i];
            ++i;
        }
        scrollPane.setPreferredSize(new Dimension(sp_width, height));
        this.getContentPane().add((Component)scrollPane, "Center");
        this.model.fireTableDataChanged();
        this.titleLabel.setText(title);
        ATKGraphicsUtils.centerDialog((Dialog)this);
        this.pack();
    }

    private void headerTableActionPerformed(MouseEvent evt) {
        int column = this.jtable.getTableHeader().columnAtPoint(new Point(evt.getX(), evt.getY()));
        new UsedData().sort(column);
        this.model.fireTableDataChanged();
    }

    private void tableActionPerformed(MouseEvent evt) {
        int column = this.jtable.columnAtPoint(new Point(evt.getX(), evt.getY()));
        int row = this.jtable.rowAtPoint(new Point(evt.getX(), evt.getY()));
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && column == 0) {
            String serverName = this.data[row][0];
            for (ServerStat serverStat : this.starterStat) {
                if (!serverStat.name.equals(serverName)) continue;
                if (this.parent != null) {
                    new ServerStatisticsPanel(this.parent, serverName, serverStat).setVisible(true);
                } else {
                    new ServerStatisticsPanel(this, serverName, serverStat).setVisible(true);
                }
                return;
            }
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (this.parent == null) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Crate name ?");
            System.exit(0);
        }
        try {
            new StarterStatTable(null, args[0]).setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return StarterStatTable.this.data[0].length;
        }

        @Override
        public int getRowCount() {
            return StarterStatTable.this.data.length;
        }

        @Override
        public String getColumnName(int aCol) {
            if (aCol >= this.getColumnCount()) {
                return StarterStat.tableHeader[this.getColumnCount() - 1];
            }
            return StarterStat.tableHeader[aCol];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return StarterStatTable.this.data[row][col];
        }
    }

    class UsedData
    extends ArrayList<String[]> {
        private int column;

        UsedData() {
            for (String[] datum : StarterStatTable.this.data) {
                this.add(datum);
            }
        }

        void sort(int column) {
            this.column = column;
            MyCompare compare = new MyCompare();
            Collections.sort(this, compare);
            for (int i = 0; i < this.size(); ++i) {
                ((StarterStatTable)StarterStatTable.this).data[i] = (String[])this.get(i);
            }
        }

        class MyCompare
        implements Comparator<String[]> {
            MyCompare() {
            }

            @Override
            public int compare(String[] array1, String[] array2) {
                String s1 = array1[UsedData.this.column];
                String s2 = array2[UsedData.this.column];
                try {
                    double d1 = Double.parseDouble(s1);
                    double d2 = Double.parseDouble(s2);
                    if (d1 == d2) {
                        return 0;
                    }
                    return d1 < d2 ? 1 : -1;
                }
                catch (NumberFormatException numberFormatException) {
                    return s1.compareToIgnoreCase(s2);
                }
            }
        }
    }
}

