/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoDs.Except;

public class ServerRecord {
    DevState state;
    String stateName;
    long startTime = -1L;
    long endTime = -1L;
    long duration = 0L;
    int autoRestart = 0;
    public static final int START_UNKNOWN = 0;
    public static final int START_REQUEST = 1;
    public static final int START_AUTO = 2;
    public static final String className = "ServerRecord";
    private static final String stateStr = "state";
    private static final String startTimeStr = "startTime";
    private static final String endTimeStr = "endTime";
    private static final String durationStr = "duration";
    private static final String autoStartStr = "started";
    private static final String description = "<ServerRecord state=\"STATE\" startTime=\"START_TIME\" endTime=\"END_TIME\" duration=\"DURATION\"started=\"STARTED\">";
    private static final String tab = "\t\t\t\t";

    public ServerRecord(String line) throws DevFailed {
        String str;
        this.stateName = Utils.parseXmlProperty(line, stateStr);
        this.state = this.stateName.equals("Start") ? DevState.ON : DevState.FAULT;
        try {
            this.startTime = Long.parseLong(Utils.parseXmlProperty(line, startTimeStr));
            this.endTime = Long.parseLong(Utils.parseXmlProperty(line, endTimeStr));
            this.duration = this.endTime - this.startTime;
        }
        catch (NumberFormatException e) {
            Except.throw_exception((String)"SYNTAX_ERROR", (String)e.toString(), (String)"ServerRecord.ServerRecord()");
        }
        switch (str = Utils.parseXmlProperty(line, autoStartStr)) {
            case "auto": {
                this.autoRestart = 2;
                break;
            }
            case "request": {
                this.autoRestart = 1;
                break;
            }
            default: {
                this.autoRestart = 0;
            }
        }
    }

    public ServerRecord(DevState state, long startTime, long endTime, int autoRestart) {
        this.state = state;
        this.stateName = state == DevState.ON ? "Start" : "Failed";
        this.startTime = startTime;
        this.endTime = endTime;
        this.duration = endTime - startTime;
        this.autoRestart = autoRestart;
    }

    public String toXml() {
        String str = description;
        str = Utils.strReplace(str, "STATE", this.stateName);
        str = Utils.strReplace(str, "START_TIME", Long.toString(this.startTime));
        str = Utils.strReplace(str, "END_TIME", Long.toString(this.endTime));
        str = Utils.strReplace(str, "DURATION", Long.toString(this.duration));
        str = this.state == DevState.ON ? (this.autoRestart == 2 ? Utils.strReplace(str, "STARTED", "auto") : (this.autoRestart == 1 ? Utils.strReplace(str, "STARTED", "request") : Utils.strReplace(str, "STARTED", ""))) : Utils.strReplace(str, "STARTED", "");
        return tab + str;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.state == DevState.ON) {
            sb.append("Start");
        } else {
            sb.append("Failed");
        }
        sb.append("\t").append(Utils.formatDate(this.startTime)).append("\t").append(Utils.formatDate(this.endTime)).append("\t").append(Utils.formatDuration(this.duration));
        return sb.toString();
    }
}

