/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.ServerStat;
import admin.astor.statistics.ServerStatisticsPanel;
import admin.astor.statistics.StarterStat;
import admin.astor.statistics.StarterStatTable;
import admin.astor.statistics.Utils;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class GlobalStatisticsTable
extends JTable {
    private JFrame parent;
    private List<ServerStat> serverStatistics;
    private List<ServerStat> filteredServerStatistics = new ArrayList<ServerStat>();
    private DataTableModel model;
    private TablePopupMenu menu;
    private static final int SERVER_NAME = 0;
    private static final int HOST_NAME = 1;
    private static final int NB_FAILURES = 2;
    private static final int TIME_FAILURE = 3;
    private static final int AVAILABILITY = 4;
    private static final int LAST_FAILURE = 5;
    private final Column[] columns = new Column[]{new Column("Server Name", 200), new Column("Host Name", 100), new Column("Failures", 50), new Column("Failure Duration", 150), new Column("Availability", 80), new Column("Last Failure", 150)};
    private static final int OFFSET = 2;
    private static final int SERVER_STAT = 0;
    private static final int HOST_STAT = 1;
    private static String[] menuLabels = new String[]{"Server statistics", "Host statistics"};

    public GlobalStatisticsTable(JFrame parent) {
        this.parent = parent;
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(true);
        this.setDragEnabled(false);
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GlobalStatisticsTable.this.tableActionPerformed(evt);
            }
        });
        this.model = new DataTableModel();
        this.setModel(this.model);
        this.getTableHeader().setFont(new Font("Dialog", 1, 12));
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GlobalStatisticsTable.this.headerTableActionPerformed(evt);
            }
        });
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tc = enumeration.nextElement();
            tc.setPreferredWidth(this.columns[i++].width);
        }
        this.menu = new TablePopupMenu(this);
    }

    public int getDefaultHeight() {
        int max = 400;
        int height = 22 + 17 * this.filteredServerStatistics.size();
        if (height > max) {
            height = max;
        }
        return height;
    }

    public int getDefaultWidth() {
        int width = 0;
        for (Column column : this.columns) {
            width += column.width;
        }
        return width;
    }

    private void tableActionPerformed(MouseEvent evt) {
        int column = this.columnAtPoint(new Point(evt.getX(), evt.getY()));
        int row = this.rowAtPoint(new Point(evt.getX(), evt.getY()));
        ServerStat server = this.filteredServerStatistics.get(row);
        if (evt.getButton() == 3) {
            switch (column) {
                case 0: {
                    this.menu.showMenu(evt, server);
                    break;
                }
                case 1: {
                    this.menu.showMenu(evt, server.starterStat);
                }
            }
        } else if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            switch (column) {
                case 0: {
                    this.displayServerStat(server);
                    break;
                }
                case 1: {
                    this.displayStarterStat(server.starterStat);
                }
            }
        }
    }

    private void displayServerStat(ServerStat serverStat) {
        String title = serverStat.name + "  registered on  " + serverStat.starterStat.name;
        new ServerStatisticsPanel(this.parent, title, serverStat).setVisible(true);
    }

    private void displayStarterStat(StarterStat starterStat) {
        String title = starterStat.name;
        new StarterStatTable(this.parent, title, starterStat).setVisible(true);
    }

    private void headerTableActionPerformed(MouseEvent evt) {
        System.out.println("headerTableActionPerformed(evt); called");
        this.sort(this.getTableHeader().columnAtPoint(new Point(evt.getX(), evt.getY())));
    }

    private void sort(int column) {
        for (ServerStat serverStat : this.filteredServerStatistics) {
            System.out.println(serverStat.name);
        }
        Collections.sort(this.filteredServerStatistics, new ServersComparator(column));
        System.out.println("==============================================================================");
        for (ServerStat serverStat : this.filteredServerStatistics) {
            System.out.println(serverStat.name);
        }
        this.model.fireTableDataChanged();
    }

    public void setStatistics(List<ServerStat> serverStatistics) {
        this.serverStatistics = serverStatistics;
        this.copyServerStatistics();
        this.sort(5);
        this.model.fireTableDataChanged();
    }

    public void setFilter(String startWith) {
        this.filteredServerStatistics.clear();
        for (ServerStat serverStat : this.serverStatistics) {
            if (!serverStat.name.startsWith(startWith)) continue;
            this.filteredServerStatistics.add(serverStat);
        }
        this.model.fireTableDataChanged();
    }

    public void resetFilter() {
        this.copyServerStatistics();
        this.model.fireTableDataChanged();
    }

    private void copyServerStatistics() {
        this.filteredServerStatistics.clear();
        for (ServerStat serverStat : this.serverStatistics) {
            this.filteredServerStatistics.add(serverStat);
        }
    }

    private class TablePopupMenu
    extends JPopupMenu {
        private JTable table;
        private ServerStat serverStat;
        private StarterStat starterStat;
        private JLabel title;

        private TablePopupMenu(JTable table) {
            this.table = table;
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : menuLabels) {
                if (menuLabel == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        TablePopupMenu.this.menuActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        private void showMenu(MouseEvent evt, ServerStat serverStat) {
            this.title.setText(serverStat.name);
            this.serverStat = serverStat;
            this.getComponent(2).setVisible(true);
            this.getComponent(3).setVisible(false);
            this.show(this.table, evt.getX(), evt.getY());
        }

        private void showMenu(MouseEvent evt, StarterStat starterStat) {
            this.title.setText(starterStat.name);
            this.starterStat = starterStat;
            this.getComponent(2).setVisible(false);
            this.getComponent(3).setVisible(true);
            this.show(this.table, evt.getX(), evt.getY());
        }

        private void menuActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int cmdidx = 0;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != obj) continue;
                cmdidx = i;
            }
            switch (cmdidx) {
                case 0: {
                    GlobalStatisticsTable.this.displayServerStat(this.serverStat);
                    break;
                }
                case 1: {
                    GlobalStatisticsTable.this.displayStarterStat(this.starterStat);
                }
            }
        }
    }

    class ServersComparator
    implements Comparator<ServerStat> {
        private int column;

        private ServersComparator(int column) {
            this.column = column;
        }

        @Override
        public int compare(ServerStat server1, ServerStat server2) {
            switch (this.column) {
                case 0: {
                    return server1.name.compareToIgnoreCase(server2.name);
                }
                case 1: {
                    return server1.starterStat.name.compareToIgnoreCase(server2.starterStat.name);
                }
                case 2: {
                    if (server1.nbFailures == server2.nbFailures) {
                        return 0;
                    }
                    return server1.nbFailures < server2.nbFailures ? 1 : -1;
                }
                case 3: {
                    if (server1.failedDuration < server2.failedDuration) {
                        return 0;
                    }
                    return server1.failedDuration < server2.failedDuration ? 1 : -1;
                }
                case 4: {
                    if (server1.getAvailability() < server2.getAvailability()) {
                        return 0;
                    }
                    return server1.getAvailability() < server2.getAvailability() ? 1 : -1;
                }
                case 5: {
                    if (server1.getLastFailure() < server2.getLastFailure()) {
                        return 0;
                    }
                    return server1.getLastFailure() < server2.getLastFailure() ? 1 : -1;
                }
            }
            return server1.name.compareToIgnoreCase(server2.name);
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return GlobalStatisticsTable.this.columns.length;
        }

        @Override
        public int getRowCount() {
            return GlobalStatisticsTable.this.filteredServerStatistics.size();
        }

        @Override
        public String getColumnName(int col) {
            return ((GlobalStatisticsTable)GlobalStatisticsTable.this).columns[col].name;
        }

        @Override
        public Object getValueAt(int row, int col) {
            ServerStat server = (ServerStat)GlobalStatisticsTable.this.filteredServerStatistics.get(row);
            return this.getServerValueString(server, col);
        }

        private String getServerValueString(ServerStat server, int column) {
            switch (column) {
                case 0: {
                    return server.name;
                }
                case 1: {
                    return server.starterStat.name;
                }
                case 2: {
                    return Integer.toString(server.nbFailures);
                }
                case 3: {
                    return Utils.formatDuration(server.failedDuration);
                }
                case 4: {
                    return Utils.formatPercentage(server.getAvailability());
                }
                case 5: {
                    long t = server.getLastFailure();
                    if (t > 0L) {
                        return Utils.formatDate(t);
                    }
                    return " ? ? ";
                }
            }
            return "--";
        }
    }

    class Column {
        String name;
        int width;

        Column(String name, int width) {
            this.name = name;
            this.width = width;
        }
    }
}

