/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.ServerStat;
import admin.astor.statistics.StarterStat;
import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class GlobalStatistics {
    public long readAt = 0L;
    public int nbHosts = 0;
    public int nbHostRead = 0;
    public int nbServers = 0;
    public int nbServersRead = 0;
    public long runDuration = 0L;
    public long failedDuration = 0L;
    public int nbFailures = 0;
    private List<StarterStat> starterStats;
    private String fileName = null;
    private static final String className = "GlobalStat";
    private static final String dateStr = "date";
    private static final String timeStr = "time";
    private static final String failuresStr = "failures";
    private static final String description = "<GlobalStatdate=\"DATE\" time=\"TIME\" failures=\"FAILURES\" >";
    public static final String system = "ctrlStatDsl:CtrlStatSystem";
    public static final String header = "<?xml version=\"1.0\" encoding=\"ASCII\"?>\n<ctrlStatDsl:CtrlStatSystem xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ctrlStatDsl=\"http://www.esrf.fr/tango/starter/CtrlStatDslDsl\">";
    public static final String footer = "</ctrlStatDsl:CtrlStatSystem>";

    public GlobalStatistics(String fileName) throws DevFailed {
        this.fileName = fileName;
        this.starterStats = new ArrayList<StarterStat>();
        String code = Utils.readFile(fileName);
        if (!code.startsWith(header)) {
            Except.throw_exception((String)"FILE_NOT_VALID", (String)(fileName + " is not a TANGO statistics file"), (String)"GlobalStatistics.GlobalStatistics()");
        }
        this.parseStatistics(code);
        this.computeStatistics();
    }

    public GlobalStatistics(List<StarterStat> starterStats) {
        this.starterStats = starterStats;
        this.readAt = System.currentTimeMillis();
        this.computeStatistics();
    }

    public String[][] getStarterResetDates() {
        String[][] dates = new String[this.starterStats.size()][];
        int i = 0;
        for (StarterStat starterStat : this.starterStats) {
            long t = starterStat.resetTime;
            String[] array = new String[]{starterStat.name, t < 0L ? " ? ? " : Utils.formatDate(t)};
            dates[i++] = array;
        }
        return dates;
    }

    public String getServersRunningTwice() {
        StringBuilder sb = new StringBuilder();
        for (StarterStat starterStat : this.starterStats) {
            if (starterStat.runningTwiceList.size() <= 0) continue;
            sb.append(starterStat.name).append(":\n");
            for (String runningTwice : starterStat.runningTwiceList) {
                sb.append("  ").append(runningTwice).append('\n');
            }
        }
        return sb.toString();
    }

    public List<StarterStat> getStarterStatistics() {
        return this.starterStats;
    }

    private void computeStatistics() {
        this.nbHosts = this.starterStats.size();
        for (StarterStat starterStat : this.starterStats) {
            this.nbServers += starterStat.size();
            if (!starterStat.readOK) continue;
            ++this.nbHostRead;
            for (ServerStat serverStat : starterStat) {
                ++this.nbServersRead;
                this.runDuration += serverStat.runDuration / 1000L;
                if (serverStat.nbFailures <= 0) continue;
                this.nbFailures += serverStat.nbFailures;
                this.failedDuration += serverStat.failedDuration / 1000L;
            }
        }
        this.runDuration *= 1000L;
        this.failedDuration *= 1000L;
    }

    public long getDuration() {
        return this.readAt - this.getOldestTime();
    }

    private long getOldestTime() {
        long t = System.currentTimeMillis();
        for (StarterStat starterStat : this.starterStats) {
            if (starterStat.resetTime >= t) continue;
            t = starterStat.resetTime;
        }
        return t;
    }

    public String getHostForOldestTime() {
        String hostName = "";
        long t = System.currentTimeMillis();
        for (StarterStat starterStat : this.starterStats) {
            if (starterStat.resetTime >= t) continue;
            t = starterStat.resetTime;
            hostName = starterStat.name;
        }
        return hostName + " (" + Utils.formatDate(t) + ")";
    }

    private void parseStatistics(String code) throws DevFailed {
        StringTokenizer stk = new StringTokenizer(code, "\n");
        ArrayList<String> lines = new ArrayList<String>();
        boolean globalFound = false;
        while (stk.hasMoreTokens()) {
            String line = stk.nextToken().trim();
            if (line.startsWith("<GlobalStat")) {
                globalFound = true;
                this.parseXmlLine(line);
                continue;
            }
            if (line.startsWith("</GlobalStat")) {
                globalFound = false;
                continue;
            }
            if (!globalFound) continue;
            lines.add(line);
        }
        ArrayList<String> records = new ArrayList<String>();
        for (String line : lines) {
            if (line.startsWith("</StarterStat")) {
                StarterStat starterStat = new StarterStat((List<String>)records);
                this.starterStats.add(starterStat);
                records.clear();
                continue;
            }
            records.add(line);
        }
    }

    private void parseXmlLine(String line) throws DevFailed {
        try {
            this.readAt = Long.parseLong(Utils.parseXmlProperty(line, timeStr));
        }
        catch (NumberFormatException e) {
            Except.throw_exception((String)"SYNTAX_ERROR", (String)e.toString(), (String)"GlobalStatistics.parseLine()");
        }
        System.out.println("Written " + Utils.parseXmlProperty(line, dateStr));
        System.out.println("--> " + Utils.formatDate(this.readAt));
        System.out.println(this.nbFailures + " failures");
    }

    public void saveStatistics(String fileName) throws DevFailed {
        StringBuilder sb = new StringBuilder(header);
        sb.append("\n");
        sb.append("\t").append(this.toXml()).append("\n");
        for (StarterStat starterStat : this.starterStats) {
            sb.append(starterStat.toXml()).append("\n");
        }
        sb.append("\t</").append(className).append(">\n");
        sb.append(footer);
        Utils.writeFile(fileName, sb.toString());
    }

    private String toXml() {
        String str = description;
        str = Utils.strReplace(str, "DATE", Utils.formatDate(this.readAt));
        str = Utils.strReplace(str, "TIME", Long.toString(this.readAt));
        str = Utils.strReplace(str, "FAILURES", Integer.toString(this.nbFailures));
        return str;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.fileName == null) {
            sb.append("Statistics from Starters\n");
        } else {
            sb.append("Statistics from file: ").append(this.fileName).append("\n");
        }
        sb.append("Between   ").append(Utils.formatDate(this.getOldestTime())).append("   and   ").append(Utils.formatDate(this.readAt)).append(" on:\n  ");
        sb.append(this.nbHostRead).append("/").append(this.nbHosts).append("   Controlled hosts\n  ");
        sb.append(this.nbServersRead).append("  Controlled servers\n  ");
        if (this.nbFailures == 0) {
            sb.append("Availability:    100 %");
        } else {
            double availability = (double)this.runDuration / (double)(this.runDuration + this.failedDuration);
            sb.append("Nb failures:   ").append(this.nbFailures).append("\n  ");
            sb.append("Availability:  ").append(Utils.formatPercentage(availability));
        }
        return sb.toString();
    }
}

