/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.dev_state_viewer;

import admin.astor.dev_state_viewer.TangoClass;
import admin.astor.dev_state_viewer.TangoDevice;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.util.ArrayList;

public class TangoServer
extends ArrayList<TangoClass> {
    private String name;

    public TangoServer(String name) throws DevFailed {
        String[] classNames;
        this.name = name;
        DbServer server = new DbServer(name);
        for (String className : classNames = server.get_class_list()) {
            String[] deviceNames;
            TangoClass tangoClass = new TangoClass(className);
            for (String deviceName : deviceNames = server.get_device_name(className)) {
                tangoClass.add(new TangoDevice(deviceName));
            }
            this.add(tangoClass);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name + ":\n");
        for (TangoClass tangoClass : this) {
            sb.append(tangoClass).append('\n');
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                ErrorPane.showErrorMessage(null, null, (Exception)new Exception("Server name ?"));
                System.exit(0);
            }
            System.out.println(new TangoServer(args[0]));
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage(null, null, (DevFailed)e);
            System.exit(0);
        }
    }
}

