/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.dev_state_viewer;

import admin.astor.AstorUtil;
import admin.astor.dev_state_viewer.ScalarViewer;
import admin.astor.dev_state_viewer.StateCell;
import admin.astor.dev_state_viewer.TangoClass;
import admin.astor.dev_state_viewer.TangoDevice;
import atkpanel.MainPanel;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableViewer
extends JTable {
    private JDialog parent;
    private TangoClass tangoClass;
    private int tableWidth = 0;
    private int selectedRow = -1;
    private TablePopupMenu popupMenu = new TablePopupMenu();
    private static final int[] COLUMN_WIDTH = new int[]{350, 90};
    private static final String[] COLUMN_HEADERS = new String[]{"Device Names", "States"};
    private static final Color firstColumnColor = new Color(221, 221, 221);
    private static final int STATUS = 0;
    private static final int TEST = 1;
    private static final int MONITOR = 2;
    private static final int OFFSET = 2;
    private static String[] menuLabels = new String[]{"Device status", "Test device", "Monitor device"};

    public TableViewer(JDialog parent, TangoClass tangoClass) throws DevFailed {
        this.parent = parent;
        this.tangoClass = tangoClass;
        for (TangoDevice device : tangoClass) {
            device.createStateCell(this);
        }
        ScalarViewer.attributeList.startRefresher();
        DataTableModel model = new DataTableModel();
        this.setModel(model);
        this.setRowSelectionAllowed(true);
        this.setDefaultRenderer(String.class, new LabelCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                TableViewer.this.tableActionPerformed(event);
            }
        });
        this.getTableHeader().setFont(new Font("Dialog", 1, 14));
        this.setRowHeight(15);
        Enumeration<TableColumn> columnEnum = this.getColumnModel().getColumns();
        int i = 0;
        while (columnEnum.hasMoreElements()) {
            this.tableWidth += COLUMN_WIDTH[i];
            TableColumn tableColumn = columnEnum.nextElement();
            tableColumn.setPreferredWidth(COLUMN_WIDTH[i++]);
        }
    }

    private void tableActionPerformed(MouseEvent event) {
        this.selectedRow = this.rowAtPoint(new Point(event.getX(), event.getY()));
        if (event.getClickCount() == 2 && event.getButton() == 1) {
            this.displayStatus();
        } else if (event.getButton() == 3) {
            this.popupMenu.showMenu(event, ((TangoDevice)this.tangoClass.get(this.selectedRow)).getName());
        }
        this.repaint();
    }

    public int getTableWidth() {
        return this.tableWidth;
    }

    private void displayStatus() {
        TangoDevice device = (TangoDevice)this.tangoClass.get(this.selectedRow);
        try {
            JOptionPane.showMessageDialog(this, device.getName() + ":\n" + device.getStatus());
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)device.getName(), (DevFailed)e);
        }
    }

    private void monitorDevice() {
        TangoDevice device = (TangoDevice)this.tangoClass.get(this.selectedRow);
        new MainPanel(device.getName());
    }

    private void testDevice() {
        TangoDevice device = (TangoDevice)this.tangoClass.get(this.selectedRow);
        AstorUtil.testDevice(this.parent, device.getName());
    }

    private class TablePopupMenu
    extends JPopupMenu {
        private TablePopupMenu() {
            JLabel title = new JLabel("");
            title.setFont(new Font("Dialog", 1, 14));
            this.add(title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : menuLabels) {
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(this::menuActionPerformed);
                this.add(btn);
            }
        }

        public void showMenu(MouseEvent event, String name) {
            ((JLabel)this.getComponent(0)).setText(name);
            this.show((Component)event.getSource(), event.getX(), event.getY());
        }

        private void menuActionPerformed(ActionEvent event) {
            Object obj = event.getSource();
            int commandIndex = 0;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != obj) continue;
                commandIndex = i;
            }
            switch (commandIndex) {
                case 0: {
                    TableViewer.this.displayStatus();
                    break;
                }
                case 1: {
                    TableViewer.this.testDevice();
                    break;
                }
                case 2: {
                    TableViewer.this.monitorDevice();
                }
            }
        }
    }

    public class LabelCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public LabelCellRenderer() {
            this.setFont(new Font("Dialog", 1, 12));
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TangoDevice device = (TangoDevice)TableViewer.this.tangoClass.get(row);
            this.setIcon(null);
            this.setForeground(Color.black);
            if (column == 0) {
                this.setText(" " + device.getName());
                if (row == TableViewer.this.selectedRow) {
                    this.setBackground(TableViewer.this.selectionBackground);
                } else {
                    this.setBackground(firstColumnColor);
                }
            } else {
                StateCell stateCell = device.getStateCell();
                this.setText("  " + stateCell.getStatus());
                this.setBackground(stateCell.getBackground());
                this.setForeground(stateCell.getForeground());
            }
            return this;
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return COLUMN_HEADERS.length;
        }

        @Override
        public int getRowCount() {
            return TableViewer.this.tangoClass.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex >= this.getColumnCount()) {
                return COLUMN_HEADERS[this.getColumnCount() - 1];
            }
            return COLUMN_HEADERS[columnIndex];
        }

        @Override
        public Object getValueAt(int row, int column) {
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
        }

        public Class getColumnClass(int column) {
            if (TableViewer.this.isVisible()) {
                return this.getValueAt(0, column).getClass();
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

