/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.dev_state_viewer;

import admin.astor.dev_state_viewer.ScalarViewer;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.attribute.StateViewer;
import java.awt.Color;
import javax.swing.JTable;

public class StateCell {
    private String name;
    private Color background = new Color(0xDDDDDD);
    private Color foreground = Color.black;
    private String status = "UNKNOWN";
    private String errorMessage;
    private StateViewer stateViewer;

    public StateCell(String attributeName, JTable table) throws DevFailed {
        this.name = " " + attributeName;
        this.stateViewer = new ScalarViewer(this, attributeName, table);
    }

    public String getName() {
        return this.name;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public String getStatusToolTip() {
        if (this.status.equals("ON")) {
            return this.name + " is OK";
        }
        return this.name + " is " + this.status;
    }

    public String getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setErrorMessage(String errorMessage) {
        int idx;
        this.errorMessage = errorMessage != null ? ((idx = errorMessage.indexOf("Description:")) < 0 ? errorMessage : errorMessage.substring(idx, errorMessage.indexOf("Reason"))) : null;
    }

    public String toString() {
        return this.name;
    }
}

