/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.dev_state_viewer;

import admin.astor.AstorUtil;
import admin.astor.dev_state_viewer.ScalarViewer;
import admin.astor.dev_state_viewer.TableViewer;
import admin.astor.dev_state_viewer.TangoClass;
import admin.astor.dev_state_viewer.TangoServer;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ServerStatesDialog
extends JDialog {
    private Component parent;
    private JLabel titleLabel;

    public ServerStatesDialog(JFrame parent, String serverName) throws DevFailed {
        super((Frame)parent, true);
        this.buildTheForm(parent, serverName);
    }

    public ServerStatesDialog(JDialog parent, String serverName) throws DevFailed {
        super((Dialog)parent, true);
        this.buildTheForm(parent, serverName);
    }

    private void buildTheForm(Component parent, String serverName) throws DevFailed {
        try {
            this.parent = parent;
            AstorUtil.startSplash("Build GUI");
            this.initComponents();
            AstorUtil.increaseSplashProgress(5, "Query database for " + serverName);
            TangoServer tangoServer = new TangoServer(serverName);
            if (tangoServer.isEmpty()) {
                Except.throw_exception((String)"", (String)("No class/device defined for specified server: " + serverName));
            }
            JTabbedPane tabbedPane = new JTabbedPane();
            this.getContentPane().add((Component)tabbedPane, "Center");
            AstorUtil.increaseSplashProgress(25, "Building the state viewers");
            TableViewer classTable = null;
            int nbDevices = 0;
            int index = 0;
            int i = 0;
            ArrayList<JScrollPane> scrollPanes = new ArrayList<JScrollPane>();
            for (TangoClass tangoClass : tangoServer) {
                classTable = new TableViewer(this, tangoClass);
                JScrollPane scrollPane = new JScrollPane(classTable);
                scrollPanes.add(scrollPane);
                tabbedPane.add((Component)scrollPane, tangoClass.getName());
                if (tangoClass.size() > nbDevices) {
                    nbDevices = tangoClass.size();
                    index = i;
                }
                ++i;
            }
            int height = nbDevices * 15 + 30;
            if (height > 800) {
                height = 800;
            }
            for (JScrollPane scrollPane : scrollPanes) {
                scrollPane.setPreferredSize(new Dimension(classTable.getTableWidth(), height));
                tabbedPane.setSelectedIndex(index);
            }
            this.titleLabel.setText(serverName);
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
            AstorUtil.stopSplash();
        }
        catch (DevFailed e) {
            AstorUtil.stopSplash();
            throw e;
        }
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ServerStatesDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerStatesDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        ScalarViewer.attributeList.stopRefresher();
        ScalarViewer.attributeList.clear();
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (Exception)new Exception("Server name ?"));
                System.exit(0);
            }
            new ServerStatesDialog((JFrame)null, args[0]).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
            System.exit(0);
        }
    }
}

