/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.dev_state_viewer;

import admin.astor.dev_state_viewer.StateCell;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.widget.attribute.StateViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.Color;
import javax.swing.JTable;

class ScalarViewer
extends StateViewer
implements IDevStateScalarListener {
    private StateCell stateCell;
    private JTable table;
    static AttributeList attributeList = new AttributeList();

    ScalarViewer(StateCell stateCell, String attributeName, JTable table) throws DevFailed {
        this.stateCell = stateCell;
        this.table = table;
        try {
            IDevStateScalar stateScalar = (IDevStateScalar)attributeList.add(attributeName);
            this.setModel(stateScalar);
            stateScalar.addDevStateScalarListener((IDevStateScalarListener)this);
        }
        catch (ConnectionException e) {
            Except.throw_exception((String)"ConnectionFailed", (String)e.getDescription());
        }
    }

    public void devStateScalarChange(DevStateScalarEvent devStateScalarEvent) {
        this.stateCell.setStatus(devStateScalarEvent.getValue());
        this.stateCell.setErrorMessage(null);
        if (this.stateCell.getStatus().equals("FAULT") || this.stateCell.getStatus().equals("UNKNOWN")) {
            this.stateCell.setForeground(Color.white);
        } else {
            this.stateCell.setForeground(Color.black);
        }
        this.stateCell.setBackground(ATKConstant.getColor4State((String)this.stateCell.getStatus()));
        if (this.table != null) {
            this.table.repaint();
        }
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.stateCell.setBackground(ATKConstant.getColor4State((String)"UNKNOWN"));
        this.stateCell.setForeground(Color.white);
        this.stateCell.setErrorMessage(errorEvent.getError().getMessage());
    }
}

