/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.AstorUtil;
import admin.astor.access.AccessProxy;
import admin.astor.access.ChooseGroupDialog;
import admin.astor.access.EditDialog;
import admin.astor.access.EditTreeItem;
import admin.astor.access.TangoAccess;
import admin.astor.access.UserGroup;
import admin.astor.access.UsersTreePopupMenu;
import admin.astor.access.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UsersTree
extends JTree
implements TangoConst {
    static final int USER_NODE = -2;
    static final int COLLECTION = -1;
    static final int ADDRESS = 0;
    static final int DEVICE = 1;
    static final String[] collecStr = new String[]{"Allowed Addresses", "Devices"};
    static final int WRITE = 0;
    static final int READ = 1;
    static final String[] rightsStr = new String[]{"write", "read"};
    static ImageIcon tango_icon;
    static ImageIcon all_users_icon;
    static ImageIcon group_icon;
    static ImageIcon user_icon;
    static ImageIcon add_icon;
    static ImageIcon dev_icon;
    static ImageIcon write_icon;
    static ImageIcon read_icon;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;
    private UsersTreePopupMenu menu;
    private JFrame parent;
    private AccessProxy accessProxy;
    List<AccessAddress> copiedAddresses = new ArrayList<AccessAddress>();
    List<AccessDevice> copiedDevices = new ArrayList<AccessDevice>();
    private static final Color background;
    private List<UserGroup> groups = new ArrayList<UserGroup>();
    private boolean manage_expand = true;
    EditTreeItem edit_item;

    public UsersTree(JFrame parent, AccessProxy access_proxy) throws DevFailed {
        this.parent = parent;
        this.accessProxy = access_proxy;
        this.setBackground(background);
        this.buildTree();
        this.menu = new UsersTreePopupMenu(this);
    }

    private void buildTree() throws DevFailed {
        String str_root = "Tango Control Access";
        try {
            str_root = "Access to  " + ApiUtil.get_db_obj().get_tango_host();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        this.root = new DefaultMutableTreeNode(str_root);
        this.createUserNodes();
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                UsersTree.this.expandedPerformed(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UsersTree.this.treeMouseClicked(evt);
            }
        });
    }

    private void treeMouseClicked(MouseEvent evt) {
        if (this.accessProxy.getAccessControl() == 0) {
            return;
        }
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        Object o = node.getUserObject();
        int mask = evt.getModifiers();
        if (evt.getClickCount() == 2 && (mask & 0x10) != 0) {
            if (o instanceof AccessAddress || o instanceof AccessDevice) {
                this.editItem();
            }
        } else if ((mask & 4) != 0) {
            if (node == this.root) {
                this.menu.showMenu(evt, o.toString());
            } else if (o instanceof UserGroup) {
                this.menu.showMenu(evt, o.toString());
            } else if (o instanceof AccessAddress) {
                this.menu.showMenu(evt, 0, o);
            } else if (o instanceof AccessDevice) {
                this.menu.showMenu(evt, 1, o);
            } else if (o instanceof AccessUser) {
                this.menu.showMenu(evt, -2, o);
            } else if (o instanceof String) {
                this.menu.showMenu(evt, -1, o);
            }
        }
    }

    public void expandedPerformed(TreeExpansionEvent evt) {
        if (!this.manage_expand) {
            return;
        }
        TreePath tp = evt.getPath();
        Object[] path = tp.getPath();
        if (path.length < 2) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getPathComponent(path.length - 1);
        if (node.getUserObject() instanceof AccessUser) {
            this.expendUserNode(node.toString());
        } else if (node.toString().equals(collecStr[0])) {
            this.createAddressNodes(node);
        } else if (node.toString().equals(collecStr[1])) {
            this.createDeviceNodes(node);
        }
    }

    private void createDeviceNodes(DefaultMutableTreeNode node) {
        try {
            Object obj = ((DefaultMutableTreeNode)node.getParent()).getUserObject();
            String user = ((AccessUser)obj).getName();
            AccessDevice[] devices = this.getDevices(user);
            for (int i = 0; i < devices.length; ++i) {
                DefaultMutableTreeNode d_node = new DefaultMutableTreeNode(devices[i]);
                this.treeModel.insertNodeInto(d_node, node, i);
            }
            this.removePreviousNode(node, devices.length);
        }
        catch (DevFailed e) {
            this.removePreviousNode(node, 0);
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Cannot read devices", (DevFailed)e);
        }
    }

    private void createAddressNodes(DefaultMutableTreeNode node) {
        try {
            Object obj = ((DefaultMutableTreeNode)node.getParent()).getUserObject();
            String user = ((AccessUser)obj).getName();
            AccessAddress[] addresses = this.getAddresses(user);
            if (!this.createChildNodes(node, addresses)) {
                return;
            }
            for (int i = 0; i < addresses.length; ++i) {
                DefaultMutableTreeNode a_node = new DefaultMutableTreeNode(addresses[i]);
                this.treeModel.insertNodeInto(a_node, node, i);
            }
            this.removePreviousNode(node, addresses.length);
        }
        catch (DevFailed e) {
            this.removePreviousNode(node, 0);
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Cannot read addresses", (DevFailed)e);
        }
    }

    private void createUserNode(String name, DefaultMutableTreeNode groupNode) {
        DefaultMutableTreeNode userNode = new DefaultMutableTreeNode(new AccessUser(name));
        DefaultMutableTreeNode addrNode = new DefaultMutableTreeNode(collecStr[0]);
        DefaultMutableTreeNode dummyNode = new DefaultMutableTreeNode(collecStr[1]);
        addrNode.add(new DefaultMutableTreeNode(new Dummy()));
        dummyNode.add(new DefaultMutableTreeNode(new Dummy()));
        userNode.add(addrNode);
        userNode.add(dummyNode);
        if (groupNode == null) {
            this.root.add(userNode);
        } else {
            groupNode.add(userNode);
        }
    }

    private void createUserNodes() throws DevFailed {
        String[] users = this.accessProxy.getUsers();
        this.buildGroups(users);
        int ratio = 80 / users.length;
        this.createUserNode(users[0], null);
        for (UserGroup group : this.groups) {
            DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(group);
            for (String user : group) {
                AstorUtil.increaseSplashProgress(ratio, "building tree for " + user);
                this.createUserNode(user, groupNode);
            }
            this.root.add(groupNode);
        }
    }

    private void buildGroups(String[] users) {
        this.groups = UserGroup.getUserGroupsFromDatabase(users);
        UserGroup unsorted = new UserGroup("Unsorted Users");
        for (String user : users) {
            boolean found = false;
            if (user.equals("*")) continue;
            for (UserGroup group : this.groups) {
                for (String member : group) {
                    if (!user.equals(member)) continue;
                    found = true;
                }
            }
            if (found) continue;
            unsorted.add(user);
        }
        if (unsorted.size() > 0) {
            unsorted.sortMembers();
            this.groups.add(unsorted);
        }
    }

    private boolean createChildNodes(DefaultMutableTreeNode node, AccessAddress[] address) {
        boolean create = false;
        if (node.getChildCount() != address.length) {
            create = true;
        } else {
            for (int i = 0; i < address.length; ++i) {
                if (node.getChildAt(i).toString().equals(address[i].toString())) continue;
                create = true;
            }
        }
        return create;
    }

    private void removePreviousNode(DefaultMutableTreeNode node, int offset) {
        while (node.getChildCount() > offset) {
            DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)node.getChildAt(offset);
            this.treeModel.removeNodeFromParent(leaf);
        }
    }

    private AccessDevice[] getDevices(String user) throws DevFailed {
        String[] result = this.accessProxy.getDevicesByUser(user);
        AccessDevice[] ret = new AccessDevice[result.length / 2];
        for (int i = 0; i < result.length / 2; ++i) {
            ret[i] = new AccessDevice(result[2 * i], result[2 * i + 1]);
        }
        return ret;
    }

    private AccessAddress[] getAddresses(String user) throws DevFailed {
        String[] result = this.accessProxy.getAddressesByUser(user);
        AccessAddress[] ret = new AccessAddress[result.length];
        for (int i = 0; i < result.length; ++i) {
            ret[i] = new AccessAddress(result[i]);
        }
        return ret;
    }

    DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    private boolean checkUserName(String user) {
        boolean ok = true;
        if (user.length() > 0) {
            StringTokenizer stk = new StringTokenizer(user.toLowerCase());
            StringBuilder sb = new StringBuilder();
            while (stk.hasMoreTokens()) {
                sb.append(stk.nextToken());
            }
            if (sb.toString().equals("allusers")) {
                TangoAccess.popupError(this, user + " is reserved !");
                ok = false;
            }
        } else {
            ok = false;
        }
        if (!user.isEmpty()) {
            if (this.userExists(user)) {
                ok = false;
                this.expendUserNode(user);
                TangoAccess.popupError(this, "User  " + user + "  Already exists !");
            }
        } else {
            ok = false;
        }
        return ok;
    }

    void addUser() {
        String userName = "";
        String address = "";
        String devname = "*/*/*";
        Object obj = this.getSelectedObject();
        UserGroup userGroup = null;
        if (obj instanceof UserGroup) {
            userGroup = (UserGroup)obj;
        }
        boolean ok = false;
        while (!ok) {
            EditDialog dlg = new EditDialog(this.parent, userName, address, this.groups, userGroup);
            if (dlg.showDialog() != 0) {
                return;
            }
            userGroup = dlg.getUserGroup();
            if (userGroup == null) continue;
            String[] str = dlg.getInputs();
            userName = str[0];
            address = str[1];
            ok = this.checkUserName(userName);
        }
        try {
            this.accessProxy.addAddress(userName, address);
            this.accessProxy.addDevice(userName, devname, rightsStr[0]);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
            return;
        }
        DefaultMutableTreeNode groupNode = this.getGroupNode(userGroup.getName());
        if (groupNode == null) {
            this.groups.add(userGroup);
            this.groups.sort(new GroupComparator());
            groupNode = new DefaultMutableTreeNode(userGroup);
            this.treeModel.insertNodeInto(groupNode, this.root, this.root.getChildCount());
        }
        userGroup.add(userName);
        UserGroup.setUserGroupsToDatabase(this, this.groups);
        DefaultMutableTreeNode new_user_node = new DefaultMutableTreeNode(new AccessUser(userName));
        DefaultMutableTreeNode new_str_add_node = new DefaultMutableTreeNode(collecStr[0]);
        DefaultMutableTreeNode new_str_dev_node = new DefaultMutableTreeNode(collecStr[1]);
        DefaultMutableTreeNode new_add_node = new DefaultMutableTreeNode(new AccessAddress(address));
        DefaultMutableTreeNode new_dev_node = new DefaultMutableTreeNode(new AccessDevice(devname, 0));
        this.treeModel.insertNodeInto(new_user_node, groupNode, groupNode.getChildCount());
        this.treeModel.insertNodeInto(new_str_add_node, new_user_node, 0);
        this.treeModel.insertNodeInto(new_str_dev_node, new_user_node, 1);
        this.treeModel.insertNodeInto(new_add_node, new_str_add_node, 0);
        this.treeModel.insertNodeInto(new_dev_node, new_str_dev_node, 0);
        Object[] path = new TreeNode[]{this.root, groupNode, new_user_node, new_str_add_node, new_add_node};
        TreePath tp = new TreePath(path);
        this.setSelectionPath(tp);
        path[3] = new_str_dev_node;
        path[4] = new_dev_node;
        tp = new TreePath(path);
        this.setSelectionPath(tp);
        this.scrollPathToVisible(tp);
    }

    private DefaultMutableTreeNode getGroupNode(String groupName) {
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            if (!this.root.getChildAt(i).toString().equals(groupName)) continue;
            return (DefaultMutableTreeNode)this.root.getChildAt(i);
        }
        return null;
    }

    void addItem() {
        DefaultMutableTreeNode new_node;
        int obj_type;
        DefaultMutableTreeNode node = this.getSelectedNode();
        Object o = node.getUserObject();
        if (o.toString().equals(collecStr[0])) {
            obj_type = 0;
        } else if (o.toString().equals(collecStr[1])) {
            obj_type = 1;
        } else {
            return;
        }
        int i = 0;
        Object[] path = new DefaultMutableTreeNode[5];
        path[i++] = this.root;
        path[i++] = node.getParent().getParent();
        path[i++] = node.getParent();
        path[i++] = node;
        DefaultMutableTreeNode dummy_node = null;
        if (node.getChildCount() > 0) {
            path[i] = node.getChildAt(0);
        } else {
            dummy_node = new DefaultMutableTreeNode(new Dummy());
            this.treeModel.insertNodeInto(dummy_node, node, node.getChildCount());
            path[i] = dummy_node;
            this.manage_expand = false;
        }
        TreePath tp = new TreePath(path);
        this.setSelectionPath(tp);
        this.scrollPathToVisible(tp);
        switch (obj_type) {
            case 0: {
                new_node = new DefaultMutableTreeNode(new AccessAddress("*.*.*.*"));
                this.treeModel.insertNodeInto(new_node, node, node.getChildCount());
                path[i] = new_node;
                tp = new TreePath(path);
                this.setSelectionPath(tp);
                this.scrollPathToVisible(tp);
                break;
            }
            case 1: {
                new_node = new DefaultMutableTreeNode(new AccessDevice("*/*/*", 0));
                this.treeModel.insertNodeInto(new_node, node, node.getChildCount());
                path[i] = new_node;
                tp = new TreePath(path);
                this.setSelectionPath(tp);
                this.scrollPathToVisible(tp);
                break;
            }
            default: {
                return;
            }
        }
        if (dummy_node != null) {
            this.treeModel.removeNodeFromParent(dummy_node);
        }
        this.manage_expand = true;
        if (!this.editItem()) {
            this.treeModel.removeNodeFromParent(new_node);
        }
    }

    boolean editItem() {
        String value;
        int obj_type;
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return true;
        }
        Object o = node.getUserObject();
        if (o instanceof AccessDevice) {
            obj_type = 1;
            value = ((AccessDevice)o).name;
        } else if (o instanceof AccessAddress) {
            obj_type = 0;
            value = ((AccessAddress)o).name;
        } else {
            return false;
        }
        this.edit_item = new EditTreeItem((Frame)this.parent, this, value, obj_type);
        if (this.edit_item.showDlg()) {
            String user = node.getParent().getParent().toString();
            String new_name = this.edit_item.getInputs();
            try {
                switch (obj_type) {
                    case 0: {
                        AccessAddress add = (AccessAddress)o;
                        this.accessProxy.removeAddress(user, add.name);
                        this.accessProxy.addAddress(user, new_name);
                        add.setName(new_name);
                        this.rebuildNode(node, add);
                        break;
                    }
                    case 1: {
                        AccessDevice dev = (AccessDevice)o;
                        this.accessProxy.removeDevice(user, dev.name, rightsStr[dev.right]);
                        this.accessProxy.addDevice(user, new_name, rightsStr[dev.right]);
                        dev.name = new_name;
                        this.rebuildNode(node, dev);
                    }
                }
                return true;
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
            }
        }
        return false;
    }

    private void rebuildNode(DefaultMutableTreeNode node, Object obj) {
        DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
        DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(obj);
        int idx = parent_node.getIndex(node);
        this.treeModel.insertNodeInto(new_node, parent_node, idx);
        this.treeModel.removeNodeFromParent(node);
    }

    private boolean isAllUsersNode(DefaultMutableTreeNode node) {
        Object o = node.getUserObject();
        if (o instanceof AccessUser) {
            String user = ((AccessUser)o).getName();
            return user.equals("*");
        }
        return false;
    }

    private boolean isLastOneForAllUsers(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode collec_node = (DefaultMutableTreeNode)node.getParent();
        DefaultMutableTreeNode user_node = (DefaultMutableTreeNode)collec_node.getParent();
        return this.isAllUsersNode(user_node) && collec_node.getChildCount() == 1;
    }

    void removeItem() {
        int obj_type;
        String message;
        String user;
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Object o = node.getUserObject();
        if (o instanceof AccessDevice) {
            if (this.isLastOneForAllUsers(node)) {
                admin.astor.tools.Utils.popupError(this.parent, "Cannot remove last device for all users");
                return;
            }
            user = node.getParent().getParent().toString();
            message = "Are you sure to want to remove :  " + o;
            obj_type = 1;
        } else if (o instanceof AccessAddress) {
            if (this.isLastOneForAllUsers(node)) {
                admin.astor.tools.Utils.popupError(this.parent, "Cannot remove last address for all users");
                return;
            }
            user = node.getParent().getParent().toString();
            message = "Are you sure to want to remove :  " + o;
            obj_type = 0;
        } else if (o instanceof AccessUser) {
            if (this.isAllUsersNode(node)) {
                admin.astor.tools.Utils.popupError(this.parent, "Cannot remove rights for all users");
                return;
            }
            user = ((AccessUser)o).getName();
            obj_type = -2;
            message = "Are you sure to want to remove all records for " + o;
        } else {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, message, "Confirm Dialog", 0) != 0) {
            return;
        }
        try {
            switch (obj_type) {
                case 0: {
                    AccessAddress add = (AccessAddress)o;
                    this.accessProxy.removeAddress(user, add.name);
                    this.treeModel.removeNodeFromParent(node);
                    break;
                }
                case 1: {
                    AccessDevice dev = (AccessDevice)o;
                    this.accessProxy.removeDevice(user, dev.name, rightsStr[dev.right]);
                    this.treeModel.removeNodeFromParent(node);
                    break;
                }
                case -2: {
                    this.accessProxy.removeUser(user);
                    DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)node.getParent();
                    for (UserGroup userGroup : this.groups) {
                        if (!userGroup.getName().equals(groupNode.toString())) continue;
                        userGroup.remove(user);
                        if (userGroup.isEmpty()) {
                            this.groups.remove(userGroup);
                            this.treeModel.removeNodeFromParent(groupNode);
                        } else {
                            this.treeModel.removeNodeFromParent(node);
                        }
                        UserGroup.setUserGroupsToDatabase(this, this.groups);
                        return;
                    }
                    break;
                }
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
        }
    }

    private String[] getDefinedUsers() {
        ArrayList<String> userList = new ArrayList<String>();
        for (UserGroup group : this.groups) {
            userList.addAll(group);
        }
        return userList.toArray(new String[0]);
    }

    private void expendUserNode(String name) {
        TreePath tp;
        DefaultMutableTreeNode userNode = this.getUserNode(name);
        int depth = userNode.getPath().length;
        Object[] path = new TreeNode[depth + 2];
        int idx = 0;
        path[idx++] = this.root;
        if (depth > 2) {
            path[idx++] = userNode.getParent();
        }
        path[idx++] = userNode;
        DefaultMutableTreeNode addressNode = (DefaultMutableTreeNode)userNode.getChildAt(0);
        if (addressNode.getChildCount() > 0) {
            path[idx] = addressNode;
            path[idx + 1] = addressNode.getChildAt(0);
            TreePath tp2 = new TreePath(path);
            this.setSelectionPath(tp2);
        }
        DefaultMutableTreeNode deviceNode = (DefaultMutableTreeNode)userNode.getChildAt(1);
        if (addressNode.getChildCount() > 0) {
            path[idx] = deviceNode;
            path[idx + 1] = deviceNode.getChildAt(0);
            tp = new TreePath(path);
            this.setSelectionPath(tp);
        }
        path = new TreeNode[depth];
        idx = 0;
        path[idx++] = this.root;
        if (depth > 2) {
            path[idx++] = userNode.getParent();
        }
        path[idx] = userNode;
        tp = new TreePath(path);
        this.setSelectionPath(tp);
    }

    private DefaultMutableTreeNode getUserNode(String name) {
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            Object userObject = node.getUserObject();
            if (userObject.toString().equals(name)) {
                return node;
            }
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode userNode = (DefaultMutableTreeNode)node.getChildAt(j);
                userObject = userNode.getUserObject();
                if (!userObject.toString().equals(name)) continue;
                return userNode;
            }
        }
        return new DefaultMutableTreeNode(name);
    }

    private boolean userExists(String name) {
        String[] users;
        for (String user : users = this.getDefinedUsers()) {
            if (!user.equals(name)) continue;
            return true;
        }
        return false;
    }

    void changeGroup() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)node.getParent();
        Object object = groupNode.getUserObject();
        if (!(object instanceof UserGroup)) {
            return;
        }
        UserGroup srcGroup = (UserGroup)object;
        Object o = node.getUserObject();
        if (o instanceof AccessUser) {
            String user = ((AccessUser)o).getName();
            String title = "Move " + user + " from " + srcGroup + "  to ";
            ChooseGroupDialog dialog = new ChooseGroupDialog(this.parent, title, this.groups);
            if (dialog.showDialog() != 2) {
                UserGroup targetGroup = dialog.getUserGroup();
                if (targetGroup == srcGroup) {
                    return;
                }
                this.treeModel.removeNodeFromParent(node);
                groupNode = this.getGroupNode(targetGroup.getName());
                if (groupNode == null) {
                    groupNode = new DefaultMutableTreeNode(targetGroup);
                    this.treeModel.insertNodeInto(groupNode, this.root, this.root.getChildCount());
                    this.groups.add(targetGroup);
                }
                this.treeModel.insertNodeInto(node, groupNode, groupNode.getChildCount());
                srcGroup.remove(user);
                targetGroup.add(user);
                UserGroup.setUserGroupsToDatabase(this, this.groups);
                Object[] path = new TreeNode[]{this.root, groupNode, node};
                TreePath tp = new TreePath(path);
                this.setSelectionPath(tp);
                tp = new TreePath(path);
                this.setSelectionPath(tp);
                this.scrollPathToVisible(tp);
            }
        }
    }

    void cloneUser() {
        Object o;
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)node.getParent();
        UserGroup userGroup = null;
        Object object = groupNode.getUserObject();
        if (object instanceof UserGroup) {
            userGroup = (UserGroup)object;
        }
        if ((o = node.getUserObject()) instanceof AccessUser) {
            String srcUser = ((AccessUser)o).getName();
            String[] inputs = new String[]{""};
            boolean ok = false;
            while (!ok) {
                EditDialog dlg = new EditDialog(this.parent, "", null, this.groups, userGroup);
                if (dlg.showDialog() != 0) {
                    return;
                }
                inputs = dlg.getInputs();
                ok = this.checkUserName(inputs[0]);
                userGroup = dlg.getUserGroup();
            }
            String newUser = inputs[0];
            groupNode = this.getGroupNode(userGroup.getName());
            if (groupNode == null) {
                groupNode = new DefaultMutableTreeNode(userGroup);
                this.treeModel.insertNodeInto(groupNode, this.root, this.root.getChildCount());
                this.groups.add(userGroup);
                this.groups.sort(new GroupComparator());
            }
            try {
                this.accessProxy.cloneUser(srcUser, newUser);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
                return;
            }
            userGroup.add(newUser);
            DefaultMutableTreeNode u_node = new DefaultMutableTreeNode(new AccessUser(newUser));
            DefaultMutableTreeNode a_node = new DefaultMutableTreeNode(collecStr[0]);
            DefaultMutableTreeNode d_node = new DefaultMutableTreeNode(collecStr[1]);
            this.treeModel.insertNodeInto(a_node, u_node, 0);
            this.treeModel.insertNodeInto(d_node, u_node, 1);
            this.treeModel.insertNodeInto(u_node, groupNode, groupNode.getChildCount());
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(new Dummy()), a_node, 0);
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(new Dummy()), d_node, 0);
            UserGroup.setUserGroupsToDatabase(this, this.groups);
            Object[] path = new DefaultMutableTreeNode[]{this.root, u_node, a_node};
            TreePath tp = new TreePath(path);
            this.setSelectionPath(tp);
            this.scrollPathToVisible(tp);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void pasteItem() {
        int obj_type;
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Object o = node.getUserObject();
        if (!(o instanceof String)) return;
        if (o.toString().equals(collecStr[1])) {
            obj_type = 1;
        } else {
            if (!o.toString().equals(collecStr[0])) return;
            obj_type = 0;
        }
        String user = node.getParent().toString();
        try {
            DefaultMutableTreeNode new_node = null;
            switch (obj_type) {
                case 0: {
                    String address = this.copiedAddresses.get((int)0).name;
                    this.accessProxy.addAddress(user, address);
                    new_node = new DefaultMutableTreeNode(new AccessAddress(address));
                    this.treeModel.insertNodeInto(new_node, node, node.getChildCount());
                    break;
                }
                case 1: {
                    String deviceName = this.copiedDevices.get((int)0).name;
                    int right = this.copiedDevices.get((int)0).right;
                    this.accessProxy.addDevice(user, deviceName, rightsStr[right]);
                    new_node = new DefaultMutableTreeNode(new AccessDevice(deviceName, right));
                    this.treeModel.insertNodeInto(new_node, node, node.getChildCount());
                }
            }
            Object[] path = new DefaultMutableTreeNode[]{this.root, node.getParent(), node, new_node};
            TreePath tp = new TreePath(path);
            this.setSelectionPath(tp);
            this.scrollPathToVisible(tp);
            return;
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
        }
    }

    void copyItem() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Object o = node.getUserObject();
        int obj_type = o instanceof AccessDevice ? 1 : 0;
        switch (obj_type) {
            case 0: {
                this.copiedAddresses.clear();
                this.copiedAddresses.add((AccessAddress)o);
                break;
            }
            case 1: {
                this.copiedDevices.clear();
                this.copiedDevices.add((AccessDevice)o);
            }
        }
    }

    void toggleRight() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Object o = node.getUserObject();
        node = (DefaultMutableTreeNode)node.getParent().getParent();
        Object uo = node.getUserObject();
        String user = ((AccessUser)uo).getName();
        try {
            AccessDevice dev = (AccessDevice)o;
            int new_right = dev.right == 1 ? 0 : 1;
            this.accessProxy.removeDevice(user, dev.name, rightsStr[dev.right]);
            this.accessProxy.addDevice(user, dev.name, rightsStr[new_right]);
            dev.right = new_right;
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
        }
    }

    private List<String> getUserList() {
        ArrayList<String> users = new ArrayList<String>();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            Object obj = childNode.getUserObject();
            if (!(obj instanceof AccessUser)) continue;
            AccessUser user = (AccessUser)obj;
            users.add(user.toString());
        }
        return users;
    }

    public void findUser(String userName) {
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            this.findUser(userName, (DefaultMutableTreeNode)this.root.getChildAt(i));
        }
    }

    public void findUser(String userName, DefaultMutableTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            AccessUser user;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            Object obj = childNode.getUserObject();
            if (!(obj instanceof AccessUser) || !(user = (AccessUser)obj).toString().equals(userName)) continue;
            this.expandChildren(childNode);
        }
    }

    private void expandNode(DefaultMutableTreeNode node) {
        ArrayList<DefaultMutableTreeNode> nodeList = new ArrayList<DefaultMutableTreeNode>();
        nodeList.add(node);
        while (node != this.root) {
            node = (DefaultMutableTreeNode)node.getParent();
            nodeList.add(0, node);
        }
        Object[] tn = nodeList.toArray(new TreeNode[0]);
        TreePath tp = new TreePath(tn);
        this.setSelectionPath(tp);
        this.scrollPathToVisible(tp);
    }

    private void expandChildren(DefaultMutableTreeNode node) {
        boolean level_done = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.isLeaf()) {
                if (level_done) continue;
                this.expandNode(child);
                level_done = true;
                continue;
            }
            this.expandChildren(child);
        }
    }

    static {
        background = Color.WHITE;
    }

    private class GroupComparator
    implements Comparator<UserGroup> {
        private GroupComparator() {
        }

        @Override
        public int compare(UserGroup group1, UserGroup group2) {
            if (group1.getName().equals("Unsorted Users")) {
                return 1;
            }
            if (group2.getName().equals("Unsorted Users")) {
                return -1;
            }
            return group1.getName().compareTo(group2.getName());
        }
    }

    private class Dummy {
        private Dummy() {
        }

        public String toString() {
            return "";
        }
    }

    class AccessDevice {
        String name;
        int right = 1;

        private AccessDevice(String add, String r) {
            this.name = add;
            for (int i = 0; i < rightsStr.length; ++i) {
                if (!rightsStr[i].equals(r)) continue;
                this.right = i;
            }
        }

        private AccessDevice(String add, int r) {
            this.name = add;
            this.right = r;
        }

        public String toString() {
            return this.name;
        }
    }

    class AccessAddress {
        String name;
        private String hostname = null;

        private AccessAddress(String add) {
            this.name = add;
            this.checkHostname(add);
        }

        private void checkHostname(String add) {
            StringTokenizer stk = new StringTokenizer(add, ".");
            ArrayList<String> tokens = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                tokens.add(stk.nextToken());
            }
            byte[] bytes = new byte[4];
            for (int i = 0; i < 4 && i < tokens.size(); ++i) {
                try {
                    bytes[i] = (byte)Integer.parseInt((String)tokens.get(i));
                    continue;
                }
                catch (NumberFormatException e) {
                    this.hostname = null;
                    return;
                }
            }
            try {
                InetAddress inetAddress = InetAddress.getByAddress(bytes);
                this.hostname = inetAddress.getHostName();
                int pos = this.hostname.indexOf(46);
                if (pos > 0) {
                    this.hostname = this.hostname.substring(0, pos);
                }
            }
            catch (Exception e) {
                this.hostname = null;
            }
        }

        private void setName(String add) {
            this.name = add;
            this.checkHostname(add);
        }

        public String toString() {
            if (this.hostname == null) {
                return this.name;
            }
            return this.name + "  (" + this.hostname + ")";
        }
    }

    class AccessUser {
        private String name;

        private AccessUser(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name.equals("*") ? "All Users" : this.name;
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private final int TITLE = 0;
        private final int ALL_USERS = 1;
        private final int USER = 2;
        private final int COLLEC = 3;
        private final int LEAF = 4;

        public TangoRenderer() {
            Utils utils = Utils.getInstance();
            tango_icon = utils.getIcon("TangoClass.png", 0.33);
            all_users_icon = utils.getIcon("user.gif", 1.0);
            group_icon = utils.getIcon("user.gif", 0.8);
            user_icon = utils.getIcon("user.gif", 0.6);
            add_icon = utils.getIcon("server.gif");
            dev_icon = utils.getIcon("device.gif");
            write_icon = utils.getIcon("greenbal.gif");
            read_icon = utils.getIcon("redball.gif");
            this.fonts = new Font[5];
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 16);
            this.fonts[2] = new Font("Dialog", 1, 12);
            this.fonts[3] = new Font("Dialog", 1, 12);
            this.fonts[4] = new Font("Monospaced", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (row == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(tango_icon);
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                if (node.getUserObject() instanceof UserGroup) {
                    UserGroup group = (UserGroup)node.getUserObject();
                    this.setFont(group.getFont());
                    this.setIcon(group_icon);
                } else if (node.getUserObject() instanceof AccessUser) {
                    String user = ((AccessUser)node.getUserObject()).getName();
                    if (user.equals("*")) {
                        this.setFont(this.fonts[1]);
                        this.setIcon(all_users_icon);
                    } else {
                        this.setFont(this.fonts[2]);
                        this.setIcon(user_icon);
                    }
                } else if (node.getUserObject() instanceof String) {
                    this.setFont(this.fonts[3]);
                    if (obj.toString().equals(collecStr[0])) {
                        this.setIcon(add_icon);
                    } else {
                        this.setIcon(dev_icon);
                    }
                } else if (node.getUserObject() instanceof AccessAddress) {
                    this.setFont(this.fonts[4]);
                    this.setIcon(add_icon);
                } else if (node.getUserObject() instanceof AccessDevice) {
                    this.setFont(this.fonts[4]);
                    AccessDevice dev = (AccessDevice)node.getUserObject();
                    if (dev.right == 0) {
                        this.setIcon(write_icon);
                    } else {
                        this.setIcon(read_icon);
                    }
                }
            }
            return this;
        }
    }
}

