/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;

class UserGroup
extends ArrayList<String> {
    private String name;
    private static final Font font = new Font("Dialog", 1, 16);
    public static final String unsorted = "Unsorted Users";

    public UserGroup(String name) {
        this.name = name;
    }

    public UserGroup(String name, String grpNames, String[] users) {
        this.name = name;
        StringTokenizer stk = new StringTokenizer(grpNames, ",");
        while (stk.hasMoreTokens()) {
            String member = stk.nextToken().trim();
            for (String user : users) {
                if (!member.equals(user)) continue;
                this.add(member);
            }
        }
        this.sortMembers();
    }

    public Font getFont() {
        return font;
    }

    public void sortMembers() {
        this.sort(new UserComparator());
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public static void setUserGroupsToDatabase(Component component, List<UserGroup> groups) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (UserGroup group : groups) {
            if (group.size() <= 0 || group.getName().equals(unsorted)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(group.getName()).append(':');
            for (int i = 0; i < group.size(); ++i) {
                sb.append((String)group.get(i));
                if (i >= group.size() - 1) continue;
                sb.append(',');
            }
            arrayList.add(sb.toString());
        }
        if (arrayList.isEmpty()) {
            return;
        }
        String[] array = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            array[i] = (String)arrayList.get(i);
        }
        try {
            DbDatum datum = new DbDatum("UserGroups");
            datum.insert(array);
            ApiUtil.get_db_obj().put_property("CtrlSystem", new DbDatum[]{datum});
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)component, null, (DevFailed)e);
        }
    }

    public static List<UserGroup> getUserGroupsFromDatabase(String[] users) {
        ArrayList<UserGroup> groups = new ArrayList<UserGroup>();
        try {
            DbDatum datum = ApiUtil.get_db_obj().get_property("CtrlSystem", "UserGroups");
            if (!datum.is_empty()) {
                String[] lines;
                for (String line : lines = datum.extractStringArray()) {
                    String grpNames;
                    String grpName;
                    UserGroup group;
                    StringTokenizer stk = new StringTokenizer(line, ":");
                    if (stk.countTokens() != 2) {
                        Except.throw_exception((String)"BadSyntax", (String)("Bad syntax property in '" + line + "'"), (String)"UserTree.getUserGroupsFromDatabase()");
                    }
                    if ((group = new UserGroup(grpName = stk.nextToken().trim(), grpNames = stk.nextToken().trim(), users)).size() <= 0) continue;
                    groups.add(group);
                }
            }
        }
        catch (DevFailed e) {
            System.err.println(e.errors[0].desc);
        }
        return groups;
    }

    private class UserComparator
    implements Comparator<String> {
        private UserComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    }
}

