/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.tools.Utils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class EditTreeItem
extends JDialog {
    private JTextField theText;
    private boolean ret_code;
    private int obj_type;
    private static final int TXT_OFFSET = 20;
    private static boolean keep_deco = false;

    public EditTreeItem(Frame parent, JTree tree, String value, int obj_type) {
        super(parent, true);
        this.obj_type = obj_type;
        this.getContentPane().setLayout(null);
        this.theText = new JTextField();
        String version = System.getProperty("java.version");
        if (version != null) {
            keep_deco = version.startsWith("1.5");
        }
        this.theText.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                EditTreeItem.this.keyReleasedListener(e);
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        Rectangle bounds = this.computeBounds(tree);
        this.getContentPane().add(this.theText);
        this.theText.setBounds(0, 0, (int)bounds.getWidth(), (int)bounds.getHeight());
        this.theText.setText(value);
        this.theText.setBorder(BorderFactory.createLineBorder(Color.black));
        this.theText.setFont(new Font("Monospaced", 0, 12));
        this.theText.selectAll();
        this.setBounds(bounds);
        if (!keep_deco) {
            this.setUndecorated(true);
        }
        this.ret_code = false;
    }

    public void keyReleasedListener(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.checkInputs()) {
            this.ret_code = true;
            this.closeDlg();
        }
        if (e.getKeyCode() == 27) {
            this.ret_code = false;
            this.closeDlg();
        }
    }

    private boolean checkInputs() {
        switch (this.obj_type) {
            case 0: {
                return this.checkAddress();
            }
            case 1: {
                return this.checkDevice();
            }
        }
        return false;
    }

    private boolean checkDevice() {
        String dev = this.theText.getText().trim().toLowerCase();
        this.theText.setText(dev);
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(dev, "/");
        while (stk.hasMoreTokens()) {
            tokens.add(stk.nextToken());
        }
        if (tokens.size() > 3) {
            Utils.popupError(this, "Incorrect device name  (too many members)");
            return false;
        }
        if (tokens.size() < 3) {
            Utils.popupError(this, "Incorrect device name  (not enough members)");
            return false;
        }
        return true;
    }

    private boolean checkAddress() {
        String add = this.theText.getText().trim();
        this.theText.setText(add);
        try {
            InetAddress iadd = InetAddress.getByName(add);
            add = iadd.getHostAddress();
            this.theText.setText(add);
        }
        catch (Exception iadd) {
            // empty catch block
        }
        StringTokenizer stk = new StringTokenizer(add, ".");
        ArrayList<String> tokens = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            tokens.add(stk.nextToken());
        }
        if (tokens.size() > 4) {
            Utils.popupError(this, "Incorrect IP address  (Too many members)");
            return false;
        }
        if (tokens.size() < 4) {
            Utils.popupError(this, "Incorrect IP address  (not enougth members)");
            return false;
        }
        add = (String)tokens.get(0) + "." + (String)tokens.get(1) + "." + (String)tokens.get(2) + "." + (String)tokens.get(3);
        this.theText.setText(add);
        for (int i = 0; i < tokens.size(); ++i) {
            try {
                Short.parseShort((String)tokens.get(i));
                continue;
            }
            catch (NumberFormatException e) {
                if (((String)tokens.get(i)).equals("*")) continue;
                Utils.popupError(this, "Incorrect IP address  (member #" + (i + 1) + " (" + (String)tokens.get(i) + ") is not a number)");
                return false;
            }
        }
        return true;
    }

    private void closeDlg() {
        this.setVisible(false);
    }

    public boolean showDlg() {
        this.setVisible(true);
        return this.ret_code;
    }

    public String getInputs() {
        return this.theText.getText();
    }

    private Rectangle computeBounds(JTree tree) {
        TreePath selPath = tree.getSelectionPath();
        tree.scrollPathToVisible(selPath);
        Rectangle r = tree.getPathBounds(selPath);
        if (r != null) {
            Point p = r.getLocation();
            SwingUtilities.convertPointToScreen(p, tree);
            r.setLocation(p);
            r.width = 250;
            r.height += 2;
            r.x += 20;
        }
        return r;
    }
}

