/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.access.AccessProxy;
import admin.astor.access.AllowedCmdTreePopupMenu;
import admin.astor.access.ClassAllowed;
import admin.astor.access.ListSelectionDialog;
import admin.astor.access.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class AllowedCmdTree
extends JTree
implements TangoConst {
    static ImageIcon tango_icon;
    static ImageIcon class_icon;
    static ImageIcon cmd_icon;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;
    private AllowedCmdTreePopupMenu menu;
    private JFrame parent;
    private AccessProxy access_dev;
    private static final Color background;

    public AllowedCmdTree(JFrame parent, AccessProxy access_dev) throws DevFailed {
        this.parent = parent;
        this.access_dev = access_dev;
        this.setBackground(background);
        this.buildTree();
        this.menu = new AllowedCmdTreePopupMenu(this);
    }

    private void buildTree() throws DevFailed {
        String str_root = "Tango Control Access";
        try {
            str_root = "Access to  " + ApiUtil.get_db_obj().get_tango_host();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        this.root = new DefaultMutableTreeNode(str_root);
        this.createClassNodes();
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AllowedCmdTree.this.treeMouseClicked(evt);
            }
        });
    }

    private void treeMouseClicked(MouseEvent evt) {
        if (this.access_dev.getAccessControl() == 0) {
            return;
        }
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        Object o = node.getUserObject();
        int mask = evt.getModifiers();
        if ((mask & 4) != 0) {
            if (node == this.root) {
                this.menu.showMenu(evt, (String)o);
            } else if (o instanceof String) {
                String parent_name = node.getParent().toString();
                String cmd = (String)o;
                if (!cmd.toLowerCase().equals("state") && !cmd.toLowerCase().equals("status")) {
                    this.menu.showMenu(evt, parent_name, cmd);
                }
            } else {
                this.menu.showMenu(evt, (ClassAllowed)o);
            }
        }
    }

    private void createClassNodes() throws DevFailed {
        try {
            String[] classlist;
            DeviceData argout = this.access_dev.command_inout("GetAllowedCommandClassList");
            for (String classname : classlist = argout.extractStringArray()) {
                DeviceData argin = new DeviceData();
                argin.insert(classname);
                argout = this.access_dev.command_inout("GetAllowedCommands", argin);
                ClassAllowed cmd_class = new ClassAllowed(classname, argout.extractStringArray());
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(cmd_class);
                this.root.add(node);
                for (Object obj : cmd_class) {
                    node.add(new DefaultMutableTreeNode(obj));
                }
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    private String[] getDefinedClasses() {
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            stringList.add(this.root.getChildAt(i).toString());
        }
        return stringList.toArray(new String[stringList.size()]);
    }

    void addClass() {
        try {
            ListSelectionDialog dialog = new ListSelectionDialog(this.parent, this.getDefinedClasses());
            if (dialog.showDialog() == 0) {
                ClassAllowed class_allowed = new ClassAllowed(dialog.getSelection());
                DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(class_allowed);
                this.treeModel.insertNodeInto(new_node, this.root, this.root.getChildCount());
                for (Object cmd : class_allowed) {
                    this.treeModel.insertNodeInto(new DefaultMutableTreeNode(cmd), new_node, new_node.getChildCount());
                }
                Object[] tn = new DefaultMutableTreeNode[]{this.root, new_node, new_node.getChildAt(0)};
                TreePath tp = new TreePath(tn);
                this.setSelectionPath(tp);
                this.scrollPathToVisible(tp);
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    void addCommand() {
        Object o = this.getSelectedObject();
        if (o instanceof ClassAllowed) {
            ClassAllowed cmd_class = null;
            String new_cmd = null;
            boolean added = false;
            try {
                cmd_class = (ClassAllowed)o;
                ListSelectionDialog dialog = new ListSelectionDialog(this.parent, cmd_class);
                if (dialog.showDialog() == 0) {
                    new_cmd = dialog.getSelection();
                    cmd_class.add(new_cmd);
                    added = true;
                    this.access_dev.addAllowedCommand(cmd_class);
                    DefaultMutableTreeNode node = this.getSelectedNode();
                    DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(new_cmd);
                    this.treeModel.insertNodeInto(new_node, node, node.getChildCount());
                    Object[] tn = new DefaultMutableTreeNode[]{this.root, node, new_node};
                    TreePath tp = new TreePath(tn);
                    this.setSelectionPath(tp);
                    this.scrollPathToVisible(tp);
                }
            }
            catch (DevFailed e) {
                if (added) {
                    cmd_class.remove(new_cmd);
                }
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
    }

    void removeCommand() {
        Object o = this.getSelectedObject();
        if (o instanceof String) {
            String cmd = (String)o;
            DefaultMutableTreeNode node = this.getSelectedNode();
            DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
            if (parent_node.getUserObject() instanceof ClassAllowed) {
                ClassAllowed cmd_class = (ClassAllowed)parent_node.getUserObject();
                if (JOptionPane.showConfirmDialog(this, "Are you sure to want to remove " + cmd + "  for class " + cmd_class, "Confirm Dialog", 0) != 0) {
                    return;
                }
                try {
                    cmd_class.remove(cmd);
                    this.access_dev.addAllowedCommand(cmd_class);
                    this.treeModel.removeNodeFromParent(node);
                }
                catch (DevFailed e) {
                    ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
                }
            }
        }
    }

    static {
        background = Color.WHITE;
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private final int TITLE = 0;
        private final int CLASS = 1;
        private final int COMMAND = 2;

        public TangoRenderer() {
            Utils utils = Utils.getInstance();
            tango_icon = utils.getIcon("TangoClass.png", 0.33);
            class_icon = utils.getIcon("TangoClass.png", 0.125);
            cmd_icon = utils.getIcon("attleaf.gif");
            this.fonts = new Font[3];
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 12);
            this.fonts[2] = new Font("Dialog", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (row == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(tango_icon);
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                if (node.getUserObject() instanceof ClassAllowed) {
                    this.setFont(this.fonts[1]);
                    this.setIcon(class_icon);
                } else {
                    this.setFont(this.fonts[2]);
                    this.setIcon(cmd_icon);
                }
            }
            return this;
        }
    }
}

