/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.PutServerInfoDialog;
import admin.astor.ServArchitectureDialog;
import admin.astor.TangoHost;
import admin.astor.tools.BlackBoxTable;
import admin.astor.tools.DbServerArchitecture;
import admin.astor.tools.DeviceSelection;
import admin.astor.tools.PoolThreadsManager;
import admin.astor.tools.PopupHtml;
import admin.astor.tools.PopupText;
import admin.astor.tools.ServerStatePanel;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jive.DevWizard;
import jive3.MainPanel;

public class TangoServer
extends DeviceProxy
implements AstorDefs,
TangoConst {
    private String name;
    private DbServer dbServer = null;
    private String deviceName;
    private DevState state;
    private int nbInstances = 1;
    public DbServInfo info;
    public JLabel label;
    public boolean controlled = false;
    public int startup_level = 0;
    private static final long RestartTimeout = 10000L;
    private MainPanel jive3 = null;
    private JDialog stateDialog;
    private ServerStatePanel statePanel;
    private PoolThreadsManager pool_thread_man = null;

    public TangoServer(String name, DevState state) throws DevFailed {
        super("dserver/" + name);
        this.set_transparency_reconnection(true);
        this.name = name;
        this.deviceName = this.get_name();
        this.state = state;
    }

    public TangoServer(String name) throws DevFailed {
        super(name);
        this.set_transparency_reconnection(true);
        this.name = name;
        this.deviceName = this.get_name();
        this.state = DevState.ON;
    }

    void putStartupInfo(DbServInfo si) throws DevFailed {
        if (this.dbServer == null) {
            this.dbServer = new DbServer(this.name);
        }
        this.info = si;
        this.dbServer.put_info(this.info);
    }

    private void updateStartupInfo() throws DevFailed {
        if (this.dbServer == null) {
            this.dbServer = new DbServer(this.name);
        }
        this.info = this.dbServer.get_info();
    }

    public void setState(DevState state) {
        this.state = state;
    }

    public DevState getState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    public int getNbInstances() {
        return this.nbInstances;
    }

    public void setNbInstances(int nbInstances) {
        this.nbInstances = nbInstances;
    }

    public String[] queryClass() throws DevFailed {
        DeviceData argOut = this.command_inout("QueryClass");
        return argOut.extractStringArray();
    }

    public DbDevImportInfo getImportInfo() throws DevFailed {
        return this.import_device();
    }

    public String[] queryDeviceFromDb() throws DevFailed {
        String[] classList;
        if (this.dbServer == null) {
            String serverName = this.name.substring(this.name.indexOf(47) + 1);
            this.dbServer = new DbServer(serverName);
        }
        ArrayList<String> v = new ArrayList<String>();
        for (String class_ : classList = this.dbServer.get_class_list()) {
            String[] deviceNames = this.dbServer.get_device_name(class_);
            v.addAll(Arrays.asList(deviceNames));
        }
        String[] deviceNames = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            deviceNames[i] = (String)v.get(i);
        }
        return deviceNames;
    }

    String[] queryDevice() throws DevFailed {
        return this.queryDevice(false);
    }

    private String[] queryDevice(boolean withDServer) throws DevFailed {
        DeviceData argOut;
        try {
            argOut = this.command_inout("QueryDevice");
        }
        catch (DevFailed e) {
            if (!e.errors[0].reason.equals("API_CommandNotFound")) {
                throw e;
            }
            argOut = this.command_inout("DevQueryDevice");
        }
        String separator = "::";
        String[] tmp = argOut.extractStringArray();
        String[] devices = new String[withDServer ? tmp.length + 1 : tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            int start = tmp[i].indexOf(separator);
            devices[i] = start > 0 ? tmp[i].substring(start + separator.length()) : tmp[i];
        }
        if (withDServer) {
            devices[devices.length - 1] = this.deviceName;
        }
        return devices;
    }

    public String toString() {
        return this.name;
    }

    boolean startupLevel(JDialog parent, String hostname, Point p) {
        boolean modified = false;
        try {
            PutServerInfoDialog dialog = new PutServerInfoDialog(parent, true);
            dialog.setLocation(p);
            this.updateStartupInfo();
            if (dialog.showDialog(this.info) == 0) {
                this.info = dialog.getSelection();
                if (this.info != null) {
                    this.info.host = hostname;
                    if (this.info.startup_level == 0) {
                        this.info.controlled = false;
                    }
                    this.putStartupInfo(this.info);
                } else {
                    if (this.state == DevState.ON) {
                        Utils.popupMessage(parent, "Stop " + this.name + "  Server before !");
                        return false;
                    }
                    this.putStartupInfo(new DbServInfo(this.name, hostname, false, 0));
                    if (this.dbServer == null) {
                        this.dbServer = new DbServer(this.name);
                    }
                    String[] deviceName = this.dbServer.get_device_class_list();
                    for (int i = 0; i < deviceName.length; i += 2) {
                        ApiUtil.get_db_obj().export_device(new DbDevExportInfo(deviceName[i], "", "", ""));
                        ApiUtil.get_db_obj().unexport_device(deviceName[i]);
                    }
                }
                modified = true;
            }
        }
        catch (DevFailed e) {
            e.printStackTrace();
            ErrorPane.showErrorMessage((Component)parent, null, (DevFailed)e);
        }
        return modified;
    }

    DbServInfo getStartupLevel(JDialog parent, Point p) {
        try {
            PutServerInfoDialog dialog = new PutServerInfoDialog(parent, true, false);
            dialog.setLocation(p);
            this.updateStartupInfo();
            if (dialog.showDialog(this.info) == 0) {
                this.info = dialog.getSelection();
                if (this.info != null && this.info.startup_level == 0) {
                    this.info.controlled = false;
                }
                return this.info;
            }
        }
        catch (DevFailed e) {
            e.printStackTrace();
            ErrorPane.showErrorMessage((Component)parent, null, (DevFailed)e);
        }
        return null;
    }

    private String chooseDevice(Component parent) throws DevFailed {
        return this.chooseDevice(parent, false);
    }

    private String chooseDevice(Component parent, boolean withDServer) throws DevFailed {
        Object[] classDeviceNames = DeviceSelection.getClassDevices(this.name);
        String selectedDevice = null;
        switch (classDeviceNames.length) {
            case 0: {
                Except.throw_exception((String)"NO_DEVICE_REGISTERED", (String)"No device registered for this server");
                break;
            }
            case 1: {
                selectedDevice = classDeviceNames[0];
                int idx = selectedDevice.indexOf("::");
                if (idx <= 0) break;
                selectedDevice = selectedDevice.substring(idx + 2);
                break;
            }
            default: {
                if (classDeviceNames[0].contains("::")) {
                    DeviceSelection dialog = parent instanceof JFrame ? new DeviceSelection((JFrame)parent, this.name, (String[])classDeviceNames, withDServer) : (parent instanceof JDialog ? new DeviceSelection((JDialog)parent, this.name, (String[])classDeviceNames, withDServer) : new DeviceSelection(new JFrame(), this.name, (String[])classDeviceNames, withDServer));
                    selectedDevice = dialog.showDialog();
                    break;
                }
                selectedDevice = (String)JOptionPane.showInputDialog(parent, "Device selection :", "", 1, null, classDeviceNames, classDeviceNames[0]);
            }
        }
        return selectedDevice;
    }

    void displayBlackBox(Component parent) {
        try {
            String choice = this.chooseDevice(parent, true);
            if (choice == null) {
                return;
            }
            BlackBoxTable bb = parent instanceof JFrame ? new BlackBoxTable((JFrame)parent, choice) : new BlackBoxTable((JDialog)parent, choice);
            bb.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, null, (DevFailed)e);
        }
    }

    void testDevice(Component parent) {
        try {
            String choice = this.chooseDevice(parent);
            if (choice == null) {
                return;
            }
            AstorUtil.testDevice(parent, choice);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, null, (DevFailed)e);
        }
    }

    void showJive(JFrame jFrame) {
        if (jFrame instanceof Astor) {
            ((Astor)jFrame).tree.showJive(this);
        } else {
            if (this.jive3 == null) {
                boolean readOnly = AstorUtil.getInstance().jiveIsReadOnly();
                this.jive3 = new MainPanel(false, readOnly);
            }
            this.jive3.setVisible(true);
            this.jive3.toFront();
            this.jive3.goToServerNode(this.getName());
        }
    }

    String getServerInfo(Component parent, boolean ds_present) {
        StringBuilder sb = new StringBuilder("------------ Server Info ------------\n\n");
        try {
            sb.append(this.get_info().toString());
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, null, (DevFailed)e);
            return "";
        }
        if (ds_present) {
            try {
                String[] devices = this.queryDevice();
                sb.append("\n\n----------- Device(s) Served -----------\n\n");
                for (String devname : devices) {
                    sb.append(devname).append("\n");
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    void configureWithWizard(JDialog parent) {
        DevWizard wdlg = new DevWizard((Dialog)parent);
        wdlg.showClassesWizard(this.name);
    }

    void manageMemorizedAttributes(JDialog parent) {
        try {
            new DbServerArchitecture(parent, this.name).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, null, (DevFailed)e);
        }
    }

    private boolean displayArchitecture(JDialog parent) {
        try {
            ServArchitectureDialog dialog = new ServArchitectureDialog(parent, this);
            AstorUtil.centerDialog((JDialog)dialog, parent);
            dialog.setVisible(true);
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("API_CommandNotFound")) {
                return false;
            }
            ErrorPane.showErrorMessage((Component)parent, null, (DevFailed)e);
        }
        return true;
    }

    String[] getServerUptime() throws DevFailed {
        int end;
        String[] retStr = new String[]{};
        String servinfo = this.get_info().toString();
        int start = servinfo.indexOf("last_exported:");
        if (start > 0 && (end = servinfo.indexOf("\n", start += "last_exported:".length())) > 0) {
            retStr = new String[]{servinfo.substring(start, end).trim(), (start = servinfo.indexOf(":", end)) > 0 ? servinfo.substring(start + 1).trim() : "???"};
        }
        return retStr;
    }

    void displayServerInfo(JDialog parent) {
        String servinfo;
        boolean done = false;
        if (this.state == DevState.ON) {
            done = this.displayArchitecture(parent);
        }
        if (!done && (servinfo = this.getServerInfo(parent, this.state == DevState.ON)).length() > 0) {
            Utils.popupMessage(parent, servinfo);
        }
    }

    void displayClassInfo(JFrame parent) {
        try {
            FileOutputStream fidout;
            if (this.dbServer == null) {
                this.dbServer = new DbServer(this.name);
            }
            String[] classes = this.dbServer.get_class_list();
            StringBuilder sb = new StringBuilder("<FONT SIZE=+2>Tango Device Server " + this.name + " : </font>\n\n");
            sb.append("<ul>\n");
            for (String classname : classes) {
                sb.append("<li> <b> Class ").append(classname).append(":</b>\n");
                sb.append("<ul>\n");
                String[] prop = AstorUtil.getServerClassProperties(classname);
                if (prop[2].equals("Doc location unknown....")) {
                    sb.append("Doc location unknown....<Br><Br>\n");
                } else {
                    sb.append("<a href=\"").append(prop[2]).append("\">\n\t");
                    sb.append(prop[2]).append("</a>\n<Br><Br>\n");
                }
                if (prop[0] != null) {
                    sb.append(prop[0]).append("<Br>\n");
                }
                if (prop[1] != null) {
                    sb.append(prop[1]).append("<Br>\n");
                }
                sb.append("</ul>\n<Br><Br>");
            }
            sb.append("</ul>\n");
            int random_value = new Random().nextInt(30000);
            String filename = "/tmp/astor." + random_value;
            try {
                fidout = new FileOutputStream(filename);
            }
            catch (FileNotFoundException e) {
                filename = "c:/temp/astor." + random_value;
                fidout = new FileOutputStream(filename);
            }
            fidout.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#FF0000\" ALINK=\"#FF0000\">\n\n<table width=\"100%\" height=\"20%\"><tr>\n<td align=CENTER>\n<FONT COLOR=\"#0000FF\"><FONT SIZE=+4>E</FONT></FONT><FONT SIZE=+1>UROPEAN</FONT>\n<FONT COLOR=\"#0000FF\"><FONT SIZE=+4>S</FONT></FONT><FONT SIZE=+1>YNCHROTRON</FONT>\n<FONT COLOR=\"#0000FF\"><FONT SIZE=+4>R</FONT></FONT><FONT SIZE=+1>ADIATION</FONT>\n<FONT COLOR=\"#0000FF\"><FONT SIZE=+4>F</FONT></FONT><FONT SIZE=+1>ACILITY</FONT>\n</td><td>\n<IMG SRC=\"http://www.esrf.fr/gifs/logo/80.gif\">\n</td></tr></table>\n<P><Br>\n".getBytes());
            fidout.write(sb.toString().getBytes());
            fidout.write("\n</Body>\n</Html>\n".getBytes());
            fidout.close();
            String urlstr = "file:" + filename;
            new PopupHtml(parent, true).show(urlstr);
            if (!new File(filename).delete()) {
                System.err.println("Failed to delete " + filename);
            }
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)parent, null, (Exception)e);
            e.printStackTrace();
        }
    }

    private String indent(String s) {
        int end;
        StringBuilder sb = new StringBuilder();
        String tab = "        ";
        int start = 0;
        while ((end = s.indexOf("\n", start)) >= 0) {
            if (start > 0) {
                sb.append("\n");
            }
            sb.append(tab).append(s.substring(start, end));
            start = end + 1;
        }
        if (start > 0) {
            sb.append("\n");
        }
        sb.append(tab).append(s.substring(start));
        if (sb.toString().endsWith("\n")) {
            sb = new StringBuilder(sb.substring(0, sb.length() - 2));
        }
        return sb.toString();
    }

    void checkStates(JDialog parent) {
        try {
            Splash splash = new Splash();
            splash.setTitle("Forking State Panel");
            splash.setMessage("Starting");
            splash.setVisible(true);
            splash.progress(10);
            this.statePanel = new ServerStatePanel(this.name);
            splash.progress(30);
            this.stateDialog = new JDialog((Dialog)parent, false);
            this.stateDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    TangoServer.this.statePanel.stopRefresher();
                    TangoServer.this.stateDialog.setVisible(false);
                    TangoServer.this.stateDialog.dispose();
                }
            });
            JButton dismissBtn = new JButton("Dismiss");
            dismissBtn.addActionListener(evt -> {
                this.statePanel.stopRefresher();
                this.stateDialog.setVisible(false);
                this.stateDialog.dispose();
            });
            JPanel panel2 = new JPanel();
            panel2.add(dismissBtn);
            this.stateDialog.getContentPane().add((Component)panel2, "South");
            splash.progress(50);
            this.stateDialog.getContentPane().add((Component)this.statePanel, "Center");
            this.stateDialog.pack();
            AstorUtil.cascadeDialog(this.stateDialog, parent);
            this.stateDialog.setVisible(true);
            splash.setVisible(false);
            return;
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, null, (DevFailed)e);
            return;
        }
        catch (NoClassDefFoundError e) {
            System.out.println(e.toString());
            try {
                StringBuilder sb = new StringBuilder();
                String[] _devices = this.queryDevice();
                String[] devices = new String[_devices.length + 1];
                devices[0] = this.deviceName;
                System.arraycopy(_devices, 0, devices, 1, _devices.length);
                DevState[] states = new DevState[devices.length];
                for (int i = 0; i < devices.length; ++i) {
                    DeviceProxy d = new DeviceProxy(devices[i]);
                    states[i] = d.state();
                    sb.append(devices[i]).append(":    ");
                    sb.append(ApiUtil.stateName((DevState)states[i])).append("\n");
                    if (states[i] != DevState.FAULT && states[i] != DevState.ALARM && states[i] != DevState.UNKNOWN) continue;
                    sb.append(this.indent(d.status())).append("\n\n");
                }
                int nb_lines = 0;
                for (int i = 0; i < sb.length(); ++i) {
                    if (sb.charAt(i) != '\n') continue;
                    ++nb_lines;
                }
                if (nb_lines <= 40) {
                    Utils.popupMessage(parent, sb.toString());
                } else {
                    new PopupText(parent, true).show(sb.toString());
                }
            }
            catch (DevFailed e2) {
                ErrorPane.showErrorMessage((Component)parent, null, (DevFailed)e2);
            }
            return;
        }
    }

    public void restart(Component parent, TangoHost host, boolean check_stop) {
        String message = check_stop ? "Are you sure to" : "Do you";
        if (JOptionPane.showConfirmDialog(parent, message = message + " want to restart " + this.getName(), "Confirm Dialog", 0) == 0) {
            new restartThread(parent, host, check_stop).start();
        }
    }

    void poolThreadManager(JDialog parent, TangoHost host) {
        try {
            if (this.pool_thread_man == null) {
                this.pool_thread_man = new PoolThreadsManager(parent, host, this);
            } else {
                this.pool_thread_man.initializeTree();
            }
            this.pool_thread_man.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, null, (DevFailed)e);
        }
    }

    private class restartThread
    extends Thread {
        private TangoHost host;
        private Component parent;
        private boolean check_stop;

        restartThread(Component parent, TangoHost host, boolean check_stop) {
            this.host = host;
            this.parent = parent;
            this.check_stop = check_stop;
        }

        @Override
        public void run() {
            try {
                long t0;
                block8: {
                    try {
                        this.host.stopServer(TangoServer.this.name);
                    }
                    catch (DevFailed e) {
                        if (!this.check_stop) break block8;
                        throw e;
                    }
                }
                long t1 = t0 = System.currentTimeMillis();
                while ((TangoServer.this.state == DevState.ON || TangoServer.this.state == DevState.MOVING) && t1 - t0 < 10000L) {
                    this.host.updateData();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    t1 = System.currentTimeMillis();
                }
                if (TangoServer.this.state == DevState.ON) {
                    Except.throw_exception((String)"STOP_TIMOUT", (String)("Stopping dbServer " + TangoServer.this.name + " timeout\nmay be, it cannot be stopped."), (String)"TangoServer.restartThread.run()");
                }
                this.host.startServer(this.parent, TangoServer.this.name);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
            }
        }
    }
}

