/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.HostInfoDialog;
import admin.astor.HostList;
import admin.astor.TangoServer;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jive.DevWizard;

public class ListDialog
extends JDialog {
    private static String str_filter = "*";
    private static String previousItem = null;
    private HostInfoDialog hostInfoDialog;
    private List<String> selectedItems = null;
    private JPanel filterPanel;
    private JTextField filterTxt;
    private JList<String> jList;
    private JLabel titleLabel;

    public ListDialog(HostInfoDialog hostInfoDialog) {
        super((Dialog)hostInfoDialog, true);
        this.hostInfoDialog = hostInfoDialog;
        this.initComponents();
        this.filterTxt.setText(str_filter);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ListDialog.this.listSelectionPerformed(e);
            }
        };
        this.jList.addMouseListener(mouseListener);
        this.pack();
    }

    private void setList() throws DevFailed {
        str_filter = this.filterTxt.getText();
        String[] serverList = ApiUtil.get_db_obj().get_server_list(str_filter);
        this.jList.setListData((String[])serverList);
        for (int i = 0; i < serverList.length; ++i) {
            if (!serverList[i].equals(previousItem)) continue;
            this.jList.setSelectedIndex(i);
        }
    }

    private void initComponents() {
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jList = new JList();
        JPanel bottomPanel = new JPanel();
        JButton fromAnotherCrateBtn = new JButton();
        JLabel jLabel3 = new JLabel();
        JPanel flowPanel = new JPanel();
        JButton startBtn = new JButton();
        JButton cancelBtn = new JButton();
        JPanel topPanel = new JPanel();
        JPanel titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.filterPanel = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.filterTxt = new JTextField();
        JButton createBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ListDialog.this.closeDialog(evt);
            }
        });
        jScrollPane1.setPreferredSize(new Dimension(200, 300));
        jScrollPane1.setViewportView(this.jList);
        this.getContentPane().add((Component)jScrollPane1, "Center");
        bottomPanel.setLayout(new BorderLayout());
        fromAnotherCrateBtn.setText("Get Server List from Another host");
        fromAnotherCrateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListDialog.this.fromAnotherCrateBtnActionPerformed(evt);
            }
        });
        bottomPanel.add((Component)fromAnotherCrateBtn, "North");
        jLabel3.setFont(new Font("Tahoma", 0, 18));
        jLabel3.setText("  ");
        bottomPanel.add((Component)jLabel3, "Center");
        startBtn.setText("Start Server");
        startBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListDialog.this.startBtnActionPerformed(evt);
            }
        });
        flowPanel.add(startBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        flowPanel.add(cancelBtn);
        bottomPanel.add((Component)flowPanel, "Last");
        this.getContentPane().add((Component)bottomPanel, "South");
        topPanel.setLayout(new BorderLayout());
        this.titleLabel.setFont(new Font("Tahoma", 1, 18));
        this.titleLabel.setText("Server list");
        titlePanel.add(this.titleLabel);
        topPanel.add((Component)titlePanel, "First");
        jLabel2.setText("Filter :  ");
        this.filterPanel.add(jLabel2);
        this.filterTxt.setColumns(20);
        this.filterTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListDialog.this.filterTxtActionPerformed(evt);
            }
        });
        this.filterPanel.add(this.filterTxt);
        createBtn.setText("Create New Server");
        createBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListDialog.this.createBtnActionPerformed(evt);
            }
        });
        this.filterPanel.add(createBtn);
        topPanel.add((Component)this.filterPanel, "Center");
        this.getContentPane().add((Component)topPanel, "North");
    }

    private void createBtnActionPerformed(ActionEvent evt) {
        block5: {
            try {
                DevWizard wdlg = new DevWizard((Dialog)this.hostInfoDialog, (DeviceProxy)this.hostInfoDialog.host);
                wdlg.showWizard(null);
                String serverName = DevWizard.lastServStarted;
                if (serverName == null) break block5;
                Point p = this.getLocationOnScreen();
                p.translate(50, 50);
                try {
                    if (new TangoServer(serverName, DevState.OFF).startupLevel(this.hostInfoDialog, this.hostInfoDialog.host.getName(), p)) {
                        this.hostInfoDialog.updateData();
                    }
                }
                catch (DevFailed e) {
                    Utils.popupError(this.hostInfoDialog, null, (Exception)((Object)e));
                }
            }
            catch (NoSuchMethodError ex) {
                Utils.popupError(this.hostInfoDialog, "This server is too old !\nUse Jive to create it.");
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    private void filterTxtActionPerformed(ActionEvent evt) {
        try {
            this.setList();
        }
        catch (DevFailed e) {
            Utils.popupError(this.hostInfoDialog, null, (Exception)((Object)e));
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void startBtnActionPerformed(ActionEvent evt) {
        this.startSelectedItems();
    }

    private void listSelectionPerformed(MouseEvent evt) {
        previousItem = this.jList.getSelectedValue();
        if (evt.getClickCount() == 2) {
            this.startSelectedItems();
        }
    }

    private void startSelectedItems() {
        this.selectedItems = new ArrayList<String>();
        List<String> selections = this.jList.getSelectedValuesList();
        if (selections.isEmpty()) {
            ErrorPane.showErrorMessage((Component)this, null, (Exception)new Exception("No server selected !"));
        } else {
            for (String serverName : selections) {
                try {
                    String deviceName = "dserver/" + serverName;
                    DeviceProxy dev = new DeviceProxy(deviceName);
                    try {
                        dev.ping();
                        ErrorPane.showErrorMessage((Component)this.hostInfoDialog, null, (Exception)new Exception(serverName + "  is Already Running  on " + new IORdump(deviceName).get_host() + " !"));
                    }
                    catch (DevFailed e) {
                        this.selectedItems.add(serverName);
                    }
                }
                catch (DevFailed e) {
                    Utils.popupError(this.hostInfoDialog, null, (Exception)((Object)e));
                }
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void fromAnotherCrateBtnActionPerformed(ActionEvent evt) {
        try {
            HostList hostListDialog = new HostList(this, this.hostInfoDialog.getHostName());
            if (hostListDialog.showDialog() == 0) {
                List<String> serverList = hostListDialog.getServerList();
                this.jList.setListData((String[])serverList.toArray(new String[serverList.size()]));
                this.filterPanel.setVisible(false);
                this.titleLabel.setText("Start servers from " + hostListDialog.getSelectedHostName());
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    public void showDialog() {
        try {
            this.setList();
        }
        catch (DevFailed e) {
            Utils.popupError(this.hostInfoDialog, null, (Exception)((Object)e));
        }
        this.setVisible(true);
    }

    List<String> getSelectedItems() {
        return this.selectedItems;
    }
}

