/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.LevelTree;
import admin.astor.ListDialog;
import admin.astor.ServerCmdThread;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import admin.astor.tools.PopupText;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.TangoChange;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class HostInfoDialog
extends JDialog
implements AstorDefs,
TangoConst {
    public TangoHost host;
    private String hostName;
    private JFrame jFrame;
    private Color bg;
    private List<TangoServer> warningServers;
    private String attribute = "Servers";
    private static final int NO_CHANGE = 0;
    private static final int LIST_CHANGED = 1;
    private static final int STATE_CHANGED = 2;
    private static Dimension preferredSize;
    private JScrollPane scrollPane;
    private LevelTree[] trees = null;
    private JPanel levelsPanel = null;
    private JPanel[] treePanels;
    private boolean standAlone = false;
    private UpdateThread updateThread;
    private static final int DON_T_ASK = 0;
    private static final int SET_ONE = 1;
    private static final int ASK_FOR_EACH = 2;
    private static final int CANCEL = 3;
    private JPanel centerPanel;
    private JRadioButton displayAllBtn;
    private JLabel separatorLabel;
    private JButton startAllBtn;
    private JButton startNewBtn;
    private JButton stopAllBtn;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JButton warningButton;
    private static final int readInfoPeriod = 1000;

    public HostInfoDialog(JFrame parent, String hostName, boolean standAlone) throws DevFailed {
        this(parent, new TangoHost(hostName, true));
        this.standAlone = standAlone;
        AstorUtil.getInstance().initIcons();
        this.initWarningButton();
    }

    public HostInfoDialog(JFrame jFrame, TangoHost host) {
        super((Frame)jFrame, false);
        this.jFrame = jFrame;
        this.host = host;
        this.hostName = host.getName();
        this.initComponents();
        this.setTitle((Object)((Object)host) + "  Control");
        this.displayAllBtn.setSelected(true);
        preferredSize = AstorUtil.getHostDialogPreferredSize();
        this.scrollPane = new JScrollPane();
        this.updateThread = new UpdateThread();
        this.updateThread.start();
        this.bg = this.titlePanel.getBackground();
        this.titleLabel.setText("Controlled Servers on " + this.hostName);
        if (Astor.rwMode == 2) {
            this.startNewBtn.setVisible(false);
            this.startAllBtn.setVisible(false);
            this.stopAllBtn.setVisible(false);
        }
        this.initWarningButton();
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initWarningButton() {
        this.warningButton.setText("");
        this.warningButton.setIcon(Utils.getInstance().getIcon("warning.gif", 0.5));
        this.separatorLabel.setVisible(false);
        this.warningButton.setVisible(false);
    }

    public String getHostName() {
        return this.hostName;
    }

    public Astor getAstorObject() {
        if (this.jFrame instanceof Astor) {
            return (Astor)this.jFrame;
        }
        return null;
    }

    public void displayHostInfoDialog(String hostname) {
        if (this.jFrame instanceof Astor) {
            ((Astor)this.jFrame).tree.displayHostInfoDialog(hostname);
        }
    }

    void setDialogPreferredSize(Dimension d) {
        preferredSize = d;
        this.packTheDialog();
    }

    void updatePanel(boolean resizePanel) {
        int i;
        if (this.trees == null) {
            int nbLevels = AstorUtil.getStarterNbStartupLevels();
            this.levelsPanel = new JPanel();
            this.levelsPanel.setLayout(new GridBagLayout());
            this.centerPanel.add((Component)this.levelsPanel, "Center");
            this.treePanels = new JPanel[++nbLevels];
            this.trees = new LevelTree[nbLevels];
            for (i = 0; i < nbLevels; ++i) {
                this.trees[i] = new LevelTree(this.jFrame, this, this.host, i);
                this.treePanels[i] = new JPanel();
                this.treePanels[i].add(this.trees[i]);
            }
        } else {
            LevelTree[] nbLevels = this.trees;
            i = nbLevels.length;
            for (int j = 0; j < i; ++j) {
                LevelTree tree = nbLevels[j];
                tree.checkUpdate();
            }
        }
        int nbServers = 0;
        for (i = 1; i < this.trees.length; ++i) {
            nbServers += this.trees[i].getNbServers();
        }
        this.titleLabel.setText("" + nbServers + " Controlled Servers on " + this.hostName);
        this.warningServers = new ArrayList<TangoServer>();
        for (LevelTree levelTree : this.trees) {
            List<TangoServer> tangoServerList = levelTree.getTangoServerList();
            for (TangoServer tangoServer : tangoServerList) {
                if (tangoServer.getNbInstances() <= 1) continue;
                this.warningServers.add(tangoServer);
            }
        }
        this.separatorLabel.setVisible(!this.warningServers.isEmpty());
        this.warningButton.setVisible(!this.warningServers.isEmpty());
        SwingUtilities.invokeLater(() -> {
            this.checkActiveLevels();
            this.updateHostState();
            if (resizePanel) {
                this.packTheDialog();
            }
        });
    }

    void packTheDialog() {
        if (!this.isVisible()) {
            return;
        }
        Point p = this.getLocation();
        this.pack();
        int width = this.levelsPanel.getWidth();
        int height = this.levelsPanel.getHeight();
        if (width > HostInfoDialog.preferredSize.width || height > HostInfoDialog.preferredSize.height) {
            int bw = 20;
            this.centerPanel.remove(this.levelsPanel);
            Dimension d = new Dimension(preferredSize);
            if (width < HostInfoDialog.preferredSize.width - bw) {
                d.width = width + bw;
            }
            if (height < HostInfoDialog.preferredSize.height - bw) {
                d.height = height + bw;
            }
            this.scrollPane.setPreferredSize(d);
            this.scrollPane.add(this.levelsPanel);
            this.scrollPane.setViewportView(this.levelsPanel);
            this.centerPanel.add((Component)this.scrollPane, "Center");
        } else {
            this.centerPanel.remove(this.scrollPane);
            this.scrollPane.remove(this.levelsPanel);
            this.centerPanel.add((Component)this.levelsPanel, "Center");
        }
        this.pack();
        this.setLocation(p);
    }

    private void checkActiveLevels() {
        this.levelsPanel.removeAll();
        ArrayList<JPanel> v = new ArrayList<JPanel>();
        for (int i = 1; i < this.trees.length; ++i) {
            if (this.trees[i].getNbServers() <= 0) continue;
            v.add(this.treePanels[i]);
        }
        if (this.trees[0].getNbServers() > 0) {
            v.add(this.treePanels[0]);
        }
        int x = 0;
        int y = 1;
        int x_size = v.size() / 2 - 1;
        if (x_size < 2) {
            x_size = 2;
        }
        for (int i = 0; i < v.size(); ++i) {
            JPanel panel = (JPanel)v.get(i);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = x++;
            gbc.gridy = y;
            gbc.insets = new Insets(5, 10, 0, 0);
            gbc.fill = 2;
            gbc.fill = 3;
            gbc.anchor = 17;
            this.levelsPanel.add((Component)panel, gbc);
            if (i != x_size) continue;
            x = 0;
            y += 2;
        }
    }

    Color getBackgroundColor() {
        return this.startNewBtn.getBackground();
    }

    void updateHostState() {
        if (this.host.state == 1) {
            String str_state = ApiUtil.stateName((DevState)DevState.MOVING);
            this.titlePanel.setBackground(ATKConstant.getColor4State((String)str_state));
        } else if (this.host.state == 3 || this.host.state == 2) {
            String str_state = ApiUtil.stateName((DevState)DevState.ALARM);
            this.titlePanel.setBackground(ATKConstant.getColor4State((String)str_state));
        } else {
            this.titlePanel.setBackground(this.bg);
        }
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.startNewBtn = new JButton();
        this.startAllBtn = new JButton();
        this.stopAllBtn = new JButton();
        this.displayAllBtn = new JRadioButton();
        this.centerPanel = new JPanel();
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton cancelBtn = new JButton();
        this.separatorLabel = new JLabel();
        this.warningButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                HostInfoDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.startNewBtn.setText("Start New");
        this.startNewBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.startNewBtnActionPerformed(evt);
            }
        });
        topPanel.add(this.startNewBtn);
        this.startAllBtn.setText("Start All");
        this.startAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.startAllBtnActionPerformed(evt);
            }
        });
        topPanel.add(this.startAllBtn);
        this.stopAllBtn.setText("Stop All");
        this.stopAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.stopAllBtnActionPerformed(evt);
            }
        });
        topPanel.add(this.stopAllBtn);
        this.displayAllBtn.setText("Display All");
        this.displayAllBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.displayAllBtn.setMargin(new Insets(0, 0, 0, 0));
        this.displayAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.displayAllBtnActionPerformed(evt);
            }
        });
        topPanel.add(this.displayAllBtn);
        this.getContentPane().add((Component)topPanel, "North");
        this.centerPanel.setLayout(new BorderLayout());
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.titlePanel.add(this.titleLabel);
        this.centerPanel.add((Component)this.titlePanel, "North");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.separatorLabel.setText("            ");
        bottomPanel.add(this.separatorLabel);
        this.warningButton.setText("Warning");
        this.warningButton.setBorder(BorderFactory.createEtchedBorder());
        this.warningButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.warningButtonActionPerformed(evt);
            }
        });
        bottomPanel.add(this.warningButton);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void displayAllBtnActionPerformed(ActionEvent evt) {
        boolean b;
        boolean bl = b = this.displayAllBtn.getSelectedObjects() != null;
        if (this.trees != null) {
            for (LevelTree tree : this.trees) {
                if (b) {
                    if (tree.getLevelRow() == 0) continue;
                    tree.expandTree();
                    continue;
                }
                tree.collapseTree();
            }
        }
    }

    private void stopAllBtnActionPerformed(ActionEvent evt) {
        ArrayList<Integer> used = new ArrayList<Integer>();
        for (int i = this.trees.length - 1; i >= 0; --i) {
            int level = this.trees[i].getLevelRow();
            if (level == 0) continue;
            if (this.trees[i].getNbServers() > 0 && this.trees[i].hasRunningServer()) {
                used.add(level);
                continue;
            }
            try {
                this.host.stopServers(level);
                continue;
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
        new ServerCmdThread(this, this.host, 1, used).start();
    }

    private void startAllBtnActionPerformed(ActionEvent evt) {
        ArrayList<Integer> used = new ArrayList<Integer>();
        for (LevelTree tree : this.trees) {
            int level = tree.getLevelRow();
            if (level == 0 || tree.getNbServers() <= 0 || tree.getState() == DevState.ON) continue;
            used.add(level);
        }
        new ServerCmdThread(this, this.host, 0, used).start();
    }

    private void startNewBtnActionPerformed(ActionEvent evt) {
        ListDialog listDialog = new ListDialog(this);
        Point point = this.getLocationOnScreen();
        point.translate(50, 50);
        listDialog.setLocation(point);
        listDialog.showDialog();
        List<String> serverNames = listDialog.getSelectedItems();
        if (serverNames != null) {
            new StartServersThread(this, serverNames, point).start();
        }
    }

    private int getLevelManagement() {
        Object[] options = new Object[]{"Don't ask", "Set one for all", "Ask for each", "Cancel"};
        int option = JOptionPane.showOptionDialog(this, "Device servers startup level ?\n\n", "Question", -1, 3, null, options, options[0]);
        switch (option) {
            case -1: 
            case 3: {
                return 3;
            }
        }
        return option;
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void warningButtonActionPerformed(ActionEvent evt) {
        StringBuilder sb = new StringBuilder("Servers running at least twice:\n\n");
        boolean i = false;
        for (TangoServer tangoServer : this.warningServers) {
            sb.append(tangoServer.getName()).append("\n");
        }
        new PopupText(this, true).show(sb.toString(), 300, 400);
    }

    void doClose() {
        if (this.jFrame instanceof Astor || !this.standAlone) {
            this.setVisible(false);
            this.dispose();
        } else {
            this.updateThread.stopThread();
            System.exit(0);
        }
    }

    void fireNewTreeSelection(LevelTree tree) {
        for (LevelTree tree1 : this.trees) {
            if (tree1 == tree) continue;
            tree1.clearSelection();
        }
    }

    void stopLevel(int level) {
        ArrayList<Integer> levels = new ArrayList<Integer>();
        levels.add(level);
        new ServerCmdThread(this, this.host, 1, levels).start();
    }

    void startLevel(int level) {
        ArrayList<Integer> levels = new ArrayList<Integer>();
        levels.add(level);
        new ServerCmdThread(this, this.host, 0, levels, false).start();
    }

    private void manageServersAttribute(DeviceAttribute att) {
        ArrayList<Server> servers = new ArrayList<Server>();
        try {
            if (!att.hasFailed()) {
                String[] lines;
                short nbLevels = AstorUtil.getStarterNbStartupLevels();
                for (String line : lines = att.extractStringArray()) {
                    Server server = new Server(line);
                    servers.add(server);
                    if (server.level <= nbLevels) continue;
                    DbServInfo info = new DbServInfo(server.name, this.hostName, false, 0);
                    new DbServer(server.name).put_info(info);
                    server.level = 0;
                    server.controlled = false;
                }
            }
        }
        catch (DevFailed e) {
            System.err.println(this.hostName);
            Except.print_exception((Exception)((Object)e));
        }
        switch (this.updateHost(servers)) {
            case 2: {
                this.updatePanel(false);
                break;
            }
            case 1: {
                this.updatePanel(true);
                break;
            }
            case 0: {
                return;
            }
        }
        for (LevelTree tree : this.trees) {
            tree.repaint();
        }
    }

    private int updateHost(List<Server> newServers) {
        boolean stateChanged = false;
        boolean listChanged = false;
        for (Server newServer : newServers) {
            TangoServer server = this.host.getServer(newServer.name);
            if (server == null) {
                try {
                    server = new TangoServer(newServer.name, newServer.state);
                    this.host.addServer(server);
                    listChanged = true;
                }
                catch (DevFailed e) {
                    System.err.println(this.hostName);
                    Except.print_exception((Exception)((Object)e));
                    ErrorPane.showErrorMessage((Component)this, (String)this.hostName, (DevFailed)e);
                }
            }
            if (server == null) continue;
            if (newServer.state != server.getState() || newServer.nbInstances != server.getNbInstances()) {
                server.setState(newServer.state);
                stateChanged = true;
                server.setNbInstances(newServer.nbInstances);
            }
            if (!(newServer.controlled != server.controlled | newServer.level != server.startup_level)) continue;
            server.controlled = newServer.controlled;
            server.startup_level = newServer.level;
            listChanged = true;
        }
        ArrayList<TangoServer> removed = new ArrayList<TangoServer>();
        for (TangoServer server : this.host.getServerList()) {
            boolean found = false;
            for (Server newServer : newServers) {
                found = newServer.name.equals(server.getName());
                if (!found) continue;
                break;
            }
            if (found) continue;
            removed.add(server);
        }
        for (TangoServer server : removed) {
            this.host.removeServer(server.getName());
            listChanged = true;
        }
        if (listChanged) {
            return 1;
        }
        if (stateChanged) {
            return 2;
        }
        return 0;
    }

    private DevState string2state(String str) {
        for (int i = 0; i < Tango_DevStateName.length; ++i) {
            if (!str.equals(Tango_DevStateName[i])) continue;
            return DevState.from_int((int)i);
        }
        return DevState.UNKNOWN;
    }

    void setSelection(String serverName) {
        if (this.trees != null) {
            for (LevelTree tree : this.trees) {
                TangoServer server = tree.getServer(serverName);
                if (server != null) {
                    tree.expandTree();
                    tree.setSelection(server);
                    continue;
                }
                tree.resetSelection();
            }
        }
    }

    void updateData() {
        this.updatePanel(true);
    }

    public static void main(String[] args) {
        try {
            String hostname;
            if (args.length > 0) {
                hostname = args[0];
            } else {
                hostname = (String)JOptionPane.showInputDialog(new JFrame(), "Host Name ?", "Input Dialog", 1, null, null, "");
                if (hostname == null) {
                    System.exit(0);
                }
            }
            new HostInfoDialog(new JFrame(), hostname, true).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
        }
    }

    private void subscribeChangeEvent() {
        try {
            if (this.host.supplier == null) {
                this.host.supplier = new TangoEventsAdapter((DeviceProxy)this.host);
            }
        }
        catch (DevFailed e) {
            this.host.onEvents = false;
            System.err.println("subscribeChangeServerEvent() for " + this.host.get_name() + " FAILED !");
            Except.print_exception((Exception)((Object)e));
            return;
        }
        catch (Exception e) {
            this.host.onEvents = false;
            System.err.println("subscribeChangeServerEvent() for " + this.host.get_name() + " FAILED !");
            System.err.println(e.toString());
            return;
        }
        try {
            ServerEventListener serverListener = new ServerEventListener();
            this.host.supplier.addTangoChangeListener((ITangoChangeListener)serverListener, this.attribute, false);
            System.out.println("subscribeChangeServerEvent() for " + this.host.get_name() + "/" + this.attribute + " OK!");
        }
        catch (DevFailed e) {
            this.host.onEvents = false;
            System.err.println("subscribeChangeServerEvent() for " + this.host.get_name() + " FAILED !");
            Except.print_exception((Exception)((Object)e));
        }
        catch (Exception e) {
            this.host.onEvents = false;
            System.err.println("subscribeChangeServerEvent() for " + this.host.get_name() + " FAILED !");
            System.err.println(e.toString());
        }
    }

    private class ServerEventListener
    implements ITangoChangeListener {
        private ServerEventListener() {
        }

        public void change(TangoChangeEvent event) {
            TangoChange tc = (TangoChange)event.getSource();
            String deviceName = tc.getEventSupplier().get_name();
            try {
                DeviceAttribute att = event.getValue();
                HostInfoDialog.this.manageServersAttribute(att);
            }
            catch (DevFailed e) {
                System.out.println(HostInfoDialog.this.hostName);
                if (e.errors[0].reason.equals("API_EventTimeout")) {
                    System.err.println("HostStateThread.ServerEventListener" + deviceName + " : API_EventTimeout");
                } else {
                    Except.print_exception((Exception)((Object)e));
                }
            }
            catch (Exception e) {
                System.err.println(HostInfoDialog.this.hostName);
                System.err.println("AstorEvent." + deviceName);
                System.err.println(e.toString());
                System.err.println("HostStateThread.ServerEventListener : could not extract data!");
            }
        }
    }

    private class UpdateThread
    extends Thread {
        private boolean stopIt = false;

        private UpdateThread() {
        }

        private synchronized void stopThread() {
            this.stopIt = true;
            this.notify();
        }

        @Override
        public void run() {
            if (HostInfoDialog.this.host.onEvents) {
                HostInfoDialog.this.subscribeChangeEvent();
            }
            while (!this.stopIt) {
                long t0 = System.currentTimeMillis();
                this.waitNextLoop(t0);
                if (this.stopIt) continue;
                SwingUtilities.invokeLater(() -> {
                    if (!HostInfoDialog.this.host.onEvents) {
                        this.manageSynchronous();
                    }
                    if (!(HostInfoDialog.this.jFrame instanceof Astor)) {
                        HostInfoDialog.this.updateHostState();
                    }
                });
            }
        }

        private synchronized void waitNextLoop(long t0) {
            try {
                long t1 = System.currentTimeMillis();
                long time_to_sleep = 1000L - (t1 - t0);
                if (time_to_sleep <= 0L) {
                    time_to_sleep = 100L;
                }
                this.wait(time_to_sleep);
            }
            catch (InterruptedException e) {
                System.out.println(e.toString());
            }
        }

        private void manageSynchronous() {
            try {
                DeviceAttribute att = HostInfoDialog.this.host.read_attribute(HostInfoDialog.this.attribute);
                HostInfoDialog.this.manageServersAttribute(att);
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
    }

    class Server {
        String name;
        DevState state;
        boolean controlled = false;
        int level = 0;
        int nbInstances = 1;

        public Server(String line) {
            String s;
            StringTokenizer stk = new StringTokenizer(line);
            ArrayList<String> items = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                items.add(stk.nextToken());
            }
            int n = 0;
            if (items.size() > n) {
                this.name = (String)items.get(n);
            }
            if (items.size() > ++n) {
                this.state = HostInfoDialog.this.string2state((String)items.get(n));
            }
            if (items.size() > ++n) {
                this.controlled = ((String)items.get(n)).equals("1");
            }
            if (items.size() > ++n) {
                s = (String)items.get(n);
                try {
                    this.level = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (items.size() > ++n) {
                s = (String)items.get(n);
                try {
                    this.nbInstances = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return this.name + " -> " + ApiUtil.stateName((DevState)this.state) + "\t- " + (this.controlled ? "" : "not ") + "Controlled \tlevel " + this.level;
        }
    }

    private class StartServersThread
    extends Thread {
        private JDialog dialog;
        private List<String> serverNames;
        private Point point;

        private StartServersThread(JDialog dialog, List<String> serverNames, Point point) {
            this.dialog = dialog;
            this.serverNames = serverNames;
            this.point = point;
        }

        @Override
        public void run() {
            try {
                DbServInfo dbServInfo = null;
                int levelManagement = 2;
                if (this.serverNames.size() > 4) {
                    levelManagement = HostInfoDialog.this.getLevelManagement();
                    if (levelManagement == 3) {
                        return;
                    }
                    if (levelManagement == 1) {
                        TangoServer server = new TangoServer(this.serverNames.get(0), DevState.OFF);
                        dbServInfo = server.getStartupLevel(this.dialog, this.point);
                    }
                }
                for (String serverName : this.serverNames) {
                    if (serverName != null) {
                        try {
                            HostInfoDialog.this.host.registerServer(serverName);
                            HostInfoDialog.this.host.startOneServer(serverName);
                            switch (levelManagement) {
                                case 0: {
                                    try {
                                        Thread.sleep(2000L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    break;
                                }
                                case 2: {
                                    TangoServer server = new TangoServer(serverName, DevState.OFF);
                                    server.startupLevel(this.dialog, HostInfoDialog.this.host.getName(), this.point);
                                    break;
                                }
                                case 1: {
                                    if (dbServInfo != null) {
                                        dbServInfo.name = serverName;
                                        dbServInfo.host = HostInfoDialog.this.host.getName();
                                        new DbServer(serverName).put_info(dbServInfo);
                                    }
                                    try {
                                        Thread.sleep(2000L);
                                        break;
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        catch (DevFailed e) {
                            ErrorPane.showErrorMessage((Component)HostInfoDialog.this.jFrame, null, (DevFailed)e);
                        }
                    }
                    HostInfoDialog.this.host.updateServersList(HostInfoDialog.this.jFrame);
                    DeviceAttribute attribute = HostInfoDialog.this.host.read_attribute("Servers");
                    HostInfoDialog.this.manageServersAttribute(attribute);
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
    }
}

