/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import admin.astor.tools.MySqlUtil;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.CommunicationFailed;
import fr.esrf.TangoApi.ConnectionFailed;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.EventSystemFailed;
import fr.esrf.TangoApi.NonDbDevice;
import fr.esrf.TangoApi.NonSupportedFeature;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoApi.WrongNameSyntax;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import jive.ExecDev;

public class AstorUtil
implements AstorDefs {
    private static DbClass _class = null;
    private static AstorUtil instance = null;
    private static String starterDeviceHeader = "tango/admin/";
    private static boolean superTango = false;
    private static short readInfoPeriod = (short)5;
    private static short nbStartupLevels = (short)5;
    private static String rloginCmd = null;
    private static String rloginUser = null;
    private static String[] tools = null;
    private static String[] known_tango_hosts = null;
    private static Dimension preferred_size = new Dimension(400, 600);
    private static Dimension host_dlg_preferred_size = new Dimension(800, 500);
    private static String[] lastCollections = null;
    private static boolean jiveReadOnly = false;
    private static boolean starterStartup = true;
    private static boolean properties_read = false;
    private static String[] helps;
    private static final String starterStartupPropName = "StartServersAtStartup";
    private static final String[] astorPropertyNames;
    public static ImageIcon[] state_icons;
    private static String hostInfoClassName;
    private static Splash splash;
    private static int splash_progress;
    private static ImageIcon tango_icon;
    private static RGB rgb;

    private AstorUtil() {
        String str = System.getenv("SUPER_TANGO");
        if (str != null) {
            superTango = str.equals("true");
        } else {
            str = System.getProperty("SUPER_TANGO");
            if (str != null) {
                superTango = str.equals("true");
            }
        }
        try {
            DbDatum datum = ApiUtil.get_db_obj().get_class_property("Starter", "Domain");
            if (!datum.is_empty()) {
                starterDeviceHeader = datum.extractString() + "/admin/";
            }
        }
        catch (DevFailed e) {
            System.err.println(e.errors[0].desc);
        }
    }

    public static AstorUtil getInstance() {
        if (instance == null) {
            instance = new AstorUtil();
        }
        return instance;
    }

    public String getApplicationName() {
        String applicationName = this.getClass().getPackage().getImplementationTitle();
        if (applicationName == null) {
            applicationName = "Astor";
        }
        return applicationName + this.getApplicationRelease();
    }

    public String getApplicationRelease() {
        String release = this.getClass().getPackage().getImplementationVersion();
        if (release != null) {
            return "-" + release;
        }
        return " - not released";
    }

    public static String getStarterDeviceHeader() {
        if (instance == null) {
            instance = new AstorUtil();
        }
        return starterDeviceHeader;
    }

    public static String getControlSystemName() throws DevFailed {
        DbDatum datum = ApiUtil.get_db_obj().get_property("CtrlSystem", "Name");
        if (!datum.is_empty()) {
            return datum.extractString();
        }
        return null;
    }

    public static void setControlSystemName(String name) throws DevFailed {
        DbDatum datum = new DbDatum("Name");
        datum.insert(name);
        ApiUtil.get_db_obj().put_property("CtrlSystem", new DbDatum[]{datum});
    }

    public void initIcons() {
        AstorUtil.state_icons[6] = ATKConstant.getSmallBallIcon4State((String)DevState.UNKNOWN.toString());
        AstorUtil.state_icons[5] = ATKConstant.getSmallBallIcon4State((String)DevState.FAULT.toString());
        AstorUtil.state_icons[3] = ATKConstant.getSmallBallIcon4State((String)DevState.ALARM.toString());
        AstorUtil.state_icons[0] = ATKConstant.getSmallBallIcon4State((String)DevState.ON.toString());
        AstorUtil.state_icons[4] = ATKConstant.getSmallBallIcon4State((String)DevState.OFF.toString());
        AstorUtil.state_icons[1] = ATKConstant.getSmallBallIcon4State((String)DevState.MOVING.toString());
        AstorUtil.state_icons[2] = Utils.getInstance().getIcon("orangeTriangle.png", 0.36);
        AstorUtil.state_icons[7] = Utils.getInstance().getIcon("failed.gif");
    }

    public boolean isSuperTango() {
        return superTango;
    }

    static String[] string2array(String str) {
        return AstorUtil.string2array(str, null);
    }

    static String[] string2array(String str, String separ) {
        StringTokenizer stk = separ == null ? new StringTokenizer(str) : new StringTokenizer(str, separ);
        ArrayList<String> list = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            list.add(stk.nextToken());
        }
        return list.toArray(new String[0]);
    }

    public static String getRloginCmd() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return rloginCmd;
    }

    public static void setRloginCmd(String s) {
        rloginCmd = s;
    }

    public static String getRloginUser() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return rloginUser;
    }

    public static void setRloginUser(String s) {
        rloginUser = s;
    }

    public static void setTools(String[] t) {
        tools = t;
    }

    public static String[] getTools() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return tools;
    }

    public static void setHtmlHelps(String[] h) {
        helps = h;
    }

    public static String[] getHtmlHelps() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return helps;
    }

    public static String[] getDbaseKnownTangoHosts() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return known_tango_hosts;
    }

    public static List<String> getUserKnownTangoHosts() {
        String astorRC = AstorUtil.getAstorRC();
        return AstorUtil.getFromEnvFile("KnownTangoHosts", astorRC);
    }

    public static List<String> getAllKnownTangoHosts() {
        String[] csTangoHosts = AstorUtil.getDbaseKnownTangoHosts();
        ArrayList<String> list = new ArrayList<String>();
        if (csTangoHosts != null) {
            Collections.addAll(list, csTangoHosts);
        }
        List<String> userTangoHosts = AstorUtil.getUserKnownTangoHosts();
        for (String userTH : userTangoHosts) {
            boolean exists = false;
            if (csTangoHosts != null) {
                for (String csTH : csTangoHosts) {
                    if (!csTH.equals(userTH)) continue;
                    exists = true;
                }
            }
            if (exists) continue;
            list.add(userTH);
        }
        return list;
    }

    private static String getAstorRC() {
        String home = System.getProperty("user.home");
        String astorRC = AstorUtil.osIsUnix() ? home + "/." + "astorrc" : home + "/" + "astorrc";
        return astorRC;
    }

    public static void saveUserKnownTangoHost(List<String> list) throws DevFailed {
        int end;
        String code;
        String tag = "KnownTangoHosts:";
        StringBuilder sb = new StringBuilder("KnownTangoHosts:  ");
        for (String host : list) {
            sb.append(host).append(", ");
        }
        String tangoHosts = sb.substring(0, sb.length() - 2) + '\n';
        String astorRC = AstorUtil.getAstorRC();
        try {
            code = AstorUtil.readFile(astorRC);
        }
        catch (DevFailed e) {
            code = "#\n#  Astor (TANGO Manager) configuration file\n#\n#\n";
        }
        int start = code.indexOf("KnownTangoHosts:");
        code = start < 0 ? code + tangoHosts : ((end = code.indexOf(10, start)) < 0 ? code.substring(0, start) + tangoHosts : code.substring(0, start) + tangoHosts + code.substring(end));
        AstorUtil.writeFile(astorRC, code);
    }

    private static List<String> getFromEnvFile(String propertyName, String fileName) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String code = AstorUtil.readFile(fileName);
            StringTokenizer stk = new StringTokenizer(code, "\n");
            ArrayList<String> lines = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                String line = stk.nextToken().trim();
                if (line.startsWith("#")) continue;
                lines.add(line);
            }
            for (String line : lines) {
                if (!line.startsWith(propertyName + ":")) continue;
                String s = line.substring(propertyName.length() + 1).trim();
                stk = new StringTokenizer(s, ",");
                while (stk.hasMoreTokens()) {
                    list.add(stk.nextToken().trim());
                }
                return list;
            }
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        return list;
    }

    public static String getHostInfoClassName() {
        if (hostInfoClassName == null) {
            hostInfoClassName = "";
            try {
                DbDatum datum = ApiUtil.get_db_obj().get_property("Astor", "_HostInfo");
                if (!datum.is_empty()) {
                    hostInfoClassName = datum.extractString();
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
        return hostInfoClassName;
    }

    public static String readFile(String filename) throws DevFailed {
        String str = "";
        try {
            FileInputStream fid = new FileInputStream(filename);
            int nb = fid.available();
            byte[] inStr = new byte[nb];
            nb = fid.read(inStr);
            fid.close();
            if (nb > 0) {
                str = new String(inStr);
            }
        }
        catch (Exception e) {
            Except.throw_exception((String)"READ_FAILED", (String)e.toString());
        }
        return str;
    }

    public static List<String> readFileLines(String filename) throws DevFailed {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String str = AstorUtil.readFile(filename);
            StringTokenizer stk = new StringTokenizer(str, "\n");
            while (stk.hasMoreTokens()) {
                lines.add(stk.nextToken());
            }
        }
        catch (Exception e) {
            Except.throw_exception((String)"READ_FAILED", (String)e.toString());
        }
        return lines;
    }

    public static void writeFile(String filename, String code) throws DevFailed {
        try {
            FileOutputStream fid = new FileOutputStream(filename);
            fid.write(code.getBytes());
            fid.close();
        }
        catch (Exception e) {
            Except.throw_exception((String)"WRITE_FAILED", (String)e.toString());
        }
    }

    public static Dimension getPreferredSize() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return preferred_size;
    }

    public static void setPreferredSize(Dimension d) {
        preferred_size = d;
    }

    public static Dimension getHostDialogPreferredSize() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return host_dlg_preferred_size;
    }

    public static void setHostDialogPreferredSize(Dimension d) {
        host_dlg_preferred_size = d;
    }

    public static void setKnownTangoHosts(String[] kth) {
        known_tango_hosts = kth;
    }

    private static String getStringProperty(DbDatum datum) {
        if (datum.is_empty()) {
            return null;
        }
        return datum.extractString();
    }

    private static String[] getStringArrayProperty(DbDatum datum) {
        if (datum.is_empty()) {
            return null;
        }
        return datum.extractStringArray();
    }

    public static void readAstorProperties() {
        try {
            int height;
            int width2;
            DbDatum[] data = ApiUtil.get_db_obj().get_property("Astor", astorPropertyNames);
            int i = 0;
            rloginCmd = AstorUtil.getStringProperty(data[i++]);
            rloginUser = AstorUtil.getStringProperty(data[i++]);
            String s = AstorUtil.getStringProperty(data[i++]);
            if (s != null) {
                jiveReadOnly = s.equals("true") || s.equals("1");
            }
            lastCollections = AstorUtil.getStringArrayProperty(data[i++]);
            known_tango_hosts = AstorUtil.getStringArrayProperty(data[i++]);
            String[] array = AstorUtil.getStringArrayProperty(data[i++]);
            try {
                if (array != null && array.length >= 2) {
                    width2 = Integer.parseInt(array[0]);
                    height = Integer.parseInt(array[1]);
                    preferred_size = new Dimension(width2, height);
                }
            }
            catch (Exception width2) {
                // empty catch block
            }
            array = AstorUtil.getStringArrayProperty(data[i++]);
            try {
                if (array != null && array.length >= 2) {
                    width2 = Integer.parseInt(array[0]);
                    height = Integer.parseInt(array[1]);
                    host_dlg_preferred_size = new Dimension(width2, height);
                }
            }
            catch (Exception width3) {
                // empty catch block
            }
            tools = AstorUtil.getStringArrayProperty(data[i++]);
            helps = AstorUtil.getStringArrayProperty(data[i]);
            DbClass dbClass = new DbClass("Starter");
            DbDatum datum = dbClass.get_property(starterStartupPropName);
            if (!datum.is_empty()) {
                starterStartup = datum.extractBoolean();
            }
            properties_read = true;
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    static void putAstorProperties() throws DevFailed {
        DbDatum[] data = new DbDatum[astorPropertyNames.length];
        int i = 0;
        data[i] = new DbDatum(astorPropertyNames[i], rloginCmd);
        data[++i] = new DbDatum(astorPropertyNames[i], rloginUser);
        data[++i] = new DbDatum(astorPropertyNames[i], jiveReadOnly);
        data[++i] = new DbDatum(astorPropertyNames[i], lastCollections);
        data[++i] = new DbDatum(astorPropertyNames[i], known_tango_hosts);
        data[++i] = new DbDatum(astorPropertyNames[i], new String[]{Integer.toString(AstorUtil.preferred_size.width), Integer.toString(AstorUtil.preferred_size.height)});
        data[++i] = new DbDatum(astorPropertyNames[i], new String[]{Integer.toString(AstorUtil.host_dlg_preferred_size.width), Integer.toString(AstorUtil.host_dlg_preferred_size.height)});
        data[++i] = new DbDatum(astorPropertyNames[i], tools);
        data[++i] = new DbDatum(astorPropertyNames[i], helps);
        ApiUtil.get_db_obj().put_property("Astor", data);
        DbDatum datum = new DbDatum(starterStartupPropName);
        datum.insert(starterStartup);
        DbClass dbClass = new DbClass("Starter");
        dbClass.put_property(new DbDatum[]{datum});
    }

    void setJiveReadOnly(boolean b) {
        jiveReadOnly = b;
    }

    void setStarterStartup(boolean b) {
        starterStartup = b;
    }

    boolean jiveIsReadOnly() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return jiveReadOnly;
    }

    boolean getStarterStartup() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return starterStartup;
    }

    public String[] getLastCollectionList() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return lastCollections;
    }

    public void setLastCollectionList(String[] lcl) {
        lastCollections = lcl;
    }

    public List<String> getCollectionList() throws DevFailed {
        return this.getCollectionList(this.getTangoHostList());
    }

    public List<String> getCollectionList(TangoHost[] hosts) {
        ArrayList<String> list = new ArrayList<String>();
        for (TangoHost host : hosts) {
            if (host.collection == null) {
                host.collection = "Miscellaneous";
            }
            boolean found = false;
            for (int j = 0; j < list.size() && !found; ++j) {
                found = host.collection.equals(list.get(j));
            }
            if (found) continue;
            list.add(host.collection);
        }
        list.sort(new StringComparator());
        list.add(0, "Tango Database");
        String[] lasts = this.getLastCollectionList();
        if (lasts != null) {
            for (String last : lasts) {
                boolean found = false;
                for (int j = 0; !found && j < list.size(); ++j) {
                    String collection = (String)list.get(j);
                    if (last == null || collection == null || !(found = last.equals(list.get(j)))) continue;
                    list.remove(j);
                    list.add(collection);
                }
            }
        }
        return list;
    }

    public TangoHost[] getTangoHostList() throws DevFailed {
        String[] hostNames = MySqlUtil.getInstance().getHostControlledList();
        boolean db_server_idl_4 = ApiUtil.get_db_obj().get_idl_version() >= 4;
        DbDevImportInfo[] devinfo = null;
        DbDevImportInfo[] adminfo = null;
        if (db_server_idl_4) {
            MySqlUtil mysql = MySqlUtil.getInstance();
            devinfo = mysql.getHostDevImportInfo(starterDeviceHeader + "%");
            adminfo = mysql.getHostDevImportInfo("dserver/starter/%");
        }
        ArrayList<TangoHost> hosts = new ArrayList<TangoHost>();
        for (String hostName : hostNames) {
            if (db_server_idl_4) {
                DbDevImportInfo deviceInfo = this.getDevImportInfo(hostName, devinfo);
                DbDevImportInfo adminInfo = this.getDevImportInfo(hostName, adminfo);
                if (deviceInfo != null) {
                    if (!deviceInfo.exported || adminInfo == null) {
                        hosts.add(new TangoHost(hostName, false));
                        continue;
                    }
                    hosts.add(new TangoHost(deviceInfo, adminInfo));
                    continue;
                }
                System.err.println("----------> " + hostName);
                continue;
            }
            hosts.add(new TangoHost(hostName, true));
        }
        if (db_server_idl_4) {
            MySqlUtil.getInstance().manageTangoHostProperties(hosts);
        }
        return hosts.toArray(new TangoHost[0]);
    }

    private DbDevImportInfo getDevImportInfo(String hostName, DbDevImportInfo[] importInfos) {
        for (DbDevImportInfo importInfo : importInfos) {
            int idx = importInfo.name.lastIndexOf(47);
            String member = importInfo.name.substring(idx + 1);
            if ((idx = member.indexOf(46)) > 0) {
                member = member.substring(0, idx);
            }
            if (!member.toLowerCase().equals(hostName.toLowerCase())) continue;
            return importInfo;
        }
        return null;
    }

    public static String getTangoHost() {
        String th;
        block3: {
            try {
                th = ApiUtil.getTangoHost();
            }
            catch (DevFailed e) {
                return null;
            }
            catch (NoSuchMethodError e) {
                th = System.getProperty("TANGO_HOST");
                if (th != null) break block3;
                th = System.getenv("TANGO_HOST");
            }
        }
        return th;
    }

    public static short getStarterReadPeriod() {
        if (_class == null) {
            AstorUtil.getStarterClassProperties();
        }
        return readInfoPeriod;
    }

    public static short getStarterNbStartupLevels() {
        if (_class == null) {
            AstorUtil.getStarterClassProperties();
        }
        return nbStartupLevels;
    }

    private static void getStarterClassProperties() {
        try {
            _class = new DbClass("Starter");
            String[] propNames = new String[]{"NbStartupLevels", "ReadInfoDbPeriod", "doc_url", "appli_doc_url"};
            DbDatum[] properties = _class.get_property(propNames);
            int i = 0;
            if (!properties[i].is_empty()) {
                nbStartupLevels = properties[i].extractShort();
            }
            if (!properties[++i].is_empty()) {
                readInfoPeriod = properties[i].extractShort();
            }
            readInfoPeriod = (short)(readInfoPeriod * 1000);
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
    }

    static String[] getServerClassProperties(String classname) {
        String[] result = new String[3];
        try {
            DbClass dbclass = new DbClass(classname);
            String[] propNames = new String[]{"ProjectTitle", "Description", "doc_url"};
            DbDatum[] prop = dbclass.get_property(propNames);
            if (!prop[0].is_empty()) {
                result[0] = prop[0].extractString();
            }
            if (!prop[1].is_empty()) {
                String[] desc = prop[1].extractStringArray();
                result[1] = "";
                for (int i = 0; i < desc.length; ++i) {
                    result[1] = result[1] + desc[i];
                    if (i >= desc.length - 1) continue;
                    result[1] = result[1] + "\n";
                }
            }
            result[2] = prop[2].is_empty() ? "Doc location unknown...." : prop[2].extractString();
        }
        catch (DevFailed e) {
            result[2] = null;
            result[1] = null;
            result[0] = null;
        }
        return result;
    }

    public static String strException(Exception except) {
        StringBuilder sb = new StringBuilder();
        if (except instanceof ConnectionFailed) {
            sb.append(((ConnectionFailed)except).getStack());
        } else if (except instanceof CommunicationFailed) {
            sb.append(((CommunicationFailed)except).getStack());
        } else if (except instanceof WrongNameSyntax) {
            sb.append(((WrongNameSyntax)except).getStack());
        } else if (except instanceof WrongData) {
            sb.append(((WrongData)except).getStack());
        } else if (except instanceof NonDbDevice) {
            sb.append(((NonDbDevice)except).getStack());
        } else if (except instanceof NonSupportedFeature) {
            sb.append(((NonSupportedFeature)except).getStack());
        } else if (except instanceof EventSystemFailed) {
            sb.append(((EventSystemFailed)except).getStack());
        } else if (except instanceof AsynReplyNotArrived) {
            sb.append(((AsynReplyNotArrived)except).getStack());
        } else if (except instanceof DevFailed) {
            DevFailed df = (DevFailed)((Object)except);
            sb.append("Tango exception  ").append(df.toString()).append("\n");
            for (int i = 0; i < df.errors.length; ++i) {
                sb.append("Severity -> ");
                switch (df.errors[i].severity.value()) {
                    case 0: {
                        sb.append("WARNING \n");
                        break;
                    }
                    case 1: {
                        sb.append("ERROR \n");
                        break;
                    }
                    case 2: {
                        sb.append("PANIC \n");
                        break;
                    }
                    default: {
                        sb.append("Unknown severity code");
                    }
                }
                sb.append("Desc   -> ").append(df.errors[i].desc).append("\n");
                sb.append("Reason -> ").append(df.errors[i].reason).append("\n");
                sb.append("Origin -> ").append(df.errors[i].origin).append("\n");
                if (i >= df.errors.length - 1) continue;
                sb.append("-------------------------------------------------------------\n");
            }
        } else {
            sb = new StringBuilder(except.toString());
        }
        return sb.toString();
    }

    public static void centerDialog(JDialog dialog, JFrame parent) {
        Point p = parent.getLocationOnScreen();
        p.x += (parent.getWidth() - dialog.getWidth()) / 2;
        p.y += (parent.getHeight() - dialog.getHeight()) / 2;
        if (p.y <= 0) {
            p.y = 20;
        }
        if (p.x <= 0) {
            p.x = 20;
        }
        dialog.setLocation(p);
    }

    public static void centerDialog(JDialog dialog, JDialog parent) {
        Point p = parent.getLocationOnScreen();
        p.x += (parent.getWidth() - dialog.getWidth()) / 2;
        p.y += (parent.getHeight() - dialog.getHeight()) / 2;
        if (p.y <= 0) {
            p.y = 20;
        }
        if (p.x <= 0) {
            p.x = 20;
        }
        dialog.setLocation(p);
    }

    public static void rightShiftDialog(JDialog dialog, JFrame parent) {
        Point p = parent.getLocationOnScreen();
        p.x += parent.getWidth();
        p.y += (parent.getHeight() - dialog.getHeight()) / 2;
        if (p.y <= 0) {
            p.y = 20;
        }
        if (p.x <= 0) {
            p.x = 20;
        }
        dialog.setLocation(p);
    }

    public static void cascadeDialog(JDialog dialog, JDialog parent) {
        Point p = parent.getLocationOnScreen();
        p.x += 20;
        p.y += 20;
        dialog.setLocation(p);
    }

    static String[] string2StringArray(String str) {
        int idx;
        ArrayList<String> list = new ArrayList<String>();
        while ((idx = str.indexOf("\n")) > 0) {
            list.add(str.substring(0, idx));
            str = str.substring(idx + 1);
        }
        list.add(str);
        return list.toArray(new String[0]);
    }

    public static void executeShellCmdAndReturn(String cmd) throws IOException {
        System.out.println(cmd);
        Process process = Runtime.getRuntime().exec(cmd);
        InputStream inputStream = process.getInputStream();
        new BufferedReader(new InputStreamReader(inputStream));
    }

    public static String executeShellCmd(String cmd) throws IOException, InterruptedException, DevFailed {
        String str;
        Process process = Runtime.getRuntime().exec(cmd);
        InputStream inputStream = process.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder sb = new StringBuilder();
        while ((str = br.readLine()) != null) {
            sb.append(str).append("\n");
        }
        process.waitFor();
        int retVal = process.exitValue();
        if (retVal != 0) {
            InputStream errorStream = process.getErrorStream();
            br = new BufferedReader(new InputStreamReader(errorStream));
            while ((str = br.readLine()) != null) {
                System.out.println(str);
                sb.append(str).append("\n");
            }
            Except.throw_exception((String)"ExecFailed", (String)("the shell command\n" + cmd + "\nreturns : " + retVal + " !\n\n" + sb));
        }
        return sb.toString();
    }

    public static boolean osIsUnix() {
        return !System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static void testDevice(Component parent, String devname) {
        JDialog d = parent instanceof JDialog ? new JDialog((Dialog)((JDialog)parent), false) : new JDialog((Frame)((JFrame)parent), false);
        d.setTitle(devname + " Device Panel");
        try {
            d.setContentPane((Container)new ExecDev(devname));
            ATKGraphicsUtils.centerDialog((Dialog)d);
            d.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, null, (DevFailed)e);
        }
    }

    public static void showInHtmBrowser(String url) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(new URI(url));
                }
                catch (Exception e) {
                    ErrorPane.showErrorMessage((Component)new JFrame(), null, (Exception)e);
                }
            }
        } else {
            String browser = AstorUtil.osIsUnix() ? "firefox - turbo" : "explorer";
            String cmd = browser + " " + url;
            try {
                AstorUtil.executeShellCmdAndReturn(cmd);
            }
            catch (Exception e) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (Exception)e);
            }
        }
    }

    public static String getAccessControlDeviceName() {
        String name;
        try {
            String[] services = ApiUtil.get_db_obj().getServices("AccessControl", "*");
            name = services.length > 0 ? services[0] : null;
        }
        catch (DevFailed e) {
            name = null;
        }
        return name;
    }

    public static void startSplash(String title) {
        String s = System.getenv("UseSplash");
        if (s != null && s.equals("false")) {
            return;
        }
        JSmoothProgressBar myBar = new JSmoothProgressBar();
        myBar.setStringPainted(true);
        myBar.setBackground(Color.lightGray);
        myBar.setProgressBarColors(Color.gray, Color.lightGray, Color.darkGray);
        if (tango_icon == null) {
            tango_icon = Utils.getInstance().getIcon("TangoLogo.png");
        }
        splash = new Splash(tango_icon, Color.black, myBar);
        splash.setTitle(title);
        splash.setMessage("Starting....");
        splash_progress = 0;
        splash.setAlwaysOnTop(true);
        splash.setVisible(true);
        splash.repaint();
    }

    public static void stopSplash() {
        if (splash != null) {
            splash_progress = 100;
            splash.progress(splash_progress);
            splash.setVisible(false);
        }
    }

    public static void increaseSplashProgress(int i, String message) {
        if (splash != null) {
            if ((splash_progress += i) > 99) {
                splash_progress = 10;
            }
            splash.progress(splash_progress);
            splash.setMessage(message);
        }
    }

    public static void increaseSplashProgress(double ratio, String message) {
        if (splash != null) {
            splash_progress = (int)(100.0 * ratio);
            if (splash_progress > 99) {
                splash_progress = 10;
            }
            splash.progress(splash_progress);
            splash.setMessage(message);
        }
    }

    public static void setSplashMessage(String message) {
        if (splash != null) {
            splash.setMessage(message);
        }
    }

    public static ImageIcon getIconImage(DevState state) {
        return ATKConstant.getSmallBallIcon4State((String)state.toString());
    }

    public void initColors(int nb) {
        if (rgb == null) {
            rgb = new RGB(nb);
        } else {
            rgb.initColor(nb);
        }
    }

    public Color getNewColor() {
        if (rgb == null) {
            rgb = new RGB();
        }
        return rgb.getNewColor();
    }

    public void sortTangoServer(ArrayList<TangoServer> list) {
        list.sort(new TangoServerComparator());
    }

    public void sort(ArrayList<String> arrayList) {
        arrayList.sort(new StringComparator());
    }

    public void startExternalApplication(JFrame parent, String className, String stringParameter) throws DevFailed {
        try {
            Constructor<?>[] constructors;
            Class<?> _class = Class.forName(className);
            boolean found = false;
            for (Constructor<?> constructor : constructors = _class.getDeclaredConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != 2 || parameterTypes[0] != JFrame.class || parameterTypes[1] != String.class) continue;
                ((Component)constructor.newInstance(parent, stringParameter)).setVisible(true);
                found = true;
            }
            if (!found) {
                throw new Exception("Cannot find constructor for " + className);
            }
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e;
                Throwable throwable = ite.getTargetException();
                System.out.println(throwable.getMessage());
                if (throwable instanceof DevFailed) {
                    throw (DevFailed)throwable;
                }
            }
            Except.throw_exception((String)e.toString(), (String)e.toString(), (String)"AstorUtil.startExternalApplication()");
        }
    }

    public void startExternalApplication(String className, String stringParameter) throws DevFailed {
        this.startExternalApplication(new JFrame(), className, stringParameter);
    }

    public void startExternalApplication(String className, String[] stringParameters) throws DevFailed {
        this.startExternalApplication(new JFrame(), className, stringParameters);
    }

    public void startExternalApplication(JFrame parent, String className, String[] stringParameters) throws DevFailed {
        try {
            Constructor<?>[] constructors;
            Class<?> _class = Class.forName(className);
            boolean found = false;
            for (Constructor<?> constructor : constructors = _class.getDeclaredConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != 2 || parameterTypes[0] != JFrame.class || parameterTypes[1] != String[].class) continue;
                ((Component)constructor.newInstance(parent, stringParameters)).setVisible(true);
                found = true;
            }
            if (!found) {
                throw new Exception("Cannot find constructor for " + className);
            }
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e;
                Throwable throwable = ite.getTargetException();
                System.out.println(throwable.getMessage());
                if (throwable instanceof DevFailed) {
                    throw (DevFailed)throwable;
                }
            }
            Except.throw_exception((String)e.toString(), (String)e.toString(), (String)"AstorUtil.startExternalApplication()");
        }
    }

    public static void main(String[] args) {
    }

    static {
        astorPropertyNames = new String[]{"RloginCmd", "RloginUser", "JiveReadOnly", "LastCollections", "KnownTangoHosts", "PreferredSize", "HostDialogPreferredSize", "Tools", "HtmlHelps"};
        state_icons = new ImageIcon[8];
        hostInfoClassName = null;
        tango_icon = null;
        rgb = null;
    }

    static class TangoServerComparator
    implements Comparator<TangoServer> {
        TangoServerComparator() {
        }

        @Override
        public int compare(TangoServer s1, TangoServer s2) {
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.getName().compareTo(s2.getName());
        }
    }

    static class StringComparator
    implements Comparator<String> {
        StringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    }

    static class RGB {
        int r = 0;
        int g = 0;
        int b = 0;
        int step = 10;
        private boolean red = true;
        private boolean green = false;
        private boolean blue = false;

        RGB() {
        }

        RGB(int nb) {
            this.initColor(nb);
        }

        void initColor(int nb) {
            this.step = 1020 / nb;
            if (this.step == 255) {
                this.step = 128;
            }
            this.red = true;
            this.green = false;
            this.blue = false;
            this.b = 0;
            this.g = 0;
            this.r = 0;
        }

        void increase() {
            if (this.red) {
                if (this.r + this.step < 255) {
                    this.r += this.step;
                } else {
                    this.r = 255;
                    this.red = false;
                    this.green = true;
                }
            } else if (this.green) {
                if (this.g + this.step < 255) {
                    if (this.r - this.step > 0) {
                        this.r -= this.step;
                    }
                    this.g += this.step;
                } else {
                    this.g = 255;
                    this.green = false;
                    this.blue = true;
                }
            } else if (this.blue) {
                if (this.b + this.step < 255) {
                    if (this.g - this.step > 0) {
                        this.g -= this.step;
                    }
                    this.b += this.step;
                } else {
                    this.b = 255;
                    this.r = 255;
                    this.blue = false;
                }
            } else if (this.r - this.step > 0) {
                this.r -= this.step;
                this.b -= this.step;
            }
        }

        Color getNewColor() {
            this.increase();
            return new Color(this.r, this.g, this.b);
        }
    }
}

