/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import java.util.Enumeration;
import java.util.Vector;
import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.matrixJep.MatrixVariableI;
import org.lsmp.djep.mrpe.MRpCommandList;
import org.lsmp.djep.mrpe.MRpEval;
import org.lsmp.djep.mrpe.MRpRes;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class MRpDiffExample {
    MatrixJep mj = new MatrixJep();
    MRpEval mrpe = null;
    MRpCommandList[] allCommands;
    int xref;
    int yref;
    double xmin = -1.0;
    double xmax = 1.0;
    double ymin = 1.0;
    double ymax = 1.0;
    int xsteps = 100;
    int ysteps = 100;
    static long oldTime = 0L;

    public static void main(String[] args) {
        MRpDiffExample.timePrint("\tStart");
        MRpDiffExample surf = new MRpDiffExample();
        MRpDiffExample.timePrint("\tDone init");
        try {
            surf.compile("th=pi*x;phi=pi*y;f=[cos(th) cos(phi),sin(th) cos(phi),sin(phi)];dx=diff(f,x);dy=diff(f,y);dx^dy;");
            MRpDiffExample.timePrint("\tDone parse");
            surf.calcMRPE();
            surf.mrpe.cleanUp();
            MRpDiffExample.timePrint("\tDone mrpe");
        }
        catch (Exception e) {
            System.out.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public static void timePrint(String msg) {
        long time = System.currentTimeMillis();
        long timediff = time - oldTime;
        oldTime = time;
        System.out.println("" + timediff + "\t" + msg);
    }

    public MRpDiffExample() {
        this.mj.setAllowAssignment(true);
        this.mj.setAllowUndeclared(true);
        this.mj.setImplicitMul(true);
        this.mj.addComplex();
        this.mj.addStandardConstants();
        this.mj.addStandardFunctions();
        this.mj.addStandardDiffRules();
        this.mrpe = new MRpEval(this.mj);
        this.mj.getPrintVisitor().setMode(16, false);
    }

    public void compile(String text) {
        this.mj.restartParser(text);
        try {
            Node n;
            Vector<Node> eqns = new Vector<Node>();
            while ((n = this.mj.continueParsing()) != null) {
                Node n2 = this.mj.preprocess(n);
                Node n3 = this.mj.simplify(n2);
                eqns.add(n3);
            }
            Node topEqn = (Node)eqns.get(eqns.size() - 1);
            Node dx = this.mj.differentiate(topEqn, "x");
            Node dy = this.mj.differentiate(topEqn, "y");
            Vector deps = this.mj.recursiveGetVarsInEquation(topEqn, new Vector());
            deps = this.mj.recursiveGetVarsInEquation(dx, deps);
            deps = this.mj.recursiveGetVarsInEquation(dy, deps);
            Vector<MRpCommandList> coms = new Vector<MRpCommandList>();
            Enumeration en = deps.elements();
            while (en.hasMoreElements()) {
                MatrixVariableI var = (MatrixVariableI)en.nextElement();
                if (var.hasEquation()) {
                    Node eqn = var.getEquation();
                    System.out.print("Compiling " + var.getName() + "=");
                    this.mj.println(eqn);
                    coms.add(this.mrpe.compile(var, eqn));
                    continue;
                }
                System.out.println("Ignoring " + var.getName());
            }
            System.out.print("Compiling ");
            this.mj.println(topEqn);
            coms.add(this.mrpe.compile(topEqn));
            System.out.print("Compiling ");
            this.mj.println(dx);
            coms.add(this.mrpe.compile(dx));
            System.out.print("Compiling ");
            this.mj.println(dy);
            coms.add(this.mrpe.compile(dy));
            int i = 0;
            this.allCommands = new MRpCommandList[coms.size()];
            Enumeration en2 = coms.elements();
            while (en2.hasMoreElements()) {
                this.allCommands[i] = (MRpCommandList)en2.nextElement();
                ++i;
            }
            this.xref = this.mrpe.getVarRef(this.mj.getVar("x"));
            this.yref = this.mrpe.getVarRef(this.mj.getVar("y"));
        }
        catch (ParseException e) {
            e.getMessage();
        }
    }

    public void calcMRPE() {
        double[] topRes = null;
        double[] dxRes = null;
        double[] dyRes = null;
        for (int i = 0; i <= this.xsteps; ++i) {
            double x = this.xmin + (this.xmax - this.xmin) * (double)i / (double)this.xsteps;
            this.mrpe.setVarValue(this.xref, x);
            for (int j = 0; j <= this.ysteps; ++j) {
                double y = this.ymin + (this.ymax - this.ymin) * (double)j / (double)this.ysteps;
                this.mrpe.setVarValue(this.yref, y);
                MRpRes res = null;
                for (int k = 0; k < this.allCommands.length - 3; ++k) {
                    res = this.mrpe.evaluate(this.allCommands[k]);
                }
                res = this.mrpe.evaluate(this.allCommands[this.allCommands.length - 3]);
                topRes = (double[])res.toArray();
                res = this.mrpe.evaluate(this.allCommands[this.allCommands.length - 2]);
                dxRes = (double[])res.toArray();
                res = this.mrpe.evaluate(this.allCommands[this.allCommands.length - 1]);
                dyRes = (double[])res.toArray();
            }
        }
        System.out.println("top [" + (double)topRes[0] + "," + (double)topRes[1] + "," + (double)topRes[2] + "]");
        System.out.println("dx [" + (double)dxRes[0] + "," + (double)dxRes[1] + "," + (double)dxRes[2] + "]");
        System.out.println("dy [" + (double)dyRes[0] + "," + (double)dyRes[1] + "," + (double)dyRes[2] + "]");
    }
}

