/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class FromBase
extends PostfixMathCommand {
    int globalBase = -1;
    String prefix = null;

    public FromBase() {
        this.numberOfParameters = 2;
    }

    public FromBase(int base) {
        this.numberOfParameters = 1;
        this.globalBase = base;
    }

    public FromBase(int base, String prefix) {
        this.numberOfParameters = 1;
        this.globalBase = base;
        this.prefix = prefix;
    }

    @Override
    public void run(Stack s) throws ParseException {
        Object lhs;
        int nargs = this.curNumberOfParameters;
        if (this.globalBase == -1 && nargs != 2) {
            throw new ParseException("fromBase: number of arguments should be 2");
        }
        if (this.globalBase != -1 && nargs != 1) {
            throw new ParseException("fromBase: number of arguments should be 1");
        }
        int base = this.globalBase;
        if (this.globalBase == -1) {
            Object rhs = s.pop();
            if (rhs instanceof Number) {
                base = ((Number)rhs).intValue();
            } else {
                throw new ParseException("toBase: second argument should be an integer");
            }
        }
        if ((lhs = s.pop()) instanceof String) {
            try {
                Object res = this.fromBase((String)lhs, base);
                s.push(res);
                return;
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.getMessage());
            }
        }
        throw new ParseException("fromBase: first arg should be a string");
    }

    public Object fromBase(String str, int base) throws NumberFormatException {
        int ind;
        boolean sign = str.startsWith("-");
        if (sign) {
            str = str.substring(1);
        }
        if (this.prefix != null) {
            if (str.startsWith(this.prefix)) {
                str = str.substring(this.prefix.length());
            } else {
                throw new NumberFormatException("fromBase: string must start with prefix " + this.prefix);
            }
        }
        if ((ind = str.indexOf(46)) == -1) {
            double val = Long.parseLong(str, base);
            if (sign) {
                val = -val;
            }
            return new Double(val);
        }
        String intpart = str.substring(0, ind);
        String fractpart = str.substring(ind + 1);
        long intlong = Long.parseLong(intpart, base);
        double fractlong = Long.parseLong(fractpart, base);
        double val = (double)intlong + fractlong / Math.pow(base, fractpart.length());
        if (sign) {
            val = -val;
        }
        return new Double(val);
    }
}

