/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep;

import org.nfunk.jep.Operator;
import org.nfunk.jep.function.PostfixMathCommandI;

public class XOperator
extends Operator {
    public static final int NO_ARGS = 0;
    public static final int UNARY = 1;
    public static final int BINARY = 2;
    public static final int NARY = 3;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int ASSOCIATIVE = 16;
    public static final int COMMUTATIVE = 32;
    public static final int REFLEXIVE = 64;
    public static final int SYMMETRIC = 128;
    public static final int TRANSITIVE = 256;
    public static final int EQUIVILENCE = 448;
    public static final int PREFIX = 512;
    public static final int SUFIX = 1024;
    public static final int SELF_INVERSE = 2048;
    public static final int COMPOSITE = 4096;
    public static final int USE_BINDING_FOR_PRINT = 8192;
    private int flags;
    private int precedence = -1;
    private Operator[] distribOver = new Operator[0];
    private Operator rootOperator = null;
    private Operator inverseOperator = null;
    private Operator binaryInverseOperator = null;

    public XOperator(String name, PostfixMathCommandI pfmc, int flags) {
        super(name, pfmc);
        this.flags = flags;
    }

    public XOperator(String name, PostfixMathCommandI pfmc, int flags, int precedence) {
        this(name, pfmc, flags);
        this.precedence = precedence;
    }

    public XOperator(String name, String symbol, PostfixMathCommandI pfmc, int flags) {
        super(name, symbol, pfmc);
        this.flags = flags;
    }

    public XOperator(String name, String symbol, PostfixMathCommandI pfmc, int flags, int precedence) {
        super(name, symbol, pfmc);
        this.precedence = precedence;
        this.flags = flags;
    }

    public XOperator(Operator op, int flags, int precedence) {
        this(op.getName(), op.getSymbol(), op.getPFMC(), flags, precedence);
    }

    public XOperator(Operator op, int flags) {
        this(op.getName(), op.getSymbol(), op.getPFMC(), flags);
    }

    public final int getPrecedence() {
        return this.precedence;
    }

    protected final void setPrecedence(int i) {
        this.precedence = i;
    }

    protected final void setDistributiveOver(Operator op) {
        int len = this.distribOver.length;
        Operator[] temp = new Operator[len + 1];
        for (int i = 0; i < len; ++i) {
            temp[i] = this.distribOver[i];
        }
        temp[len] = op;
        this.distribOver = temp;
    }

    public boolean isDistributiveOver(Operator op) {
        for (int i = 0; i < this.distribOver.length; ++i) {
            if (op != this.distribOver[i]) continue;
            return true;
        }
        return false;
    }

    protected void setRootOp(Operator root) {
        this.rootOperator = root;
    }

    protected void setInverseOp(Operator inv) {
        this.inverseOperator = inv;
    }

    protected void setBinaryInverseOp(Operator inv) {
        this.binaryInverseOperator = inv;
    }

    public Operator getRootOp() {
        return this.rootOperator;
    }

    public Operator getInverseOp() {
        return this.inverseOperator;
    }

    public Operator getBinaryInverseOp() {
        return this.binaryInverseOperator;
    }

    public final int getBinding() {
        return this.flags & 0xC;
    }

    public final boolean isAssociative() {
        return (this.flags & 0x10) == 16;
    }

    public final boolean isCommutative() {
        return (this.flags & 0x20) == 32;
    }

    public final boolean isBinary() {
        return (this.flags & 3) == 2;
    }

    public final boolean isUnary() {
        return (this.flags & 3) == 1;
    }

    public final boolean isNary() {
        return (this.flags & 3) == 3;
    }

    public final int numArgs() {
        return this.flags & 3;
    }

    public final boolean isTransitive() {
        return (this.flags & 0x100) == 256;
    }

    public final boolean isSymmetric() {
        return (this.flags & 0x80) == 128;
    }

    public final boolean isReflexive() {
        return (this.flags & 0x40) == 64;
    }

    public final boolean isEquivilence() {
        return (this.flags & 0x1C0) == 448;
    }

    public final boolean isPrefix() {
        return (this.flags & 0x200) == 512;
    }

    public final boolean isSufix() {
        return (this.flags & 0x400) == 1024;
    }

    public final boolean isComposite() {
        return (this.flags & 0x1000) == 4096;
    }

    public final boolean isSelfInverse() {
        return (this.flags & 0x800) == 2048;
    }

    public final boolean useBindingForPrint() {
        return (this.flags & 0x2000) == 8192;
    }

    public String toFullString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Operator: \"" + this.getSymbol() + "\"");
        if (!this.getName().equals(this.getSymbol())) {
            sb.append(" " + this.getName());
        }
        switch (this.numArgs()) {
            case 0: {
                sb.append(" no arguments,");
                break;
            }
            case 1: {
                sb.append(" unary,");
                break;
            }
            case 2: {
                sb.append(" binary,");
                break;
            }
            case 3: {
                sb.append(" variable number of arguments,");
            }
        }
        if (this.isPrefix() && this.isSufix()) {
            sb.append(" trifix,");
        } else if (this.isPrefix()) {
            sb.append(" prefix,");
        } else if (this.isSufix()) {
            sb.append(" sufix,");
        } else {
            sb.append(" infix,");
        }
        if (this.getBinding() == 4) {
            sb.append(" left binding,");
        } else if (this.getBinding() == 8) {
            sb.append(" right binding,");
        }
        if (this.isAssociative()) {
            sb.append(" associative,");
        }
        if (this.isCommutative()) {
            sb.append(" commutative,");
        }
        sb.append(" precedence " + this.getPrecedence() + ",");
        if (this.isEquivilence()) {
            sb.append(" equivilence relation,");
        } else {
            if (this.isReflexive()) {
                sb.append(" reflexive,");
            }
            if (this.isSymmetric()) {
                sb.append(" symmetric,");
            }
            if (this.isTransitive()) {
                sb.append(" transitive,");
            }
        }
        sb.setCharAt(sb.length() - 1, '.');
        return sb.toString();
    }
}

