/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.values;

import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Scaler;

public class MVector
implements MatrixValueI {
    private Object[] data = null;
    private Dimensions dim;

    private MVector() {
    }

    public MVector(int size) {
        this.data = new Object[size];
        this.dim = Dimensions.valueOf(size);
    }

    public static MatrixValueI getInstance(int size) {
        return new MVector(size);
    }

    private static MatrixValueI getInstance(Object[] eles) {
        if (eles.length == 1) {
            return Scaler.getInstance(eles[0]);
        }
        MVector res = new MVector(eles.length);
        for (int i = 0; i < eles.length; ++i) {
            res.setEle(i, eles[i]);
        }
        return res;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        for (int i = 0; i < this.data.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.data[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Dimensions getDim() {
        return this.dim;
    }

    @Override
    public int getNumEles() {
        return this.data.length;
    }

    @Override
    public void setEle(int i, Object value) {
        this.data[i] = value;
    }

    @Override
    public Object getEle(int i) {
        return this.data[i];
    }

    @Override
    public void setEles(MatrixValueI val) {
        if (!this.dim.equals(val.getDim())) {
            return;
        }
        System.arraycopy(((MVector)val).data, 0, this.data, 0, this.getNumEles());
    }

    public Object[] getEles() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MVector)) {
            return false;
        }
        MVector vec = (MVector)obj;
        if (!vec.getDim().equals(this.getDim())) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].equals(vec.data[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        for (int i = 0; i < this.data.length; ++i) {
            result = 37 * result + this.data[i].hashCode();
        }
        return result;
    }

    @Override
    public MatrixValueI copy() {
        MVector tmp = new MVector(this.data.length);
        tmp.setEles(this);
        return tmp;
    }
}

