/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.function;

import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.NaryOperatorI;
import org.lsmp.djep.vectorJep.function.VList;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.EvaluatorI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.CallbackEvaluationI;
import org.nfunk.jep.function.PostfixMathCommand;

public class VMap
extends PostfixMathCommand
implements NaryOperatorI,
CallbackEvaluationI {
    public VMap() {
        this.numberOfParameters = -1;
    }

    @Override
    public Dimensions calcDim(Dimensions[] dims) throws ParseException {
        return dims[2];
    }

    @Override
    public MatrixValueI calcValue(MatrixValueI res, MatrixValueI[] inputs) throws ParseException {
        return null;
    }

    public static Variable[] getVars(Node varsNode) throws ParseException {
        Variable[] vars = null;
        if (varsNode instanceof ASTFunNode && ((ASTFunNode)varsNode).getPFMC() instanceof VList) {
            int nVars = varsNode.jjtGetNumChildren();
            vars = new Variable[nVars];
            for (int i = 0; i < nVars; ++i) {
                Node n = varsNode.jjtGetChild(i);
                if (!(n instanceof ASTVarNode)) {
                    throw new ParseException("Map: second argument should be list of variables");
                }
                vars[i] = ((ASTVarNode)n).getVar();
            }
        } else if (varsNode instanceof ASTVarNode) {
            vars = new Variable[]{((ASTVarNode)varsNode).getVar()};
        } else {
            throw new ParseException("Map: second argument should be a variable or list of variables");
        }
        return vars;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n >= 3;
    }

    @Override
    public Object evaluate(Node node, EvaluatorI pv) throws ParseException {
        int nChild = node.jjtGetNumChildren();
        if (nChild < 3) {
            throw new ParseException("Map must have three or more arguments");
        }
        Variable[] vars = VMap.getVars(node.jjtGetChild(1));
        if (nChild != vars.length + 2) {
            throw new ParseException("Map: number of arguments should match number of variables + 2");
        }
        MatrixValueI[] inputs = new MatrixValueI[nChild - 2];
        Dimensions dim = null;
        for (int i = 0; i < nChild - 2; ++i) {
            Object out = pv.eval(node.jjtGetChild(i + 2));
            if (out instanceof MatrixValueI) {
                inputs[i] = (MatrixValueI)out;
                if (i == 0) {
                    dim = inputs[0].getDim();
                    continue;
                }
                if (dim.equals(inputs[i].getDim())) continue;
                throw new ParseException("Map: dimensions of thrid and subsequent arguments must match");
            }
            throw new ParseException("Map: third and following arguments should be vectos or matricies");
        }
        MatrixValueI res = Tensor.getInstance(dim);
        for (int i = 0; i < dim.numEles(); ++i) {
            for (int j = 0; j < vars.length; ++j) {
                vars[j].setValue(inputs[j].getEle(i));
            }
            Object val = pv.eval(node.jjtGetChild(0));
            res.setEle(i, val);
        }
        return res;
    }
}

