/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.rpe;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import org.lsmp.djep.rpe.RpCommand;
import org.lsmp.djep.rpe.RpCommandList;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.SpecialEvaluationI;

public final class RpEval
implements ParserVisitor {
    private OperatorSet opSet;
    private ScalerStore scalerStore = new ScalerStore();
    double[] constVals = new double[0];
    private RpCommandList curCommandList;
    public static final short CONST = 0;
    public static final short VAR = 1;
    public static final short ADD = 2;
    public static final short SUB = 3;
    public static final short MUL = 4;
    public static final short DIV = 5;
    public static final short MOD = 6;
    public static final short POW = 7;
    public static final short AND = 8;
    public static final short OR = 9;
    public static final short NOT = 10;
    public static final short LT = 11;
    public static final short LE = 12;
    public static final short GT = 13;
    public static final short GE = 14;
    public static final short NE = 15;
    public static final short EQ = 16;
    public static final short LIST = 17;
    public static final short DOT = 18;
    public static final short CROSS = 19;
    public static final short ASSIGN = 20;
    public static final short VLIST = 21;
    public static final short MLIST = 22;
    public static final short FUN = 23;
    public static final short UMINUS = 24;
    private static final short SIN = 1;
    private static final short COS = 2;
    private static final short TAN = 3;
    private static final short ASIN = 4;
    private static final short ACOS = 5;
    private static final short ATAN = 6;
    private static final short SINH = 7;
    private static final short COSH = 8;
    private static final short TANH = 9;
    private static final short ASINH = 10;
    private static final short ACOSH = 11;
    private static final short ATANH = 12;
    private static final short ABS = 13;
    private static final short EXP = 14;
    private static final short LOG = 15;
    private static final short LN = 16;
    private static final short SQRT = 17;
    private static final short SEC = 18;
    private static final short COSEC = 19;
    private static final short COT = 20;
    private static final Hashtable functionHash = new Hashtable();
    private static final double LOG10 = Math.log(10.0);

    public RpEval(JEP jep) {
        functionHash.put("sin", new Short(1));
        functionHash.put("cos", new Short(2));
        functionHash.put("tan", new Short(3));
        functionHash.put("asin", new Short(4));
        functionHash.put("acos", new Short(5));
        functionHash.put("atan", new Short(6));
        functionHash.put("sinh", new Short(7));
        functionHash.put("cosh", new Short(8));
        functionHash.put("tanh", new Short(9));
        functionHash.put("asinh", new Short(10));
        functionHash.put("acosh", new Short(11));
        functionHash.put("atanh", new Short(12));
        functionHash.put("abs", new Short(13));
        functionHash.put("exp", new Short(14));
        functionHash.put("log", new Short(15));
        functionHash.put("ln", new Short(16));
        functionHash.put("sqrt", new Short(17));
        functionHash.put("sec", new Short(18));
        functionHash.put("cosec", new Short(19));
        functionHash.put("cot", new Short(20));
        this.opSet = jep.getOperatorSet();
    }

    private RpEval() {
        functionHash.put("sin", new Short(1));
        functionHash.put("cos", new Short(2));
        functionHash.put("tan", new Short(3));
        functionHash.put("asin", new Short(4));
        functionHash.put("acos", new Short(5));
        functionHash.put("atan", new Short(6));
        functionHash.put("sinh", new Short(7));
        functionHash.put("cosh", new Short(8));
        functionHash.put("tanh", new Short(9));
        functionHash.put("asinh", new Short(10));
        functionHash.put("acosh", new Short(11));
        functionHash.put("atanh", new Short(12));
        functionHash.put("abs", new Short(13));
        functionHash.put("exp", new Short(14));
        functionHash.put("log", new Short(15));
        functionHash.put("ln", new Short(16));
        functionHash.put("sqrt", new Short(17));
        functionHash.put("sec", new Short(18));
        functionHash.put("cosec", new Short(19));
        functionHash.put("cot", new Short(20));
    }

    public final RpCommandList compile(Node node) throws ParseException {
        this.curCommandList = new RpCommandList(this);
        node.jjtAccept(this, null);
        this.scalerStore.alloc();
        return this.curCommandList;
    }

    @Override
    public final Object visit(ASTStart node, Object data) throws ParseException {
        throw new ParseException("RpeEval: Start node encountered");
    }

    @Override
    public final Object visit(SimpleNode node, Object data) throws ParseException {
        throw new ParseException("RpeEval: Simple node encountered");
    }

    @Override
    public final Object visit(ASTConstant node, Object data) throws ParseException {
        Object obj = node.getValue();
        if (!(obj instanceof Double)) {
            throw new ParseException("RpeEval: only constants of double type allowed");
        }
        double val = (Double)node.getValue();
        this.scalerStore.incStack();
        for (short i = 0; i < this.constVals.length; i = (short)(i + 1)) {
            if (val != this.constVals[i]) continue;
            this.curCommandList.addCommand((short)0, i);
            return null;
        }
        double[] newConst = new double[this.constVals.length + 1];
        System.arraycopy(this.constVals, 0, newConst, 0, this.constVals.length);
        newConst[this.constVals.length] = val;
        this.curCommandList.addCommand((short)0, (short)this.constVals.length);
        this.constVals = newConst;
        return null;
    }

    @Override
    public final Object visit(ASTVarNode node, Object data) throws ParseException {
        Variable var = node.getVar();
        short vRef = (short)this.scalerStore.addVar(var);
        this.scalerStore.incStack();
        this.curCommandList.addCommand((short)1, vRef);
        return null;
    }

    @Override
    public final Object visit(ASTFunNode node, Object data) throws ParseException {
        int nChild = node.jjtGetNumChildren();
        if (!(node.getPFMC() instanceof SpecialEvaluationI)) {
            node.childrenAccept(this, null);
        }
        if (node.isOperator()) {
            Operator op = node.getOperator();
            if (op == this.opSet.getAdd()) {
                this.curCommandList.addCommand((short)2);
                this.scalerStore.decStack();
                return null;
            }
            if (op == this.opSet.getSubtract()) {
                this.curCommandList.addCommand((short)3);
                this.scalerStore.decStack();
                return null;
            }
            if (op == this.opSet.getUMinus()) {
                this.curCommandList.addCommand((short)24);
                return null;
            }
            if (op == this.opSet.getMultiply()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)4);
                return null;
            }
            if (op == this.opSet.getAssign()) {
                Node rightnode = node.jjtGetChild(1);
                rightnode.jjtAccept(this, null);
                Variable var = ((ASTVarNode)node.jjtGetChild(0)).getVar();
                short vRef = (short)this.scalerStore.addVar(var);
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)20, vRef);
                return null;
            }
            if (op == this.opSet.getEQ()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)16);
                return null;
            }
            if (op == this.opSet.getNE()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)15);
                return null;
            }
            if (op == this.opSet.getLT()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)11);
                return null;
            }
            if (op == this.opSet.getGT()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)13);
                return null;
            }
            if (op == this.opSet.getLE()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)12);
                return null;
            }
            if (op == this.opSet.getGE()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)14);
                return null;
            }
            if (op == this.opSet.getAnd()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)8);
                return null;
            }
            if (op == this.opSet.getOr()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)9);
                return null;
            }
            if (op == this.opSet.getNot()) {
                this.curCommandList.addCommand((short)10);
                return null;
            }
            if (op == this.opSet.getDivide()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)5);
                return null;
            }
            if (op == this.opSet.getMod()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)6);
                return null;
            }
            if (op == this.opSet.getPower()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)7);
                return null;
            }
            throw new ParseException("RpeEval: Sorry unsupported operator/function: " + node.getName());
        }
        Short val = (Short)functionHash.get(node.getName());
        if (val == null) {
            throw new ParseException("RpeEval: Sorry unsupported operator/function: " + node.getName());
        }
        if (node.getPFMC().getNumberOfParameters() == 1 && nChild == 1) {
            this.curCommandList.addCommand((short)23, val);
            return null;
        }
        throw new ParseException("RpeEval: sorry can currently only support single argument functions");
    }

    public final double evaluate(RpCommandList comList) {
        this.scalerStore.reset();
        int num = comList.getNumCommands();
        block22: for (int commandNum = 0; commandNum < num; commandNum = (int)((short)(commandNum + 1))) {
            RpCommand command = comList.commands[commandNum];
            short aux1 = command.aux1;
            switch (command.command) {
                case 0: {
                    this.scalerStore.stack[this.scalerStore.sp++] = this.constVals[aux1];
                    continue block22;
                }
                case 1: {
                    this.scalerStore.stack[this.scalerStore.sp++] = this.scalerStore.vars[aux1];
                    continue block22;
                }
                case 2: {
                    this.scalerStore.add();
                    continue block22;
                }
                case 3: {
                    this.scalerStore.sub();
                    continue block22;
                }
                case 4: {
                    this.scalerStore.mulS();
                    continue block22;
                }
                case 5: {
                    this.scalerStore.div();
                    continue block22;
                }
                case 6: {
                    this.scalerStore.mod();
                    continue block22;
                }
                case 7: {
                    this.scalerStore.pow();
                    continue block22;
                }
                case 8: {
                    this.scalerStore.and();
                    continue block22;
                }
                case 9: {
                    this.scalerStore.or();
                    continue block22;
                }
                case 10: {
                    this.scalerStore.not();
                    continue block22;
                }
                case 11: {
                    this.scalerStore.lt();
                    continue block22;
                }
                case 12: {
                    this.scalerStore.le();
                    continue block22;
                }
                case 13: {
                    this.scalerStore.gt();
                    continue block22;
                }
                case 14: {
                    this.scalerStore.ge();
                    continue block22;
                }
                case 15: {
                    this.scalerStore.neq();
                    continue block22;
                }
                case 16: {
                    this.scalerStore.eq();
                    continue block22;
                }
                case 20: {
                    this.scalerStore.assign(aux1);
                    continue block22;
                }
                case 23: {
                    this.unitaryFunction(aux1);
                    continue block22;
                }
                case 24: {
                    this.scalerStore.uminus();
                }
            }
        }
        return this.scalerStore.stack[--this.scalerStore.sp];
    }

    private final void unitaryFunction(short fun) {
        double r = this.scalerStore.stack[--this.scalerStore.sp];
        switch (fun) {
            case 1: {
                r = Math.sin(r);
                break;
            }
            case 2: {
                r = Math.cos(r);
                break;
            }
            case 3: {
                r = Math.tan(r);
                break;
            }
            case 4: {
                r = Math.asin(r);
                break;
            }
            case 5: {
                r = Math.acos(r);
                break;
            }
            case 6: {
                r = Math.atan(r);
                break;
            }
            case 7: {
                r = (Math.exp(r) - Math.exp(-r)) / 2.0;
                break;
            }
            case 8: {
                r = (Math.exp(r) + Math.exp(-r)) / 2.0;
                break;
            }
            case 9: {
                double ex = Math.exp(r * 2.0);
                r = (ex - 1.0) / (ex + 1.0);
                break;
            }
            case 10: {
                r = Math.log(r + Math.sqrt(1.0 + r * r));
                break;
            }
            case 11: {
                r = Math.log(r + Math.sqrt(r * r - 1.0));
                break;
            }
            case 12: {
                r = Math.log((1.0 + r) / (1.0 - r)) / 2.0;
                break;
            }
            case 13: {
                r = Math.abs(r);
                break;
            }
            case 14: {
                r = Math.exp(r);
                break;
            }
            case 15: {
                r = Math.log(r) / LOG10;
                break;
            }
            case 16: {
                r = Math.log(r);
                break;
            }
            case 17: {
                r = Math.sqrt(r);
                break;
            }
            case 18: {
                r = 1.0 / Math.cos(r);
                break;
            }
            case 19: {
                r = 1.0 / Math.sin(r);
                break;
            }
            case 20: {
                r = 1.0 / Math.tan(r);
            }
        }
        this.scalerStore.stack[this.scalerStore.sp++] = r;
    }

    public void cleanUp() {
        this.scalerStore.cleanUp();
    }

    public Variable getVariable(int ref) {
        return this.scalerStore.getVariable(ref);
    }

    public String getFunction(short ref) {
        switch (ref) {
            case 1: {
                return "sin";
            }
            case 2: {
                return "cos";
            }
            case 3: {
                return "tan";
            }
            case 4: {
                return "asin";
            }
            case 5: {
                return "acos";
            }
            case 6: {
                return "atan";
            }
            case 7: {
                return "sinh";
            }
            case 8: {
                return "cosh";
            }
            case 9: {
                return "tanh";
            }
            case 10: {
                return "asinh";
            }
            case 11: {
                return "acosh";
            }
            case 12: {
                return "atanh";
            }
            case 13: {
                return "abs";
            }
            case 14: {
                return "exp";
            }
            case 15: {
                return "log";
            }
            case 16: {
                return "ln";
            }
            case 17: {
                return "sqrt";
            }
            case 18: {
                return "sec";
            }
            case 19: {
                return "cosec";
            }
            case 20: {
                return "cot";
            }
        }
        return null;
    }

    private final class ScalerStore
    extends ObjStore {
        double[] stack;
        double[] vars;

        private ScalerStore() {
            this.stack = new double[0];
            this.vars = new double[0];
        }

        @Override
        final void alloc() {
            this.stack = new double[this.stackMax];
        }

        @Override
        final void expandVarArray(int size) {
            double[] newvars = new double[size];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            this.vars = newvars;
        }

        @Override
        final void copyFromVar(Variable var, int i) {
            if (var.hasValidValue()) {
                Double val = (Double)var.getValue();
                this.vars[i] = val;
            }
        }

        @Override
        final void add() {
            double r = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] + r;
        }

        @Override
        final void sub() {
            double r = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] - r;
        }

        final void uminus() {
            double r = this.stack[--this.sp];
            this.stack[this.sp++] = -r;
        }

        @Override
        final void mulS() {
            double r = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] * r;
        }

        final void div() {
            double r = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] / r;
        }

        final void mod() {
            double r = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] % r;
        }

        final void pow() {
            double r = this.stack[--this.sp];
            double l = this.stack[--this.sp];
            this.stack[this.sp++] = Math.pow(l, r);
        }

        final void powN(int n) {
            double r = this.stack[--this.sp];
            switch (n) {
                case 0: {
                    r = 1.0;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    r *= r;
                    break;
                }
                case 3: {
                    r *= r * r;
                    break;
                }
                case 4: {
                    r *= r * r * r;
                    break;
                }
                case 5: {
                    r *= r * r * r * r;
                    break;
                }
                default: {
                    r = Math.pow(r, n);
                }
            }
            this.stack[this.sp++] = r;
        }

        @Override
        final void assign(int i) {
            this.vars[i] = this.stack[--this.sp];
            ++this.sp;
        }

        final void and() {
            double l;
            double r = this.stack[--this.sp];
            this.stack[this.sp++] = (l = this.stack[--this.sp]) != 0.0 && r != 0.0 ? 1.0 : 0.0;
        }

        final void or() {
            double l;
            double r = this.stack[--this.sp];
            this.stack[this.sp++] = (l = this.stack[--this.sp]) != 0.0 || r != 0.0 ? 1.0 : 0.0;
        }

        final void not() {
            double r;
            this.stack[this.sp++] = (r = this.stack[--this.sp]) == 0.0 ? 1.0 : 0.0;
        }

        final void lt() {
            double r;
            double l;
            this.stack[this.sp++] = (l = this.stack[--this.sp]) < (r = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void gt() {
            double r;
            double l;
            this.stack[this.sp++] = (l = this.stack[--this.sp]) > (r = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void le() {
            double r;
            double l;
            this.stack[this.sp++] = (l = this.stack[--this.sp]) <= (r = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void ge() {
            double r;
            double l;
            this.stack[this.sp++] = (l = this.stack[--this.sp]) >= (r = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void eq() {
            double r;
            double l;
            this.stack[this.sp++] = (l = this.stack[--this.sp]) == (r = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void neq() {
            double r;
            double l;
            this.stack[this.sp++] = (l = this.stack[--this.sp]) != (r = this.stack[--this.sp]) ? 1.0 : 0.0;
        }
    }

    private static abstract class ObjStore
    implements Observer {
        Hashtable varRefs = new Hashtable();
        int sp = 0;
        int stackMax = 0;

        private ObjStore() {
        }

        final void incStack() {
            ++this.sp;
            if (this.sp > this.stackMax) {
                this.stackMax = this.sp;
            }
        }

        final void decStack() throws ParseException {
            --this.sp;
            if (this.sp < 0) {
                throw new ParseException("RPEval: stack error");
            }
        }

        final void reset() {
            this.sp = 0;
        }

        final int addVar(Variable var) {
            Object index = this.varRefs.get(var);
            if (index == null) {
                int size = this.varRefs.size();
                this.expandVarArray(size + 1);
                this.varRefs.put(var, new Integer(size));
                this.copyFromVar(var, size);
                var.addObserver(this);
                return size;
            }
            return (Integer)index;
        }

        @Override
        public final void update(Observable obs, Object arg1) {
            Variable var = (Variable)obs;
            Object index = this.varRefs.get(var);
            this.copyFromVar(var, (Integer)index);
        }

        abstract void alloc();

        final void cleanUp() {
            Enumeration e = this.varRefs.keys();
            while (e.hasMoreElements()) {
                Variable var = (Variable)e.nextElement();
                var.deleteObserver(this);
            }
            this.varRefs.clear();
        }

        abstract void copyFromVar(Variable var1, int var2);

        abstract void expandVarArray(int var1);

        abstract void add();

        abstract void sub();

        abstract void mulS();

        abstract void assign(int var1);

        Variable getVariable(int ref) {
            Enumeration en = this.varRefs.keys();
            while (en.hasMoreElements()) {
                Variable var = (Variable)en.nextElement();
                Integer index = (Integer)this.varRefs.get(var);
                if (index != ref) continue;
                return var;
            }
            return null;
        }
    }
}

