/*
 * Decompiled with CFR 0.152.
 */
package ij.util;

import ij.plugin.MacroInstaller;
import ij.process.FloatProcessor;
import ij.process.ImageStatistics;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;

public class Tools {
    public static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String c2hex(Color c) {
        int i = c.getRGB();
        char[] buf7 = new char[7];
        buf7[0] = 35;
        for (int pos = 6; pos >= 1; --pos) {
            buf7[pos] = hexDigits[i & 0xF];
            i >>>= 4;
        }
        return new String(buf7);
    }

    public static String f2hex(float f) {
        int i = Float.floatToIntBits(f);
        char[] buf9 = new char[9];
        buf9[0] = 35;
        for (int pos = 8; pos >= 1; --pos) {
            buf9[pos] = hexDigits[i & 0xF];
            i >>>= 4;
        }
        return new String(buf9);
    }

    public static String int2hex(int i, int digits) {
        char[] buf = new char[digits];
        for (int pos = buf.length - 1; pos >= 0; --pos) {
            buf[pos] = hexDigits[i & 0xF];
            i >>>= 4;
        }
        return new String(buf);
    }

    public static ImageStatistics getStatistics(double[] a) {
        FloatProcessor ip = new FloatProcessor(a.length, 1, a);
        return ip.getStats();
    }

    public static double[] getMinMax(double[] a) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < a.length; ++i) {
            double value = a[i];
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        double[] minAndMax = new double[]{min, max};
        return minAndMax;
    }

    public static double[] getMinMax(float[] a) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < a.length; ++i) {
            double value = a[i];
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        double[] minAndMax = new double[]{min, max};
        return minAndMax;
    }

    public static double[] toDouble(float[] a) {
        int len = a.length;
        double[] d = new double[len];
        for (int i = 0; i < len; ++i) {
            d[i] = a[i];
        }
        return d;
    }

    public static float[] toFloat(double[] a) {
        if (a == null) {
            return null;
        }
        int len = a.length;
        float[] f = new float[len];
        for (int i = 0; i < len; ++i) {
            f[i] = (float)a[i];
        }
        return f;
    }

    public static void addToArray(float[] a, float value) {
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] + value;
        }
    }

    public static String fixNewLines(String s) {
        if (s == null) {
            return null;
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\r') continue;
            chars[i] = 10;
        }
        return new String(chars);
    }

    public static double parseDouble(String s, double defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            defaultValue = Double.parseDouble(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static double parseDouble(String s) {
        return Tools.parseDouble(s, Double.NaN);
    }

    public static int getDecimalPlaces(double n) {
        if ((double)((int)n) == n || Double.isNaN(n)) {
            return 0;
        }
        String s = "" + n;
        if (s.contains("E")) {
            return -2;
        }
        while (s.endsWith("0")) {
            s = s.substring(0, s.length() - 1);
        }
        int index = s.indexOf(".");
        if (index == -1) {
            return 0;
        }
        int digits = s.length() - index - 1;
        if (digits > 4) {
            digits = 4;
        }
        return digits;
    }

    public static int getDecimalPlaces(double n1, double n2) {
        if ((double)((int)n1) == n1 && (double)((int)n2) == n2) {
            return 0;
        }
        int digits = Tools.getDecimalPlaces(n1);
        int digits2 = Tools.getDecimalPlaces(n2);
        if (digits == 0) {
            return digits2;
        }
        if (digits2 == 0) {
            return digits;
        }
        if (digits < 0 || digits2 < 0) {
            return digits;
        }
        if (digits2 > digits) {
            digits = digits2;
        }
        return digits;
    }

    public static String[] split(String str) {
        return Tools.split(str, " \t\n\r");
    }

    public static String[] split(String str, String delim) {
        String[] strings;
        if (delim.equals("\n")) {
            return Tools.splitLines(str);
        }
        StringTokenizer t = new StringTokenizer(str, delim);
        int tokens = t.countTokens();
        if (tokens > 0) {
            strings = new String[tokens];
            for (int i = 0; i < tokens; ++i) {
                strings[i] = t.nextToken();
            }
        } else {
            strings = new String[]{};
        }
        return strings;
    }

    static String[] splitLines(String str) {
        Vector<String> v = new Vector<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new StringReader(str));
            while ((line = br.readLine()) != null) {
                v.addElement(line);
            }
            br.close();
        }
        catch (Exception br) {
            // empty catch block
        }
        Object[] lines = new String[v.size()];
        v.copyInto(lines);
        return lines;
    }

    public static int[] rank(double[] values) {
        int n = values.length;
        Integer[] indexes = new Integer[n];
        final Double[] data = new Double[n];
        for (int i = 0; i < n; ++i) {
            indexes[i] = new Integer(i);
            data[i] = new Double(values[i]);
        }
        Arrays.sort(indexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return data[o1].compareTo(data[o2]);
            }
        });
        int[] indexes2 = new int[n];
        for (int i = 0; i < n; ++i) {
            indexes2[i] = indexes[i];
        }
        return indexes2;
    }

    public static int[] rank(final String[] data) {
        int n = data.length;
        Integer[] indexes = new Integer[n];
        for (int i = 0; i < n; ++i) {
            indexes[i] = new Integer(i);
        }
        Arrays.sort(indexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return data[o1].compareToIgnoreCase(data[o2]);
            }
        });
        int[] indexes2 = new int[n];
        for (int i = 0; i < n; ++i) {
            indexes2[i] = indexes[i];
        }
        return indexes2;
    }

    public static double[] resampleArray(double[] y1, int len2) {
        int jj;
        int len1 = y1.length;
        double factor = (double)(len2 - 1) / (double)(len1 - 1);
        double[] y2 = new double[len2];
        if (len1 == 0) {
            return y2;
        }
        if (len1 == 1) {
            for (int jj2 = 0; jj2 < len2; ++jj2) {
                y2[jj2] = y1[0];
            }
            return y2;
        }
        double[] f1 = new double[len1];
        double[] f2 = new double[len2];
        for (jj = 0; jj < len1; ++jj) {
            f1[jj] = (double)jj * factor;
        }
        for (jj = 0; jj < len2; ++jj) {
            f2[jj] = (double)jj / factor;
        }
        for (jj = 0; jj < len2 - 1; ++jj) {
            double value;
            double pos = f2[jj];
            int leftPos = (int)Math.floor(pos);
            int rightPos = (int)Math.floor(pos) + 1;
            double fraction = pos - Math.floor(pos);
            y2[jj] = value = y1[leftPos] + fraction * (y1[rightPos] - y1[leftPos]);
        }
        y2[len2 - 1] = y1[len1 - 1];
        return y2;
    }

    public static String openFromIJJarAsString(String path) {
        return new MacroInstaller().openFromIJJar(path);
    }

    public static String copyFile(String path1, String path2) {
        File f1 = new File(path1);
        File f2 = new File(path2);
        try {
            if (!f1.exists()) {
                return "Source file does not exist";
            }
            if (!f2.exists()) {
                f2.createNewFile();
            }
            long time = f1.lastModified();
            FileInputStream stream1 = new FileInputStream(f1);
            FileChannel channel1 = stream1.getChannel();
            FileOutputStream stream2 = new FileOutputStream(f2);
            FileChannel channel2 = stream2.getChannel();
            if (channel2 != null && channel1 != null) {
                channel2.transferFrom(channel1, 0L, channel1.size());
            }
            channel1.close();
            stream1.close();
            channel2.close();
            stream2.close();
            f2.setLastModified(time);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return "";
    }

    public static double getNumberFromList(String list, String key) {
        return Tools.getNumberFromList(list, key, Double.NaN);
    }

    public static double getNumberFromList(String list, String key, double defaultValue) {
        int start;
        int n;
        if (list == null) {
            return defaultValue;
        }
        int i = list.indexOf(key);
        if (i < 0) {
            return defaultValue;
        }
        for (n = start = i + key.length(); n < list.length() && !Tools.isDelimiter(list.charAt(n)); ++n) {
        }
        double value = Tools.parseDouble(list.substring(start, n));
        return Double.isNaN(value) ? defaultValue : value;
    }

    public static String getStringFromList(String list, String key) {
        return Tools.getStringFromList(list, key, null);
    }

    public static String getStringFromList(String list, String key, String defaultValue) {
        String str;
        boolean hasQuotes;
        if (list == null) {
            return defaultValue;
        }
        int i = list.indexOf(key);
        if (i < 0) {
            return defaultValue;
        }
        int start = i + key.length();
        if (list.length() == start) {
            return "";
        }
        char quote = list.charAt(start);
        boolean bl = hasQuotes = quote == '\'' || quote == '\"';
        if (hasQuotes) {
            ++start;
        }
        if ((str = Tools.decodeEscaped(list.substring(start), hasQuotes ? quote : (char)'\ufffe')) == null) {
            str = defaultValue;
        }
        return str;
    }

    public static String decodeEscaped(String str, char delim) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (delim == '\ufffe' && Tools.isDelimiter(c) || c == delim) break;
            if (c == '\\' && i + 1 < str.length()) {
                if ((c = str.charAt(++i)) == 'u' && i + 4 < str.length()) {
                    try {
                        c = (char)Integer.parseInt(str.substring(i + 1, i + 5), 16);
                        i += 4;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    c = Tools.withBackslash(c);
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isDelimiter(char c) {
        return Character.isWhitespace(c) || c == ',' || c == ';';
    }

    private static char withBackslash(char c) {
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case 'n': {
                return '\n';
            }
        }
        return c;
    }

    public static String getHash(String method, boolean fromFile, String pathOrString) {
        method = method.toUpperCase();
        boolean md5 = method.contains("MD5");
        boolean sha_256 = method.contains("SHA-256");
        try {
            MessageDigest digest = null;
            if (md5) {
                digest = MessageDigest.getInstance("MD5");
            } else if (sha_256) {
                digest = MessageDigest.getInstance("SHA-256");
            } else {
                return "0";
            }
            Path path = Paths.get(pathOrString, new String[0]);
            byte[] encodedhash = fromFile ? digest.digest(Files.readAllBytes(path)) : digest.digest(pathOrString.getBytes());
            return Tools.bytesToHex(encodedhash);
        }
        catch (Exception exception) {
            return "0";
        }
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

