/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;

public class BinaryInterpolator {
    int[][] idt;
    int w;
    int h;

    public void run(ImagePlus image, Roi[] rois) {
        int i;
        this.w = image.getWidth();
        this.h = image.getHeight();
        ImageStack stack = new ImageStack(this.w, this.h);
        int firstIndex = -1;
        int lastIndex = -1;
        for (i = 1; i < rois.length; ++i) {
            if (rois[i] == null) continue;
            firstIndex = firstIndex == -1 ? i : firstIndex;
            lastIndex = i;
        }
        if (firstIndex == -1) {
            IJ.error("There must be at least one selection in order to interpolate.");
            return;
        }
        for (i = firstIndex; i <= lastIndex; ++i) {
            ByteProcessor bp = new ByteProcessor(this.w, this.h);
            if (rois[i] != null) {
                bp.copyBits(rois[i].getMask(), rois[i].getBounds().x, rois[i].getBounds().y, 3);
            }
            stack.addSlice("", bp);
        }
        this.run(stack);
        ImagePlus roiImage = new ImagePlus("bla", stack);
        ThresholdToSelection ts = new ThresholdToSelection();
        ts.setup("", roiImage);
        for (int i2 = firstIndex; i2 <= lastIndex; ++i2) {
            ImageProcessor bp = stack.getProcessor(1);
            stack.deleteSlice(1);
            int threshold = 255;
            bp.setThreshold(threshold, threshold, 2);
            ts.run(bp);
            rois[i2] = roiImage.getRoi();
        }
    }

    public void run(ImageStack stack) {
        int sliceCount = stack.size();
        if (sliceCount < 3) {
            IJ.error("Too few slices to interpolate!");
            return;
        }
        IJ.showStatus("getting signed integer distance transform");
        this.w = stack.getWidth();
        this.h = stack.getHeight();
        this.idt = new int[sliceCount][];
        int first = sliceCount;
        int last = -1;
        for (int z = 0; z < sliceCount; ++z) {
            this.idt[z] = this.getIDT(stack.getProcessor(z + 1).getPixels());
            if (this.idt[z] == null) continue;
            if (z < first) {
                first = z;
            }
            last = z;
        }
        if (first == last || last < 0) {
            IJ.error("Not enough to interpolate");
            return;
        }
        IJ.showStatus("calculating weights");
        int current = 0;
        int next = first;
        for (int z = first; z < last; ++z) {
            if (z == next) {
                current = z;
                next = z + 1;
                while (this.idt[next] == null) {
                    ++next;
                }
                continue;
            }
            byte[] p = (byte[])stack.getProcessor(z + 1).getPixels();
            for (int i = 0; i < this.w * this.h; ++i) {
                if (0 > this.idt[current][i] * (next - z) + this.idt[next][i] * (z - current)) continue;
                p[i] = -1;
            }
            IJ.showProgress(z - first + 1, last - z);
        }
    }

    int[] getIDT(Object pixels) {
        IDT idt = new IDT();
        if (idt.init((byte[])pixels) == 0) {
            return null;
        }
        idt.propagate();
        return idt.result;
    }

    final boolean isBoundary(byte[] pixels, int x, int y) {
        if (pixels[x + this.w * y] == 0) {
            return false;
        }
        if (x <= 0 || pixels[x - 1 + this.w * y] == 0) {
            return true;
        }
        if (x >= this.w - 1 || pixels[x + 1 + this.w * y] == 0) {
            return true;
        }
        if (y <= 0 || pixels[x + this.w * (y - 1)] == 0) {
            return true;
        }
        if (y >= this.h - 1 || pixels[x + this.w * (y + 1)] == 0) {
            return true;
        }
        if (x <= 0 || y <= 0 || pixels[x - 1 + this.w * (y - 1)] == 0) {
            return true;
        }
        if (x <= 0 || y >= this.h - 1 || pixels[x - 1 + this.w * (y + 1)] == 0) {
            return true;
        }
        if (x >= this.w - 1 || y <= 0 || pixels[x + 1 + this.w * (y - 1)] == 0) {
            return true;
        }
        return x >= this.w - 1 || y >= this.h - 1 || pixels[x + 1 + this.w * (y + 1)] == 0;
    }

    final boolean isJustOutside(byte[] pixels, int x, int y) {
        if (pixels[x + this.w * y] != 0) {
            return false;
        }
        if (x > 0 && pixels[x - 1 + this.w * y] != 0) {
            return true;
        }
        if (x < this.w - 1 && pixels[x + 1 + this.w * y] != 0) {
            return true;
        }
        if (y > 0 && pixels[x + this.w * (y - 1)] != 0) {
            return true;
        }
        if (y < this.h - 1 && pixels[x + this.w * (y + 1)] != 0) {
            return true;
        }
        if (x > 0 && y > 0 && pixels[x - 1 + this.w * (y - 1)] != 0) {
            return true;
        }
        if (x > 0 && y < this.h - 1 && pixels[x - 1 + this.w * (y + 1)] != 0) {
            return true;
        }
        if (x < this.w - 1 && y > 0 && pixels[x + 1 + this.w * (y - 1)] != 0) {
            return true;
        }
        return x < this.w - 1 && y < this.h - 1 && pixels[x + 1 + this.w * (y + 1)] != 0;
    }

    class IDT {
        int[] result;

        IDT() {
            this.result = new int[BinaryInterpolator.this.w * BinaryInterpolator.this.h];
            int infinity = (BinaryInterpolator.this.w + BinaryInterpolator.this.h) * 9;
            for (int i = 0; i < this.result.length; ++i) {
                this.result[i] = infinity;
            }
        }

        int init(byte[] p) {
            int count = 0;
            for (int j = 0; j < BinaryInterpolator.this.h; ++j) {
                for (int i = 0; i < BinaryInterpolator.this.w; ++i) {
                    int idx = i + BinaryInterpolator.this.w * j;
                    if (BinaryInterpolator.this.isBoundary(p, i, j)) {
                        this.result[idx] = 0;
                        ++count;
                        continue;
                    }
                    if (!BinaryInterpolator.this.isJustOutside(p, i, j)) continue;
                    this.result[idx] = -1;
                }
            }
            return count;
        }

        final void idt(int x, int y, int dx, int dy) {
            if (x + dx < 0 || y + dy < 0 || x + dx >= BinaryInterpolator.this.w || y + dy >= BinaryInterpolator.this.h) {
                return;
            }
            int value = this.result[x + dx + BinaryInterpolator.this.w * (y + dy)];
            int distance = dx == 0 || dy == 0 ? 3 : 4;
            if (Math.abs(this.result[x + BinaryInterpolator.this.w * y]) > Math.abs(value += distance * (value < 0 ? -1 : 1))) {
                this.result[x + BinaryInterpolator.this.w * y] = value;
            }
        }

        void propagate() {
            int j;
            int i;
            int i2;
            int j2;
            for (j2 = 0; j2 < BinaryInterpolator.this.h; ++j2) {
                for (i2 = 0; i2 < BinaryInterpolator.this.w; ++i2) {
                    this.idt(i2, j2, -1, 0);
                    this.idt(i2, j2, -1, -1);
                    this.idt(i2, j2, 0, -1);
                }
            }
            for (j2 = BinaryInterpolator.this.h - 1; j2 >= 0; --j2) {
                for (i2 = BinaryInterpolator.this.w - 1; i2 >= 0; --i2) {
                    this.idt(i2, j2, 1, 0);
                    this.idt(i2, j2, 1, 1);
                    this.idt(i2, j2, 0, 1);
                }
            }
            for (i = BinaryInterpolator.this.w - 1; i >= 0; --i) {
                for (j = BinaryInterpolator.this.h - 1; j >= 0; --j) {
                    this.idt(i, j, 1, 0);
                    this.idt(i, j, 1, 1);
                    this.idt(i, j, 0, 1);
                }
            }
            for (i = 0; i < BinaryInterpolator.this.w; ++i) {
                for (j = 0; j < BinaryInterpolator.this.h; ++j) {
                    this.idt(i, j, -1, 0);
                    this.idt(i, j, -1, -1);
                    this.idt(i, j, 0, -1);
                }
            }
        }
    }
}

