/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.plugin.TextReader;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class XY_Reader
implements PlugIn {
    @Override
    public void run(String arg) {
        TextReader tr = new TextReader();
        ImageProcessor ip = tr.open();
        if (ip == null) {
            return;
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        if (width != 2 || height < 3) {
            IJ.showMessage("XY Reader", "Two column text file required");
            return;
        }
        float[] x = new float[height];
        float[] y = new float[height];
        boolean allIntegers = true;
        double length = 0.0;
        for (int i = 0; i < height; ++i) {
            x[i] = ip.getf(0, i);
            y[i] = ip.getf(1, i);
            if ((float)((int)x[i]) != x[i] || (float)((int)y[i]) != y[i]) {
                allIntegers = false;
            }
            if (i <= 0) continue;
            double dx = x[i] - x[i - 1];
            double dy = y[i] - y[i - 1];
            length += Math.sqrt(dx * dx + dy * dy);
        }
        PolygonRoi roi = null;
        int type = length / (double)x.length > 10.0 ? 2 : 3;
        roi = allIntegers ? new PolygonRoi(Roi.toIntR(x), Roi.toIntR(y), height, type) : new PolygonRoi(x, y, height, type);
        Rectangle r = roi.getBoundingRect();
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null || imp.getWidth() < r.x + r.width || imp.getHeight() < r.y + r.height) {
            new ImagePlus(tr.getName(), new ByteProcessor(Math.abs(r.x) + r.width + 10, Math.abs(r.y) + r.height + 10)).show();
            imp = WindowManager.getCurrentImage();
        }
        if (imp != null) {
            imp.setRoi(roi);
        }
    }
}

