/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.Prefs;
import ij.gui.GUI;
import ij.gui.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class MessageDialog
extends Dialog
implements ActionListener,
KeyListener,
WindowListener {
    protected Button button;
    protected MultiLineLabel label;
    private boolean escapePressed;

    public MessageDialog(Frame parent, String title, String message) {
        super(parent, title, true);
        this.setLayout(new BorderLayout());
        if (message == null) {
            message = "";
        }
        Font font = null;
        double scale = Prefs.getGuiScale();
        if (scale > 1.0) {
            font = this.getFont();
            font = font != null ? font.deriveFont((float)((double)font.getSize() * scale)) : new Font("SansSerif", 0, (int)(12.0 * scale));
            this.setFont(font);
        }
        this.label = new MultiLineLabel(message);
        if (font != null) {
            this.label.setFont(font);
        } else if (!IJ.isLinux()) {
            this.label.setFont(new Font("SansSerif", 0, 14));
        }
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 15, 15));
        panel.add(this.label);
        this.add("Center", panel);
        this.button = new Button("  OK  ");
        this.button.addActionListener(this);
        this.button.addKeyListener(this);
        panel = new Panel();
        panel.setLayout(new FlowLayout());
        panel.add(this.button);
        this.add("South", panel);
        if (IJ.isMacintosh()) {
            this.setResizable(false);
        }
        this.pack();
        GUI.centerOnImageJScreen(this);
        this.addWindowListener(this);
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        IJ.setKeyDown(keyCode);
        boolean bl = this.escapePressed = keyCode == 27;
        if (keyCode == 10 || this.escapePressed) {
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        IJ.setKeyUp(keyCode);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    public boolean escapePressed() {
        return this.escapePressed;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

