/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.CompositeImage;
import ij.Executer;
import ij.IJEventListener;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.HTMLDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.MessageDialog;
import ij.gui.NewImage;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.gui.Wand;
import ij.gui.YesNoCancelDialog;
import ij.io.DirectoryChooser;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.io.LogStream;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.PluginClassLoader;
import ij.io.SaveDialog;
import ij.macro.Interpreter;
import ij.macro.MacroRunner;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.BatchProcessor;
import ij.plugin.Colors;
import ij.plugin.FileInfoVirtualStack;
import ij.plugin.GifWriter;
import ij.plugin.HyperStackMaker;
import ij.plugin.JpegWriter;
import ij.plugin.Macro_Runner;
import ij.plugin.Memory;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.ThresholdAdjuster;
import ij.process.AutoThresholder;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.StackStatistics;
import ij.text.TextPanel;
import ij.text.TextWindow;
import ij.util.Tools;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class IJ {
    public static Font font10 = new Font("SansSerif", 0, 10);
    public static Font font12 = ImageJ.SansSerif12;
    public static final int COMPOSITE = 1;
    public static final int COLOR = 2;
    public static final int GRAYSCALE = 3;
    public static final String URL = "http://imagej.nih.gov/ij";
    public static final int ALL_KEYS = -1;
    public static boolean debugMode;
    public static boolean hideProcessStackDialog;
    public static final char micronSymbol = '\u00b5';
    public static final char angstromSymbol = '\u00c5';
    public static final char degreeSymbol = '\u00b0';
    private static ImageJ ij;
    private static Applet applet;
    private static ProgressBar progressBar;
    private static TextPanel textPanel;
    private static String osname;
    private static String osarch;
    private static boolean isMac;
    private static boolean isWin;
    private static boolean isLinux;
    private static boolean is64Bit;
    private static int javaVersion;
    private static boolean controlDown;
    private static boolean altDown;
    private static boolean spaceDown;
    private static boolean shiftDown;
    private static boolean macroRunning;
    private static Thread previousThread;
    private static TextPanel logPanel;
    private static boolean checkForDuplicatePlugins;
    private static ClassLoader classLoader;
    private static boolean memMessageDisplayed;
    private static long maxMemory;
    private static boolean escapePressed;
    private static boolean redirectErrorMessages;
    private static boolean suppressPluginNotFoundError;
    private static Hashtable commandTable;
    private static Vector eventListeners;
    private static String lastErrorMessage;
    private static Properties properties;
    private static DecimalFormat[] df;
    private static DecimalFormat[] sf;
    private static DecimalFormatSymbols dfs;
    private static boolean trustManagerCreated;
    private static String smoothMacro;
    private static Interpreter macroInterpreter;
    private static boolean protectStatusBar;
    private static Thread statusBarThread;
    public static final int CANCELED = Integer.MIN_VALUE;
    static ExceptionHandler exceptionHandler;

    static void init(ImageJ imagej, Applet theApplet) {
        ij = imagej;
        applet = theApplet;
        progressBar = ij.getProgressBar();
    }

    static void cleanup() {
        ij = null;
        applet = null;
        progressBar = null;
        textPanel = null;
    }

    public static ImageJ getInstance() {
        return ij;
    }

    public static void setDebugMode(boolean b) {
        debugMode = b;
        LogStream.redirectSystem(debugMode);
    }

    public static String runMacro(String macro) {
        return IJ.runMacro(macro, "");
    }

    public static String runMacro(String macro, String arg) {
        Macro_Runner mr = new Macro_Runner();
        return mr.runMacro(macro, arg);
    }

    public static String runMacroFile(String name, String arg) {
        Macro_Runner mr = new Macro_Runner();
        return mr.runMacroFile(name, arg);
    }

    public static String runMacroFile(String name) {
        return IJ.runMacroFile(name, null);
    }

    public static Object runPlugIn(ImagePlus imp, String className, String arg) {
        if (imp != null) {
            ImagePlus temp = WindowManager.getTempCurrentImage();
            WindowManager.setTempCurrentImage(imp);
            Object o = IJ.runPlugIn("", className, arg);
            WindowManager.setTempCurrentImage(temp);
            return o;
        }
        return IJ.runPlugIn(className, arg);
    }

    public static Object runPlugIn(String className, String arg) {
        return IJ.runPlugIn("", className, arg);
    }

    public static Object runPlugIn(String commandName, String className, String arg) {
        if (arg == null) {
            arg = "";
        }
        if (debugMode) {
            IJ.log("runPlugIn: " + className + IJ.argument(arg));
        }
        if (!className.startsWith("ij.") && applet == null) {
            return IJ.runUserPlugIn(commandName, className, arg, false);
        }
        Object thePlugIn = null;
        try {
            Class<?> c = Class.forName(className);
            thePlugIn = c.newInstance();
            if (thePlugIn instanceof PlugIn) {
                ((PlugIn)thePlugIn).run(arg);
            } else {
                new PlugInFilterRunner(thePlugIn, commandName, arg);
            }
        }
        catch (ClassNotFoundException e) {
            IJ.log("Plugin or class not found: \"" + className + "\"\n(" + e + ")");
            String path = Prefs.getCustomPropsPath();
            if (path != null) {
                // empty if block
            }
            IJ.log("Error may be due to custom properties at " + path);
        }
        catch (InstantiationException e) {
            IJ.log("Unable to load plugin (ins)");
        }
        catch (IllegalAccessException e) {
            IJ.log("Unable to load plugin, possibly \nbecause it is not public.");
        }
        redirectErrorMessages = false;
        return thePlugIn;
    }

    static Object runUserPlugIn(String commandName, String className, String arg, boolean createNewLoader) {
        if (debugMode) {
            IJ.log("runUserPlugIn: " + className + ", arg=" + IJ.argument(arg));
        }
        if (applet != null) {
            return null;
        }
        if (checkForDuplicatePlugins) {
            IJ.runPlugIn("ij.plugin.ClassChecker", "");
            checkForDuplicatePlugins = false;
        }
        if (createNewLoader) {
            classLoader = null;
        }
        ClassLoader loader = IJ.getClassLoader();
        Object thePlugIn = null;
        try {
            thePlugIn = loader.loadClass(className).newInstance();
            if (thePlugIn instanceof PlugIn) {
                ((PlugIn)thePlugIn).run(arg);
            } else if (thePlugIn instanceof PlugInFilter) {
                new PlugInFilterRunner(thePlugIn, commandName, arg);
            }
        }
        catch (ClassNotFoundException e) {
            if (className.startsWith("macro:")) {
                IJ.runMacro(className.substring(6));
            } else if (className.contains("_") && !suppressPluginNotFoundError) {
                IJ.error("Plugin or class not found: \"" + className + "\"\n(" + e + ")");
            }
        }
        catch (NoClassDefFoundError e) {
            int dotIndex = className.indexOf(46);
            if (dotIndex >= 0 && className.contains("_")) {
                if (debugMode) {
                    IJ.log("runUserPlugIn: rerunning " + className);
                }
                return IJ.runUserPlugIn(commandName, className.substring(dotIndex + 1), arg, createNewLoader);
            }
            if (className.contains("_") && !suppressPluginNotFoundError) {
                IJ.error("Run User Plugin", "Class not found while attempting to run \"" + className + "\"\n \n   " + e);
            }
        }
        catch (InstantiationException e) {
            IJ.error("Unable to load plugin (ins)");
        }
        catch (IllegalAccessException e) {
            IJ.error("Unable to load plugin, possibly \nbecause it is not public.");
        }
        if (thePlugIn != null && !"HandleExtraFileTypes".equals(className)) {
            redirectErrorMessages = false;
        }
        suppressPluginNotFoundError = false;
        return thePlugIn;
    }

    private static String argument(String arg) {
        return arg != null && !arg.equals("") && !arg.contains("\n") ? "(\"" + arg + "\")" : "";
    }

    static void wrongType(int capabilities, String cmd) {
        String s = "\"" + cmd + "\" requires an image of type:\n \n";
        if ((capabilities & 1) != 0) {
            s = s + "    8-bit grayscale\n";
        }
        if ((capabilities & 2) != 0) {
            s = s + "    8-bit color\n";
        }
        if ((capabilities & 4) != 0) {
            s = s + "    16-bit grayscale\n";
        }
        if ((capabilities & 8) != 0) {
            s = s + "    32-bit (float) grayscale\n";
        }
        if ((capabilities & 0x10) != 0) {
            s = s + "    RGB color\n";
        }
        IJ.error(s);
    }

    public static void doCommand(String command) {
        new Executer(command, null);
    }

    public static void doCommand(ImagePlus imp, String command) {
        new Executer(command, imp);
    }

    public static void run(String command) {
        IJ.run(command, null);
    }

    public static void run(String command, String options) {
        String name;
        if (ij == null && Menus.getCommands() == null) {
            IJ.init();
        }
        Macro.abort = false;
        Macro.setOptions(options);
        Thread thread = Thread.currentThread();
        if (!(previousThread != null && thread == previousThread || (name = thread.getName()).startsWith("Run$_"))) {
            thread.setName("Run$_" + name);
        }
        command = IJ.convert(command);
        previousThread = thread;
        macroRunning = true;
        Executer e = new Executer(command);
        e.run();
        macroRunning = false;
        Macro.setOptions(null);
        IJ.testAbort();
        macroInterpreter = null;
    }

    public static void run(Interpreter interpreter, String command, String options) {
        macroInterpreter = interpreter;
        IJ.run(command, options);
        macroInterpreter = null;
    }

    private static String convert(String command) {
        String command2;
        if (commandTable == null) {
            commandTable = new Hashtable(30);
            commandTable.put("New...", "Image...");
            commandTable.put("Threshold", "Make Binary");
            commandTable.put("Display...", "Appearance...");
            commandTable.put("Start Animation", "Start Animation [\\]");
            commandTable.put("Convert Images to Stack", "Images to Stack");
            commandTable.put("Convert Stack to Images", "Stack to Images");
            commandTable.put("Convert Stack to RGB", "Stack to RGB");
            commandTable.put("Convert to Composite", "Make Composite");
            commandTable.put("RGB Split", "Split Channels");
            commandTable.put("RGB Merge...", "Merge Channels...");
            commandTable.put("Channels...", "Channels Tool...");
            commandTable.put("New... ", "Table...");
            commandTable.put("Arbitrarily...", "Rotate... ");
            commandTable.put("Measurements...", "Results... ");
            commandTable.put("List Commands...", "Find Commands...");
            commandTable.put("Capture Screen ", "Capture Screen");
            commandTable.put("Add to Manager ", "Add to Manager");
            commandTable.put("In", "In [+]");
            commandTable.put("Out", "Out [-]");
            commandTable.put("Enhance Contrast", "Enhance Contrast...");
            commandTable.put("XY Coodinates... ", "XY Coordinates... ");
            commandTable.put("Statistics...", "Statistics");
            commandTable.put("Channels Tool... ", "Channels Tool...");
            commandTable.put("Profile Plot Options...", "Plots...");
            commandTable.put("AuPbSn 40 (56K)", "AuPbSn 40");
            commandTable.put("Bat Cochlea Volume (19K)", "Bat Cochlea Volume");
            commandTable.put("Bat Cochlea Renderings (449K)", "Bat Cochlea Renderings");
            commandTable.put("Blobs (25K)", "Blobs");
            commandTable.put("Boats (356K)", "Boats");
            commandTable.put("Cardio (768K, RGB DICOM)", "Cardio (RGB DICOM)");
            commandTable.put("Cell Colony (31K)", "Cell Colony");
            commandTable.put("Clown (14K)", "Clown");
            commandTable.put("Confocal Series (2.2MB)", "Confocal Series");
            commandTable.put("CT (420K, 16-bit DICOM)", "CT (16-bit DICOM)");
            commandTable.put("Dot Blot (7K)", "Dot Blot");
            commandTable.put("Embryos (42K)", "Embryos");
            commandTable.put("Fluorescent Cells (400K)", "Fluorescent Cells");
            commandTable.put("Fly Brain (1MB)", "Fly Brain");
            commandTable.put("Gel (105K)", "Gel");
            commandTable.put("HeLa Cells (1.3M, 48-bit RGB)", "HeLa Cells (48-bit RGB)");
            commandTable.put("Leaf (36K)", "Leaf");
            commandTable.put("Line Graph (21K)", "Line Graph");
            commandTable.put("Mitosis (26MB, 5D stack)", "Mitosis (5D stack)");
            commandTable.put("MRI Stack (528K)", "MRI Stack");
            commandTable.put("M51 Galaxy (177K, 16-bits)", "M51 Galaxy (16-bits))");
            commandTable.put("Neuron (1.6M, 5 channels", "Neuron (5 channels");
            commandTable.put("Nile Bend (1.9M)", "Nile Bend");
            commandTable.put("Organ of Corti (2.8M, 4D stack)", "Organ of Corti (4D stack)");
            commandTable.put("Particles (75K)", "Particles");
            commandTable.put("T1 Head (2.4M, 16-bits)", "T1 Head (16-bits)");
            commandTable.put("T1 Head Renderings (736K)", "T1 Head Renderings");
            commandTable.put("TEM Filter (112K)", "TEM Filter");
            commandTable.put("Tree Rings (48K)", "Tree Rings");
        }
        if ((command2 = (String)commandTable.get(command)) != null) {
            return command2;
        }
        return command;
    }

    public static void run(ImagePlus imp, String command, String options) {
        if (ij == null && Menus.getCommands() == null) {
            IJ.init();
        }
        if (imp != null) {
            ImagePlus temp = WindowManager.getTempCurrentImage();
            WindowManager.setTempCurrentImage(imp);
            IJ.run(command, options);
            WindowManager.setTempCurrentImage(temp);
        } else {
            IJ.run(command, options);
        }
    }

    static void init() {
        Menus m = new Menus(null, null);
        Prefs.load(m, null);
        m.addMenuBar();
    }

    private static void testAbort() {
        if (Macro.abort) {
            IJ.abort();
        }
    }

    public static boolean macroRunning() {
        return macroRunning;
    }

    public static boolean isMacro() {
        return macroRunning || Interpreter.getInstance() != null;
    }

    public static Applet getApplet() {
        return applet;
    }

    public static void showStatus(String s) {
        boolean doProtect;
        if (Interpreter.getInstance() == null && statusBarThread == null || statusBarThread != null && Thread.currentThread() != statusBarThread) {
            IJ.protectStatusBar(false);
        }
        if (doProtect = s.startsWith("!")) {
            IJ.protectStatusBar(true);
            statusBarThread = Thread.currentThread();
            s = s.substring(1);
        }
        if (doProtect || !protectStatusBar) {
            ImagePlus imp;
            ImageCanvas ic;
            if (ij != null) {
                ij.showStatus(s);
            }
            ImageCanvas imageCanvas = ic = (imp = WindowManager.getCurrentImage()) != null ? imp.getCanvas() : null;
            if (ic != null) {
                ic.setShowCursorStatus(s.length() == 0);
            }
        }
    }

    public static void showStatus(String message, String options) {
        IJ.showStatus(message);
        if (options == null) {
            return;
        }
        options = options.replace("flash", "");
        options = options.replace("ms", "");
        Color optionalColor = null;
        int index1 = options.indexOf("#");
        if (index1 >= 0) {
            int index2 = options.indexOf(" ", index1);
            if (index2 == -1) {
                index2 = options.length();
            }
            String hexColor = options.substring(index1, index2);
            optionalColor = Colors.decode(hexColor, null);
            options = options.replace(hexColor, "");
        }
        if (optionalColor == null) {
            for (String c : Colors.colors) {
                if (!options.contains(c)) continue;
                optionalColor = Colors.getColor(c, ImageJ.backgroundColor);
                options = options.replace(c, "");
                break;
            }
        }
        boolean flashImage = options.contains("image");
        Color defaultColor = new Color(255, 255, 245);
        int defaultDelay = 500;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (flashImage) {
            options = options.replace("image", "");
            if (imp != null && imp.getWindow() != null) {
                defaultColor = Color.black;
                defaultDelay = 100;
            } else {
                flashImage = false;
            }
        }
        Color color = optionalColor != null ? optionalColor : defaultColor;
        int delay = (int)Tools.parseDouble(options, defaultDelay);
        if (delay > 8000) {
            delay = 8000;
        }
        Object colorString = null;
        ImageJ ij = IJ.getInstance();
        if (flashImage) {
            Color previousColor = imp.getWindow().getBackground();
            imp.getWindow().setBackground(color);
            if (delay > 0) {
                IJ.wait(delay);
                imp.getWindow().setBackground(previousColor);
            }
        } else if (ij != null) {
            ij.getStatusBar().setBackground(color);
            IJ.wait(delay);
            ij.getStatusBar().setBackground(ImageJ.backgroundColor);
        }
    }

    public static void write(String s) {
        if (textPanel == null && ij != null) {
            IJ.showResults();
        }
        if (textPanel != null) {
            textPanel.append(s);
        } else {
            System.out.println(s);
        }
    }

    private static void showResults() {
        TextWindow resultsWindow = new TextWindow("Results", "", 400, 250);
        textPanel = resultsWindow.getTextPanel();
        textPanel.setResultsTable(Analyzer.getResultsTable());
    }

    public static synchronized void log(String s) {
        if (s == null) {
            return;
        }
        if (logPanel == null && ij != null) {
            TextWindow logWindow = new TextWindow("Log", "", 400, 250);
            logPanel = logWindow.getTextPanel();
            logPanel.setFont(new Font("SansSerif", 0, 16));
        }
        if (logPanel != null) {
            if (s.startsWith("\\")) {
                IJ.handleLogCommand(s);
            } else {
                if (s.endsWith("\n")) {
                    s = s.equals("\n\n") ? "\n \n " : (s.endsWith("\n\n") ? s.substring(0, s.length() - 2) + "\n \n " : s + " ");
                }
                logPanel.append(s);
            }
        } else {
            LogStream.redirectSystem(false);
            System.out.println(s);
        }
    }

    static void handleLogCommand(String s) {
        if (s.equals("\\Closed")) {
            logPanel = null;
        } else if (s.startsWith("\\Update:")) {
            int n = logPanel.getLineCount();
            String s2 = s.substring(8, s.length());
            if (n == 0) {
                logPanel.append(s2);
            } else {
                logPanel.setLine(n - 1, s2);
            }
        } else if (s.startsWith("\\Update")) {
            int cindex = s.indexOf(":");
            if (cindex == -1) {
                logPanel.append(s);
                return;
            }
            String nstr = s.substring(7, cindex);
            int line = (int)Tools.parseDouble(nstr, -1.0);
            if (line < 0 || line > 25) {
                logPanel.append(s);
                return;
            }
            for (int count = logPanel.getLineCount(); line >= count; ++count) {
                IJ.log("");
            }
            String s2 = s.substring(cindex + 1, s.length());
            logPanel.setLine(line, s2);
        } else if (s.equals("\\Clear")) {
            logPanel.clear();
        } else if (s.startsWith("\\Heading:")) {
            logPanel.updateColumnHeadings(s.substring(10));
        } else if (s.equals("\\Close")) {
            Frame f = WindowManager.getFrame("Log");
            if (f != null && f instanceof TextWindow) {
                ((TextWindow)f).close();
            }
        } else {
            logPanel.append(s);
        }
    }

    public static synchronized String getLog() {
        if (logPanel == null || ij == null) {
            return null;
        }
        return logPanel.getText();
    }

    public static void setColumnHeadings(String headings) {
        if (textPanel == null && ij != null) {
            IJ.showResults();
        }
        if (textPanel != null) {
            textPanel.setColumnHeadings(headings);
        } else {
            System.out.println(headings);
        }
    }

    public static boolean isResultsWindow() {
        return textPanel != null;
    }

    public static void renameResults(String title) {
        Frame frame = WindowManager.getFrontWindow();
        if (frame != null && frame instanceof TextWindow) {
            TextWindow tw = (TextWindow)frame;
            if (tw.getResultsTable() == null) {
                IJ.error("Rename", "\"" + tw.getTitle() + "\" is not a results table");
                return;
            }
            tw.rename(title);
        } else if (IJ.isResultsWindow()) {
            TextPanel tp = IJ.getTextPanel();
            TextWindow tw = (TextWindow)tp.getParent();
            tw.rename(title);
        }
    }

    public static void renameResults(String oldTitle, String newTitle) {
        Frame frame = WindowManager.getFrame(oldTitle);
        if (frame == null) {
            IJ.error("Rename", "\"" + oldTitle + "\" not found");
            return;
        }
        if (frame instanceof TextWindow) {
            TextWindow tw = (TextWindow)frame;
            if (tw.getResultsTable() == null) {
                IJ.error("Rename", "\"" + oldTitle + "\" is not a table");
                return;
            }
            tw.rename(newTitle);
        } else {
            IJ.error("Rename", "\"" + oldTitle + "\" is not a table");
        }
    }

    public static void deleteRows(int row1, int row2) {
        ResultsTable rt = Analyzer.getResultsTable();
        int tableSize = rt.size();
        rt.deleteRows(row1, row2);
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            Overlay.updateTableOverlay(imp, row1, row2, tableSize);
        }
        rt.show("Results");
    }

    public static double getValue(ImagePlus imp, String measurement) {
        String options = "";
        int index = measurement.indexOf(" ");
        if (index > 0) {
            if (index < measurement.length() - 1) {
                options = measurement.substring(index + 1, measurement.length());
            }
            measurement = measurement.substring(0, index);
        }
        int measurements = 2091775;
        if (options.contains("limit")) {
            measurements += 256;
        }
        Calibration cal = null;
        if (options.contains("raw")) {
            cal = imp.getCalibration();
            imp.setCalibration(null);
        }
        ResultsTable rt = new ResultsTable();
        Analyzer analyzer = new Analyzer(imp, measurements, rt);
        analyzer.measure();
        double value = Double.NaN;
        try {
            value = rt.getValue(measurement, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cal != null) {
            imp.setCalibration(cal);
        }
        return value;
    }

    public static TextPanel getTextPanel() {
        if (textPanel == null && ij != null) {
            IJ.showResults();
        }
        return textPanel;
    }

    public static void setTextPanel(TextPanel tp) {
        textPanel = tp;
    }

    public static void noImage() {
        String msg = "There are no images open";
        if (macroInterpreter != null) {
            macroInterpreter.abort(msg);
            macroInterpreter = null;
        } else {
            IJ.error("No Image", msg);
        }
    }

    public static void outOfMemory(String name) {
        Undo.reset();
        System.gc();
        lastErrorMessage = "out of memory";
        String tot = Runtime.getRuntime().maxMemory() / 0x100000L + "MB";
        if (!memMessageDisplayed) {
            IJ.log(">>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
        IJ.log("<Out of memory>");
        if (!memMessageDisplayed) {
            IJ.log("<All available memory (" + tot + ") has been>");
            IJ.log("<used. To make more available, use the>");
            IJ.log("<Edit>Options>Memory & Threads command.>");
            IJ.log(">>>>>>>>>>>>>>>>>>>>>>>>>>>");
            memMessageDisplayed = true;
        }
        Macro.abort();
    }

    public static void showProgress(double progress) {
        if (progressBar != null) {
            progressBar.show(progress, false);
        }
    }

    public static void showProgress(int currentIndex, int finalIndex) {
        if (progressBar != null) {
            progressBar.show(currentIndex, finalIndex);
            if (currentIndex == finalIndex) {
                progressBar.setBatchMode(false);
            }
        }
    }

    public static void showMessage(String msg) {
        IJ.showMessage("Message", msg);
    }

    public static void showMessage(String title, String msg) {
        if (ij != null) {
            if (msg != null && (msg.startsWith("<html>") || msg.startsWith("<HTML>"))) {
                HTMLDialog hd = new HTMLDialog(title, msg);
                if (IJ.isMacro() && hd.escapePressed()) {
                    throw new RuntimeException("Macro canceled");
                }
            } else {
                MessageDialog md = new MessageDialog((Frame)ij, title, msg);
                if (IJ.isMacro() && md.escapePressed()) {
                    throw new RuntimeException("Macro canceled");
                }
            }
        } else {
            System.out.println(msg);
        }
    }

    public static void error(String msg) {
        IJ.error(null, msg);
        if (Thread.currentThread().getName().endsWith("JavaScript")) {
            throw new RuntimeException("Macro canceled");
        }
        Macro.abort();
    }

    public static void error(String title, String msg) {
        if (macroInterpreter != null) {
            macroInterpreter.abort(msg);
            macroInterpreter = null;
            return;
        }
        if (msg != null && msg.endsWith("Macro canceled")) {
            return;
        }
        String title2 = title != null ? title : "ImageJ";
        boolean abortMacro = title != null;
        lastErrorMessage = msg;
        if (redirectErrorMessages) {
            IJ.log(title2 + ": " + msg);
            if (abortMacro && (title.contains("Open") || title.contains("Reader"))) {
                abortMacro = false;
            }
        } else {
            IJ.showMessage(title2, msg);
        }
        redirectErrorMessages = false;
        if (abortMacro) {
            Macro.abort();
        }
    }

    public static void exit() {
        if (Thread.currentThread().getName().endsWith("JavaScript")) {
            throw new RuntimeException("Macro canceled");
        }
    }

    public static String getErrorMessage() {
        String msg = lastErrorMessage;
        lastErrorMessage = null;
        return msg;
    }

    public static boolean showMessageWithCancel(String title, String msg) {
        GenericDialog gd = new GenericDialog(title);
        gd.addMessage(msg);
        gd.showDialog();
        return !gd.wasCanceled();
    }

    public static double getNumber(String prompt, double defaultValue) {
        GenericDialog gd = new GenericDialog("");
        int decimalPlaces = (double)((int)defaultValue) == defaultValue ? 0 : 2;
        gd.addNumericField(prompt, defaultValue, decimalPlaces);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return -2.147483648E9;
        }
        double v = gd.getNextNumber();
        if (gd.invalidNumber()) {
            return defaultValue;
        }
        return v;
    }

    public static String getString(String prompt, String defaultString) {
        GenericDialog gd = new GenericDialog("");
        gd.addStringField(prompt, defaultString, 20);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return "";
        }
        return gd.getNextString();
    }

    public static void wait(int msecs) {
        try {
            Thread.sleep(msecs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static String freeMemory() {
        long inUse = IJ.currentMemory();
        String inUseStr = inUse < 10240000L ? inUse / 1024L + "K" : inUse / 0x100000L + "MB";
        String maxStr = "";
        long max = IJ.maxMemory();
        if (max > 0L) {
            double percent = inUse * 100L / max;
            maxStr = " of " + max / 0x100000L + "MB (" + (percent < 1.0 ? "<1" : IJ.d2s(percent, 0)) + "%)";
        }
        return inUseStr + maxStr;
    }

    public static long currentMemory() {
        long freeMem = Runtime.getRuntime().freeMemory();
        long totMem = Runtime.getRuntime().totalMemory();
        return totMem - freeMem;
    }

    public static long maxMemory() {
        Memory mem;
        if (maxMemory == 0L && (maxMemory = (mem = new Memory()).getMemorySetting()) == 0L) {
            maxMemory = mem.maxMemory();
        }
        return maxMemory;
    }

    public static void showTime(ImagePlus imp, long start, String str) {
        IJ.showTime(imp, start, str, 1);
    }

    public static void showTime(ImagePlus imp, long start, String str, int nslices) {
        if (Interpreter.isBatchMode()) {
            return;
        }
        double seconds = (double)(System.currentTimeMillis() - start) / 1000.0;
        if (seconds <= 0.5 && IJ.macroRunning()) {
            return;
        }
        double pixels = (double)imp.getWidth() * (double)imp.getHeight();
        double rate = pixels * (double)nslices / seconds;
        String str2 = rate > 1.0E9 ? "" : (rate < 1000000.0 ? ", " + IJ.d2s(rate, 0) + " pixels/second" : ", " + IJ.d2s(rate / 1000000.0, 1) + " million pixels/second");
        IJ.showStatus(str + seconds + " seconds" + str2);
    }

    public static String time(ImagePlus imp, long startNanoTime) {
        double planes = imp.getStackSize();
        double seconds = (double)(System.nanoTime() - startNanoTime) / 1.0E9;
        double mpixels = (double)(imp.getWidth() * imp.getHeight()) * planes / 1000000.0;
        String time = seconds < 1.0 ? IJ.d2s(seconds * 1000.0, 0) + " ms" : IJ.d2s(seconds, 1) + " seconds";
        return time + ", " + IJ.d2s(mpixels / seconds, 1) + " million pixels/second";
    }

    public static String d2s(double n) {
        return IJ.d2s(n, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String d2s(double n, int decimalPlaces) {
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            return "" + n;
        }
        if (n == 3.4028234663852886E38) {
            return "3.4e38";
        }
        double np = n;
        if (n < 0.0) {
            np = -n;
        }
        if (decimalPlaces < 0) {
            Class<IJ> clazz = IJ.class;
            synchronized (IJ.class) {
                decimalPlaces = -decimalPlaces;
                if (decimalPlaces > 9) {
                    decimalPlaces = 9;
                }
                if (sf == null) {
                    if (dfs == null) {
                        dfs = new DecimalFormatSymbols(Locale.US);
                    }
                    sf = new DecimalFormat[10];
                    IJ.sf[1] = new DecimalFormat("0.0E0", dfs);
                    IJ.sf[2] = new DecimalFormat("0.00E0", dfs);
                    IJ.sf[3] = new DecimalFormat("0.000E0", dfs);
                    IJ.sf[4] = new DecimalFormat("0.0000E0", dfs);
                    IJ.sf[5] = new DecimalFormat("0.00000E0", dfs);
                    IJ.sf[6] = new DecimalFormat("0.000000E0", dfs);
                    IJ.sf[7] = new DecimalFormat("0.0000000E0", dfs);
                    IJ.sf[8] = new DecimalFormat("0.00000000E0", dfs);
                    IJ.sf[9] = new DecimalFormat("0.000000000E0", dfs);
                }
                // ** MonitorExit[var5_3] (shouldn't be in output)
                return sf[decimalPlaces].format(n);
            }
        }
        if (decimalPlaces < 0) {
            decimalPlaces = 0;
        }
        if (decimalPlaces > 9) {
            decimalPlaces = 9;
        }
        return df[decimalPlaces].format(n);
    }

    public static String d2s(double x, int significantDigits, int maxDigits) {
        int decimals;
        double log10 = Math.log10(Math.abs(x));
        double roundErrorAtMax = 0.223 * Math.pow(10.0, -maxDigits);
        int magnitude = (int)Math.ceil(log10 + roundErrorAtMax);
        int n = decimals = x == 0.0 ? 0 : maxDigits - magnitude;
        if (decimals < 0 || magnitude < significantDigits + 1 - maxDigits) {
            return IJ.d2s(x, -significantDigits);
        }
        if (decimals > significantDigits) {
            decimals = Math.max(significantDigits, decimals - maxDigits + significantDigits);
        }
        return IJ.d2s(x, decimals);
    }

    public static String pad(int n, int digits) {
        String str = "" + n;
        while (str.length() < digits) {
            str = "0" + str;
        }
        return str;
    }

    public static String pad(String s, int digits) {
        String str = "" + s;
        while (str.length() < digits) {
            str = "0" + str;
        }
        return str;
    }

    public static void register(Class c) {
        if (ij != null) {
            ij.register(c);
        }
    }

    public static boolean spaceBarDown() {
        return spaceDown;
    }

    public static boolean controlKeyDown() {
        return controlDown;
    }

    public static boolean altKeyDown() {
        return altDown;
    }

    public static boolean shiftKeyDown() {
        return shiftDown;
    }

    public static void setKeyDown(int key) {
        switch (key) {
            case 17: {
                controlDown = true;
                break;
            }
            case 157: {
                if (!IJ.isMacintosh()) break;
                controlDown = true;
                break;
            }
            case 18: {
                altDown = true;
                IJ.updateStatus();
                break;
            }
            case 16: {
                shiftDown = true;
                if (!debugMode) break;
                IJ.beep();
                break;
            }
            case 32: {
                spaceDown = true;
                ImageWindow win = WindowManager.getCurrentWindow();
                break;
            }
            case 27: {
                escapePressed = true;
            }
        }
    }

    public static void setKeyUp(int key) {
        switch (key) {
            case 17: {
                controlDown = false;
                break;
            }
            case 157: {
                if (!IJ.isMacintosh()) break;
                controlDown = false;
                break;
            }
            case 18: {
                altDown = false;
                IJ.updateStatus();
                break;
            }
            case 16: {
                shiftDown = false;
                if (!debugMode) break;
                IJ.beep();
                break;
            }
            case 32: {
                spaceDown = false;
                ImageWindow win = WindowManager.getCurrentWindow();
                break;
            }
            case -1: {
                spaceDown = false;
                altDown = false;
                controlDown = false;
                shiftDown = false;
            }
        }
    }

    private static void updateStatus() {
        Roi roi;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && (roi = imp.getRoi()) != null && imp.getCalibration().scaled()) {
            roi.showStatus();
        }
    }

    public static void setInputEvent(InputEvent e) {
        altDown = e.isAltDown();
        shiftDown = e.isShiftDown();
    }

    public static boolean isMacintosh() {
        return isMac;
    }

    public static boolean isMacOSX() {
        return IJ.isMacintosh();
    }

    public static boolean isWindows() {
        return isWin;
    }

    public static int javaVersion() {
        return javaVersion;
    }

    public static boolean isJava2() {
        return true;
    }

    public static boolean isJava14() {
        return true;
    }

    public static boolean isJava15() {
        return true;
    }

    public static boolean isJava16() {
        return javaVersion >= 6;
    }

    public static boolean isJava17() {
        return javaVersion >= 7;
    }

    public static boolean isJava18() {
        return javaVersion >= 8;
    }

    public static boolean isJava19() {
        return javaVersion >= 9;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static boolean isVista() {
        return false;
    }

    public static boolean is64Bit() {
        if (osarch == null) {
            osarch = System.getProperty("os.arch");
        }
        return osarch != null && osarch.indexOf("64") != -1;
    }

    public static boolean versionLessThan(String version) {
        boolean lessThan;
        boolean bl = lessThan = "1.53j".compareTo(version) < 0;
        if (lessThan) {
            IJ.error("This plugin or macro requires ImageJ " + version + " or later. Use\nHelp>Update ImageJ to upgrade to the latest version.");
        }
        return lessThan;
    }

    public static int setupDialog(ImagePlus imp, int flags) {
        if (imp == null || ij != null && IJ.ij.hotkey) {
            if (ij != null) {
                IJ.ij.hotkey = false;
            }
            return flags;
        }
        int stackSize = imp.getStackSize();
        if (stackSize > 1) {
            String macroOptions = Macro.getOptions();
            if (imp.isComposite() && ((CompositeImage)imp).getMode() == 1 && (macroOptions == null || !macroOptions.contains("slice"))) {
                return flags | 0x20;
            }
            if (macroOptions != null) {
                if (macroOptions.indexOf("stack ") >= 0) {
                    return flags | 0x20;
                }
                return flags;
            }
            if (hideProcessStackDialog) {
                return flags;
            }
            String note = (flags & 0x80) == 0 ? " There is\nno Undo if you select \"Yes\"." : "";
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)IJ.getInstance(), "Process Stack?", "Process all " + stackSize + " images?" + note);
            if (d.cancelPressed()) {
                return 4096;
            }
            if (d.yesPressed()) {
                if (imp.getStack().isVirtual() && (flags & 0x80) == 0) {
                    int size = (stackSize * imp.getWidth() * imp.getHeight() * imp.getBytesPerPixel() + 524288) / 0x100000;
                    String msg = "Use the Process>Batch>Virtual Stack command\nto process a virtual stack or convert it into a\nnormal stack using Image>Duplicate, which\nwill require " + size + "MB of additional memory.";
                    IJ.error(msg);
                    return 4096;
                }
                if (Recorder.record) {
                    Recorder.recordOption("stack");
                }
                return flags | 0x20;
            }
            if (Recorder.record) {
                Recorder.recordOption("slice");
            }
        }
        return flags;
    }

    public static void makeRectangle(int x, int y, int width, int height) {
        if (width <= 0 || height < 0) {
            IJ.getImage().deleteRoi();
        } else {
            ImagePlus img = IJ.getImage();
            if (Interpreter.isBatchMode()) {
                img.setRoi(new Roi(x, y, width, height), false);
            } else {
                img.setRoi(x, y, width, height);
            }
        }
    }

    public static void makeRectangle(double x, double y, double width, double height) {
        if (width <= 0.0 || height < 0.0) {
            IJ.getImage().deleteRoi();
        } else {
            IJ.getImage().setRoi(new Roi(x, y, width, height), !Interpreter.isBatchMode());
        }
    }

    public static void makeOval(int x, int y, int width, int height) {
        if (width <= 0 || height < 0) {
            IJ.getImage().deleteRoi();
        } else {
            ImagePlus img = IJ.getImage();
            img.setRoi(new OvalRoi(x, y, width, height));
        }
    }

    public static void makeOval(double x, double y, double width, double height) {
        if (width <= 0.0 || height < 0.0) {
            IJ.getImage().deleteRoi();
        } else {
            IJ.getImage().setRoi(new OvalRoi(x, y, width, height));
        }
    }

    public static void makeLine(int x1, int y1, int x2, int y2) {
        IJ.getImage().setRoi(new Line(x1, y1, x2, y2));
    }

    public static void makeLine(double x1, double y1, double x2, double y2) {
        IJ.getImage().setRoi(new Line(x1, y1, x2, y2));
    }

    public static void makePoint(int x, int y) {
        ImagePlus img = IJ.getImage();
        Roi roi = img.getRoi();
        if (IJ.shiftKeyDown() && roi != null && roi.getType() == 10) {
            Polygon p = roi.getPolygon();
            p.addPoint(x, y);
            img.setRoi(new PointRoi(p.xpoints, p.ypoints, p.npoints));
            IJ.setKeyUp(16);
        } else if (IJ.altKeyDown() && roi != null && roi.getType() == 10) {
            ((PolygonRoi)roi).deleteHandle(x, y);
            IJ.setKeyUp(18);
        } else {
            img.setRoi(new PointRoi(x, y));
        }
    }

    public static void makePoint(double x, double y) {
        ImagePlus img = IJ.getImage();
        Roi roi = img.getRoi();
        if (IJ.shiftKeyDown() && roi != null && roi.getType() == 10) {
            Polygon p = roi.getPolygon();
            p.addPoint((int)Math.round(x), (int)Math.round(y));
            img.setRoi(new PointRoi(p.xpoints, p.ypoints, p.npoints));
            IJ.setKeyUp(16);
        } else if (IJ.altKeyDown() && roi != null && roi.getType() == 10) {
            ((PolygonRoi)roi).deleteHandle(x, y);
            IJ.setKeyUp(18);
        } else {
            img.setRoi(new PointRoi(x, y));
        }
    }

    public static Roi Roi(double x, double y, double width, double height) {
        return new Roi(x, y, width, height);
    }

    public static OvalRoi OvalRoi(double x, double y, double width, double height) {
        return new OvalRoi(x, y, width, height);
    }

    public static void setMinAndMax(double min, double max) {
        IJ.setMinAndMax(IJ.getImage(), min, max, 7);
    }

    public static void setMinAndMax(ImagePlus img, double min, double max) {
        IJ.setMinAndMax(img, min, max, 7);
    }

    public static void setMinAndMax(double min, double max, int channels) {
        IJ.setMinAndMax(IJ.getImage(), min, max, channels);
    }

    private static void setMinAndMax(ImagePlus img, double min, double max, int channels) {
        Calibration cal = img.getCalibration();
        min = cal.getRawValue(min);
        max = cal.getRawValue(max);
        if (channels == 7) {
            img.setDisplayRange(min, max);
        } else {
            img.setDisplayRange(min, max, channels);
        }
        img.updateAndDraw();
    }

    public static void resetMinAndMax() {
        IJ.resetMinAndMax(IJ.getImage());
    }

    public static void resetMinAndMax(ImagePlus img) {
        img.resetDisplayRange();
        img.updateAndDraw();
    }

    public static void setThreshold(double lowerThreshold, double upperThresold) {
        IJ.setThreshold(lowerThreshold, upperThresold, null);
    }

    public static void setThreshold(double lowerThreshold, double upperThreshold, String displayMode) {
        IJ.setThreshold(IJ.getImage(), lowerThreshold, upperThreshold, displayMode);
    }

    public static void setThreshold(ImagePlus img, double lowerThreshold, double upperThreshold) {
        IJ.setThreshold(img, lowerThreshold, upperThreshold, "Red");
    }

    public static void setThreshold(ImagePlus img, double lowerThreshold, double upperThreshold, String displayMode) {
        Calibration cal = img.getCalibration();
        if (displayMode == null || !displayMode.contains("raw")) {
            lowerThreshold = cal.getRawValue(lowerThreshold);
            upperThreshold = cal.getRawValue(upperThreshold);
        }
        IJ.setRawThreshold(img, lowerThreshold, upperThreshold, displayMode);
    }

    public static void setRawThreshold(ImagePlus img, double lowerThreshold, double upperThreshold, String displayMode) {
        int mode = 0;
        if (displayMode != null) {
            if ((displayMode = displayMode.toLowerCase(Locale.US)).contains("black")) {
                mode = 1;
            } else if (displayMode.contains("over")) {
                mode = 3;
            } else if (displayMode.contains("no")) {
                mode = 2;
            }
        }
        img.getProcessor().setThreshold(lowerThreshold, upperThreshold, mode);
        if (mode != 2 && img.getWindow() != null) {
            img.getProcessor().setLutAnimation(true);
            img.updateAndDraw();
            ThresholdAdjuster.update();
        }
    }

    public static void setAutoThreshold(ImagePlus imp, String method) {
        block6: {
            ImageProcessor ip = imp.getProcessor();
            if (ip instanceof ColorProcessor) {
                throw new IllegalArgumentException("Non-RGB image required");
            }
            ip.setRoi(imp.getRoi());
            if (method != null) {
                try {
                    if (method.indexOf("stack") != -1) {
                        IJ.setStackThreshold(imp, ip, method);
                        break block6;
                    }
                    ip.setAutoThreshold(method);
                }
                catch (Exception e) {
                    IJ.log(e.getMessage());
                }
            } else {
                ip.setAutoThreshold(1, 0);
            }
        }
        imp.updateAndDraw();
    }

    private static void setStackThreshold(ImagePlus imp, ImageProcessor ip, String method) {
        double upper;
        double lower;
        boolean darkBackground = method.indexOf("dark") != -1;
        int measurements = Analyzer.getMeasurements();
        Analyzer.setMeasurements(17);
        StackStatistics stats = new StackStatistics(imp);
        Analyzer.setMeasurements(measurements);
        AutoThresholder thresholder = new AutoThresholder();
        double min = 0.0;
        double max = 255.0;
        if (imp.getBitDepth() != 8) {
            min = stats.min;
            max = stats.max;
        }
        int threshold = thresholder.getThreshold(method, stats.histogram);
        if (darkBackground) {
            if (ip.isInvertedLut()) {
                lower = 0.0;
                upper = threshold;
            } else {
                lower = threshold + 1;
                upper = 255.0;
            }
        } else if (ip.isInvertedLut()) {
            lower = threshold + 1;
            upper = 255.0;
        } else {
            lower = 0.0;
            upper = threshold;
        }
        if (lower > 255.0) {
            lower = 255.0;
        }
        if (max > min) {
            lower = min + lower / 255.0 * (max - min);
            upper = min + upper / 255.0 * (max - min);
        } else {
            lower = upper = min;
        }
        ip.setMinAndMax(min, max);
        ip.setThreshold(lower, upper, 0);
        imp.updateAndDraw();
    }

    public static void resetThreshold() {
        IJ.resetThreshold(IJ.getImage());
    }

    public static void resetThreshold(ImagePlus img) {
        ImageProcessor ip = img.getProcessor();
        ip.resetThreshold();
        ip.setLutAnimation(true);
        img.updateAndDraw();
        ThresholdAdjuster.update();
    }

    public static void selectWindow(int id) {
        ImagePlus imp;
        if (id > 0) {
            id = WindowManager.getNthImageID(id);
        }
        if ((imp = WindowManager.getImage(id)) == null) {
            IJ.error("Macro Error", "Image " + id + " not found or no images are open.");
        }
        if (Interpreter.isBatchMode()) {
            ImagePlus impT = WindowManager.getTempCurrentImage();
            ImagePlus impC = WindowManager.getCurrentImage();
            if (impC != null && impC != imp && impT != null) {
                impC.saveRoi();
            }
        } else {
            int timeout;
            if (imp == null) {
                return;
            }
            ImageWindow win = imp.getWindow();
            if (win != null) {
                win.toFront();
                win.setState(0);
                WindowManager.setWindow(win);
            }
            long start = System.currentTimeMillis();
            String thread = Thread.currentThread().getName();
            int n = timeout = thread != null && thread.indexOf("EventQueue") != -1 ? 0 : 1000;
            if (IJ.isMacOSX() && IJ.isJava18() && timeout > 0) {
                timeout = 250;
            }
            do {
                IJ.wait(10);
                imp = WindowManager.getCurrentImage();
                if (imp == null || imp.getID() != id) continue;
                return;
            } while (System.currentTimeMillis() - start <= (long)timeout || win == null);
            WindowManager.setCurrentWindow(win);
            return;
        }
        WindowManager.setTempCurrentImage(imp);
        Interpreter.activateImage(imp);
        WindowManager.setWindow(null);
    }

    public static void selectWindow(String title) {
        if (title.equals("ImageJ") && ij != null) {
            ij.toFront();
            return;
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 3000L) {
            Window win = WindowManager.getWindow(title);
            if (win != null && !(win instanceof ImageWindow)) {
                IJ.selectWindow(win);
                return;
            }
            int[] wList = WindowManager.getIDList();
            int len = wList != null ? wList.length : 0;
            for (int i = 0; i < len; ++i) {
                ImagePlus imp = WindowManager.getImage(wList[i]);
                if (imp == null || !imp.getTitle().equals(title)) continue;
                IJ.selectWindow(imp.getID());
                return;
            }
            IJ.wait(10);
        }
        IJ.error("Macro Error", "No window with the title \"" + title + "\" found.");
    }

    static void selectWindow(Window win) {
        if (win instanceof Frame) {
            ((Frame)win).toFront();
            ((Frame)win).setState(0);
        } else {
            ((Dialog)win).toFront();
        }
        long start = System.currentTimeMillis();
        do {
            IJ.wait(10);
            if (WindowManager.getActiveWindow() != win) continue;
            return;
        } while (System.currentTimeMillis() - start <= 1000L);
        WindowManager.setWindow(win);
    }

    public static void setForegroundColor(int red, int green, int blue) {
        IJ.setColor(red, green, blue, true);
    }

    public static void setBackgroundColor(int red, int green, int blue) {
        IJ.setColor(red, green, blue, false);
    }

    static void setColor(int red, int green, int blue, boolean foreground) {
        Color c = Colors.toColor(red, green, blue);
        if (foreground) {
            Toolbar.setForegroundColor(c);
            ImagePlus img = WindowManager.getCurrentImage();
            if (img != null) {
                img.getProcessor().setColor(c);
            }
        } else {
            Toolbar.setBackgroundColor(c);
        }
    }

    public static void setTool(int id) {
        Toolbar.getInstance().setTool(id);
    }

    public static boolean setTool(String name) {
        return Toolbar.getInstance().setTool(name);
    }

    public static String getToolName() {
        return Toolbar.getToolName();
    }

    public static int doWand(int x, int y) {
        return IJ.doWand(IJ.getImage(), x, y, 0.0, null);
    }

    public static int doWand(int x, int y, double tolerance, String mode) {
        return IJ.doWand(IJ.getImage(), x, y, tolerance, mode);
    }

    public static int doWand(ImagePlus img, int x, int y, double tolerance, String mode) {
        ImageProcessor ip = img.getProcessor();
        if (img.getType() == 2 && Double.isNaN(ip.getPixelValue(x, y))) {
            return 0;
        }
        int imode = 1;
        boolean smooth = false;
        if (mode != null) {
            if (mode.startsWith("4")) {
                imode = 4;
            } else if (mode.startsWith("8")) {
                imode = 8;
            }
            smooth = mode.contains("smooth");
        }
        Wand w = new Wand(ip);
        double t1 = ip.getMinThreshold();
        if (t1 == -808080.0 || ip.getLutUpdateMode() == 2 && tolerance > 0.0) {
            w.autoOutline(x, y, tolerance, imode);
            smooth = false;
        } else {
            w.autoOutline(x, y, t1, ip.getMaxThreshold(), imode);
        }
        if (w.npoints > 0) {
            Roi previousRoi = img.getRoi();
            PolygonRoi roi = new PolygonRoi(w.xpoints, w.ypoints, w.npoints, 4);
            img.deleteRoi();
            img.setRoi(roi);
            if (previousRoi != null) {
                roi.update(IJ.shiftKeyDown(), IJ.altKeyDown());
            }
            Roi roi2 = img.getRoi();
            if (smooth && roi2 != null && roi2.getType() == 4) {
                Rectangle bounds = roi2.getBounds();
                if (bounds.width > 1 && bounds.height > 1) {
                    if (smoothMacro == null) {
                        smoothMacro = BatchProcessor.openMacroFromJar("SmoothWandTool.txt");
                    }
                    if (EventQueue.isDispatchThread()) {
                        new MacroRunner(smoothMacro);
                    } else {
                        Macro.eval(smoothMacro);
                    }
                }
            }
        }
        return w.npoints;
    }

    public static void setPasteMode(String mode) {
        Roi.setPasteMode(IJ.stringToPasteMode(mode));
    }

    public static int stringToPasteMode(String mode) {
        if (mode == null) {
            return 0;
        }
        mode = mode.toLowerCase(Locale.US);
        int m = 0;
        if (mode.startsWith("ble") || mode.startsWith("ave")) {
            m = 7;
        } else if (mode.startsWith("diff")) {
            m = 8;
        } else if (mode.indexOf("zero") != -1) {
            m = 14;
        } else if (mode.startsWith("tran")) {
            m = 2;
        } else if (mode.startsWith("and")) {
            m = 9;
        } else if (mode.startsWith("or")) {
            m = 10;
        } else if (mode.startsWith("xor")) {
            m = 11;
        } else if (mode.startsWith("sub")) {
            m = 4;
        } else if (mode.startsWith("add")) {
            m = 3;
        } else if (mode.startsWith("div")) {
            m = 6;
        } else if (mode.startsWith("mul")) {
            m = 5;
        } else if (mode.startsWith("min")) {
            m = 12;
        } else if (mode.startsWith("max")) {
            m = 13;
        }
        return m;
    }

    public static ImagePlus getImage() {
        ImagePlus img = WindowManager.getCurrentImage();
        if (img == null) {
            IJ.noImage();
            if (ij == null) {
                System.exit(0);
            } else {
                IJ.abort();
            }
        }
        return img;
    }

    public static ImagePlus getImage(Interpreter interpreter) {
        macroInterpreter = interpreter;
        ImagePlus imp = IJ.getImage();
        macroInterpreter = null;
        return imp;
    }

    public static ImageProcessor getProcessor() {
        ImagePlus imp = IJ.getImage();
        return imp.getProcessor();
    }

    public static void setSlice(int slice) {
        IJ.getImage().setSlice(slice);
    }

    public static String getVersion() {
        return "1.53j";
    }

    public static String getFullVersion() {
        String build = "";
        if (build.length() == 0) {
            build = "99";
        } else if (build.length() == 1) {
            build = "0" + build;
        }
        return "1.53j" + build;
    }

    public static String getDirectory(String title) {
        String dir = null;
        String title2 = title.toLowerCase(Locale.US);
        if (title2.equals("plugins")) {
            dir = Menus.getPlugInsPath();
        } else if (title2.equals("macros")) {
            dir = Menus.getMacrosPath();
        } else if (title2.equals("luts")) {
            String ijdir = Prefs.getImageJDir();
            dir = ijdir != null ? ijdir + "luts" + File.separator : null;
        } else if (title2.equals("home")) {
            dir = System.getProperty("user.home");
        } else if (title2.equals("downloads")) {
            dir = System.getProperty("user.home") + File.separator + "Downloads";
        } else if (title2.equals("startup")) {
            dir = Prefs.getImageJDir();
        } else if (title2.equals("imagej")) {
            dir = Prefs.getImageJDir();
        } else if (title2.equals("current") || title2.equals("default")) {
            dir = OpenDialog.getDefaultDirectory();
        } else if (title2.equals("temp")) {
            dir = System.getProperty("java.io.tmpdir");
            if (IJ.isMacintosh()) {
                dir = "/tmp/";
            }
        } else if (title2.equals("image")) {
            FileInfo fi;
            ImagePlus imp = WindowManager.getCurrentImage();
            FileInfo fileInfo = fi = imp != null ? imp.getOriginalFileInfo() : null;
            dir = fi != null && fi.directory != null ? fi.directory : null;
        } else if (title2.equals("file")) {
            dir = OpenDialog.getLastDirectory();
        } else if (title2.equals("cwd")) {
            dir = System.getProperty("user.dir");
        } else {
            DirectoryChooser dc = new DirectoryChooser(title);
            dir = dc.getDirectory();
            if (dir == null) {
                Macro.abort();
            }
        }
        dir = IJ.addSeparator(dir);
        return dir;
    }

    public static String addSeparator(String path) {
        if (path == null) {
            return null;
        }
        if (path.length() > 0 && !path.endsWith(File.separator) && !path.endsWith("/")) {
            path = IJ.isWindows() && path.contains(File.separator) ? path + File.separator : path + "/";
        }
        return path;
    }

    public static String getDir(String title) {
        return IJ.getDirectory(title);
    }

    public static String getFilePath(String dialogTitle) {
        OpenDialog od = new OpenDialog(dialogTitle);
        return od.getPath();
    }

    public static void open() {
        IJ.open(null);
    }

    public static void open(String path) {
        if (ij == null && Menus.getCommands() == null) {
            IJ.init();
        }
        Opener o = new Opener();
        macroRunning = true;
        if (path == null || path.equals("")) {
            o.open();
        } else {
            o.open(path);
        }
        macroRunning = false;
    }

    public static void open(String path, int n) {
        ImagePlus imp;
        if (ij == null && Menus.getCommands() == null) {
            IJ.init();
        }
        if ((imp = IJ.openImage(path, n)) != null) {
            imp.show();
        }
    }

    public static ImagePlus openImage(String path) {
        macroRunning = true;
        ImagePlus imp = new Opener().openImage(path);
        macroRunning = false;
        return imp;
    }

    public static ImagePlus openImage(String path, int n) {
        return new Opener().openImage(path, n);
    }

    public static ImagePlus openVirtual(String path) {
        return FileInfoVirtualStack.openVirtual(path);
    }

    public static ImagePlus openImage() {
        return IJ.openImage(null);
    }

    public static String openUrlAsString(String url) {
        url = Opener.updateUrl(url);
        if (debugMode) {
            IJ.log("OpenUrlAsString: " + url);
        }
        StringBuffer sb = null;
        url = url.replaceAll(" ", "%20");
        try {
            String line;
            URL u = new URL(url);
            URLConnection uc = u.openConnection();
            long len = uc.getContentLength();
            if (len > 0x500000L) {
                return "<Error: file is larger than 5MB>";
            }
            InputStream in = u.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            in.close();
        }
        catch (Exception e) {
            return "<Error: " + e + ">";
        }
        if (sb != null) {
            return new String(sb);
        }
        return "";
    }

    public static void save(String path) {
        IJ.save(null, path);
    }

    public static void save(ImagePlus imp, String path) {
        int dotLoc;
        ImagePlus imp2 = imp;
        if (imp2 == null) {
            imp2 = WindowManager.getCurrentImage();
        }
        if ((dotLoc = path.lastIndexOf(46)) == -1 && imp2 != null) {
            path = path + ".tif";
            dotLoc = path.lastIndexOf(46);
        }
        if (dotLoc != -1) {
            String title = imp2 != null ? imp2.getTitle() : null;
            IJ.saveAs(imp, path.substring(dotLoc + 1), path);
            if (title != null) {
                imp2.setTitle(title);
            }
        } else {
            IJ.error("The file path passed to IJ.save() method or save()\nmacro function is missing the required extension.\n \n\"" + path + "\"");
        }
    }

    public static void saveAs(String format, String path) {
        IJ.saveAs(null, format, path);
    }

    public static void saveAs(ImagePlus imp, String format, String path) {
        Roi roi2;
        if (format == null) {
            return;
        }
        if (path != null && path.length() == 0) {
            path = null;
        }
        format = format.toLowerCase(Locale.US);
        Roi roi = roi2 = imp != null ? imp.getRoi() : null;
        if (roi2 != null) {
            roi2.endPaste();
        }
        if (format.indexOf("tif") != -1) {
            IJ.saveAsTiff(imp, path);
            return;
        }
        if (format.indexOf("jpeg") != -1 || format.indexOf("jpg") != -1) {
            path = IJ.updateExtension(path, ".jpg");
            JpegWriter.save(imp, path, FileSaver.getJpegQuality());
            return;
        }
        if (format.indexOf("gif") != -1) {
            path = IJ.updateExtension(path, ".gif");
            GifWriter.save(imp, path);
            return;
        }
        if (format.indexOf("text image") != -1) {
            path = IJ.updateExtension(path, ".txt");
            format = "Text Image...";
        } else if (format.indexOf("text") != -1 || format.indexOf("txt") != -1) {
            if (!(path == null || path.endsWith(".xls") || path.endsWith(".csv") || path.endsWith(".tsv"))) {
                path = IJ.updateExtension(path, ".txt");
            }
            format = "Text...";
        } else if (format.indexOf("zip") != -1) {
            path = IJ.updateExtension(path, ".zip");
            format = "ZIP...";
        } else if (format.indexOf("raw") != -1) {
            format = "Raw Data...";
        } else if (format.indexOf("avi") != -1) {
            path = IJ.updateExtension(path, ".avi");
            format = "AVI... ";
        } else if (format.indexOf("bmp") != -1) {
            path = IJ.updateExtension(path, ".bmp");
            format = "BMP...";
        } else if (format.indexOf("fits") != -1) {
            path = IJ.updateExtension(path, ".fits");
            format = "FITS...";
        } else if (format.indexOf("png") != -1) {
            path = IJ.updateExtension(path, ".png");
            format = "PNG...";
        } else if (format.indexOf("pgm") != -1) {
            path = IJ.updateExtension(path, ".pgm");
            format = "PGM...";
        } else if (format.indexOf("lut") != -1) {
            path = IJ.updateExtension(path, ".lut");
            format = "LUT...";
        } else if (format.contains("results") || format.contains("measurements") || format.contains("table")) {
            format = "Results...";
        } else if (format.contains("selection") || format.contains("roi")) {
            path = IJ.updateExtension(path, ".roi");
            format = "Selection...";
        } else if (format.indexOf("xy") != -1 || format.indexOf("coordinates") != -1) {
            path = IJ.updateExtension(path, ".txt");
            format = "XY Coordinates...";
        } else {
            IJ.error("Unsupported save() or saveAs() file format: \"" + format + "\"\n \n\"" + path + "\"");
        }
        if (path == null) {
            IJ.run(format);
        } else if (path.contains(" ")) {
            IJ.run(imp, format, "save=[" + path + "]");
        } else {
            IJ.run(imp, format, "save=" + path);
        }
    }

    public static boolean saveAsTiff(ImagePlus imp, String path) {
        if (imp == null) {
            imp = IJ.getImage();
        }
        if (path == null || path.equals("")) {
            return new FileSaver(imp).saveAsTiff();
        }
        if (!path.endsWith(".tiff")) {
            path = IJ.updateExtension(path, ".tif");
        }
        FileSaver fs = new FileSaver(imp);
        boolean ok = imp.getStackSize() > 1 ? fs.saveAsTiffStack(path) : fs.saveAsTiff(path);
        if (ok) {
            fs.updateImagePlus(path, 2);
        }
        return ok;
    }

    static String updateExtension(String path, String extension) {
        if (path == null) {
            return null;
        }
        int dotIndex = path.lastIndexOf(".");
        int separatorIndex = path.lastIndexOf(File.separator);
        path = dotIndex >= 0 && dotIndex > separatorIndex && path.length() - dotIndex <= 5 ? (dotIndex + 1 < path.length() && Character.isDigit(path.charAt(dotIndex + 1)) ? path + extension : path.substring(0, dotIndex) + extension) : path + extension;
        return path;
    }

    public static String saveString(String string, String path) {
        return IJ.write(string, path, false);
    }

    public static String append(String string, String path) {
        return IJ.write(string + "\n", path, true);
    }

    private static String write(String string, String path, boolean append) {
        if (path == null || path.equals("")) {
            String msg = append ? "Append String..." : "Save String...";
            SaveDialog sd = new SaveDialog(msg, "Untitled", ".txt");
            String name = sd.getFileName();
            if (name == null) {
                return null;
            }
            path = sd.getDirectory() + name;
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(path, append));
            out.write(string);
            out.close();
        }
        catch (IOException e) {
            return "" + e;
        }
        return null;
    }

    public static String openAsString(String path) {
        if (path == null || path.equals("")) {
            OpenDialog od = new OpenDialog("Open Text File", "");
            String directory = od.getDirectory();
            String name = od.getFileName();
            if (name == null) {
                return null;
            }
            path = directory + name;
        }
        String str = "";
        File file = new File(path);
        if (!file.exists()) {
            return "Error: file not found";
        }
        try {
            String s;
            StringBuffer sb = new StringBuffer(5000);
            BufferedReader r = new BufferedReader(new FileReader(file));
            while ((s = r.readLine()) != null) {
                sb.append(s + "\n");
            }
            r.close();
            str = new String(sb);
        }
        catch (Exception e) {
            str = "Error: " + e.getMessage();
        }
        return str;
    }

    public static ByteBuffer openAsByteBuffer(String path) {
        File file;
        if (path == null || path.equals("")) {
            OpenDialog od = new OpenDialog("Open as ByteBuffer", "");
            String directory = od.getDirectory();
            String name = od.getFileName();
            if (name == null) {
                return null;
            }
            path = directory + name;
        }
        if (!(file = new File(path)).exists()) {
            IJ.error("OpenAsByteBuffer", "File not found");
            return null;
        }
        int len = (int)file.length();
        byte[] buffer = new byte[len];
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(path));
            DataInputStream dis = new DataInputStream(in);
            dis.readFully(buffer);
            dis.close();
        }
        catch (Exception e) {
            IJ.error("OpenAsByteBuffer", e.getMessage());
            return null;
        }
        return ByteBuffer.wrap(buffer);
    }

    public static ImagePlus createImage(String title, int width, int height, int depth, int bitdepth) {
        return NewImage.createImage(title, width, height, depth, bitdepth, 1);
    }

    public static ImagePlus createImage(String title, String type, int width, int height, int depth) {
        type = type.toLowerCase(Locale.US);
        int bitDepth = 8;
        if (type.contains("16")) {
            bitDepth = 16;
        }
        boolean signedInt = type.contains("32-bit int");
        if (type.contains("32")) {
            bitDepth = 32;
        }
        if (type.contains("24") || type.contains("rgb") || signedInt) {
            bitDepth = 24;
        }
        int options = 4;
        if (bitDepth == 16 || bitDepth == 32) {
            options = 1;
        }
        if (type.contains("white")) {
            options = 4;
        } else if (type.contains("black")) {
            options = 1;
        } else if (type.contains("ramp")) {
            options = 2;
        } else if (type.contains("noise") || type.contains("random")) {
            options = 3;
        }
        options += 8;
        if (signedInt) {
            options += 16;
        }
        return NewImage.createImage(title, width, height, depth, bitDepth, options);
    }

    public static ImagePlus createImage(String title, String type, int width, int height, int channels, int slices, int frames) {
        if (type.contains("label")) {
            type = type + "ramp";
        }
        if (!type.contains("white") && !type.contains("ramp")) {
            type = type + "black";
        }
        ImagePlus imp = IJ.createImage(title, type, width, height, channels * slices * frames);
        imp.setDimensions(channels, slices, frames);
        int mode = 2;
        if (type.contains("composite")) {
            mode = 1;
        }
        if (type.contains("grayscale")) {
            mode = 3;
        }
        if (channels > 1 && imp.getBitDepth() != 24) {
            imp = new CompositeImage(imp, mode);
        }
        imp.setOpenAsHyperStack(true);
        if (type.contains("label")) {
            HyperStackMaker.labelHyperstack(imp);
        }
        return imp;
    }

    public static ImagePlus createHyperStack(String title, int width, int height, int channels, int slices, int frames, int bitdepth) {
        ImagePlus imp = IJ.createImage(title, width, height, channels * slices * frames, bitdepth);
        imp.setDimensions(channels, slices, frames);
        if (channels > 1 && bitdepth != 24) {
            imp = new CompositeImage(imp, 1);
        }
        imp.setOpenAsHyperStack(true);
        return imp;
    }

    public static void newImage(String title, String type, int width, int height, int depth) {
        ImagePlus imp = IJ.createImage(title, type, width, height, depth);
        if (imp != null) {
            macroRunning = true;
            imp.show();
            macroRunning = false;
        }
    }

    public static boolean escapePressed() {
        return escapePressed;
    }

    public static void resetEscape() {
        escapePressed = false;
    }

    public static void redirectErrorMessages() {
        redirectErrorMessages = true;
        lastErrorMessage = null;
    }

    public static void redirectErrorMessages(boolean redirect) {
        redirectErrorMessages = redirect;
        lastErrorMessage = null;
    }

    public static boolean redirectingErrorMessages() {
        return redirectErrorMessages;
    }

    public static void suppressPluginNotFoundError() {
        suppressPluginNotFoundError = true;
    }

    public static ClassLoader getClassLoader() {
        if (classLoader == null) {
            String home;
            String pluginsDir = Menus.getPlugInsPath();
            if (pluginsDir == null && (home = System.getProperty("plugins.dir")) != null) {
                if (!home.endsWith(Prefs.separator)) {
                    home = home + Prefs.separator;
                }
                if (!new File(pluginsDir = home + "plugins" + Prefs.separator).isDirectory()) {
                    pluginsDir = home;
                }
            }
            if (pluginsDir == null) {
                return IJ.class.getClassLoader();
            }
            classLoader = Menus.jnlp ? new PluginClassLoader(pluginsDir, true) : new PluginClassLoader(pluginsDir);
        }
        return classLoader;
    }

    public static Dimension getScreenSize() {
        Rectangle bounds = GUI.getScreenBounds();
        return new Dimension(bounds.width, bounds.height);
    }

    public static String[] getLuts() {
        ArrayList<String> list = new ArrayList<String>();
        Hashtable commands = Menus.getCommands();
        Menu lutsMenu = Menus.getImageJMenu("Image>Lookup Tables");
        if (commands == null || lutsMenu == null) {
            return new String[0];
        }
        for (int i = 0; i < lutsMenu.getItemCount(); ++i) {
            String command;
            MenuItem menuItem = lutsMenu.getItem(i);
            String label = menuItem.getLabel();
            if (label.equals("-") || label.equals("Invert LUT") || label.equals("Apply LUT") || (command = (String)commands.get(label)) != null && !command.startsWith("ij.plugin.LutLoader")) continue;
            list.add(label);
        }
        return list.toArray(new String[list.size()]);
    }

    static void abort() {
        if ((ij != null || Interpreter.isBatchMode()) && macroInterpreter == null) {
            throw new RuntimeException("Macro canceled");
        }
    }

    static void setClassLoader(ClassLoader loader) {
        classLoader = loader;
    }

    public static void resetClassLoader() {
        IJ.setClassLoader(null);
    }

    public static void handleException(Throwable e) {
        if (exceptionHandler != null) {
            exceptionHandler.handle(e);
            return;
        }
        if ("Macro canceled".equals(e.getMessage())) {
            return;
        }
        CharArrayWriter caw = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(caw);
        e.printStackTrace(pw);
        String s = caw.toString();
        if (s != null && s.contains("ThreadDeath")) {
            return;
        }
        if (IJ.getInstance() != null) {
            s = IJ.getInstance().getInfo() + "\n \n" + s;
            new TextWindow("Exception", s, 500, 340);
        } else {
            IJ.log(s);
        }
    }

    public static void setExceptionHandler(ExceptionHandler handler) {
        exceptionHandler = handler;
    }

    public static void addEventListener(IJEventListener listener) {
        eventListeners.addElement(listener);
    }

    public static void removeEventListener(IJEventListener listener) {
        eventListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyEventListeners(int eventID) {
        Vector vector = eventListeners;
        synchronized (vector) {
            for (int i = 0; i < eventListeners.size(); ++i) {
                IJEventListener listener = (IJEventListener)eventListeners.elementAt(i);
                listener.eventOccurred(eventID);
            }
        }
    }

    public static void setProperty(String key, Object value) {
        if (properties == null) {
            properties = new Properties();
        }
        if (value == null) {
            properties.remove(key);
        } else {
            properties.put(key, value);
        }
    }

    public static Object getProperty(String key) {
        if (properties == null) {
            return null;
        }
        return properties.get(key);
    }

    public static boolean statusBarProtected() {
        return protectStatusBar;
    }

    public static void protectStatusBar(boolean protect) {
        protectStatusBar = protect;
        if (!protectStatusBar) {
            statusBarThread = null;
        }
    }

    static {
        checkForDuplicatePlugins = true;
        eventListeners = new Vector();
        osname = System.getProperty("os.name");
        isWin = osname.startsWith("Windows");
        isMac = !isWin && osname.startsWith("Mac");
        isLinux = osname.startsWith("Linux");
        String version = System.getProperty("java.version");
        if (version == null || version.length() < 2) {
            version = "1.8";
        }
        javaVersion = version.startsWith("1.8") ? 8 : (version.charAt(0) == '1' && Character.isDigit(version.charAt(1)) ? 10 + (version.charAt(1) - 48) : (version.charAt(0) == '2' && Character.isDigit(version.charAt(1)) ? 20 + (version.charAt(1) - 48) : (version.startsWith("1.6") ? 6 : (version.startsWith("1.9") || version.startsWith("9") ? 9 : (version.startsWith("1.7") ? 7 : 8)))));
        dfs = new DecimalFormatSymbols(Locale.US);
        df = new DecimalFormat[10];
        IJ.df[0] = new DecimalFormat("0", dfs);
        IJ.df[1] = new DecimalFormat("0.0", dfs);
        IJ.df[2] = new DecimalFormat("0.00", dfs);
        IJ.df[3] = new DecimalFormat("0.000", dfs);
        IJ.df[4] = new DecimalFormat("0.0000", dfs);
        IJ.df[5] = new DecimalFormat("0.00000", dfs);
        IJ.df[6] = new DecimalFormat("0.000000", dfs);
        IJ.df[7] = new DecimalFormat("0.0000000", dfs);
        IJ.df[8] = new DecimalFormat("0.00000000", dfs);
        IJ.df[9] = new DecimalFormat("0.000000000", dfs);
        df[0].setRoundingMode(RoundingMode.HALF_UP);
    }

    public static interface ExceptionHandler {
        public void handle(Throwable var1);
    }
}

