/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jgl3dchart;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import fr.esrf.tangoatk.widget.util.jgl3dchart.JGL3DView;
import fr.esrf.tangoatk.widget.util.jgl3dchart.LabelInfo;
import fr.esrf.tangoatk.widget.util.jgl3dchart.Utils;
import fr.esrf.tangoatk.widget.util.jgl3dchart.VERTEX3D;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;

public class JGL3DAxis {
    public static final int XAXIS = 0;
    public static final int YAXIS = 1;
    public static final int ZAXIS = 2;
    public static final int AUTO_FORMAT = 0;
    public static final int SCIENTIFIC_FORMAT = 1;
    public static final int TIME_FORMAT = 2;
    public static final int DECINT_FORMAT = 3;
    public static final int HEXINT_FORMAT = 4;
    public static final int BININT_FORMAT = 5;
    public static final int SCIENTIFICINT_FORMAT = 6;
    public static final int LINEAR_SCALE = 0;
    public static final int LOG_SCALE = 1;
    static final String[] labelFomats = new String[]{"%g", "", "%02d:%02d:%02d", "%d", "%X", "%b"};
    VERTEX3D p1;
    VERTEX3D p2;
    VERTEX3D normal;
    private JGL3DView parent;
    private Color labelColor;
    private Font labelFont;
    private Color nameColor;
    private Font nameFont;
    private int labelFormat;
    private int scale;
    ArrayList<LabelInfo> labelInfo;
    LabelInfo nameInfo;
    private int type;
    private String name;
    private boolean drawAble;
    private boolean visible;
    private double min;
    private double max;
    private double minimum;
    private double maximum;
    private boolean autoScale;
    private int tickSpacing;
    private double offLabel;
    private double atOffset;
    private double atGain;

    public JGL3DAxis(JGL3DView parent, int type) {
        this.type = type;
        this.parent = parent;
        this.labelFont = new Font("Dialog", 0, 11);
        this.nameFont = new Font("Dialog", 1, 11);
        this.labelColor = Color.black;
        this.labelFormat = 0;
        this.scale = 0;
        this.labelInfo = new ArrayList();
        this.name = "";
        this.drawAble = true;
        this.visible = true;
        this.min = 0.0;
        this.max = 100.0;
        this.minimum = 0.0;
        this.maximum = 100.0;
        this.autoScale = true;
        this.tickSpacing = 30;
        this.offLabel = 4.0;
        this.atOffset = 0.0;
        this.atGain = 1.0;
    }

    public void setLabelFormat(int l) {
        this.labelFormat = l;
    }

    public int getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFont(Font lFont) {
        this.labelFont = lFont;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setNameFont(Font lFont) {
        this.nameFont = lFont;
    }

    public Font getNameFont() {
        return this.nameFont;
    }

    public void setNameColor(Color color) {
        this.nameColor = color;
    }

    public Color getNameColor() {
        return this.nameColor;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setMaximum(double max) {
        this.maximum = max;
        this.parent.computeScale();
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setMinimum(double min) {
        this.minimum = min;
        this.parent.computeScale();
    }

    public void setScale(int scale) {
        this.scale = scale;
        this.parent.computeScale();
    }

    public int getScale() {
        return this.scale;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setAutoScale(boolean enable) {
        this.autoScale = enable;
        this.parent.computeScale();
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setTickSpacing(int tickSpacing) {
        this.tickSpacing = tickSpacing;
    }

    public int getTickSpacing() {
        return this.tickSpacing;
    }

    public void setTitleOffset(double offset) {
        this.offLabel = offset;
    }

    public double getTitleOffset() {
        return this.offLabel;
    }

    public void setOffsetTransform(double offset) {
        this.atOffset = offset;
        this.parent.computeScale();
    }

    public double getOffsetTransform() {
        return this.atOffset;
    }

    public void setGainTransform(double gain) {
        this.atGain = gain;
        this.parent.computeScale();
    }

    public double getGainTransform() {
        return this.atGain;
    }

    boolean isDrawAble() {
        return this.drawAble;
    }

    double getMin() {
        return this.min * this.atGain;
    }

    double getMax() {
        return this.max * this.atGain;
    }

    void setMin(double min) {
        this.min = min;
    }

    void setMax(double max) {
        this.max = max;
    }

    void setPosition(VERTEX3D p1, VERTEX3D p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    void setNormal(VERTEX3D normal) {
        this.normal = normal;
    }

    private String toScientific(double d) {
        double a = Math.abs(d);
        int e = 0;
        String f = "%.2fe%d";
        if (a != 0.0) {
            if (a < 1.0) {
                while (a < 1.0) {
                    a *= 10.0;
                    --e;
                }
            } else {
                while (a >= 10.0) {
                    a /= 10.0;
                    ++e;
                }
            }
        }
        if (a >= 9.999999999) {
            a /= 10.0;
            ++e;
        }
        if (d < 0.0) {
            a = -a;
        }
        return String.format(f, a, e);
    }

    private String toScientificInt(double d) {
        double a = Math.abs(d);
        int e = 0;
        String f = "%de%d";
        if (a != 0.0) {
            if (a < 1.0) {
                while (a < 1.0) {
                    a *= 10.0;
                    --e;
                }
            } else {
                while (a >= 10.0) {
                    a /= 10.0;
                    ++e;
                }
            }
        }
        if (a >= 9.999999999) {
            a /= 10.0;
            ++e;
        }
        if (d < 0.0) {
            a = -a;
        }
        return String.format(f, (int)Math.rint(a), e);
    }

    private String suppressZero(String n) {
        boolean hasDecimal;
        if (n.indexOf(101) >= 0 || n.indexOf(69) >= 0) {
            return n;
        }
        boolean bl = hasDecimal = n.indexOf(46) != -1;
        if (hasDecimal) {
            StringBuffer str = new StringBuffer(n);
            int i = str.length() - 1;
            while (str.charAt(i) == '0') {
                str.deleteCharAt(i);
                --i;
            }
            if (str.charAt(i) == '.') {
                str.deleteCharAt(i);
            }
            return str.toString();
        }
        return n;
    }

    private String formatValue(double vt, double prec) {
        if (Double.isNaN(vt)) {
            return "NaN";
        }
        if (this.scale == 1) {
            vt = Math.pow(10.0, vt);
        }
        if (prec != 0.0 && this.scale == 0) {
            boolean isNegative;
            boolean bl = isNegative = vt < 0.0;
            if (isNegative) {
                vt = -vt;
            }
            double i = Math.floor(vt / prec + 0.5);
            vt = i * prec;
            if (isNegative) {
                vt = -vt;
            }
        }
        switch (this.labelFormat) {
            case 1: {
                return this.toScientific(vt);
            }
            case 6: {
                return this.toScientificInt(vt);
            }
            case 3: 
            case 4: 
            case 5: {
                if (vt < 0.0) {
                    return "-" + String.format(labelFomats[this.labelFormat], (int)(Math.abs(vt) + 0.5));
                }
                return String.format(labelFomats[this.labelFormat], (int)(Math.abs(vt) + 0.5));
            }
            case 2: {
                int sec = (int)Math.abs(vt);
                int h = sec / 3600;
                int m = sec % 3600 / 60;
                int s = sec % 60;
                if (vt < 0.0) {
                    return "-" + String.format(labelFomats[this.labelFormat], h, m, s);
                }
                return String.format(labelFomats[this.labelFormat], h, m, s);
            }
        }
        if (vt == 0.0) {
            return "0";
        }
        if (Math.abs(vt) <= 1.0E-4) {
            return this.toScientific(vt);
        }
        int nbDigit = -((int)Math.floor(Math.log10(prec)));
        if (nbDigit <= 0) {
            return this.suppressZero(Double.toString(vt));
        }
        String dFormat = "%." + nbDigit + "f";
        return this.suppressZero(String.format(dFormat, vt));
    }

    private void computeTicks(GLU glu, GL gl, double length) {
        double sx;
        double startx;
        double min = 0.0;
        double max = 0.0;
        VERTEX3D axisPos = new VERTEX3D();
        boolean extractLabel = false;
        double[] coord = new double[2];
        switch (this.type) {
            case 0: {
                min = this.p1.x;
                max = this.p2.x;
                axisPos.x = 0.0;
                axisPos.y = this.p1.y;
                axisPos.z = this.p1.z;
                break;
            }
            case 1: {
                min = this.p1.y;
                max = this.p2.y;
                axisPos.x = this.p1.x;
                axisPos.y = 0.0;
                axisPos.z = this.p1.z;
                break;
            }
            case 2: {
                min = this.p1.z;
                max = this.p2.z;
                axisPos.x = this.p1.x;
                axisPos.y = this.p1.y;
                axisPos.z = 0.0;
            }
        }
        double prec = this.computeLowTen((max /= this.atGain) - (min /= this.atGain));
        int n = (int)Math.rint((max - min) / prec);
        int nbMaxLab = (int)length / this.tickSpacing;
        if (nbMaxLab > 20) {
            nbMaxLab = 20;
        }
        double sz = max - min;
        int step = 10;
        double precDelta = sz / length;
        if (this.scale == 1) {
            prec = 1.0;
            startx = Math.rint(min);
            n = (int)Math.rint((max - min) / prec);
            while (n > nbMaxLab) {
                n = (int)Math.rint((max - min) / (prec *= 2.0));
                if (n <= nbMaxLab) continue;
                n = (int)Math.rint((max - min) / (prec *= 5.0));
            }
        } else {
            if (n <= nbMaxLab) {
                n = (int)Math.rint((max - min) / (prec / 2.0));
                while (n <= nbMaxLab) {
                    step = 5;
                    n = (int)Math.rint((max - min) / ((prec /= 2.0) / 5.0));
                    if (n > nbMaxLab) continue;
                    step = 10;
                    n = (int)Math.rint((max - min) / ((prec /= 5.0) / 2.0));
                }
            } else {
                while (n > nbMaxLab) {
                    step = 5;
                    n = (int)Math.rint((max - min) / (prec *= 5.0));
                    if (n <= nbMaxLab) continue;
                    step = 10;
                    n = (int)Math.rint((max - min) / (prec *= 2.0));
                }
            }
            long round = (long)Math.floor(min / prec);
            int nbL = 0;
            for (sx = startx = (double)round * prec; sx <= max + precDelta; sx += prec) {
                if (!(sx >= min - precDelta)) continue;
                ++nbL;
            }
            if (nbL <= 2) {
                prec = step == 10 ? (prec /= 2.0) : (prec /= 5.0);
                extractLabel = true;
            }
        }
        VERTEX3D nV = new VERTEX3D(this.p2.x - this.p1.x, this.p2.y - this.p1.y, this.p2.z - this.p1.z);
        nV.normalize();
        while (startx <= max + precDelta) {
            if (startx > min - precDelta) {
                LabelInfo l = new LabelInfo();
                sx = startx * this.atGain;
                l.p1 = new VERTEX3D(sx * nV.x + axisPos.x, sx * nV.y + axisPos.y, sx * nV.z + axisPos.z);
                l.p2 = new VERTEX3D(sx * nV.x + this.normal.x + axisPos.x, sx * nV.y + this.normal.y + axisPos.y, sx * nV.z + this.normal.z + axisPos.z);
                l.value = this.formatValue(startx, prec);
                l.labelColor = this.labelColor;
                double offLabel = 1.5;
                Utils.project(glu, gl, sx * nV.x + axisPos.x, sx * nV.y + axisPos.y, sx * nV.z + axisPos.z, coord);
                l.x1 = coord[0];
                l.y1 = coord[1];
                Utils.project(glu, gl, sx * nV.x + axisPos.x + this.normal.x * offLabel, sx * nV.y + axisPos.y + this.normal.y * offLabel, sx * nV.z + axisPos.z + this.normal.z * offLabel, coord);
                l.x2 = coord[0];
                l.y2 = coord[1];
                this.labelInfo.add(l);
            }
            startx += prec;
        }
        if (extractLabel && this.labelInfo.size() > 2) {
            ArrayList<LabelInfo> nLabels = new ArrayList<LabelInfo>();
            LabelInfo lis = this.labelInfo.get(0);
            LabelInfo lie = this.labelInfo.get(this.labelInfo.size() - 1);
            nLabels.add(lis);
            nLabels.add(lie);
            this.labelInfo = nLabels;
        }
        double middlePos = (max + min) / 2.0;
        this.nameInfo = new LabelInfo();
        this.nameInfo.value = this.name;
        this.nameInfo.labelColor = this.nameColor;
        Utils.project(glu, gl, middlePos * nV.x + axisPos.x, middlePos * nV.y + axisPos.y, middlePos * nV.z + axisPos.z, coord);
        this.nameInfo.x1 = coord[0];
        this.nameInfo.y1 = coord[1];
        Utils.project(glu, gl, middlePos * nV.x + axisPos.x + this.normal.x * this.offLabel, middlePos * nV.y + axisPos.y + this.normal.y * this.offLabel, middlePos * nV.z + axisPos.z + this.normal.z * this.offLabel, coord);
        this.nameInfo.x2 = coord[0];
        this.nameInfo.y2 = coord[1];
    }

    private double computeHighTen(double d) {
        int p = (int)Math.log10(d);
        return Math.pow(10.0, p + 1);
    }

    private double computeLowTen(double d) {
        int p = (int)Math.log10(d);
        return Math.pow(10.0, p);
    }

    void measureAxis(GLU glu, GL gl) {
        this.labelInfo.clear();
        double[] coord = new double[2];
        Utils.project(glu, gl, this.p1.x, this.p1.y, this.p1.z, coord);
        double x1 = coord[0];
        double y1 = coord[1];
        Utils.project(glu, gl, this.p2.x, this.p2.y, this.p2.z, coord);
        double x2 = coord[0];
        double y2 = coord[1];
        double axisLenght = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        this.drawAble = !(axisLenght < 10.0);
        if (this.drawAble) {
            this.computeTicks(glu, gl, axisLenght);
        }
    }

    void paintAxisLabel(GL gl, int screenWidth, int screenHeight) {
        if (this.isVisible() && this.isDrawAble()) {
            for (int i = 0; i < this.labelInfo.size(); ++i) {
                LabelInfo l = this.labelInfo.get(i);
                l.paint(gl, screenWidth, screenHeight);
            }
            this.nameInfo.paint(gl, screenWidth, screenHeight);
        }
    }

    void paintAxis(GL gl) {
        if (!this.drawAble || !this.visible) {
            return;
        }
        GL2 gl2 = (GL2)gl;
        gl2.glDisable(2896);
        gl2.glDisable(3553);
        gl2.glDisable(2929);
        gl2.glDisable(2852);
        gl2.glLineWidth(2.0f);
        gl2.glColor3f((float)this.labelColor.getRed() / 255.0f, (float)this.labelColor.getGreen() / 255.0f, (float)this.labelColor.getBlue() / 255.0f);
        gl2.glBegin(1);
        gl2.glVertex3f((float)this.p1.x, (float)this.p1.y, (float)this.p1.z);
        gl2.glVertex3f((float)this.p2.x, (float)this.p2.y, (float)this.p2.z);
        gl2.glEnd();
        gl2.glLineWidth(1.0f);
        gl2.glBegin(1);
        for (int i = 0; i < this.labelInfo.size(); ++i) {
            LabelInfo li = this.labelInfo.get(i);
            gl2.glVertex3f((float)li.p1.x, (float)li.p1.y, (float)li.p1.z);
            gl2.glVertex3f((float)li.p2.x, (float)li.p2.y, (float)li.p2.z);
        }
        gl2.glEnd();
    }
}

