/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDBar;
import fr.esrf.tangoatk.widget.util.jdraw.JDEllipse;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroup;
import fr.esrf.tangoatk.widget.util.jdraw.JDImage;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDSlider;
import fr.esrf.tangoatk.widget.util.jdraw.JDSpline;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDTitledRect;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.util.Vector;

class UndoBuffer {
    UndoPattern[] undoBuffer;
    String name;

    UndoBuffer(Vector objects, String n) {
        this.undoBuffer = new UndoPattern[objects.size()];
        for (int i = 0; i < objects.size(); ++i) {
            this.undoBuffer[i] = ((JDObject)objects.get(i)).getUndoPattern();
        }
        this.name = n;
    }

    UndoBuffer(JDObject[] objects, String n) {
        this.undoBuffer = new UndoPattern[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            this.undoBuffer[i] = objects[i].getUndoPattern();
        }
        this.name = n;
    }

    static void rebuildObject(UndoPattern u, Vector children) {
        switch (u.JDclass) {
            case 1: {
                children.add(new JDEllipse(u));
                break;
            }
            case 2: {
                children.add(new JDGroup(u));
                break;
            }
            case 3: {
                children.add(new JDLabel(u));
                break;
            }
            case 4: {
                children.add(new JDLine(u));
                break;
            }
            case 5: {
                children.add(new JDPolyline(u));
                break;
            }
            case 6: {
                children.add(new JDRectangle(u));
                break;
            }
            case 7: {
                children.add(new JDRoundRectangle(u));
                break;
            }
            case 14: {
                children.add(new JDTitledRect(u));
                break;
            }
            case 8: {
                children.add(new JDSpline(u));
                break;
            }
            case 9: {
                children.add(new JDImage(u));
                break;
            }
            case 10: {
                children.add(new JDSwingObject(u));
                break;
            }
            case 11: {
                children.add(new JDAxis(u));
                break;
            }
            case 12: {
                children.add(new JDBar(u));
                break;
            }
            case 13: {
                children.add(new JDSlider(u));
                break;
            }
            default: {
                System.out.println("!!! UndoBuffer.rebuildObject() : WARNING Undo failure !!!");
            }
        }
    }

    Vector rebuild() {
        Vector children = new Vector();
        for (int i = 0; i < this.undoBuffer.length; ++i) {
            UndoBuffer.rebuildObject(this.undoBuffer[i], children);
        }
        return children;
    }

    UndoPattern get(int id) {
        return this.undoBuffer[id];
    }

    String getName() {
        return this.name;
    }
}

