/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.jdraw.SimpleSynopticAppli;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.FileFinder;
import fr.esrf.tangoatk.widget.util.jdraw.JDClipboard;
import fr.esrf.tangoatk.widget.util.jdraw.JDCreationMenu;
import fr.esrf.tangoatk.widget.util.jdraw.JDDeviceTree;
import fr.esrf.tangoatk.widget.util.jdraw.JDLibraryViewer;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueListener;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditorListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class JDrawEditorFrame
extends JFrame
implements ActionListener,
JDrawEditorListener,
JDValueListener {
    public JScrollPane theEditorView;
    public JLabel statusLabel;
    public JMenu fileMenu;
    public JMenuItem fileOpenMenuItem;
    public JMenuItem fileImportMenuItem;
    public JMenuItem fileSaveMenuItem;
    public JMenuItem fileSaveasMenuItem;
    public JMenuItem fileExitMenuItem;
    public JMenu editMenu;
    public JMenuItem editUndoMenuItem;
    public JMenuItem editRedoMenuItem;
    public JMenuItem editCutMenuItem;
    public JMenuItem editCopyMenuItem;
    public JMenuItem editPasteMenuItem;
    public JMenuItem editDeleteMenuItem;
    public JMenuItem editSelectAllMenuItem;
    public JMenuItem editSelectNVMenuItem;
    public JMenuItem editSelectNoneMenuItem;
    public JMenu viewsMenu;
    public JMenuItem viewsTransformMenuItem;
    public JMenuItem viewsPlayMenuItem;
    public JMenuItem viewsTangoSynopticMenuItem;
    public JMenuItem viewsOptionMenuItem;
    public JMenuItem viewsBrowseMenuItem;
    private JMenuItem viewsGroupEditMenuItem;
    private JMenuItem viewsJavaMenuItem;
    private JMenuItem viewsGlobalMenuItem;
    public JMenu toolsMenu;
    public JMenuItem toolsHMirrorMenuItem;
    public JMenuItem toolsVMirrorMenuItem;
    public JMenuItem toolsAligntopMenuItem;
    public JMenuItem toolsAlignleftMenuItem;
    public JMenuItem toolsAlignbottomMenuItem;
    public JMenuItem toolsAlignrightMenuItem;
    private JMenuItem toolsRaiseMenuItem;
    private JMenuItem toolsLowerMenuItem;
    private JMenuItem toolsFrontMenuItem;
    private JMenuItem toolsBackMenuItem;
    private JMenuItem toolsConvertPolyMenuItem;
    private JCheckBoxMenuItem toolsGridVisible;
    private JCheckBoxMenuItem toolsAlignToGrid;
    private JMenuItem toolsGridSettings;
    private JMenuItem toolsFitToGraph;
    public JDCreationMenu createMenu;
    public JToolBar editToolBar;
    public JButton editToolFileOpenBtn;
    public JButton editToolFileSaveBtn;
    public JButton editToolUndoBtn;
    public JButton editToolRedoBtn;
    public JButton editToolCutBtn;
    public JButton editToolCopyBtn;
    public JButton editToolPasteBtn;
    public JButton editToolZoomInBtn;
    public JButton editToolZoomOutBtn;
    public JLabel editToolZoomLabel;
    public JButton editToolOptionBtn;
    public JButton editToolTransformBtn;
    public JButton editToolHMirrorBtn;
    public JButton editToolVMirrorBtn;
    public JButton editToolAlignLeftBtn;
    public JButton editToolAlignTopBtn;
    public JButton editToolAlignRightBtn;
    public JButton editToolAlignBottomBtn;
    private JDrawEditor theEditor;
    private JDrawEditor thePlayer;
    private JFrame framePlayer;
    private JScrollPane fpTextView;
    private JTextArea fpText;
    private JMenuItem viewDebugOutput;
    private JMenuItem hideDebugOutput;
    private JMenuItem clearDebugOutput;
    private StringBuffer fpStr;
    private JPanel statusLine;
    private JMenuBar theMenu;
    private String APP_RELEASE;
    private JSplitPane splitPane;
    private JButton[] libButton;
    private JComboBox libCombo;
    private JDLibraryViewer[] libViewer;
    private int nLibs;
    private JDDeviceTree deviceTree;
    private JPanel editorPanel;
    private SimpleSynopticAppli theSynopticAppli = null;

    public JDrawEditorFrame() {
        this.setTitle(this.APP_RELEASE);
        JSplitPane sPane = new JSplitPane();
        this.editorPanel = new JPanel();
        this.editorPanel.setLayout(new BorderLayout());
        this.deviceTree = new JDDeviceTree();
        this.statusLine = new JPanel(new GridLayout(1, 1));
        this.editorPanel.add((Component)this.statusLine, "South");
        this.statusLabel = new JLabel();
        this.statusLabel.setFont(JDUtils.labelFont);
        this.statusLabel.setHorizontalAlignment(2);
        this.statusLine.add(this.statusLabel);
        this.createMenu = new JDCreationMenu();
        this.editorPanel.add((Component)this.createMenu.getToolbar(), "West");
        this.editToolBar = new JToolBar();
        this.editToolZoomLabel = new JLabel();
        this.editToolZoomLabel.setFont(JDUtils.labelFont);
        this.editToolZoomLabel.setText("100%");
        this.editToolZoomLabel.setHorizontalAlignment(0);
        this.editToolZoomLabel.setMaximumSize(new Dimension(50, 32));
        this.editToolZoomLabel.setPreferredSize(new Dimension(50, 32));
        this.editToolZoomLabel.setMinimumSize(new Dimension(50, 32));
        this.editToolFileOpenBtn = JDUtils.createIconButton("jdraw_fileopen", true, "Open File", this);
        this.editToolFileSaveBtn = JDUtils.createIconButton("jdraw_filesave", true, "Save File", this);
        this.editToolUndoBtn = JDUtils.createIconButton("jdraw_undo", true, "Undo the last action", this);
        this.editToolRedoBtn = JDUtils.createIconButton("jdraw_redo", true, "Redo the last canceled action", this);
        this.editToolCutBtn = JDUtils.createIconButton("jdraw_cut", true, "Cut selection", this);
        this.editToolCopyBtn = JDUtils.createIconButton("jdraw_copy", true, "Copy selection to clipboard", this);
        this.editToolPasteBtn = JDUtils.createIconButton("jdraw_paste", true, "Paste selection", this);
        this.editToolZoomInBtn = JDUtils.createIconButton("jdraw_zoom", true, "Zoom In", this);
        this.editToolZoomOutBtn = JDUtils.createIconButton("jdraw_zoomm", true, "Zoom Out", this);
        this.editToolOptionBtn = JDUtils.createIconButton("jdraw_option", true, "Show selected object(s) properties", this);
        this.editToolTransformBtn = JDUtils.createIconButton("jdraw_transform", true, "Show transformation dialog", this);
        this.editToolHMirrorBtn = JDUtils.createIconButton("jdraw_hmirror", true, "Horizontal mirror on selected object(s)", this);
        this.editToolVMirrorBtn = JDUtils.createIconButton("jdraw_vmirror", true, "Vertical mirror on selected object(s)", this);
        this.editToolAlignTopBtn = JDUtils.createIconButton("jdraw_aligntop", true, "Align selected objects", this);
        this.editToolAlignLeftBtn = JDUtils.createIconButton("jdraw_alignleft", true, "Align selected objects", this);
        this.editToolAlignBottomBtn = JDUtils.createIconButton("jdraw_alignbottom", true, "Align selected objects", this);
        this.editToolAlignRightBtn = JDUtils.createIconButton("jdraw_alignright", true, "Align selected objects", this);
        this.editToolBar.add(this.editToolFileOpenBtn);
        this.editToolBar.add(this.editToolFileSaveBtn);
        this.editToolBar.add(new JLabel(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/jdraw_separator.gif"))));
        this.editToolBar.add(this.editToolUndoBtn);
        this.editToolBar.add(this.editToolRedoBtn);
        this.editToolBar.add(new JLabel(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/jdraw_separator.gif"))));
        this.editToolBar.add(this.editToolCutBtn);
        this.editToolBar.add(this.editToolCopyBtn);
        this.editToolBar.add(this.editToolPasteBtn);
        this.editToolBar.add(new JLabel(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/jdraw_separator.gif"))));
        this.editToolBar.add(this.editToolZoomInBtn);
        this.editToolBar.add(this.editToolZoomOutBtn);
        this.editToolBar.add(this.editToolZoomLabel);
        this.editToolBar.add(new JLabel(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/jdraw_separator.gif"))));
        this.editToolBar.add(this.editToolOptionBtn);
        this.editToolBar.add(this.editToolTransformBtn);
        this.editToolBar.add(new JLabel(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/jdraw_separator.gif"))));
        this.editToolBar.add(this.editToolHMirrorBtn);
        this.editToolBar.add(this.editToolVMirrorBtn);
        this.editToolBar.add(this.editToolAlignTopBtn);
        this.editToolBar.add(this.editToolAlignLeftBtn);
        this.editToolBar.add(this.editToolAlignBottomBtn);
        this.editToolBar.add(this.editToolAlignRightBtn);
        this.editToolBar.setOrientation(0);
        this.editorPanel.add((Component)this.editToolBar, "North");
        this.theMenu = new JMenuBar();
        this.fileExitMenuItem = new JMenuItem("Exit");
        this.fileExitMenuItem.addActionListener(this);
        this.fileOpenMenuItem = new JMenuItem("Open...");
        this.fileOpenMenuItem.addActionListener(this);
        this.fileImportMenuItem = new JMenuItem("Import...");
        this.fileImportMenuItem.addActionListener(this);
        this.fileSaveMenuItem = new JMenuItem("Save");
        this.fileSaveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileSaveMenuItem.addActionListener(this);
        this.fileSaveasMenuItem = new JMenuItem("Save as...");
        this.fileSaveasMenuItem.addActionListener(this);
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('F');
        this.fileMenu.add(this.fileOpenMenuItem);
        this.fileMenu.add(this.fileImportMenuItem);
        this.fileMenu.add(this.fileSaveMenuItem);
        this.fileMenu.add(this.fileSaveasMenuItem);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(this.fileExitMenuItem);
        this.theMenu.add(this.fileMenu);
        this.editUndoMenuItem = new JMenuItem("Undo");
        this.editUndoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.editUndoMenuItem.addActionListener(this);
        this.editRedoMenuItem = new JMenuItem("Redo");
        this.editRedoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 3));
        this.editRedoMenuItem.addActionListener(this);
        this.editCutMenuItem = new JMenuItem("Cut");
        this.editCutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.editCutMenuItem.addActionListener(this);
        this.editCopyMenuItem = new JMenuItem("Copy");
        this.editCopyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.editCopyMenuItem.addActionListener(this);
        this.editPasteMenuItem = new JMenuItem("Paste");
        this.editPasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.editPasteMenuItem.addActionListener(this);
        this.editDeleteMenuItem = new JMenuItem("Delete");
        this.editDeleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(8, 0));
        this.editDeleteMenuItem.addActionListener(this);
        this.editSelectAllMenuItem = new JMenuItem("Select all");
        this.editSelectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.editSelectAllMenuItem.addActionListener(this);
        this.editSelectNoneMenuItem = new JMenuItem("Select none");
        this.editSelectNoneMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.editSelectNoneMenuItem.addActionListener(this);
        this.editSelectNVMenuItem = new JMenuItem("Select not visible");
        this.editSelectNVMenuItem.addActionListener(this);
        this.editMenu = new JMenu("Edit");
        this.editMenu.setMnemonic('E');
        this.editMenu.add(this.editUndoMenuItem);
        this.editMenu.add(this.editRedoMenuItem);
        this.editMenu.add(new JSeparator());
        this.editMenu.add(this.editCutMenuItem);
        this.editMenu.add(this.editCopyMenuItem);
        this.editMenu.add(this.editPasteMenuItem);
        this.editMenu.add(this.editDeleteMenuItem);
        this.editMenu.add(new JSeparator());
        this.editMenu.add(this.editSelectAllMenuItem);
        this.editMenu.add(this.editSelectNoneMenuItem);
        this.editMenu.add(this.editSelectNVMenuItem);
        this.theMenu.add(this.editMenu);
        this.theMenu.add(this.createMenu.getMenu());
        this.viewsPlayMenuItem = new JMenuItem("Player view");
        this.viewsPlayMenuItem.addActionListener(this);
        this.viewsTangoSynopticMenuItem = new JMenuItem("Tango Synoptic view");
        this.viewsTangoSynopticMenuItem.addActionListener(this);
        this.viewsOptionMenuItem = new JMenuItem("Object properties...");
        this.viewsOptionMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.viewsOptionMenuItem.addActionListener(this);
        this.viewsTransformMenuItem = new JMenuItem("Transform view...");
        this.viewsTransformMenuItem.addActionListener(this);
        this.viewsBrowseMenuItem = new JMenuItem("Selection browser...");
        this.viewsBrowseMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.viewsBrowseMenuItem.addActionListener(this);
        this.viewsGroupEditMenuItem = new JMenuItem("Group editor...");
        this.viewsGroupEditMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.viewsGroupEditMenuItem.addActionListener(this);
        this.viewsJavaMenuItem = new JMenuItem("Java code generator...");
        this.viewsJavaMenuItem.addActionListener(this);
        this.viewsGlobalMenuItem = new JMenuItem("Global properties...");
        this.viewsGlobalMenuItem.addActionListener(this);
        this.viewsMenu = new JMenu("Views");
        this.viewsMenu.setMnemonic('V');
        this.viewsMenu.add(this.viewsPlayMenuItem);
        this.viewsMenu.add(this.viewsTangoSynopticMenuItem);
        this.viewsMenu.add(this.viewsGlobalMenuItem);
        this.viewsMenu.add(this.viewsTransformMenuItem);
        this.viewsMenu.add(this.viewsOptionMenuItem);
        this.viewsMenu.add(this.viewsBrowseMenuItem);
        this.viewsMenu.add(this.viewsGroupEditMenuItem);
        this.viewsMenu.add(this.viewsJavaMenuItem);
        this.theMenu.add(this.viewsMenu);
        this.toolsHMirrorMenuItem = new JMenuItem("Horizontal mirror");
        this.toolsHMirrorMenuItem.addActionListener(this);
        this.toolsVMirrorMenuItem = new JMenuItem("Vertical mirror");
        this.toolsVMirrorMenuItem.addActionListener(this);
        this.toolsAligntopMenuItem = new JMenuItem("Align top");
        this.toolsAligntopMenuItem.addActionListener(this);
        this.toolsAlignleftMenuItem = new JMenuItem("Align left");
        this.toolsAlignleftMenuItem.addActionListener(this);
        this.toolsAlignbottomMenuItem = new JMenuItem("Align bottom");
        this.toolsAlignbottomMenuItem.addActionListener(this);
        this.toolsAlignrightMenuItem = new JMenuItem("Align right");
        this.toolsAlignrightMenuItem.addActionListener(this);
        this.toolsConvertPolyMenuItem = new JMenuItem("Convert to Polyline");
        this.toolsConvertPolyMenuItem.addActionListener(this);
        this.toolsRaiseMenuItem = new JMenuItem("Raise");
        this.toolsRaiseMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 3));
        this.toolsRaiseMenuItem.addActionListener(this);
        this.toolsLowerMenuItem = new JMenuItem("Lower");
        this.toolsLowerMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 3));
        this.toolsLowerMenuItem.addActionListener(this);
        this.toolsFrontMenuItem = new JMenuItem("Bring to front");
        this.toolsFrontMenuItem.addActionListener(this);
        this.toolsBackMenuItem = new JMenuItem("Send to back");
        this.toolsBackMenuItem.addActionListener(this);
        this.toolsAlignToGrid = new JCheckBoxMenuItem("Align to grid");
        this.toolsAlignToGrid.setAccelerator(KeyStroke.getKeyStroke(65, 3));
        this.toolsAlignToGrid.setSelected(false);
        this.toolsAlignToGrid.addActionListener(this);
        this.toolsGridVisible = new JCheckBoxMenuItem("Show grid");
        this.toolsGridVisible.setSelected(false);
        this.toolsGridVisible.addActionListener(this);
        this.toolsGridSettings = new JMenuItem("Grid settings...");
        this.toolsGridSettings.addActionListener(this);
        this.toolsFitToGraph = new JMenuItem("Fit view to graph");
        this.toolsFitToGraph.addActionListener(this);
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic('T');
        this.toolsMenu.add(this.toolsHMirrorMenuItem);
        this.toolsMenu.add(this.toolsVMirrorMenuItem);
        this.toolsMenu.add(new JSeparator());
        this.toolsMenu.add(this.toolsAligntopMenuItem);
        this.toolsMenu.add(this.toolsAlignleftMenuItem);
        this.toolsMenu.add(this.toolsAlignbottomMenuItem);
        this.toolsMenu.add(this.toolsAlignrightMenuItem);
        this.toolsMenu.add(new JSeparator());
        this.toolsMenu.add(this.toolsRaiseMenuItem);
        this.toolsMenu.add(this.toolsLowerMenuItem);
        this.toolsMenu.add(this.toolsFrontMenuItem);
        this.toolsMenu.add(this.toolsBackMenuItem);
        this.toolsMenu.add(new JSeparator());
        this.toolsMenu.add(this.toolsConvertPolyMenuItem);
        this.toolsMenu.add(new JSeparator());
        this.toolsMenu.add(this.toolsAlignToGrid);
        this.toolsMenu.add(this.toolsGridVisible);
        this.toolsMenu.add(this.toolsGridSettings);
        this.toolsMenu.add(new JSeparator());
        this.toolsMenu.add(this.toolsFitToGraph);
        this.theMenu.add(this.toolsMenu);
        this.setJMenuBar(this.theMenu);
        sPane.setRightComponent(this.editorPanel);
        sPane.setLeftComponent(this.deviceTree);
        this.setContentPane(sPane);
        JDClipboard.getInstance().addChangeListener(this);
        JDClipboard.getInstance().check();
    }

    public void setEditor(JDrawEditor editor) {
        this.theEditor = editor;
        this.theEditor.setStatusLabel(this.statusLabel);
        this.theEditor.setStatus("");
        this.theEditor.addEditorListener(this);
        this.createMenu.setEditor(editor);
        this.theEditor.setBorder(BorderFactory.createEtchedBorder());
        this.theEditorView = new JScrollPane(editor);
        this.theEditorView.setWheelScrollingEnabled(true);
        this.editorPanel.add((Component)this.theEditorView, "Center");
        this.selectionChanged();
        this.valueChanged();
    }

    public void setPlayer(JDrawEditor editor) {
        this.framePlayer = new JFrame();
        this.framePlayer.getContentPane().setLayout(new BorderLayout());
        JMenuBar fpBar = new JMenuBar();
        JMenu fpMenu = new JMenu("Debug");
        this.viewDebugOutput = new JMenuItem("View output");
        this.viewDebugOutput.addActionListener(this);
        fpMenu.add(this.viewDebugOutput);
        this.hideDebugOutput = new JMenuItem("Hide output");
        this.hideDebugOutput.addActionListener(this);
        fpMenu.add(this.hideDebugOutput);
        this.clearDebugOutput = new JMenuItem("Clear history");
        this.clearDebugOutput.addActionListener(this);
        fpMenu.add(this.clearDebugOutput);
        fpBar.add(fpMenu);
        this.splitPane = new JSplitPane(0);
        this.fpText = new JTextArea();
        this.fpText.setEditable(false);
        this.fpText.setFont(JDUtils.labelFont);
        this.fpTextView = new JScrollPane(this.fpText);
        this.thePlayer = new JDrawEditor(3);
        this.splitPane.add(this.thePlayer);
        this.splitPane.add(this.fpTextView);
        this.framePlayer.getContentPane().add((Component)this.splitPane, "Center");
        this.fpTextView.setPreferredSize(new Dimension(0, 60));
        this.framePlayer.setTitle("Play mode");
        this.framePlayer.setJMenuBar(fpBar);
        this.framePlayer.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JDrawEditorFrame.this.fpStr = new StringBuffer();
                JDrawEditorFrame.this.fpText.setText("");
            }
        });
    }

    public void setAppTitle(String title) {
        this.APP_RELEASE = title;
    }

    public void setLibraries(String path) {
        FileFinder ff;
        String[] fileList;
        String libPath = path == null ? System.getProperty("LIBPATH", "null") : path;
        if (libPath.equals("null")) {
            System.out.println("Warning LIBPATH is not defined.");
        }
        if ((fileList = (ff = new FileFinder(libPath, ".lib", 12)).getList(true)) == null) {
            System.out.println("No libraries found in " + libPath);
            return;
        }
        this.nLibs = fileList.length;
        this.libViewer = new JDLibraryViewer[this.nLibs];
        this.libButton = new JButton[this.nLibs];
        this.libCombo = new JComboBox();
        this.libCombo.addItem("Palette Libraries");
        for (int i = 0; i < this.nLibs; ++i) {
            this.libViewer[i] = new JDLibraryViewer(libPath + (!libPath.endsWith("/") ? "/" : "") + fileList[i], this.theEditor, false);
            this.libViewer[i].setTitle("JDraw library: " + fileList[i]);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.libViewer[i].pack();
            this.libViewer[i].setBounds(screenSize.width - this.libViewer[i].getPreferredSize().width - 15, (screenSize.height - this.libViewer[i].getPreferredSize().height) / 2, this.libViewer[i].getPreferredSize().width < screenSize.width ? this.libViewer[i].getPreferredSize().width : screenSize.width, this.libViewer[i].getPreferredSize().height < screenSize.height ? this.libViewer[i].getPreferredSize().height : screenSize.width);
            this.libCombo.addItem(fileList[i]);
        }
        this.libCombo.addItem("Choose a file ...");
        this.libCombo.setSelectedIndex(0);
        this.libCombo.addActionListener(this);
        this.editToolBar.add(new JLabel(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/jdraw_separator.gif"))));
        this.editToolBar.add(this.libCombo);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.fileExitMenuItem) {
            this.exitApp();
        } else if (src == this.editToolPasteBtn || src == this.editPasteMenuItem) {
            this.theEditor.create(7);
        } else if (src == this.editToolCopyBtn || src == this.editCopyMenuItem) {
            this.theEditor.copySelection();
        } else if (src == this.editToolCutBtn || src == this.editCutMenuItem) {
            this.theEditor.cutSelection();
        } else if (src == this.editDeleteMenuItem) {
            this.theEditor.deleteSelection();
        } else if (src == this.editToolOptionBtn || src == this.viewsOptionMenuItem) {
            this.theEditor.showPropertyWindow();
        } else if (src == this.editToolTransformBtn || src == this.viewsTransformMenuItem) {
            this.theEditor.showTransformWindow();
        } else if (src == this.editToolHMirrorBtn || src == this.toolsHMirrorMenuItem) {
            this.theEditor.scaleSelection(-1.0, 1.0);
        } else if (src == this.editToolVMirrorBtn || src == this.toolsVMirrorMenuItem) {
            this.theEditor.scaleSelection(1.0, -1.0);
        } else if (src == this.fileSaveasMenuItem) {
            this.theEditor.showSaveDialog(".");
        } else if (src == this.editToolFileOpenBtn || src == this.fileOpenMenuItem) {
            this.theEditor.showOpenDialog(".");
        } else if (src == this.editToolFileSaveBtn || src == this.fileSaveMenuItem) {
            this.theEditor.instantSave(".");
        } else if (src == this.editToolZoomInBtn) {
            this.theEditor.zoomIn();
        } else if (src == this.editToolZoomOutBtn) {
            this.theEditor.zoomOut();
        } else if (src == this.editSelectAllMenuItem) {
            this.theEditor.selectAll();
        } else if (src == this.editSelectNVMenuItem) {
            this.theEditor.selectNotVisible();
        } else if (src == this.editSelectNoneMenuItem) {
            this.theEditor.unselectAll();
        } else if (src == this.editToolUndoBtn || src == this.editUndoMenuItem) {
            this.theEditor.undo();
        } else if (src == this.editToolRedoBtn || src == this.editRedoMenuItem) {
            this.theEditor.redo();
        } else if (src == this.editToolAlignTopBtn || src == this.toolsAligntopMenuItem) {
            this.theEditor.aligntopSelection();
        } else if (src == this.editToolAlignLeftBtn || src == this.toolsAlignleftMenuItem) {
            this.theEditor.alignleftSelection();
        } else if (src == this.editToolAlignBottomBtn || src == this.toolsAlignbottomMenuItem) {
            this.theEditor.alignbottomSelection();
        } else if (src == this.editToolAlignRightBtn || src == this.toolsAlignrightMenuItem) {
            this.theEditor.alignrightSelection();
        } else if (src == this.viewsBrowseMenuItem) {
            this.theEditor.showBrowserWindow();
        } else if (src == this.viewsPlayMenuItem) {
            this.showPlayer();
        } else if (src == this.viewsTangoSynopticMenuItem) {
            this.showSimpleSynopticAppli();
        } else if (src == this.viewsGroupEditMenuItem) {
            this.theEditor.showGroupEditorWindow();
        } else if (src == this.viewsJavaMenuItem) {
            this.theEditor.showGroupJavaWindow();
        } else if (src == this.viewsGlobalMenuItem) {
            JDUtils.showGlobalDialog(this.theEditor);
        } else if (src == this.toolsConvertPolyMenuItem) {
            this.theEditor.convertToPolyline();
        } else if (src == this.toolsRaiseMenuItem) {
            this.theEditor.raiseObject();
        } else if (src == this.toolsLowerMenuItem) {
            this.theEditor.lowerObject();
        } else if (src == this.toolsFrontMenuItem) {
            this.theEditor.frontSelection();
        } else if (src == this.toolsBackMenuItem) {
            this.theEditor.backSelection();
        } else if (src == this.viewDebugOutput) {
            this.fpTextView.setVisible(true);
            this.splitPane.setDividerLocation(this.splitPane.getHeight() - 80);
            this.splitPane.revalidate();
        } else if (src == this.hideDebugOutput) {
            this.fpTextView.setVisible(false);
            this.splitPane.revalidate();
        } else if (src == this.clearDebugOutput) {
            this.fpStr = new StringBuffer();
            this.fpText.setText("");
        } else if (src == this.toolsAlignToGrid) {
            this.theEditor.setAlignToGrid(this.toolsAlignToGrid.isSelected());
        } else if (src == this.toolsGridVisible) {
            this.theEditor.setGridVisible(this.toolsGridVisible.isSelected());
        } else if (src == this.toolsGridSettings) {
            String newSize = JOptionPane.showInputDialog("Enter Grid Size", (Object)new Integer(this.theEditor.getGridSize()));
            if (newSize != null) {
                try {
                    int sz = Integer.parseInt(newSize);
                    this.theEditor.setGridSize(sz);
                }
                catch (NumberFormatException e2) {
                    JOptionPane.showMessageDialog(this, "Wrong integer value\n" + e2.getMessage());
                }
            }
        } else if (src == this.toolsFitToGraph) {
            this.theEditor.computePreferredSize();
        } else if (src == this.libCombo) {
            if (this.libCombo.getSelectedIndex() > this.libViewer.length) {
                JFileChooser chooser = new JFileChooser(".");
                chooser.setDialogTitle("[SimpleSynopticAppli] Open a synoptic file.");
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal != 0) {
                    return;
                }
                File f = chooser.getSelectedFile();
                String fullFileName = f.getAbsolutePath();
                JDLibraryViewer noLib = new JDLibraryViewer(fullFileName, this.theEditor, false);
                noLib.setTitle("JDraw library: " + fullFileName);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                noLib.pack();
                noLib.setBounds(screenSize.width - noLib.getPreferredSize().width - 15, (screenSize.height - noLib.getPreferredSize().height) / 2, noLib.getPreferredSize().width < screenSize.width ? noLib.getPreferredSize().width : screenSize.width, noLib.getPreferredSize().height < screenSize.height ? noLib.getPreferredSize().height : screenSize.width);
                noLib.setVisible(true);
                this.libCombo.setSelectedIndex(0);
                return;
            }
            if (this.libCombo.getSelectedIndex() > 0) {
                this.libViewer[this.libCombo.getSelectedIndex() - 1].setVisible(true);
                this.libCombo.setSelectedIndex(0);
                return;
            }
        }
    }

    @Override
    public void creationDone() {
    }

    @Override
    public void selectionChanged() {
        int sz = this.theEditor.getSelectionLength();
        this.editToolCutBtn.setEnabled(sz > 0);
        this.editCutMenuItem.setEnabled(sz > 0);
        this.editToolCopyBtn.setEnabled(sz > 0);
        this.editCopyMenuItem.setEnabled(sz > 0);
        this.editDeleteMenuItem.setEnabled(sz > 0);
        this.editToolOptionBtn.setEnabled(sz > 0);
        this.viewsOptionMenuItem.setEnabled(sz > 0);
        this.editToolTransformBtn.setEnabled(sz > 0);
        this.viewsTransformMenuItem.setEnabled(sz > 0);
        this.editToolHMirrorBtn.setEnabled(sz > 0);
        this.toolsHMirrorMenuItem.setEnabled(sz > 0);
        this.editToolVMirrorBtn.setEnabled(sz > 0);
        this.toolsVMirrorMenuItem.setEnabled(sz > 0);
        this.editToolAlignLeftBtn.setEnabled(sz > 1);
        this.toolsAlignleftMenuItem.setEnabled(sz > 1);
        this.editToolAlignTopBtn.setEnabled(sz > 1);
        this.toolsAligntopMenuItem.setEnabled(sz > 1);
        this.editToolAlignRightBtn.setEnabled(sz > 1);
        this.toolsAlignrightMenuItem.setEnabled(sz > 1);
        this.editToolAlignBottomBtn.setEnabled(sz > 1);
        this.toolsAlignbottomMenuItem.setEnabled(sz > 1);
        this.editSelectAllMenuItem.setEnabled(sz < this.theEditor.getObjectNumber());
        this.editSelectNVMenuItem.setEnabled(sz < this.theEditor.getObjectNumber());
        this.editSelectNoneMenuItem.setEnabled(sz > 0);
        this.viewsBrowseMenuItem.setEnabled(sz > 0);
        this.toolsConvertPolyMenuItem.setEnabled(this.theEditor.canConvertToPolyline());
        this.viewsGroupEditMenuItem.setEnabled(this.theEditor.canEditGroup());
        this.viewsJavaMenuItem.setEnabled(sz > 0);
        this.toolsRaiseMenuItem.setEnabled(sz == 1);
        this.toolsLowerMenuItem.setEnabled(sz == 1);
        this.toolsFrontMenuItem.setEnabled(sz >= 1);
        this.toolsBackMenuItem.setEnabled(sz >= 1);
        this.toolsAlignToGrid.setSelected(this.theEditor.isAlignToGrid());
        this.toolsGridVisible.setSelected(this.theEditor.isGridVisible());
    }

    @Override
    public void clipboardChanged() {
        int sz = JDClipboard.getInstance().size();
        this.editToolPasteBtn.setEnabled(sz > 0);
        this.editPasteMenuItem.setEnabled(sz > 0);
    }

    @Override
    public void valueChanged() {
        this.editUndoMenuItem.setText("Undo " + this.theEditor.getLastActionName());
        this.editUndoMenuItem.setEnabled(this.theEditor.canUndo());
        this.editRedoMenuItem.setText("Redo " + this.theEditor.getNextActionName());
        this.editRedoMenuItem.setEnabled(this.theEditor.canRedo());
        this.editToolUndoBtn.setEnabled(this.theEditor.canUndo());
        this.editToolRedoBtn.setEnabled(this.theEditor.canRedo());
        String title = this.APP_RELEASE;
        if (this.theEditor.getFileName().length() > 0) {
            title = title + " [" + this.theEditor.getFileName() + "]";
        }
        if (this.theEditor.getNeedToSaveState()) {
            this.setTitle(title + "*");
        } else {
            this.setTitle(title);
        }
    }

    @Override
    public void sizeChanged() {
        this.theEditorView.revalidate();
        this.repaint();
        this.editToolZoomLabel.setText(this.theEditor.getZoomFactorPercent() + "%");
    }

    @Override
    public void valueChanged(JDObject src) {
        if (this.fpTextView.isVisible()) {
            this.fpStr.append(src.getName() + " valueChanged(value=" + src.getValue() + ")\n");
            this.fpText.setText(this.fpStr.toString());
        }
    }

    @Override
    public void valueExceedBounds(JDObject src) {
        if (this.fpTextView.isVisible()) {
            this.fpStr.append(src.getName() + " valueExceedBounds(value=" + src.getValue() + ")\n");
            this.fpText.setText(this.fpStr.toString());
        }
    }

    private void showPlayer() {
        int i;
        this.thePlayer.clearObjects();
        this.thePlayer.setBackground(this.theEditor.getBackground());
        this.fpStr = new StringBuffer();
        for (i = 0; i < this.theEditor.getObjectNumber(); ++i) {
            JDObject p = this.theEditor.getObjectAt(i).copy(0, 0);
            this.thePlayer.addObject(p);
            if (!p.isProgrammed()) continue;
            this.fpStr.append(p.getName() + " is programmed.\n");
        }
        this.thePlayer.initPlayer();
        this.thePlayer.computePreferredSize();
        Vector inter = this.thePlayer.getInteractiveObjects();
        for (i = 0; i < inter.size(); ++i) {
            JDObject o = (JDObject)inter.get(i);
            this.fpStr.append(o.getName() + " has user value enabled.\n");
            o.addValueListener(this);
        }
        this.fpText.setText(this.fpStr.toString());
        ATKGraphicsUtils.centerFrameOnScreen(this.framePlayer);
        this.framePlayer.setVisible(true);
    }

    private void showSimpleSynopticAppli() {
        if (this.theSynopticAppli != null) {
            this.theSynopticAppli.setVisible(false);
            this.theSynopticAppli.stopSimpleSynopticAppli();
            this.theSynopticAppli = null;
        }
        this.theEditor.instantSave(".");
        String fileName = this.theEditor.getFileName();
        if (fileName == null || fileName.length() == 0) {
            return;
        }
        File f = new File(fileName);
        String absolutePathName = null;
        try {
            absolutePathName = f.getAbsolutePath();
        }
        catch (Exception ex) {
            return;
        }
        if (absolutePathName == null || absolutePathName.length() == 0) {
            return;
        }
        this.theSynopticAppli = new SimpleSynopticAppli(absolutePathName);
        this.theSynopticAppli.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                JDrawEditorFrame.this.theSynopticAppli = null;
            }
        });
    }

    public void exitApp() {
        int rep = 0;
        if (this.theEditor.getNeedToSaveState() && (rep = JOptionPane.showConfirmDialog(this, "Your changes will be lost , save before exiting ?", "Exit confirmation", 1)) == 0) {
            this.theEditor.instantSave(".");
        }
        if (rep != 2) {
            System.exit(0);
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.exitApp();
        } else if (e.getID() == 205) {
            JDClipboard.getInstance().check();
            super.processWindowEvent(e);
        } else {
            super.processWindowEvent(e);
        }
    }

    public static void main(String[] args) {
        JDrawEditor ed = new JDrawEditor(1);
        JDrawEditor py = new JDrawEditor(3);
        JDrawEditorFrame jde = new JDrawEditorFrame();
        jde.setAppTitle("JDraw Editor 1.17");
        jde.setEditor(ed);
        jde.setPlayer(py);
        jde.setLibraries(null);
        if (args.length == 1) {
            try {
                ed.loadFile(args[0]);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Error, cannot load " + args[0] + "\n" + e.getMessage(), "JDrawEditor", 0);
            }
        }
        ATKGraphicsUtils.centerFrameOnScreen(jde);
        jde.setVisible(true);
    }
}

