/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.booleanMapEntry;
import fr.esrf.tangoatk.widget.util.jdraw.colorMapEntry;
import fr.esrf.tangoatk.widget.util.jdraw.integerMapEntry;
import fr.esrf.tangoatk.widget.util.jdraw.mapEntry;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Vector;

public class JDValueProgram {
    public static final int MAP_BY_VALUE = 0;
    public static final int MAP_LINEAR = 1;
    public static final int MAP_REMAP = 2;
    public static final int INTEGER_TYPE = 1;
    public static final int COLOR_TYPE = 2;
    public static final int BOOLEAN_TYPE = 3;
    private int mode;
    private int type;
    private Vector tableMap;
    private mapEntry defaultValue;
    private int parsePos;

    public JDValueProgram(int type) {
        this.mode = 0;
        this.type = type;
        this.tableMap = new Vector();
        switch (type) {
            case 1: {
                this.defaultValue = new integerMapEntry(0, 1, 0);
                break;
            }
            case 3: {
                this.defaultValue = new booleanMapEntry(0, 1, false);
                break;
            }
            case 2: {
                this.defaultValue = new colorMapEntry(0, 1, Color.GRAY);
            }
        }
    }

    JDValueProgram copy() {
        if (this.mode == 0 && this.getEntryNumber() == 0) {
            return null;
        }
        JDValueProgram ret = new JDValueProgram(this.type);
        ret.mode = this.mode;
        for (int i = 0; i < this.getEntryNumber(); ++i) {
            ret.tableMap.add(((mapEntry)this.tableMap.get(i)).copy());
        }
        ret.defaultValue = this.defaultValue.copy();
        return ret;
    }

    public int getType() {
        return this.type;
    }

    public boolean setMode(int m) {
        if (this.type != 1 && (m == 1 || m == 2)) {
            return false;
        }
        this.mode = m;
        return true;
    }

    public int getMode() {
        return this.mode;
    }

    public void addNewEntry() {
        switch (this.type) {
            case 1: {
                this.tableMap.add(new integerMapEntry(0, 0, this.getIntegerMapping(this.defaultValue)));
                break;
            }
            case 3: {
                this.tableMap.add(new booleanMapEntry(0, 0, this.getBooleanMapping(this.defaultValue)));
                break;
            }
            case 2: {
                this.tableMap.add(new colorMapEntry(0, 0, this.getColorMapping(this.defaultValue)));
            }
        }
    }

    public void removeEntry(int idx) {
        this.tableMap.remove(idx);
    }

    public int getEntryNumber() {
        return this.tableMap.size();
    }

    public String getDefaultMapping() {
        return this.getStrValue(this.defaultValue);
    }

    public boolean setDefaultMapping(String v) {
        switch (this.type) {
            case 1: {
                return this.setIntegerMapping((integerMapEntry)this.defaultValue, v);
            }
            case 3: {
                return this.setBooleanMapping((booleanMapEntry)this.defaultValue, v);
            }
            case 2: {
                return this.setColorMapping((colorMapEntry)this.defaultValue, v);
            }
        }
        return false;
    }

    public Color getDefaultColorMapping() {
        return this.getColorMapping(this.defaultValue);
    }

    public boolean getDefaultBooleanMapping() {
        return this.getBooleanMapping(this.defaultValue);
    }

    public int getDefaultIntegerMapping() {
        return this.getIntegerMapping(this.defaultValue);
    }

    public String getValue(int idx) {
        mapEntry mp = (mapEntry)this.tableMap.get(idx);
        if (mp.minValue == mp.maxValue) {
            return Integer.toString(mp.minValue);
        }
        return Integer.toString(mp.minValue) + ".." + Integer.toString(mp.maxValue);
    }

    public String getCompleteValue(int idx) {
        mapEntry mp = (mapEntry)this.tableMap.get(idx);
        return Integer.toString(mp.minValue) + "," + Integer.toString(mp.maxValue);
    }

    public boolean setValueAt(int idx, String v) {
        mapEntry mp = (mapEntry)this.tableMap.get(idx);
        this.parsePos = 0;
        try {
            mp.minValue = this.parseNumber(v);
            if (this.parsePos + 2 <= v.length() && v.substring(this.parsePos, this.parsePos + 2).equals("..")) {
                this.parsePos += 2;
                mp.maxValue = this.parseNumber(v);
            } else if (this.parsePos + 2 > v.length()) {
                mp.maxValue = mp.minValue;
            } else {
                return false;
            }
            return mp.minValue <= mp.maxValue;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getMapping(int idx) {
        return this.getStrValue((mapEntry)this.tableMap.get(idx));
    }

    public boolean setMappingAt(int idx, String v) {
        switch (this.type) {
            case 1: {
                return this.setIntegerMapping((integerMapEntry)this.tableMap.get(idx), v);
            }
            case 3: {
                return this.setBooleanMapping((booleanMapEntry)this.tableMap.get(idx), v);
            }
            case 2: {
                return this.setColorMapping((colorMapEntry)this.tableMap.get(idx), v);
            }
        }
        return false;
    }

    public Color getColorMappingAt(int idx) {
        return this.getColorMapping((mapEntry)this.tableMap.get(idx));
    }

    public boolean getBooleanMappingAt(int idx) {
        return this.getBooleanMapping((mapEntry)this.tableMap.get(idx));
    }

    public int getIntegerMappingAt(int idx) {
        return this.getIntegerMapping((mapEntry)this.tableMap.get(idx));
    }

    boolean getBooleanMappingFor(JDObject p) {
        booleanMapEntry m = (booleanMapEntry)this.findEntry(p.getValue());
        if (m == null) {
            return ((booleanMapEntry)this.defaultValue).value;
        }
        return m.value;
    }

    Color getColorMappingFor(JDObject p) {
        colorMapEntry m = (colorMapEntry)this.findEntry(p.getValue());
        if (m == null) {
            return ((colorMapEntry)this.defaultValue).color;
        }
        return m.color;
    }

    int getIntegerMappingFor(JDObject p, JDObject master) {
        switch (this.mode) {
            case 0: {
                integerMapEntry m = (integerMapEntry)this.findEntry(p.getValue());
                if (m == null) {
                    return ((integerMapEntry)this.defaultValue).value;
                }
                return m.value;
            }
            case 1: {
                double ratio = (double)(p.getValue() - p.getMinValue()) / (double)(p.getMaxValue() - p.getMinValue());
                return this.defaultValue.minValue + (int)(ratio * (double)(this.defaultValue.maxValue - this.defaultValue.minValue) + 0.5);
            }
            case 2: {
                double ratio = (double)(p.getValue() - p.getMinValue()) / (double)(p.getMaxValue() - p.getMinValue());
                Rectangle r = master.getBoundRect();
                switch (master.getValueChangeMode()) {
                    case 2: {
                        return (int)((double)r.width * ratio) - r.width / 2;
                    }
                    case 3: {
                        return -((int)((double)r.width * ratio)) + r.width / 2;
                    }
                    case 4: {
                        return (int)((double)r.height * ratio) - r.height / 2;
                    }
                    case 5: {
                        return -((int)((double)r.height * ratio)) + r.height / 2;
                    }
                }
            }
        }
        return 0;
    }

    public int getMinLinearMapping() {
        return this.defaultValue.minValue;
    }

    public int getMaxLinearMapping() {
        return this.defaultValue.maxValue;
    }

    public void setMinLinearValue(int min) {
        this.defaultValue.minValue = min;
    }

    public void setMaxLinearValue(int max) {
        this.defaultValue.maxValue = max;
    }

    public void recordObject(StringBuffer to_write, StringBuffer decal) {
        to_write.append("  ").append(decal).append("mapping_type:").append(this.type).append("\n");
        to_write.append("  ").append(decal).append("mode:").append(this.mode).append("\n");
        to_write.append("  ").append(decal).append("default:").append(this.getDefaultMapping()).append("\n");
        switch (this.mode) {
            case 0: {
                for (int i = 0; i < this.getEntryNumber(); ++i) {
                    to_write.append("  ").append(decal).append("map:");
                    to_write.append(this.getCompleteValue(i)).append(",").append(this.getMapping(i)).append("\n");
                }
                break;
            }
            case 1: {
                to_write.append("  ").append(decal).append("lmin:").append(this.getMinLinearMapping()).append("\n");
                to_write.append("  ").append(decal).append("lmax:").append(this.getMaxLinearMapping()).append("\n");
            }
        }
    }

    public JDValueProgram(JDFileLoader f) throws IOException {
        int sl = f.getCurrentLine();
        this.type = -1;
        this.mode = 0;
        this.tableMap = new Vector();
        this.defaultValue = null;
        f.startBlock();
        block10: while (!f.isEndBlock()) {
            Color c;
            boolean b;
            int i;
            String propName = f.parseProperyName();
            if (propName.equals("mapping_type")) {
                this.type = (int)f.parseDouble();
                continue;
            }
            if (propName.equals("mode")) {
                this.mode = (int)f.parseDouble();
                continue;
            }
            if (propName.equals("lmin")) {
                if (this.defaultValue != null) {
                    this.defaultValue.minValue = (int)f.parseDouble();
                    continue;
                }
                throw new IOException("default must be specified before lmin line " + f.getCurrentLine());
            }
            if (propName.equals("lmax")) {
                if (this.defaultValue != null) {
                    this.defaultValue.maxValue = (int)f.parseDouble();
                    continue;
                }
                throw new IOException("default must be specified before lmax at line " + f.getCurrentLine());
            }
            if (propName.equals("default")) {
                switch (this.type) {
                    case 1: {
                        i = (int)f.parseDouble();
                        this.defaultValue = new integerMapEntry(0, 1, i);
                        break;
                    }
                    case 3: {
                        b = f.parseBoolean();
                        this.defaultValue = new booleanMapEntry(0, 1, b);
                        break;
                    }
                    case 2: {
                        c = f.parseColor();
                        this.defaultValue = new colorMapEntry(0, 1, c);
                    }
                }
                continue;
            }
            if (propName.equals("map")) {
                int min = (int)f.parseDouble();
                f.jumpLexem(3);
                int max = (int)f.parseDouble();
                f.jumpLexem(3);
                switch (this.type) {
                    case 1: {
                        i = (int)f.parseDouble();
                        this.tableMap.add(new integerMapEntry(min, max, i));
                        continue block10;
                    }
                    case 3: {
                        b = f.parseBoolean();
                        this.tableMap.add(new booleanMapEntry(min, max, b));
                        continue block10;
                    }
                    case 2: {
                        c = f.parseColor();
                        this.tableMap.add(new colorMapEntry(min, max, c));
                        continue block10;
                    }
                }
                throw new IOException("No mapping_type specified for the ValueMapper at line " + sl);
            }
            System.out.println("Unknown property found:" + propName);
            f.jumpPropertyValue();
        }
        f.endBlock();
        if (this.defaultValue == null) {
            throw new IOException("No default specified for the ValueMapper at line " + sl);
        }
        if (this.type == -1) {
            throw new IOException("No mapping_type specified for the ValueMapper at line " + sl);
        }
        if (this.mode == 0 && this.getEntryNumber() == 0) {
            throw new IOException("No mapping table found for the ValueMapper at line " + sl);
        }
    }

    private boolean isNumber(char c) {
        return c >= '0' && c <= '9' || c == '-';
    }

    private String getStrValue(mapEntry mp) {
        if (mp instanceof colorMapEntry) {
            Color c = ((colorMapEntry)mp).color;
            return c.getRed() + "," + c.getGreen() + "," + c.getBlue();
        }
        if (mp instanceof integerMapEntry) {
            return Integer.toString(((integerMapEntry)mp).value);
        }
        if (mp instanceof booleanMapEntry) {
            return Boolean.toString(((booleanMapEntry)mp).value);
        }
        return "Invalid mapping";
    }

    private Color getColorMapping(mapEntry mp) {
        return ((colorMapEntry)mp).color;
    }

    private int getIntegerMapping(mapEntry mp) {
        return ((integerMapEntry)mp).value;
    }

    private boolean getBooleanMapping(mapEntry mp) {
        return ((booleanMapEntry)mp).value;
    }

    private boolean setColorMapping(colorMapEntry mp, String c) {
        this.parsePos = 0;
        try {
            int r = this.parseNumber(c);
            if (c.charAt(this.parsePos) != ',') {
                return false;
            }
            ++this.parsePos;
            int g = this.parseNumber(c);
            if (c.charAt(this.parsePos) != ',') {
                return false;
            }
            ++this.parsePos;
            int b = this.parseNumber(c);
            mp.color = new Color(r, g, b);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean setBooleanMapping(booleanMapEntry mp, String c) {
        mp.value = Boolean.valueOf(c);
        return true;
    }

    private boolean setIntegerMapping(integerMapEntry mp, String c) {
        this.parsePos = 0;
        try {
            mp.value = this.parseNumber(c);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int parseNumber(String v) {
        StringBuffer num = new StringBuffer();
        int l = v.length();
        boolean ok = true;
        while (this.parsePos < l && ok) {
            ok = this.isNumber(v.charAt(this.parsePos));
            if (!ok) continue;
            num.append(v.charAt(this.parsePos));
            ++this.parsePos;
        }
        return Integer.parseInt(num.toString());
    }

    private mapEntry findEntry(int value) {
        boolean found = false;
        int i = 0;
        mapEntry m = null;
        while (!found && i < this.tableMap.size()) {
            m = (mapEntry)this.tableMap.get(i);
            found = value >= m.minValue && value <= m.maxValue;
            if (found) continue;
            ++i;
        }
        if (found) {
            return m;
        }
        return null;
    }
}

