/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDAxisPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDBar;
import fr.esrf.tangoatk.widget.util.jdraw.JDBarPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDBrowserPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDClipboard;
import fr.esrf.tangoatk.widget.util.jdraw.JDEllipse;
import fr.esrf.tangoatk.widget.util.jdraw.JDEllipsePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDExtensionPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDGlobalPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroup;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroupEditorView;
import fr.esrf.tangoatk.widget.util.jdraw.JDImage;
import fr.esrf.tangoatk.widget.util.jdraw.JDImagePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabelPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDLinePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDObjectPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolylinePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangularPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectanglePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDSlider;
import fr.esrf.tangoatk.widget.util.jdraw.JDSliderPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDTitledRect;
import fr.esrf.tangoatk.widget.util.jdraw.JDTitledRectPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDTransformPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueMappingPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDValuePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueProgram;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JDUtils {
    static boolean modified;
    private static Insets bMargin;
    static Insets zMargin;
    private static Class theClass;
    static Font labelFont;
    static Font labelFontBold;
    static Color labelColor;
    private static JDialog nonModalPropDlg;
    private static JDrawEditor lastInvoker;
    private static Component lastSelectedPanel;
    private static boolean updatingProp;
    private static JTabbedPane innerPane;
    private static JDObjectPanel objectPanel;
    private static JDRectangularPanel rectangularPanel;
    private static JDLabelPanel labelPanel;
    private static JDLinePanel linePanel;
    private static JDPolylinePanel polylinePanel;
    private static JDEllipsePanel ellipsePanel;
    private static JDRoundRectanglePanel roundRectanglePanel;
    private static JDImagePanel imagePanel;
    private static JDSwingPanel swingPanel;
    private static JDAxisPanel axisPanel;
    private static JDBarPanel barPanel;
    private static JDTitledRectPanel titledRectPanel;
    private static JDSliderPanel sliderPanel;
    private static JDValuePanel valuePanel;
    private static JDExtensionPanel extensionPanel;

    JDUtils() {
    }

    private static void init() {
        if (theClass == null) {
            String className = "fr.esrf.tangoatk.widget.util.jdraw.JDUtils";
            try {
                theClass = Class.forName(className);
            }
            catch (Exception e) {
                System.out.println("JDUtils.init() Class not found: " + className);
            }
        }
    }

    private static JDialog buildDialog(JComponent invoker, boolean modal) {
        Container parent = invoker.getRootPane().getParent();
        JDialog dlg = parent instanceof JDialog ? new JDialog((Dialog)((JDialog)parent), modal) : (parent instanceof JFrame ? new JDialog((Frame)((JFrame)parent), modal) : new JDialog((Frame)null, modal));
        return dlg;
    }

    private static JDialog buildModalDialog(JComponent invoker) {
        return JDUtils.buildDialog(invoker, true);
    }

    public static void updatePropertyDialog(Vector objects) {
        JDObject[] objs2;
        if (nonModalPropDlg == null) {
            return;
        }
        if (objectPanel.nameHasChanged()) {
            if (JOptionPane.showConfirmDialog(nonModalPropDlg, "Object name has changed but has not been applied\nDo you want to apply ?", "Confirmation", 0) == 0) {
                objectPanel.applyName();
            } else {
                objectPanel.cancelNameChanged();
            }
        }
        if (objects.size() == 0) {
            nonModalPropDlg.setTitle("Properties [None selected]");
            objectPanel.updatePanel(null);
            rectangularPanel.updatePanel(null);
            labelPanel.updatePanel(null);
            linePanel.updatePanel(null);
            polylinePanel.updatePanel(null);
            ellipsePanel.updatePanel(null);
            roundRectanglePanel.updatePanel(null);
            imagePanel.updatePanel(null);
            swingPanel.updatePanel(null);
            axisPanel.updatePanel(null);
            barPanel.updatePanel(null);
            titledRectPanel.updatePanel(null);
            valuePanel.updatePanel(null);
            extensionPanel.updatePanel(null);
            return;
        }
        updatingProp = true;
        JDObject[] objs = new JDObject[objects.size()];
        boolean sameClass = true;
        int i = 1;
        objs[0] = (JDObject)objects.get(0);
        Class<?> firstClass = objs[0].getClass();
        boolean isRectangular = objs[0] instanceof JDRectangular;
        for (i = 1; i < objs.length; ++i) {
            objs[i] = (JDObject)objects.get(i);
            sameClass &= firstClass.equals(objs[i].getClass());
            isRectangular &= objs[i] instanceof JDRectangular;
        }
        innerPane.removeAll();
        innerPane.add((Component)objectPanel, "Graphics");
        objectPanel.updatePanel(objs);
        if (sameClass && objs[0] instanceof JDLabel) {
            objs2 = new JDLabel[objs.length];
            for (i = 0; i < objs.length; ++i) {
                objs2[i] = (JDLabel)objs[i];
            }
            labelPanel.updatePanel((JDLabel[])objs2);
            innerPane.add((Component)labelPanel, "Text");
        }
        if (isRectangular) {
            objs2 = new JDRectangular[objs.length];
            for (i = 0; i < objs.length; ++i) {
                objs2[i] = (JDRectangular)objs[i];
            }
            rectangularPanel.updatePanel((JDRectangular[])objs2);
            innerPane.add((Component)rectangularPanel, "Size");
        }
        if (sameClass && objs[0] instanceof JDLine) {
            objs2 = new JDLine[objs.length];
            for (i = 0; i < objs.length; ++i) {
                objs2[i] = (JDLine)objs[i];
            }
            linePanel.updatePanel((JDLine[])objs2);
            innerPane.add((Component)linePanel, "Line");
        }
        if (sameClass && objs[0] instanceof JDPolyline) {
            objs2 = new JDPolyline[objs.length];
            for (i = 0; i < objs.length; ++i) {
                objs2[i] = (JDPolyline)objs[i];
            }
            polylinePanel.updatePanel((JDPolyline[])objs2);
            innerPane.add((Component)polylinePanel, "Polyline");
        }
        if (sameClass && objs[0] instanceof JDEllipse) {
            objs2 = new JDEllipse[objs.length];
            for (i = 0; i < objs.length; ++i) {
                objs2[i] = (JDEllipse)objs[i];
            }
            ellipsePanel.updatePanel((JDEllipse[])objs2);
            innerPane.add((Component)ellipsePanel, "Ellipse");
        }
        if (sameClass && objs[0] instanceof JDRoundRectangle) {
            objs2 = new JDRoundRectangle[objs.length];
            for (i = 0; i < objs.length; ++i) {
                objs2[i] = (JDRoundRectangle)objs[i];
            }
            roundRectanglePanel.updatePanel((JDRoundRectangle[])objs2);
            innerPane.add((Component)roundRectanglePanel, "Corner");
        }
        if (sameClass && objs[0] instanceof JDImage) {
            objs2 = new JDImage[objs.length];
            for (i = 0; i < objs.length; ++i) {
                objs2[i] = (JDImage)objs[i];
            }
            imagePanel.updatePanel((JDImage[])objs2);
            innerPane.add((Component)imagePanel, "Image");
        }
        if (sameClass && objs[0] instanceof JDSwingObject) {
            objs2 = new JDSwingObject[objs.length];
            for (i = 0; i < objs.length; ++i) {
                objs2[i] = (JDSwingObject)objs[i];
            }
            swingPanel.updatePanel((JDSwingObject[])objs2);
            innerPane.add((Component)swingPanel, "Swing");
        }
        if (sameClass && objs[0] instanceof JDAxis) {
            objs2 = new JDAxis[objs.length];
            for (i = 0; i < objs.length; ++i) {
                objs2[i] = (JDAxis)objs[i];
            }
            axisPanel.updatePanel((JDAxis[])objs2);
            innerPane.add((Component)axisPanel, "Axis");
        }
        if (sameClass && objs[0] instanceof JDBar) {
            objs2 = new JDBar[objs.length];
            for (i = 0; i < objs.length; ++i) {
                objs2[i] = (JDBar)objs[i];
            }
            barPanel.updatePanel((JDBar[])objs2);
            innerPane.add((Component)barPanel, "Bar");
        }
        if (sameClass && objs[0] instanceof JDTitledRect) {
            objs2 = new JDTitledRect[objs.length];
            for (i = 0; i < objs.length; ++i) {
                objs2[i] = (JDTitledRect)objs[i];
            }
            titledRectPanel.updatePanel((JDTitledRect[])objs2);
            innerPane.add((Component)titledRectPanel, "TitledRect");
        }
        if (sameClass && objs[0] instanceof JDSlider) {
            objs2 = new JDSlider[objs.length];
            for (i = 0; i < objs.length; ++i) {
                objs2[i] = (JDSlider)objs[i];
            }
            sliderPanel.updatePanel((JDSlider[])objs2);
            innerPane.add((Component)sliderPanel, "Slider");
        }
        valuePanel.updatePanel(objs);
        innerPane.add((Component)valuePanel, "Value");
        extensionPanel.updatePanel(objs);
        innerPane.add((Component)extensionPanel, "Extensions");
        String title = "Properties";
        JDObject p = (JDObject)objects.get(0);
        title = sameClass ? title + " [" + objects.size() + " " + p.toString() + " selected]" : title + " [" + objects.size() + " objects selected]";
        nonModalPropDlg.setTitle(title);
        try {
            innerPane.setSelectedComponent(lastSelectedPanel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        innerPane.getSelectedComponent().setVisible(true);
        updatingProp = false;
    }

    public static void showPropertyDialog(JDrawEditor invoker, Vector objects) {
        if (nonModalPropDlg != null && lastInvoker != invoker) {
            nonModalPropDlg.dispose();
            nonModalPropDlg = null;
        }
        if (nonModalPropDlg == null) {
            nonModalPropDlg = JDUtils.buildDialog(invoker, false);
            lastInvoker = invoker;
            JPanel innerPanel = new JPanel();
            innerPanel.setLayout(new BorderLayout());
            JPanel buttonPanel = new JPanel();
            FlowLayout fl = new FlowLayout();
            fl.setAlignment(2);
            buttonPanel.setLayout(fl);
            JButton dismissBtn = new JButton("Dismiss");
            dismissBtn.setFont(labelFont);
            dismissBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (objectPanel.nameHasChanged()) {
                        if (JOptionPane.showConfirmDialog(nonModalPropDlg, "Object name has changed but has not been applied\nDo you want to apply ?", "Confirmation", 0) == 0) {
                            objectPanel.applyName();
                        } else {
                            objectPanel.cancelNameChanged();
                        }
                    }
                    nonModalPropDlg.setVisible(false);
                }
            });
            buttonPanel.add(dismissBtn);
            innerPanel.add((Component)buttonPanel, "South");
            innerPane = new JTabbedPane();
            objectPanel = new JDObjectPanel(null, invoker, null);
            rectangularPanel = new JDRectangularPanel(null, invoker);
            labelPanel = new JDLabelPanel(null, invoker);
            linePanel = new JDLinePanel(null, invoker);
            polylinePanel = new JDPolylinePanel(null, invoker);
            ellipsePanel = new JDEllipsePanel(null, invoker);
            roundRectanglePanel = new JDRoundRectanglePanel(null, invoker);
            imagePanel = new JDImagePanel(null, invoker);
            swingPanel = new JDSwingPanel(null, invoker);
            axisPanel = new JDAxisPanel(null, invoker);
            barPanel = new JDBarPanel(null, invoker);
            titledRectPanel = new JDTitledRectPanel(null, invoker);
            sliderPanel = new JDSliderPanel(null, invoker);
            valuePanel = new JDValuePanel(null, invoker, null);
            extensionPanel = new JDExtensionPanel(null, invoker);
            innerPanel.add((Component)innerPane, "Center");
            nonModalPropDlg.setContentPane(innerPanel);
            nonModalPropDlg.setResizable(false);
            innerPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (innerPane.getSelectedComponent() != null && !updatingProp) {
                        lastSelectedPanel = innerPane.getSelectedComponent();
                    }
                }
            });
        }
        JDUtils.updatePropertyDialog(objects);
        if (!nonModalPropDlg.isVisible()) {
            ATKGraphicsUtils.centerDialog(nonModalPropDlg);
        }
        nonModalPropDlg.setVisible(true);
    }

    public static boolean showBrowserDialog(JDrawEditor invoker, Vector objects) {
        if (objects.size() == 0) {
            return false;
        }
        if (nonModalPropDlg != null) {
            nonModalPropDlg.setVisible(false);
        }
        JDialog propDlg = JDUtils.buildModalDialog(invoker);
        JDObject[] objs = new JDObject[objects.size()];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = (JDObject)objects.get(i);
        }
        JDBrowserPanel bp = new JDBrowserPanel(objs, invoker);
        propDlg.setContentPane(bp);
        bp.postInit();
        ATKGraphicsUtils.centerDialog(propDlg);
        propDlg.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                JDialog dlg = (JDialog)e.getSource();
                dlg.setSize(Math.max(460, dlg.getWidth()), Math.max(400, dlg.getHeight()));
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        modified = false;
        propDlg.setVisible(true);
        propDlg.dispose();
        invoker.unselectAll();
        invoker.selectObjects(objs);
        invoker.fireSelectionChange();
        return modified;
    }

    public static boolean showGroupEditorDialog(JDrawEditor invoker, JDGroup g) {
        if (nonModalPropDlg != null) {
            nonModalPropDlg.setVisible(false);
        }
        JDialog propDlg = JDUtils.buildModalDialog(invoker);
        JDGroupEditorView gEdit = new JDGroupEditorView(g, invoker);
        propDlg.setContentPane(gEdit);
        propDlg.setTitle("Group Editor [" + g.getName() + "]");
        propDlg.setResizable(true);
        propDlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                JDClipboard.getInstance().check();
            }
        });
        ATKGraphicsUtils.centerDialog(propDlg);
        propDlg.setVisible(true);
        propDlg.dispose();
        return modified;
    }

    public static boolean showTransformDialog(JComponent invoker, Vector objects) {
        if (objects.size() == 0) {
            return false;
        }
        if (nonModalPropDlg != null) {
            nonModalPropDlg.setVisible(false);
        }
        JDialog propDlg = JDUtils.buildModalDialog(invoker);
        JDObject[] objs = new JDObject[objects.size()];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = (JDObject)objects.get(i);
        }
        propDlg.setContentPane(new JDTransformPanel(objs, invoker));
        String title = "Transformation";
        JDObject p = (JDObject)objects.get(0);
        if (objects.size() == 1) {
            title = title + ": " + p.getName();
        }
        propDlg.setTitle(title);
        ATKGraphicsUtils.centerDialog(propDlg);
        propDlg.setResizable(false);
        modified = false;
        propDlg.setVisible(true);
        propDlg.dispose();
        return modified;
    }

    public static boolean showGlobalDialog(JDrawEditor invoker) {
        if (nonModalPropDlg != null) {
            nonModalPropDlg.setVisible(false);
        }
        JDialog propDlg = JDUtils.buildModalDialog(invoker);
        propDlg.setContentPane(new JDGlobalPanel(invoker));
        String title = "Global graph properties";
        propDlg.setTitle(title);
        ATKGraphicsUtils.centerDialog(propDlg);
        propDlg.setResizable(false);
        modified = false;
        propDlg.setVisible(true);
        propDlg.dispose();
        return modified;
    }

    public static JDValueProgram showValueMappingDialog(JComponent invoker, JDObject[] objs, String desc, int type, JDValueProgram defMapper) {
        if (objs.length == 0) {
            return null;
        }
        JDialog propDlg = JDUtils.buildModalDialog(invoker);
        JDValueMappingPanel vp = new JDValueMappingPanel(objs, invoker, desc, type, defMapper);
        propDlg.setContentPane(vp);
        String title = "Mapping for " + desc;
        title = title + " [" + objs.length + " objects selected]";
        propDlg.setTitle(title);
        ATKGraphicsUtils.centerDialog(propDlg);
        propDlg.setResizable(false);
        propDlg.setVisible(true);
        propDlg.dispose();
        if (vp.hasChanged()) {
            return vp.getMapper();
        }
        return null;
    }

    static boolean showBooleanDialog(JComponent invoker, String name, boolean defaultValue) {
        JDialog propDlg = JDUtils.buildModalDialog(invoker);
        JPanel panel = new JPanel();
        panel.setLayout(null);
        JComboBox<String> boolCombo = new JComboBox<String>();
        boolCombo.setFont(labelFont);
        boolCombo.addItem("False");
        boolCombo.addItem("True");
        boolCombo.setSelectedIndex(defaultValue ? 1 : 0);
        panel.add(boolCombo);
        boolCombo.setBounds(10, 10, 150, 25);
        panel.setPreferredSize(new Dimension(170, 40));
        propDlg.setContentPane(panel);
        propDlg.setTitle(name);
        ATKGraphicsUtils.centerDialog(propDlg);
        propDlg.setVisible(true);
        propDlg.dispose();
        return boolCombo.getSelectedIndex() == 1;
    }

    static int showIntegerDialog(JComponent invoker, String name, int defaultValue) {
        String str = JOptionPane.showInputDialog(invoker, "Integer value", name, 1);
        int ret = defaultValue;
        if (str != null) {
            try {
                ret = Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public static Point getTopLeftCorner(JDObject[] list) {
        int xOrg = 65536;
        int yOrg = 65536;
        for (int i = 0; i < list.length; ++i) {
            Rectangle r = list[i].getBoundRect();
            if (r.x < xOrg) {
                xOrg = r.x;
            }
            if (r.y >= yOrg) continue;
            yOrg = r.y;
        }
        return new Point(xOrg, yOrg);
    }

    public static Point getTopLeftCorner(Vector list) {
        int xOrg = 65536;
        int yOrg = 65536;
        for (int i = 0; i < list.size(); ++i) {
            Rectangle r = ((JDObject)list.get(i)).getBoundRect();
            if (r.x < xOrg) {
                xOrg = r.x;
            }
            if (r.y >= yOrg) continue;
            yOrg = r.y;
        }
        return new Point(xOrg, yOrg);
    }

    public static Point getCenter(Vector list) {
        int x1 = 65536;
        int y1 = 65536;
        int x2 = -65536;
        int y2 = -65536;
        for (int i = 0; i < list.size(); ++i) {
            Rectangle r = ((JDObject)list.get(i)).getBoundRect();
            if (r.x < x1) {
                x1 = r.x;
            }
            if (r.x + r.width > x2) {
                x2 = r.x + r.width;
            }
            if (r.y < y1) {
                y1 = r.y;
            }
            if (r.y + r.height <= y2) continue;
            y2 = r.y + r.height;
        }
        return new Point((x1 + x2) / 2, (y1 + y2) / 2);
    }

    public static Point getCenter(JDObject[] list) {
        int x1 = 65536;
        int y1 = 65536;
        int x2 = -65536;
        int y2 = -65536;
        for (int i = 0; i < list.length; ++i) {
            Rectangle r = list[i].getBoundRect();
            if (r.x < x1) {
                x1 = r.x;
            }
            if (r.x + r.width > x2) {
                x2 = r.x + r.width;
            }
            if (r.y < y1) {
                y1 = r.y;
            }
            if (r.y + r.height <= y2) continue;
            y2 = r.y + r.height;
        }
        return new Point((x1 + x2) / 2, (y1 + y2) / 2);
    }

    public static Point getBottomRightCorner(Vector list) {
        int xOrg = -65536;
        int yOrg = -65536;
        for (int i = 0; i < list.size(); ++i) {
            Rectangle r = ((JDObject)list.get(i)).getBoundRect();
            if (r.x + r.width > xOrg) {
                xOrg = r.x + r.width;
            }
            if (r.y + r.height <= yOrg) continue;
            yOrg = r.y + r.height;
        }
        return new Point(xOrg, yOrg);
    }

    public static JButton createIconButton(String name, boolean hasDisa, String tipText, ActionListener l) {
        JDUtils.init();
        if (theClass != null) {
            JButton nB = new JButton(new ImageIcon(theClass.getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/" + name + ".gif")));
            nB.setPressedIcon(new ImageIcon(theClass.getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/" + name + "_push.gif")));
            if (hasDisa) {
                nB.setDisabledIcon(new ImageIcon(theClass.getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/" + name + "_disa.gif")));
            }
            nB.setToolTipText(tipText);
            nB.setMargin(bMargin);
            nB.setBorder(null);
            nB.addActionListener(l);
            return nB;
        }
        return new JButton(name);
    }

    public static JButton createSetButton(ActionListener l) {
        JButton b = new JButton("...");
        b.setMargin(zMargin);
        b.setForeground(Color.BLACK);
        if (l != null) {
            b.addActionListener(l);
        }
        return b;
    }

    public static JLabel createLabel(String name) {
        JLabel ret = new JLabel(name);
        ret.setFont(labelFont);
        ret.setForeground(labelColor);
        return ret;
    }

    public static Border createTitleBorder(String name) {
        return BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), name, 1, 0, labelFontBold, labelColor);
    }

    public static JCheckBox createCheckBox(String name, ActionListener l) {
        JCheckBox cb = new JCheckBox(name);
        cb.setFont(labelFont);
        cb.setForeground(labelColor);
        if (l != null) {
            cb.addActionListener(l);
        }
        return cb;
    }

    static String buildFontName(Font f) {
        String name = f.getName();
        String size = Integer.toString(f.getSize());
        String style = "";
        switch (f.getStyle()) {
            case 0: {
                style = "Plain";
                break;
            }
            case 2: {
                style = "Italic";
                break;
            }
            case 1: {
                style = "Bold";
                break;
            }
            case 3: {
                style = "Italic Bold";
            }
        }
        return name + "," + style + "," + size;
    }

    static String[] makeStringArray(String value) {
        while (value.endsWith("\n")) {
            value = value.substring(0, value.length() - 1);
        }
        return value.split("\n");
    }

    static String buildShortClassName(String className) {
        if (className == null) {
            return "";
        }
        int i = className.lastIndexOf(46);
        if (i != -1) {
            return className.substring(i + 1);
        }
        return className;
    }

    static void computeSpline(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, int step, boolean full, int start, Vector pts, int[] ptsx, int[] ptsy) {
        double stp = 1.0 / (double)step;
        double k = 0.0;
        for (int j = 0; j <= step; ++j) {
            double ks = k * k;
            double kc = ks * k;
            double x = (1.0 - 3.0 * k + 3.0 * ks - kc) * x1 + 3.0 * (k - 2.0 * ks + kc) * x2 + 3.0 * (ks - kc) * x3 + kc * x4;
            double y = (1.0 - 3.0 * k + 3.0 * ks - kc) * y1 + 3.0 * (k - 2.0 * ks + kc) * y2 + 3.0 * (ks - kc) * y3 + kc * y4;
            if (full || j < step) {
                if (pts != null) {
                    double[] pt = new double[]{(int)(x + 0.5), (int)(y + 0.5)};
                    pts.add(pt);
                } else {
                    ptsx[start + j] = (int)(x + 0.5);
                    ptsy[start + j] = (int)(y + 0.5);
                }
            }
            k += stp;
        }
    }

    static {
        bMargin = new Insets(3, 3, 3, 3);
        zMargin = new Insets(0, 0, 0, 0);
        theClass = null;
        labelFont = new Font("Dialog", 0, 12);
        labelFontBold = new Font("Dialog", 1, 12);
        labelColor = new Color(85, 87, 140);
        nonModalPropDlg = null;
        lastInvoker = null;
        lastSelectedPanel = null;
        updatingProp = false;
        innerPane = null;
        objectPanel = null;
        rectangularPanel = null;
        labelPanel = null;
        linePanel = null;
        polylinePanel = null;
        ellipsePanel = null;
        roundRectanglePanel = null;
        imagePanel = null;
        swingPanel = null;
        axisPanel = null;
        barPanel = null;
        titledRectPanel = null;
        sliderPanel = null;
        valuePanel = null;
        extensionPanel = null;
    }
}

