/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKFontChooser;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class JDSwingPanel
extends JPanel
implements ActionListener {
    private JTextField classnameLabel;
    private JLabel fontLabel;
    private JButton fontBtn;
    private JLabel borderLabel;
    private JComboBox borderCombo;
    private JDSwingObject[] allObjects = null;
    private JDrawEditor invoker;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDSwingPanel(JDSwingObject[] p, JDrawEditor jc) {
        this.invoker = jc;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel classPanel = new JPanel(null);
        classPanel.setBorder(JDUtils.createTitleBorder("Object Class"));
        classPanel.setBounds(5, 5, 370, 60);
        this.classnameLabel = new JTextField();
        this.classnameLabel.setMargin(JDUtils.zMargin);
        this.classnameLabel.setFont(JDUtils.labelFont);
        this.classnameLabel.setEditable(false);
        this.classnameLabel.setBorder(null);
        this.classnameLabel.setForeground(JDUtils.labelColor);
        this.classnameLabel.setBounds(10, 20, 350, 25);
        classPanel.add(this.classnameLabel);
        this.add(classPanel);
        JPanel propPanel = new JPanel(null);
        propPanel.setBorder(JDUtils.createTitleBorder("Component properties"));
        propPanel.setBounds(5, 65, 370, 85);
        this.fontLabel = new JLabel("Font");
        this.fontLabel.setFont(JDUtils.labelFont);
        this.fontLabel.setForeground(JDUtils.labelColor);
        this.fontLabel.setBounds(10, 20, 135, 24);
        propPanel.add(this.fontLabel);
        this.fontBtn = new JButton();
        this.fontBtn.setText("Choose");
        this.fontBtn.setMargin(new Insets(0, 0, 0, 0));
        this.fontBtn.setFont(JDUtils.labelFont);
        this.fontBtn.setBounds(220, 20, 140, 24);
        this.fontBtn.addActionListener(this);
        propPanel.add(this.fontBtn);
        this.borderLabel = new JLabel("Border");
        this.borderLabel.setFont(JDUtils.labelFont);
        this.borderLabel.setForeground(JDUtils.labelColor);
        this.borderLabel.setBounds(10, 50, 125, 25);
        propPanel.add(this.borderLabel);
        this.borderCombo = new JComboBox();
        this.borderCombo.setFont(JDUtils.labelFont);
        this.borderCombo.addItem("No border");
        this.borderCombo.addItem("Lowered");
        this.borderCombo.addItem("Raised");
        this.borderCombo.addItem("Etched");
        this.borderCombo.addActionListener(this);
        this.borderCombo.setBounds(220, 50, 140, 25);
        propPanel.add(this.borderCombo);
        this.add(propPanel);
        this.updatePanel(p);
    }

    public void updatePanel(JDSwingObject[] objs) {
        this.allObjects = objs;
        this.isUpdating = true;
        if (objs == null || objs.length <= 0) {
            this.borderCombo.setSelectedIndex(-1);
            this.classnameLabel.setText("");
            this.fontLabel.setText("Font: ");
        } else {
            JDSwingObject p = objs[0];
            this.fontLabel.setText("Font: [" + JDUtils.buildFontName(p.getFont()) + "]");
            this.classnameLabel.setText(p.getClassName());
            this.borderCombo.setSelectedIndex(p.getBorder());
        }
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            this.oldRect = this.oldRect.union(this.allObjects[i].getRepaintRect());
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle newRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            newRect = newRect.union(this.allObjects[i].getRepaintRect());
        }
        this.invoker.repaint(newRect.union(this.oldRect));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object src = e.getSource();
        if (src == this.fontBtn) {
            Font newFont = ATKFontChooser.getNewFont(this, "Choose component font", this.allObjects[0].getFont());
            if (newFont != null) {
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setFont(newFont, this.invoker.resizeLabelOnFontChange);
                }
                this.fontLabel.setText("Font: [" + JDUtils.buildFontName(newFont) + "]");
                this.invoker.setNeedToSave(true, "Change font");
            }
        } else if (src == this.borderCombo) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setBorder(this.borderCombo.getSelectedIndex());
            }
            this.invoker.setNeedToSave(true, "Change border");
        }
        this.repaintObjects();
    }
}

