/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyConvert;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.JLXPath;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Vector;

public class JDSpline
extends JDPolyline
implements JDPolyConvert {
    public JDSpline(String objectName, Point[] p) {
        this.initDefault();
        this.summit = new Point2D.Double[p.length];
        for (int i = 0; i < p.length; ++i) {
            this.summit[i] = new Point2D.Double(p[i].x, p[i].y);
        }
        this.step = 10;
        this.name = objectName;
        this.updateShape();
        Point2D.Double org = new Point2D.Double(this.boundRect.x + this.boundRect.width / 2, this.boundRect.y + this.boundRect.height / 2);
        this.setOrigin(org);
    }

    JDSpline(JDSpline e, int x, int y) {
        this.cloneObject(e, x, y);
        this.isClosed = e.isClosed;
        this.step = e.step;
        this.updateShape();
    }

    JDSpline(JLXObject jlxObj, JLXPath p) {
        this.initDefault();
        this.loadObject(jlxObj);
        double x = jlxObj.boundRect.getX();
        double y = jlxObj.boundRect.getY();
        double w = jlxObj.boundRect.getWidth();
        double h = jlxObj.boundRect.getHeight();
        int nbp = (p.path.size() - 1) * 3 + 1;
        this.setOrigin(new Point2D.Double(x + w / 2.0, y + h / 2.0));
        this.summit = new Point2D.Double[nbp];
        this.createSummit();
        int k = 0;
        for (int i = 0; i < p.path.size(); ++i) {
            double[] pts = (double[])p.path.get(i);
            if (i == 0) {
                this.summit[k].x = this.origin.x + pts[0];
                this.summit[k].y = this.origin.y + pts[1];
                ++k;
                continue;
            }
            if (p.pathType == 2) {
                this.summit[k].x = this.origin.x + pts[0];
                this.summit[k].y = this.origin.y + pts[1];
                this.summit[k + 1].x = this.origin.x + pts[0];
                this.summit[k + 1].y = this.origin.y + pts[1];
                this.summit[k + 2].x = this.origin.x + pts[2];
                this.summit[k + 2].y = this.origin.y + pts[3];
            } else {
                this.summit[k].x = this.origin.x + pts[0];
                this.summit[k].y = this.origin.y + pts[1];
                this.summit[k + 1].x = this.origin.x + pts[2];
                this.summit[k + 1].y = this.origin.y + pts[3];
                this.summit[k + 2].x = this.origin.x + pts[4];
                this.summit[k + 2].y = this.origin.y + pts[5];
            }
            k += 3;
        }
        this.isClosed = p.closed;
        this.step = 10;
        this.updateShape();
    }

    JDSpline(LXObject lxObj, double[] ptsx, double[] ptsy, boolean closed) {
        int i;
        this.initDefault();
        this.loadObject(lxObj);
        int nbp = ptsx.length;
        Vector<Point2D.Double> newPts = new Vector<Point2D.Double>();
        double x = (ptsx[0] + ptsx[1]) / 2.0;
        double y = (ptsy[0] + ptsy[1]) / 2.0;
        newPts.add(new Point2D.Double(ptsx[0], ptsy[0]));
        newPts.add(new Point2D.Double(ptsx[0], ptsy[0]));
        newPts.add(new Point2D.Double(x, y));
        newPts.add(new Point2D.Double(x, y));
        for (i = 1; i < nbp; ++i) {
            if (i < nbp - 1) {
                x = (ptsx[i] + ptsx[i + 1]) / 2.0;
                y = (ptsy[i] + ptsy[i + 1]) / 2.0;
            } else {
                x = (ptsx[i] + ptsx[0]) / 2.0;
                y = (ptsy[i] + ptsy[0]) / 2.0;
            }
            newPts.add(new Point2D.Double(ptsx[i], ptsy[i]));
            newPts.add(new Point2D.Double(ptsx[i], ptsy[i]));
            newPts.add(new Point2D.Double(x, y));
        }
        newPts.add(new Point2D.Double(x, y));
        newPts.add(new Point2D.Double(ptsx[0], ptsy[0]));
        newPts.add(new Point2D.Double(ptsx[0], ptsy[0]));
        this.summit = new Point2D.Double[newPts.size()];
        for (i = 0; i < this.summit.length; ++i) {
            this.summit[i] = (Point2D.Double)newPts.get(i);
        }
        this.isClosed = closed;
        this.step = 10;
        this.updateShape();
        double bx = this.boundRect.getX();
        double by = this.boundRect.getY();
        double bw = this.boundRect.getWidth();
        double bh = this.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(bx + bw / 2.0, by + bh / 2.0));
    }

    @Override
    public JDObject copy(int x, int y) {
        return new JDSpline(this, x, y);
    }

    @Override
    void computeBoundRect() {
        int i;
        double maxx = -65536.0;
        double maxy = -65536.0;
        double minx = 65536.0;
        double miny = 65536.0;
        for (i = 0; i < this.summit.length; ++i) {
            if (this.summit[i].x < minx) {
                minx = this.summit[i].x;
            }
            if (this.summit[i].x > maxx) {
                maxx = this.summit[i].x;
            }
            if (this.summit[i].y < miny) {
                miny = this.summit[i].y;
            }
            if (!(this.summit[i].y > maxy)) continue;
            maxy = this.summit[i].y;
        }
        for (i = 0; i < this.ptsx.length; ++i) {
            if ((double)this.ptsx[i] < minx) {
                minx = this.ptsx[i];
            }
            if ((double)this.ptsx[i] > maxx) {
                maxx = this.ptsx[i];
            }
            if ((double)this.ptsy[i] < miny) {
                miny = this.ptsy[i];
            }
            if (!((double)this.ptsy[i] > maxy)) continue;
            maxy = this.ptsy[i];
        }
        this.boundRect.setRect((int)minx, (int)miny, (int)(maxx - minx) + 1, (int)(maxy - miny) + 1);
    }

    @Override
    public void setStep(int s) {
        this.step = s;
        this.updateShape();
    }

    @Override
    public JDPolyline convertToPolyline() {
        JDPolyline ret = this.buildDefaultPolyline();
        ret.setClosed(this.isClosed());
        ret.updateShape();
        return ret;
    }

    @Override
    public void moveSummit(int id, double x, double y) {
        if (id % 3 == 0) {
            double tx = x - this.summit[id].x;
            double ty = y - this.summit[id].y;
            if (id > 0) {
                this.summit[id - 1].x += tx;
                this.summit[id - 1].y += ty;
            }
            this.summit[id].x += tx;
            this.summit[id].y += ty;
            if (id < this.summit.length - 1) {
                this.summit[id + 1].x += tx;
                this.summit[id + 1].y += ty;
            }
        } else {
            this.summit[id].x = x;
            this.summit[id].y = y;
        }
        this.updateShape();
    }

    @Override
    void deleteSummit() {
        if (this.breakId < 0) {
            return;
        }
        Point2D.Double[] nSummit = null;
        nSummit = new Point2D.Double[this.summit.length - 3];
        if (this.breakId == 0) {
            for (int i = 3; i < this.summit.length; ++i) {
                nSummit[i - 3] = this.summit[i];
            }
        } else if (this.breakId == this.summit.length - 1) {
            for (int i = 0; i < this.summit.length - 3; ++i) {
                nSummit[i] = this.summit[i];
            }
        } else {
            int nb = 0;
            for (int i = 0; i < this.summit.length; ++i) {
                if (i >= this.breakId - 1 && i <= this.breakId + 1) continue;
                nSummit[nb++] = this.summit[i];
            }
        }
        this.summit = nSummit;
        this.updateShape();
    }

    @Override
    boolean canDeleteSummit(int id) {
        if (!this.visible) {
            return false;
        }
        this.breakId = -1;
        if (id < 0 || id >= this.summit.length || this.summit.length <= 4) {
            return false;
        }
        if (id % 3 != 0) {
            return false;
        }
        this.breakId = id;
        return true;
    }

    @Override
    void paintSummit(Graphics g, double summitWidth) {
        super.paintSummit(g, summitWidth);
        g.setColor(Color.green);
        for (int i = 0; i < this.summit.length - 1; i += 3) {
            g.drawLine((int)this.summit[i].x, (int)this.summit[i].y, (int)this.summit[i + 1].x, (int)this.summit[i + 1].y);
            g.drawLine((int)this.summit[i + 2].x, (int)this.summit[i + 2].y, (int)this.summit[i + 3].x, (int)this.summit[i + 3].y);
        }
    }

    @Override
    void breakShape() {
        if (this.breakId < 0) {
            return;
        }
        Point2D.Double[] nSummit = new Point2D.Double[this.summit.length + 3];
        int sumId = this.breakId / this.step * 3 + 2;
        if (sumId < this.summit.length) {
            double vx = this.ptsx[this.breakId + 1] - this.ptsx[this.breakId];
            double vy = this.ptsy[this.breakId + 1] - this.ptsy[this.breakId];
            double n = Math.sqrt(vx * vx + vy * vy);
            if (n < 1.0) {
                vx = 30.0;
                vy = 30.0;
            } else {
                vx = 30.0 * vx / n;
                vy = 30.0 * vy / n;
            }
            int nb = 0;
            for (int i = 0; i < this.summit.length; ++i) {
                if (i == sumId) {
                    nSummit[nb++] = new Point2D.Double(this.breakX - (int)vx, this.breakY - (int)vy);
                    nSummit[nb++] = new Point2D.Double(this.breakX, this.breakY);
                    nSummit[nb++] = new Point2D.Double(this.breakX + (int)vx, this.breakY + (int)vy);
                }
                nSummit[nb++] = this.summit[i];
            }
        } else {
            double vx = this.ptsx[0] - this.ptsx[this.ptsx.length - 1];
            double vy = this.ptsy[0] - this.ptsy[this.ptsx.length - 1];
            double n = Math.sqrt(vx * vx + vy * vy);
            if (n < 1.0) {
                vx = 30.0;
                vy = 30.0;
            } else {
                vx = 30.0 * vx / n;
                vy = 30.0 * vy / n;
            }
            for (int i = 0; i < this.summit.length; ++i) {
                nSummit[i] = this.summit[i];
            }
            nSummit[i++] = new Point2D.Double(this.breakX - (int)vx, this.breakY - (int)vy);
            nSummit[i++] = new Point2D.Double(this.breakX, this.breakY);
            nSummit[i++] = new Point2D.Double(this.breakX + (int)vx, this.breakY + (int)vy);
        }
        this.summit = nSummit;
        this.updateShape();
    }

    JDSpline(JDFileLoader f) throws IOException {
        this.initDefault();
        int l = f.getCurrentLine();
        f.startBlock();
        this.summit = f.parseSummitArray();
        if (this.summit.length < 2) {
            throw new IOException("Invalid summit number for JDSpline at line " + l);
        }
        while (!f.isEndBlock()) {
            String propName = f.parseProperyName();
            if (propName.equals("isClosed")) {
                this.isClosed = f.parseBoolean();
                continue;
            }
            if (propName.equals("step")) {
                this.step = (int)f.parseDouble();
                continue;
            }
            this.loadDefaultPropery(f, propName);
        }
        f.endBlock();
        this.updateShape();
    }

    @Override
    public void connect(JDPolyline pline) {
        if (pline instanceof JDSpline) {
            int i;
            Point2D.Double[] nSummit = new Point2D.Double[this.summit.length + pline.getSummitNumber() + 2];
            for (i = 0; i < this.summit.length; ++i) {
                nSummit[i] = this.summit[i];
            }
            double x1 = this.summit[i - 1].x;
            double y1 = this.summit[i - 1].y;
            double vx = pline.getSummit((int)0).x - this.summit[i - 1].x;
            double vy = pline.getSummit((int)0).y - this.summit[i - 1].y;
            nSummit[i] = new Point2D.Double(x1 + vx * 0.33, y1 + vy * 0.33);
            nSummit[i + 1] = new Point2D.Double(x1 + vx * 0.66, y1 + vy * 0.66);
            for (i = 0; i < pline.getSummitNumber(); ++i) {
                nSummit[i + 2 + this.summit.length] = new Point2D.Double(pline.getSummit((int)i).x, pline.getSummit((int)i).y);
            }
            this.summit = nSummit;
            this.updateShape();
        } else {
            System.out.println("JDSpline.connect() : Cannot connect a JDSpline to JDPolyline.");
        }
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern u = new UndoPattern(8);
        this.fillUndoPattern(u);
        u.step = this.step;
        u.isClosed = this.isClosed;
        return u;
    }

    JDSpline(UndoPattern e) {
        this.initDefault();
        this.applyUndoPattern(e);
        this.step = e.step;
        this.isClosed = e.isClosed;
        this.updateShape();
    }

    @Override
    void updateShape() {
        int nb = 0;
        this.ptsx = new int[this.summit.length / 3 * this.step + 1];
        this.ptsy = new int[this.summit.length / 3 * this.step + 1];
        for (int i = 0; i < this.summit.length - 1; i += 3) {
            JDUtils.computeSpline(this.summit[i + 0].x, this.summit[i + 0].y, this.summit[i + 1].x, this.summit[i + 1].y, this.summit[i + 2].x, this.summit[i + 2].y, this.summit[i + 3].x, this.summit[i + 3].y, this.step, i == this.summit.length - 4, nb, null, this.ptsx, this.ptsy);
            nb += this.step;
        }
        if (this.hasShadow()) {
            this.computeShadow(this.isClosed());
            this.computeShadowColors();
        }
        this.computeBoundRect();
    }
}

