/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.UndoBuffer;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Vector;

public class JDSlider
extends JDRectangular {
    public static final int SLIDER_HORIZONTAL_LEFT = 0;
    public static final int SLIDER_HORIZONTAL_RIGHT = 1;
    public static final int SLIDER_VERTICAL_TOP = 2;
    public static final int SLIDER_VERTICAL_BOTTOM = 3;
    static final double minDefault = 0.0;
    static final double maxDefault = 1.0;
    static final double valueDefault = 0.5;
    static final int orientationDefault = 3;
    static final JDObject cursorDefault = new JDRectangle("DefaultSliderCursor", 0, 0, 16, 16);
    double min;
    double max;
    double value;
    int orientation;
    JDObject cursor;

    public JDSlider(String objectName, int x, int y, int w, int h) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(x, y));
        this.summit = new Point2D.Double[8];
        this.name = objectName;
        this.createSummit();
        this.computeSummitCoordinates(x, y, w, h);
        this.updateShape();
    }

    JDSlider(JDSlider e, int x, int y) {
        this.cloneObject(e, x, y);
        this.min = e.min;
        this.max = e.max;
        this.value = e.value;
        this.orientation = e.orientation;
        this.cursor = e.cursor.copy(x, y);
        this.updateShape();
    }

    JDSlider(JDFileLoader f) throws IOException {
        this.initDefault();
        f.startBlock();
        this.summit = f.parseRectangularSummitArray();
        while (!f.isEndBlock()) {
            String propName = f.parseProperyName();
            if (propName.equals("minSlider")) {
                this.min = f.parseDouble();
                continue;
            }
            if (propName.equals("maxSlider")) {
                this.max = f.parseDouble();
                continue;
            }
            if (propName.equals("valueSlider")) {
                this.value = f.parseDouble();
                continue;
            }
            if (propName.equals("orientation")) {
                this.orientation = (int)f.parseDouble();
                continue;
            }
            if (propName.equals("cursor")) {
                this.cursor = f.parseObject();
                continue;
            }
            this.loadDefaultPropery(f, propName);
        }
        f.endBlock();
        this.updateShape();
    }

    @Override
    public JDObject copy(int x, int y) {
        return new JDSlider(this, x, y);
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.min = 0.0;
        this.max = 1.0;
        this.value = 0.5;
        this.orientation = 3;
        this.cursor = cursorDefault.copy(0, 0);
    }

    @Override
    public boolean isInsideObject(int x, int y) {
        if (this.cursor.isInsideObject(x, y)) {
            return true;
        }
        if (!super.isInsideObject(x, y)) {
            return false;
        }
        if (this.fillStyle != 0) {
            return this.boundRect.contains(x, y);
        }
        int x1 = this.boundRect.x;
        int x2 = this.boundRect.x + this.boundRect.width;
        int y1 = this.boundRect.y;
        int y2 = this.boundRect.y + this.boundRect.height;
        return this.isPointOnLine(x, y, x1, y1, x2, y1) || this.isPointOnLine(x, y, x2, y1, x2, y2) || this.isPointOnLine(x, y, x2, y2, x1, y2) || this.isPointOnLine(x, y, x1, y2, x1, y1);
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[4];
        this.ptsy = new int[4];
        this.ptsx[0] = (int)(this.summit[0].x + 0.5);
        this.ptsy[0] = (int)(this.summit[0].y + 0.5);
        this.ptsx[1] = (int)(this.summit[2].x + 0.5);
        this.ptsy[1] = (int)(this.summit[2].y + 0.5);
        this.ptsx[2] = (int)(this.summit[4].x + 0.5);
        this.ptsy[2] = (int)(this.summit[4].y + 0.5);
        this.ptsx[3] = (int)(this.summit[6].x + 0.5);
        this.ptsy[3] = (int)(this.summit[6].y + 0.5);
        if (!Double.isNaN(this.value)) {
            double ratio = 0.0;
            if (this.min != this.max) {
                ratio = (this.value - this.min) / (this.max - this.min);
            }
            if (ratio < 0.0) {
                ratio = 0.0;
            }
            if (ratio > 1.0) {
                ratio = 1.0;
            }
            this.cursor.centerOrigin();
            double xOrg = (this.summit[0].x + this.summit[4].x) / 2.0;
            double yOrg = (this.summit[0].y + this.summit[4].y) / 2.0;
            double w = this.boundRect.width - 1;
            double h = this.boundRect.height - 1;
            switch (this.orientation) {
                case 0: {
                    double tH = w * (ratio - 0.5);
                    if (tH < -(w / 2.0)) {
                        tH = -w / 2.0;
                    }
                    if (tH > w / 2.0) {
                        tH = w / 2.0;
                    }
                    double trX = xOrg - this.cursor.origin.x + tH;
                    double trY = yOrg - this.cursor.origin.y;
                    if (!(Math.abs(trX) > 0.5) && !(Math.abs(trY) > 0.5)) break;
                    this.cursor.translate(trX, trY);
                    break;
                }
                case 1: {
                    double tH = w * (1.0 - ratio - 0.5);
                    if (tH < -(w / 2.0)) {
                        tH = -w / 2.0;
                    }
                    if (tH > w / 2.0) {
                        tH = w / 2.0;
                    }
                    double trX = xOrg - this.cursor.origin.x + tH;
                    double trY = yOrg - this.cursor.origin.y;
                    if (!(Math.abs(trX) > 0.5) && !(Math.abs(trY) > 0.5)) break;
                    this.cursor.translate(trX, trY);
                    break;
                }
                case 2: {
                    double tV = h * (ratio - 0.5);
                    if (tV < -(h / 2.0)) {
                        tV = -h / 2.0;
                    }
                    if (tV > h / 2.0) {
                        tV = h / 2.0;
                    }
                    double trX = xOrg - this.cursor.origin.x;
                    double trY = yOrg - this.cursor.origin.y + tV;
                    if (!(Math.abs(trX) > 0.5) && !(Math.abs(trY) > 0.5)) break;
                    this.cursor.translate(trX, trY);
                    break;
                }
                case 3: {
                    double tV = h * (1.0 - ratio - 0.5);
                    if (tV < -(h / 2.0)) {
                        tV = -h / 2.0;
                    }
                    if (tV > h / 2.0) {
                        tV = h / 2.0;
                    }
                    double trX = xOrg - this.cursor.origin.x;
                    double trY = yOrg - this.cursor.origin.y + tV;
                    if (!(Math.abs(trX) > 0.5) && !(Math.abs(trY) > 0.5)) break;
                    this.cursor.translate(trX, trY);
                }
            }
        }
        if (this.hasShadow()) {
            this.computeShadow(true);
            this.computeShadowColors();
        }
    }

    @Override
    public void paint(JDrawEditor parent, Graphics g) {
        if (!this.visible) {
            return;
        }
        this.prepareRendering((Graphics2D)g);
        super.paint(parent, g);
        if (!Double.isNaN(this.value)) {
            this.cursor.paint(parent, g);
        }
    }

    @Override
    Rectangle getRepaintRect() {
        Rectangle r = super.getRepaintRect();
        if (Double.isNaN(this.value)) {
            return r;
        }
        return r.union(this.cursor.getRepaintRect());
    }

    public void setMaximum(double m) {
        this.max = m;
        this.updateShape();
    }

    public double getMaximum() {
        return this.max;
    }

    public void setMinimum(double m) {
        this.min = m;
        this.updateShape();
    }

    public double getMinimum() {
        return this.min;
    }

    public void setSliderValue(double v) {
        this.value = v;
        this.updateShape();
    }

    public double getSliderValue() {
        return this.value;
    }

    public void setOrientation(int o) {
        this.orientation = o;
        this.updateShape();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public JDObject getCursor() {
        return this.cursor;
    }

    public void setCursor(JDObject nCursor) {
        this.cursor = nCursor;
        this.updateShape();
    }

    @Override
    void recordObject(StringBuffer to_write, int level) {
        StringBuffer decal = this.recordObjectHeader(to_write, level);
        if (this.min != 0.0) {
            to_write.append(decal).append("minSlider:").append(this.min).append("\n");
        }
        if (this.max != 1.0) {
            to_write.append(decal).append("maxSlider:").append(this.max).append("\n");
        }
        if (this.value != 0.5) {
            to_write.append(decal).append("valueSlider:").append(this.value).append("\n");
        }
        if (this.orientation != 3) {
            to_write.append(decal).append("orientation:").append(this.orientation).append("\n");
        }
        to_write.append(decal).append("cursor:\n");
        this.cursor.recordObject(to_write, level + 2);
        this.closeObjectHeader(to_write, level);
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern u = new UndoPattern(13);
        this.fillUndoPattern(u);
        u.min = this.min;
        u.max = this.max;
        u.value = this.value;
        u.textOrientation = this.orientation;
        u.gChildren = new Vector();
        u.gChildren.add(this.cursor.getUndoPattern());
        return u;
    }

    JDSlider(UndoPattern e) {
        this.initDefault();
        this.applyUndoPattern(e);
        this.min = e.min;
        this.max = e.max;
        this.value = e.value;
        this.orientation = e.textOrientation;
        Vector tmp = new Vector();
        UndoBuffer.rebuildObject((UndoPattern)e.gChildren.get(0), tmp);
        this.cursor = (JDObject)tmp.get(0);
        this.updateShape();
    }

    private void computeSummitCoordinates(int x, int y, int width, int height) {
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[2].x = x + width;
        this.summit[2].y = y;
        this.summit[4].x = x + width;
        this.summit[4].y = y + height;
        this.summit[6].x = x;
        this.summit[6].y = y + height;
        this.centerSummit();
    }
}

