/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyConvert;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.io.IOException;

public class JDRoundRectangle
extends JDRectangular
implements JDPolyConvert {
    static final int stepDefault = 6;
    static final int cornerWidthDefault = 24;
    private int step;
    private int cornerWidth;

    public JDRoundRectangle(String objectName, int x, int y, int w, int h) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(x, y));
        this.summit = new Point2D.Double[8];
        this.name = objectName;
        this.createSummit();
        this.computeSummitCoordinates(x, y, w, h);
        this.updateShape();
    }

    JDRoundRectangle(JDRoundRectangle e, int x, int y) {
        this.cloneObject(e, x, y);
        this.cornerWidth = e.cornerWidth;
        this.step = e.step;
        this.updateShape();
    }

    JDRoundRectangle(JLXObject jlxObj, int corner) {
        this.initDefault();
        this.loadObject(jlxObj);
        double x = jlxObj.boundRect.getX();
        double y = jlxObj.boundRect.getY();
        double w = jlxObj.boundRect.getWidth();
        double h = jlxObj.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(x + w / 2.0, y + w / 2.0));
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[1].x = x + w / 2.0;
        this.summit[1].y = y;
        this.summit[2].x = x + w;
        this.summit[2].y = y;
        this.summit[3].x = x + w;
        this.summit[3].y = y + h / 2.0;
        this.summit[4].x = x + w;
        this.summit[4].y = y + h;
        this.summit[5].x = x + w / 2.0;
        this.summit[5].y = y + h;
        this.summit[6].x = x;
        this.summit[6].y = y + h;
        this.summit[7].x = x;
        this.summit[7].y = y + h / 2.0;
        this.step = 6;
        this.cornerWidth = corner;
        this.updateShape();
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.step = 6;
        this.cornerWidth = 24;
    }

    @Override
    public JDObject copy(int x, int y) {
        return new JDRoundRectangle(this, x, y);
    }

    @Override
    public boolean isInsideObject(int x, int y) {
        if (!super.isInsideObject(x, y)) {
            return false;
        }
        boolean found = false;
        int i = 0;
        if (this.fillStyle != 0) {
            Polygon p = new Polygon(this.ptsx, this.ptsy, this.ptsx.length);
            found = p.contains(x, y);
        } else {
            while (i < this.ptsx.length - 1 && !found) {
                found = this.isPointOnLine(x, y, this.ptsx[i], this.ptsy[i], this.ptsx[i + 1], this.ptsy[i + 1]);
                if (found) continue;
                ++i;
            }
            if (!found) {
                found = this.isPointOnLine(x, y, this.ptsx[i], this.ptsy[i], this.ptsx[0], this.ptsy[0]);
            }
        }
        return found;
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        if (this.boundRect.width <= this.cornerWidth * 2 || this.boundRect.height <= this.cornerWidth * 2) {
            this.ptsx = new int[4];
            this.ptsy = new int[4];
            this.ptsx[0] = (int)(this.summit[0].x + 0.5);
            this.ptsy[0] = (int)(this.summit[0].y + 0.5);
            this.ptsx[1] = (int)(this.summit[2].x + 0.5);
            this.ptsy[1] = (int)(this.summit[2].y + 0.5);
            this.ptsx[2] = (int)(this.summit[4].x + 0.5);
            this.ptsy[2] = (int)(this.summit[4].y + 0.5);
            this.ptsx[3] = (int)(this.summit[6].x + 0.5);
            this.ptsy[3] = (int)(this.summit[6].y + 0.5);
        } else {
            int i = 0;
            int nb = 0;
            this.ptsx = new int[(this.step + 1) * 4];
            this.ptsy = new int[(this.step + 1) * 4];
            for (i = 0; i < 4; ++i) {
                double p4y;
                double p3y;
                double p2y;
                double p1y;
                double p4x;
                double p3x;
                double p2x;
                double p1x;
                switch (i) {
                    case 0: {
                        p1x = this.boundRect.x;
                        p2x = this.boundRect.x;
                        p3x = this.boundRect.x + this.cornerWidth / 4;
                        p4x = this.boundRect.x + this.cornerWidth;
                        p1y = this.boundRect.y + this.cornerWidth;
                        p2y = this.boundRect.y + this.cornerWidth / 4;
                        p3y = this.boundRect.y;
                        p4y = this.boundRect.y;
                        break;
                    }
                    case 1: {
                        p1x = this.boundRect.x + this.boundRect.width - 1 - this.cornerWidth;
                        p2x = this.boundRect.x + this.boundRect.width - 1 - this.cornerWidth / 4;
                        p3x = this.boundRect.x + this.boundRect.width - 1;
                        p4x = this.boundRect.x + this.boundRect.width - 1;
                        p1y = this.boundRect.y;
                        p2y = this.boundRect.y;
                        p3y = this.boundRect.y + this.cornerWidth / 4;
                        p4y = this.boundRect.y + this.cornerWidth;
                        break;
                    }
                    case 2: {
                        p1x = this.boundRect.x + this.boundRect.width - 1;
                        p2x = this.boundRect.x + this.boundRect.width - 1;
                        p3x = this.boundRect.x + this.boundRect.width - 1 - this.cornerWidth / 4;
                        p4x = this.boundRect.x + this.boundRect.width - 1 - this.cornerWidth;
                        p1y = this.boundRect.y + this.boundRect.height - 1 - this.cornerWidth;
                        p2y = this.boundRect.y + this.boundRect.height - 1 - this.cornerWidth / 4;
                        p3y = this.boundRect.y + this.boundRect.height - 1;
                        p4y = this.boundRect.y + this.boundRect.height - 1;
                        break;
                    }
                    default: {
                        p1x = this.boundRect.x + this.cornerWidth;
                        p2x = this.boundRect.x + this.cornerWidth / 4;
                        p3x = this.boundRect.x;
                        p4x = this.boundRect.x;
                        p1y = this.boundRect.y + this.boundRect.height - 1;
                        p2y = this.boundRect.y + this.boundRect.height - 1;
                        p3y = this.boundRect.y + this.boundRect.height - 1 - this.cornerWidth / 4;
                        p4y = this.boundRect.y + this.boundRect.height - 1 - this.cornerWidth;
                    }
                }
                double stp = 1.0 / (double)this.step;
                double k = 0.0;
                for (int j = 0; j <= this.step; ++j) {
                    double ks = k * k;
                    double kc = ks * k;
                    int x = (int)((1.0 - 3.0 * k + 3.0 * ks - kc) * p1x + 3.0 * (k - 2.0 * ks + kc) * p2x + 3.0 * (ks - kc) * p3x + kc * p4x + 0.5);
                    int y = (int)((1.0 - 3.0 * k + 3.0 * ks - kc) * p1y + 3.0 * (k - 2.0 * ks + kc) * p2y + 3.0 * (ks - kc) * p3y + kc * p4y + 0.5);
                    if (j == 0) {
                        this.ptsx[nb] = (int)(p1x + 0.5);
                        this.ptsy[nb] = (int)(p1y + 0.5);
                    }
                    if (j == this.step) {
                        this.ptsx[nb] = (int)(p4x + 0.5);
                        this.ptsy[nb] = (int)(p4y + 0.5);
                    } else {
                        this.ptsx[nb] = x;
                        this.ptsy[nb] = y;
                    }
                    ++nb;
                    k += stp;
                }
            }
        }
        if (this.hasShadow()) {
            this.computeShadow(true);
            this.computeShadowColors();
        }
    }

    @Override
    public JDPolyline convertToPolyline() {
        JDPolyline ret = this.buildDefaultPolyline();
        ret.setClosed(true);
        ret.updateShape();
        return ret;
    }

    @Override
    void recordObject(StringBuffer to_write, int level) {
        StringBuffer decal = this.recordObjectHeader(to_write, level);
        if (this.step != 6) {
            to_write.append(decal).append("step:").append(this.step).append("\n");
        }
        if (this.cornerWidth != 24) {
            to_write.append(decal).append("cornerWidth:").append(this.cornerWidth).append("\n");
        }
        this.closeObjectHeader(to_write, level);
    }

    JDRoundRectangle(JDFileLoader f) throws IOException {
        this.initDefault();
        f.startBlock();
        this.summit = f.parseRectangularSummitArray();
        while (!f.isEndBlock()) {
            String propName = f.parseProperyName();
            if (propName.equals("cornerWidth")) {
                this.cornerWidth = (int)f.parseDouble();
                continue;
            }
            if (propName.equals("step")) {
                this.step = (int)f.parseDouble();
                continue;
            }
            this.loadDefaultPropery(f, propName);
        }
        f.endBlock();
        this.updateShape();
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern u = new UndoPattern(7);
        this.fillUndoPattern(u);
        u.step = this.step;
        u.cornerWidth = this.cornerWidth;
        return u;
    }

    JDRoundRectangle(UndoPattern e) {
        this.initDefault();
        this.applyUndoPattern(e);
        this.step = e.step;
        this.cornerWidth = e.cornerWidth;
        this.updateShape();
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int s) {
        this.step = s;
        this.updateShape();
    }

    public int getCornerWidth() {
        return this.cornerWidth;
    }

    public void setCornerWidth(int w) {
        this.cornerWidth = w;
        this.updateShape();
    }

    private void computeSummitCoordinates(int x, int y, int width, int height) {
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[2].x = x + width;
        this.summit[2].y = y;
        this.summit[4].x = x + width;
        this.summit[4].y = y + height;
        this.summit[6].x = x;
        this.summit[6].y = y + height;
        this.centerSummit();
    }
}

